/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;

public final class TextSerializer
extends BaseMarkupSerializer {
    public TextSerializer() {
        super(new OutputFormat("text", null, false));
    }

    protected void characters(String string, boolean bl) {
        ElementState elementState = this.content();
        elementState.inCData = false;
        elementState.doCData = false;
        this.printText(string, true, true);
    }

    public void characters(char[] cArray, int n, int n2) {
        ElementState elementState = this.content();
        elementState.inCData = false;
        elementState.doCData = false;
        this.printText(cArray, n, n2, true, true);
    }

    public void comment(String string) {
    }

    public void comment(char[] cArray, int n, int n2) {
    }

    protected ElementState content() {
        ElementState elementState = this.getElementState();
        if (!this.isDocumentState()) {
            if (elementState.empty) {
                elementState.empty = false;
            }
            elementState.afterElement = false;
        }
        return elementState;
    }

    public void endElement(String string) {
        ElementState elementState = this.getElementState();
        elementState = this.leaveElementState();
        elementState.afterElement = true;
        elementState.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    public void endElement(String string, String string2, String string3) {
        this.endElement(string3 == null ? string2 : string3);
    }

    protected String getEntityRef(char c) {
        return null;
    }

    public void processingInstruction(String string, String string2) {
    }

    protected void serializeElement(Element element) {
        String string = element.getTagName();
        ElementState elementState = this.getElementState();
        if (this.isDocumentState() && !this._started) {
            this.startDocument(string);
        }
        boolean bl = elementState.preserveSpace;
        if (element.hasChildNodes()) {
            elementState = this.enterElementState(null, null, string, bl);
            Node node = element.getFirstChild();
            while (node != null) {
                this.serializeNode(node);
                node = node.getNextSibling();
            }
            this.endElement(string);
        } else if (!this.isDocumentState()) {
            elementState.afterElement = true;
            elementState.empty = false;
        }
    }

    protected void serializeNode(Node node) {
        switch (node.getNodeType()) {
            case 3: {
                String string = node.getNodeValue();
                if (string == null) break;
                this.characters(node.getNodeValue(), true);
                break;
            }
            case 4: {
                String string = node.getNodeValue();
                if (string == null) break;
                this.characters(node.getNodeValue(), true);
                break;
            }
            case 1: {
                this.serializeElement((Element)node);
                break;
            }
            case 9: 
            case 11: {
                Node node2 = node.getFirstChild();
                while (node2 != null) {
                    this.serializeNode(node2);
                    node2 = node2.getNextSibling();
                }
                break;
            }
        }
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        super.setOutputFormat(outputFormat != null ? outputFormat : new OutputFormat("text", null, false));
    }

    public void startDocument() {
    }

    protected void startDocument(String string) {
        this._printer.leaveDTD();
        this._started = true;
        this.serializePreRoot();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.startElement(string3 == null ? string2 : string3, null);
    }

    public void startElement(String string, AttributeList attributeList) {
        ElementState elementState = this.getElementState();
        if (this.isDocumentState() && !this._started) {
            this.startDocument(string);
        }
        boolean bl = elementState.preserveSpace;
        elementState = this.enterElementState(null, null, string, bl);
    }
}

