/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.stylebook.BasicContext;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Engine;
import org.apache.stylebook.Entry;
import org.apache.stylebook.LoadingException;
import org.apache.stylebook.NodeListParameters;
import org.apache.stylebook.Parameters;
import org.apache.stylebook.Printer;
import org.apache.stylebook.Processor;
import org.apache.stylebook.Producer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BasicEntry
extends BasicContext
implements Entry {
    private Producer producer = null;
    private Printer printer = null;
    private Vector tasks = new Vector();

    public BasicEntry(Engine engine, URL uRL, String string, Element element, Parameters parameters) throws LoadingException {
        super(uRL, string);
        String string2 = element.getAttribute("producer");
        String string3 = element.getAttribute("printer");
        engine.debug(this, "Creating Entry Source=\"" + uRL + "\" Target=\"" + string + "\"" + " [" + string2 + "/" + string3 + "]");
        this.producer = engine.getProducer(string2);
        if (this.producer == null) {
            throw new LoadingException("Invalid Producer \"" + string2 + "\"");
        }
        this.printer = engine.getPrinter(string3);
        if (this.printer == null) {
            throw new LoadingException("Invalid Printer \"" + string3 + "\"");
        }
        NodeList nodeList = element.getChildNodes();
        Parameters parameters2 = new NodeListParameters(nodeList).merge(parameters);
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2;
            if (nodeList.item(n).getNodeType() == 1 && !(element2 = (Element)nodeList.item(n)).getTagName().equals("parameter")) {
                if (!element2.getTagName().equals("processor")) {
                    throw new LoadingException("Invalid Tag <" + element2.getTagName() + ">");
                }
                Processor processor = engine.getProcessor(element2.getAttribute("name"));
                if (processor == null) {
                    throw new LoadingException("Invalid Processr \"" + processor + "\"");
                }
                Parameters parameters3 = new NodeListParameters(element2.getChildNodes()).merge(parameters2);
                this.tasks.add(new Task(processor, parameters3));
            }
            ++n;
        }
        this.merge(parameters2);
    }

    public void create(OutputStream outputStream) throws IOException, CreationException {
        Document document = this.producer.produce(this);
        Enumeration enumeration = this.tasks.elements();
        while (enumeration.hasMoreElements()) {
            Task task = (Task)enumeration.nextElement();
            document = task.processor.process(document, this, task.parameters);
        }
        this.printer.print(document, this, outputStream);
    }

    public boolean equals(Entry entry) {
        return false;
    }

    private class Task {
        public Processor processor = null;
        public Parameters parameters = null;

        public Task(Processor processor, Parameters parameters) {
            this.processor = processor;
            this.parameters = parameters;
        }
    }
}

