/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit.swingui.runner;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class ParserLoader
extends ClassLoader {
    private HashMap<String, Class> classList;
    private String grammar;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ParserLoader(String grammarName, String classDir) throws IOException, ClassNotFoundException {
        String lexerName = grammarName + "Lexer";
        File dir = new File(classDir);
        if (dir.isDirectory()) {
            File[] files;
            this.classList = new HashMap();
            this.grammar = grammarName;
            File[] arr$ = files = dir.listFiles(new ClassFilenameFilter(grammarName));
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                File f = arr$[i$];
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
                byte[] classData = new byte[((InputStream)in).available()];
                ((InputStream)in).read(classData);
                ((InputStream)in).close();
                Class<?> newClass = this.defineClass(null, classData, 0, classData.length);
                if (!$assertionsDisabled && newClass == null) {
                    throw new AssertionError();
                }
                this.resolveClass(newClass);
                String fileName = f.getName();
                String className = fileName.substring(0, fileName.lastIndexOf("."));
                this.classList.put(className, newClass);
            }
        } else {
            throw new IOException(classDir + " is not a directory.");
        }
        if (this.classList.isEmpty() || !this.classList.containsKey(lexerName)) {
            throw new ClassNotFoundException(lexerName + " not found.");
        }
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith(this.grammar)) {
            if (this.classList.containsKey(name)) {
                return this.classList.get(name);
            }
            throw new ClassNotFoundException(name);
        }
        Class<?> c = this.findSystemClass(name);
        return c;
    }

    static {
        $assertionsDisabled = !ParserLoader.class.desiredAssertionStatus();
    }

    protected static class ClassFilenameFilter
    implements FilenameFilter {
        private String grammarName;

        protected ClassFilenameFilter(String name) {
            this.grammarName = name;
        }

        public boolean accept(File dir, String name) {
            return name.startsWith(this.grammarName) && name.endsWith(".class");
        }
    }
}

