/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.antlr.gunit.AbstractTest;
import org.antlr.gunit.GrammarInfo;
import org.antlr.gunit.InvalidInputException;
import org.antlr.gunit.gUnitTestInput;
import org.antlr.gunit.gUnitTestResult;
import org.antlr.gunit.gUnitTestSuite;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class gUnitExecutor {
    public GrammarInfo grammarInfo;
    private final ClassLoader grammarClassLoader;
    public int numOfTest;
    public int numOfSuccess;
    public int numOfFailure;
    private String title;
    public int numOfInvalidInput;
    private String parserName;
    private String lexerName;
    public List<AbstractTest> failures;
    public List<AbstractTest> invalids;
    private PrintStream console = System.out;
    private PrintStream consoleErr = System.err;

    public gUnitExecutor(GrammarInfo grammarInfo) {
        this(grammarInfo, gUnitExecutor.determineClassLoader());
    }

    private static ClassLoader determineClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = gUnitExecutor.class.getClassLoader();
        }
        return classLoader;
    }

    public gUnitExecutor(GrammarInfo grammarInfo, ClassLoader classLoader) {
        this.grammarInfo = grammarInfo;
        this.grammarClassLoader = classLoader;
        this.numOfTest = 0;
        this.numOfSuccess = 0;
        this.numOfFailure = 0;
        this.numOfInvalidInput = 0;
        this.failures = new ArrayList<AbstractTest>();
        this.invalids = new ArrayList<AbstractTest>();
    }

    protected ClassLoader getGrammarClassLoader() {
        return this.grammarClassLoader;
    }

    protected final Class classForName(String string) throws ClassNotFoundException {
        return this.getGrammarClassLoader().loadClass(string);
    }

    public String execTest() throws IOException {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("testResult");
        try {
            if (this.grammarInfo.getHeader() != null) {
                this.parserName = this.grammarInfo.getHeader() + "." + this.grammarInfo.getGrammarName() + "Parser";
                this.lexerName = this.grammarInfo.getHeader() + "." + this.grammarInfo.getGrammarName() + "Lexer";
            } else {
                this.parserName = this.grammarInfo.getGrammarName() + "Parser";
                this.lexerName = this.grammarInfo.getGrammarName() + "Lexer";
            }
            this.title = this.grammarInfo.getTreeGrammarName() != null ? "executing testsuite for tree grammar:" + this.grammarInfo.getTreeGrammarName() + " walks " + this.parserName : "executing testsuite for grammar:" + this.grammarInfo.getGrammarName();
            this.executeTests();
            stringTemplate.setAttribute("title", (Object)this.title);
            stringTemplate.setAttribute("num_of_test", this.numOfTest);
            stringTemplate.setAttribute("num_of_failure", this.numOfFailure);
            if (this.numOfFailure > 0) {
                stringTemplate.setAttribute("failure", this.failures);
            }
            if (this.numOfInvalidInput > 0) {
                stringTemplate.setAttribute("has_invalid", (Object)new Boolean(true));
                stringTemplate.setAttribute("num_of_invalid", this.numOfInvalidInput);
                stringTemplate.setAttribute("invalid", this.invalids);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return stringTemplate.toString();
    }

    private StringTemplateGroup getTemplateGroup() {
        CommonGroupLoader commonGroupLoader = new CommonGroupLoader("org/antlr/gunit", null);
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)commonGroupLoader);
        StringTemplateGroup.registerDefaultLexer((Class)AngleBracketTemplateLexer.class);
        StringTemplateGroup stringTemplateGroup = StringTemplateGroup.loadGroup((String)"gUnitTestResult");
        return stringTemplateGroup;
    }

    private gUnitTestResult runCorrectParser(String string, String string2, String string3, String string4, String string5, gUnitTestInput gUnitTestInput2) throws Exception {
        if (string4 != null) {
            return this.runLexer(string2, string4, gUnitTestInput2);
        }
        if (string5 != null) {
            return this.runTreeParser(string, string2, string3, string5, gUnitTestInput2);
        }
        return this.runParser(string, string2, string3, gUnitTestInput2);
    }

    private void executeTests() throws Exception {
        Iterator<gUnitTestSuite> iterator = this.grammarInfo.getRuleTestSuites().iterator();
        while (iterator.hasNext()) {
            gUnitTestSuite gUnitTestSuite2 = iterator.next();
            String string = gUnitTestSuite2.getRuleName();
            String string2 = gUnitTestSuite2.getLexicalRuleName();
            String string3 = gUnitTestSuite2.getTreeRuleName();
            Iterator<gUnitTestInput> iterator2 = gUnitTestSuite2.testSuites.keySet().iterator();
            while (iterator2.hasNext()) {
                gUnitTestInput gUnitTestInput2 = iterator2.next();
                ++this.numOfTest;
                gUnitTestResult gUnitTestResult2 = null;
                AbstractTest abstractTest = gUnitTestSuite2.testSuites.get(gUnitTestInput2);
                try {
                    gUnitTestResult2 = this.runCorrectParser(this.parserName, this.lexerName, string, string2, string3, gUnitTestInput2);
                }
                catch (InvalidInputException invalidInputException) {
                    ++this.numOfInvalidInput;
                    abstractTest.setHeader(string, string2, string3, this.numOfTest, gUnitTestInput2.getLine());
                    abstractTest.setActual(gUnitTestInput2.testInput);
                    this.invalids.add(abstractTest);
                    continue;
                }
                String string4 = abstractTest.getExpected();
                String string5 = abstractTest.getResult(gUnitTestResult2);
                abstractTest.setActual(string5);
                if (string5 == null) {
                    ++this.numOfFailure;
                    abstractTest.setHeader(string, string2, string3, this.numOfTest, gUnitTestInput2.getLine());
                    abstractTest.setActual("null");
                    this.failures.add(abstractTest);
                    continue;
                }
                if (string4.equals(string5) || string4.equals("FAIL") && !string5.equals("OK")) {
                    ++this.numOfSuccess;
                    continue;
                }
                if (gUnitTestSuite2.testSuites.get(gUnitTestInput2).getType() == 7) {
                    ++this.numOfFailure;
                    abstractTest.setHeader(string, string2, string3, this.numOfTest, gUnitTestInput2.getLine());
                    abstractTest.setActual("\t{ACTION} is not supported in the grammarInfo yet...");
                    this.failures.add(abstractTest);
                    continue;
                }
                ++this.numOfFailure;
                abstractTest.setHeader(string, string2, string3, this.numOfTest, gUnitTestInput2.getLine());
                this.failures.add(abstractTest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected gUnitTestResult runLexer(String string, String string2, gUnitTestInput gUnitTestInput2) throws Exception {
        Object object;
        Class clazz = null;
        PrintStream printStream = null;
        PrintStream printStream2 = null;
        try {
            ANTLRStringStream aNTLRStringStream;
            Object object2;
            if (gUnitTestInput2.inputIsFile) {
                object2 = gUnitTestInput2.testInput;
                object = new File((String)object2);
                if (!((File)object).exists() && this.grammarInfo.getHeader() != null && ((File)(object = new File("./" + this.grammarInfo.getHeader().replace('.', '/'), gUnitTestInput2.testInput))).exists()) {
                    object2 = ((File)object).getCanonicalPath();
                }
                aNTLRStringStream = new ANTLRFileStream((String)object2);
            } else {
                aNTLRStringStream = new ANTLRStringStream(gUnitTestInput2.testInput);
            }
            clazz = this.classForName(string);
            object2 = new Class[]{CharStream.class};
            object = clazz.getConstructor((Class<?>)object2);
            Object[] objectArray = new Object[]{aNTLRStringStream};
            Object t = ((Constructor)object).newInstance(objectArray);
            Method method = clazz.getMethod("m" + string2, new Class[0]);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            printStream = new PrintStream(byteArrayOutputStream);
            printStream2 = new PrintStream(byteArrayOutputStream2);
            System.setOut(printStream);
            System.setErr(printStream2);
            method.invoke(t, new Object[0]);
            Method method2 = clazz.getMethod("getCharIndex", new Class[0]);
            int n = (Integer)method2.invoke(t, new Object[0]);
            if (n != aNTLRStringStream.size()) {
                printStream2.print("extra text found, '" + aNTLRStringStream.substring(n, aNTLRStringStream.size() - 1) + "'");
            }
            if (byteArrayOutputStream2.toString().length() > 0) {
                gUnitTestResult gUnitTestResult2 = new gUnitTestResult(false, byteArrayOutputStream2.toString(), true);
                gUnitTestResult2.setError(byteArrayOutputStream2.toString());
                gUnitTestResult gUnitTestResult3 = gUnitTestResult2;
                return gUnitTestResult3;
            }
            String string3 = null;
            if (byteArrayOutputStream.toString().length() > 0) {
                string3 = byteArrayOutputStream.toString();
            }
            gUnitTestResult gUnitTestResult4 = new gUnitTestResult(true, string3, true);
            return gUnitTestResult4;
        }
        catch (IOException iOException) {
            object = this.getTestExceptionResult(iOException);
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            System.exit(1);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            System.exit(1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.exit(1);
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            System.exit(1);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            System.exit(1);
        }
        catch (InvocationTargetException invocationTargetException) {
            object = this.getTestExceptionResult(invocationTargetException);
            return object;
        }
        finally {
            try {
                if (printStream != null) {
                    printStream.close();
                }
                if (printStream2 != null) {
                    printStream2.close();
                }
                System.setOut(this.console);
                System.setErr(this.consoleErr);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        throw new Exception("This should be unreachable?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected gUnitTestResult runParser(String string, String string2, String string3, gUnitTestInput gUnitTestInput2) throws Exception {
        Object object;
        Class clazz = null;
        Class clazz2 = null;
        PrintStream printStream = null;
        PrintStream printStream2 = null;
        try {
            Object object2;
            Method[] methodArray;
            ANTLRStringStream aNTLRStringStream;
            Object object3;
            if (gUnitTestInput2.inputIsFile) {
                object3 = gUnitTestInput2.testInput;
                object = new File((String)object3);
                if (!((File)object).exists() && this.grammarInfo.getHeader() != null && ((File)(object = new File("./" + this.grammarInfo.getHeader().replace('.', '/'), gUnitTestInput2.testInput))).exists()) {
                    object3 = ((File)object).getCanonicalPath();
                }
                aNTLRStringStream = new ANTLRFileStream((String)object3);
            } else {
                aNTLRStringStream = new ANTLRStringStream(gUnitTestInput2.testInput);
            }
            clazz = this.classForName(string2);
            object3 = new Class[]{CharStream.class};
            object = clazz.getConstructor((Class<?>)object3);
            Object[] objectArray = new Object[]{aNTLRStringStream};
            Object t = ((Constructor)object).newInstance(objectArray);
            CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)((Lexer)t));
            clazz2 = this.classForName(string);
            Class[] classArray = new Class[]{TokenStream.class};
            Constructor constructor = clazz2.getConstructor(classArray);
            Object[] objectArray2 = new Object[]{commonTokenStream};
            Object t2 = constructor.newInstance(objectArray2);
            Method method = clazz2.getMethod(string3, new Class[0]);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            printStream = new PrintStream(byteArrayOutputStream);
            printStream2 = new PrintStream(byteArrayOutputStream2);
            System.setOut(printStream);
            System.setErr(printStream2);
            Object object4 = method.invoke(t2, new Object[0]);
            String string4 = null;
            String string5 = null;
            if (object4 != null && object4.getClass().toString().indexOf(string3 + "_return") > 0) {
                try {
                    methodArray = this.classForName(string + "$" + string3 + "_return");
                    Object object5 = object2 = methodArray.getDeclaredMethods();
                    int n = ((Method[])object5).length;
                    for (int i = 0; i < n; ++i) {
                        CommonTree commonTree;
                        Method method2;
                        Method method3 = object5[i];
                        if (method3.getName().equals("getTree")) {
                            method2 = methodArray.getMethod("getTree", new Class[0]);
                            commonTree = (CommonTree)method2.invoke(object4, new Object[0]);
                            string4 = commonTree.toStringTree();
                            continue;
                        }
                        if (!method3.getName().equals("getTemplate")) continue;
                        method2 = methodArray.getMethod("getTemplate", new Class[0]);
                        commonTree = (StringTemplate)method2.invoke(object4, new Object[0]);
                        string5 = commonTree.toString();
                    }
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
            if (commonTokenStream.index() != commonTokenStream.size()) {
                throw new InvalidInputException();
            }
            if (byteArrayOutputStream2.toString().length() > 0) {
                methodArray = new gUnitTestResult(false, byteArrayOutputStream2.toString());
                methodArray.setError(byteArrayOutputStream2.toString());
                object2 = methodArray;
                return object2;
            }
            methodArray = null;
            if (byteArrayOutputStream.toString().length() > 0) {
                methodArray = byteArrayOutputStream.toString();
            }
            if (string4 != null) {
                object2 = new gUnitTestResult(true, (String)methodArray, string4);
                return object2;
            }
            if (string5 != null) {
                object2 = new gUnitTestResult(true, (String)methodArray, string5);
                return object2;
            }
            if (object4 != null) {
                object2 = new gUnitTestResult(true, (String)methodArray, String.valueOf(object4));
                return object2;
            }
            object2 = new gUnitTestResult(true, (String)methodArray, (String)methodArray);
            return object2;
        }
        catch (IOException iOException) {
            object = this.getTestExceptionResult(iOException);
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            System.exit(1);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            System.exit(1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.exit(1);
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            System.exit(1);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            System.exit(1);
        }
        catch (InvocationTargetException invocationTargetException) {
            object = this.getTestExceptionResult(invocationTargetException);
            return object;
        }
        finally {
            try {
                if (printStream != null) {
                    printStream.close();
                }
                if (printStream2 != null) {
                    printStream2.close();
                }
                System.setOut(this.console);
                System.setErr(this.consoleErr);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        throw new Exception("This should be unreachable?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected gUnitTestResult runTreeParser(String string, String string2, String string3, String string4, gUnitTestInput gUnitTestInput2) throws Exception {
        Object object;
        Class clazz = null;
        Class clazz2 = null;
        Class clazz3 = null;
        PrintStream printStream = null;
        PrintStream printStream2 = null;
        try {
            Object object2;
            Method[] methodArray;
            ANTLRStringStream aNTLRStringStream;
            Object object3;
            if (gUnitTestInput2.inputIsFile) {
                object3 = gUnitTestInput2.testInput;
                object = new File((String)object3);
                if (!((File)object).exists() && this.grammarInfo.getHeader() != null && ((File)(object = new File("./" + this.grammarInfo.getHeader().replace('.', '/'), gUnitTestInput2.testInput))).exists()) {
                    object3 = ((File)object).getCanonicalPath();
                }
                aNTLRStringStream = new ANTLRFileStream((String)object3);
            } else {
                aNTLRStringStream = new ANTLRStringStream(gUnitTestInput2.testInput);
            }
            String string5 = this.grammarInfo.getHeader() != null ? this.grammarInfo.getHeader() + "." + this.grammarInfo.getTreeGrammarName() : this.grammarInfo.getTreeGrammarName();
            clazz = this.classForName(string2);
            object3 = new Class[]{CharStream.class};
            object = clazz.getConstructor((Class<?>)object3);
            Object[] objectArray = new Object[]{aNTLRStringStream};
            Object t = ((Constructor)object).newInstance(objectArray);
            CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)((Lexer)t));
            clazz2 = this.classForName(string);
            Class[] classArray = new Class[]{TokenStream.class};
            Constructor constructor = clazz2.getConstructor(classArray);
            Object[] objectArray2 = new Object[]{commonTokenStream};
            Object t2 = constructor.newInstance(objectArray2);
            Method method = clazz2.getMethod(string3, new Class[0]);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            printStream = new PrintStream(byteArrayOutputStream);
            printStream2 = new PrintStream(byteArrayOutputStream2);
            System.setOut(printStream);
            System.setErr(printStream2);
            Object object4 = method.invoke(t2, new Object[0]);
            Class clazz4 = this.classForName(string + "$" + string3 + "_return");
            Method method2 = clazz4.getMethod("getTree", new Class[0]);
            CommonTree commonTree = (CommonTree)method2.invoke(object4, new Object[0]);
            CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream((Object)commonTree);
            commonTreeNodeStream.setTokenStream((TokenStream)commonTokenStream);
            clazz3 = this.classForName(string5);
            Class[] classArray2 = new Class[]{TreeNodeStream.class};
            Constructor constructor2 = clazz3.getConstructor(classArray2);
            Object[] objectArray3 = new Object[]{commonTreeNodeStream};
            Object t3 = constructor2.newInstance(objectArray3);
            Method method3 = clazz3.getMethod(string4, new Class[0]);
            Object object5 = method3.invoke(t3, new Object[0]);
            String string6 = null;
            String string7 = null;
            if (object5 != null && object5.getClass().toString().indexOf(string4 + "_return") > 0) {
                try {
                    methodArray = this.classForName(string5 + "$" + string4 + "_return");
                    Object object6 = object2 = methodArray.getDeclaredMethods();
                    int n = ((Method[])object6).length;
                    for (int i = 0; i < n; ++i) {
                        CommonTree commonTree2;
                        Method method4;
                        Method method5 = object6[i];
                        if (method5.getName().equals("getTree")) {
                            method4 = methodArray.getMethod("getTree", new Class[0]);
                            commonTree2 = (CommonTree)method4.invoke(object5, new Object[0]);
                            string6 = commonTree2.toStringTree();
                            continue;
                        }
                        if (!method5.getName().equals("getTemplate")) continue;
                        method4 = clazz4.getMethod("getTemplate", new Class[0]);
                        commonTree2 = (StringTemplate)method4.invoke(object5, new Object[0]);
                        string7 = commonTree2.toString();
                    }
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
            if (commonTokenStream.index() != commonTokenStream.size()) {
                throw new InvalidInputException();
            }
            if (byteArrayOutputStream2.toString().length() > 0) {
                methodArray = new gUnitTestResult(false, byteArrayOutputStream2.toString());
                methodArray.setError(byteArrayOutputStream2.toString());
                object2 = methodArray;
                return object2;
            }
            methodArray = null;
            if (byteArrayOutputStream.toString().length() > 0) {
                methodArray = byteArrayOutputStream.toString();
            }
            if (string6 != null) {
                object2 = new gUnitTestResult(true, (String)methodArray, string6);
                return object2;
            }
            if (string7 != null) {
                object2 = new gUnitTestResult(true, (String)methodArray, string7);
                return object2;
            }
            if (object5 != null) {
                object2 = new gUnitTestResult(true, (String)methodArray, String.valueOf(object5));
                return object2;
            }
            object2 = new gUnitTestResult(true, (String)methodArray, (String)methodArray);
            return object2;
        }
        catch (IOException iOException) {
            object = this.getTestExceptionResult(iOException);
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            System.exit(1);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            System.exit(1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.exit(1);
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
            System.exit(1);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            System.exit(1);
        }
        catch (InvocationTargetException invocationTargetException) {
            object = this.getTestExceptionResult(invocationTargetException);
            return object;
        }
        finally {
            try {
                if (printStream != null) {
                    printStream.close();
                }
                if (printStream2 != null) {
                    printStream2.close();
                }
                System.setOut(this.console);
                System.setErr(this.consoleErr);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        throw new Exception("Should not be reachable?");
    }

    private gUnitTestResult getTestExceptionResult(Exception exception) {
        gUnitTestResult gUnitTestResult2;
        if (exception.getCause() != null) {
            gUnitTestResult2 = new gUnitTestResult(false, exception.getCause().toString(), true);
            gUnitTestResult2.setError(exception.getCause().toString());
        } else {
            gUnitTestResult2 = new gUnitTestResult(false, exception.toString(), true);
            gUnitTestResult2.setError(exception.toString());
        }
        return gUnitTestResult2;
    }
}

