encapsulated package test
"
  file:        test.mo
  package:     test
  description: Generated by Susan.
"

public import Tpl;

public import TplAbsyn;

public function pathIdent
  input Tpl.Text in_txt;
  input TplAbsyn.PathIdent in_a_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_it)
    local
      Tpl.Text txt;
      TplAbsyn.PathIdent i_path;
      TplAbsyn.Ident i_ident;

    case ( txt,
           TplAbsyn.IDENT(ident = i_ident) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
      then txt;

    case ( txt,
           TplAbsyn.PATH_IDENT(ident = i_ident, path = i_path) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = pathIdent(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end pathIdent;

protected function lm_3
  input Tpl.Text in_txt;
  input TplAbsyn.TypedIdents in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      TplAbsyn.TypedIdents rest;
      TplAbsyn.Ident i_id;
      TplAbsyn.PathIdent i_pid;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_id, i_pid) :: rest )
      equation
        txt = pathIdent(txt, i_pid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_id);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";//heja"));
        txt = Tpl.nextIter(txt);
        txt = lm_3(txt, rest);
      then txt;
  end match;
end lm_3;

public function typedIdents
  input Tpl.Text txt;
  input TplAbsyn.TypedIdents a_decls;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_3(out_txt, a_decls);
  out_txt := Tpl.popIter(out_txt);
end typedIdents;

protected function lm_5
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_5(txt, rest);
      then txt;
  end match;
end lm_5;

public function test
  input Tpl.Text txt;
  input list<String> a_items;
  input Integer a_ind;

  output Tpl.Text out_txt;
protected
  String ret_5;
  Integer ret_4;
  Tpl.StringToken ret_3;
  Tpl.Text txt_2;
  Integer ret_1;
  String ret_0;
algorithm
  ret_0 := intString(a_ind);
  ret_1 := testfn(intString(a_ind));
  txt_2 := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("ss"));
  txt_2 := Tpl.writeStr(txt_2, intString(a_ind));
  ret_3 := Tpl.textStrTok(txt_2);
  ret_4 := testfn("2");
  ret_5 := intString(ret_4);
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(ret_0)), ret_1, 0, ret_3, 0, Tpl.ST_STRING(ret_5)));
  out_txt := lm_5(out_txt, a_items);
  out_txt := Tpl.popIter(out_txt);
end test;

protected function lm_7
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_7(txt, rest);
      then txt;
  end match;
end lm_7;

public function test2
  input Tpl.Text txt;
  input list<String> a_items;
  input String a_sep;
  input Integer a_a;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(a_sep)), a_a, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_7(out_txt, a_items);
  out_txt := Tpl.popIter(out_txt);
end test2;

protected function lm_9
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_st;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_st :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bla"));
        txt = Tpl.writeStr(txt, i_st);
        txt = Tpl.nextIter(txt);
        txt = lm_9(txt, rest);
      then txt;
  end match;
end lm_9;

protected function smf_10
  input Tpl.Text in_txt;
  input String in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      String i_st;

    case ( txt,
           i_st )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bla"));
        txt = Tpl.writeStr(txt, i_st);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_10;

protected function smf_11
  input Tpl.Text in_txt;
  input Integer in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Integer i_st;

    case ( txt,
           i_st )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bla"));
        txt = Tpl.writeStr(txt, intString(i_st));
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_11;

protected function lm_12
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_12(txt, rest);
      then txt;
  end match;
end lm_12;

protected function smf_13
  input Tpl.Text in_txt;
  input String in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      String i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_13;

protected function smf_14
  input Tpl.Text in_txt;
  input Integer in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Integer i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeStr(txt, intString(i_it));
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_14;

protected function lm_15
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_15(txt, rest);
      then txt;
  end match;
end lm_15;

protected function smf_16
  input Tpl.Text in_txt;
  input String in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      String i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_16;

protected function smf_17
  input Tpl.Text in_txt;
  input Integer in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Integer i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeStr(txt, intString(i_it));
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_17;

protected function smf_18
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_18;

protected function smf_19
  input Tpl.Text in_txt;
  input Tpl.StringToken in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.StringToken i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeTok(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_19;

protected function lm_20
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_20(txt, rest);
      then txt;
  end match;
end lm_20;

protected function smf_21
  input Tpl.Text in_txt;
  input String in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      String i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_21;

protected function smf_22
  input Tpl.Text in_txt;
  input Integer in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Integer i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeStr(txt, intString(i_it));
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_22;

protected function lm_23
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_23(txt, rest);
      then txt;
  end match;
end lm_23;

protected function smf_24
  input Tpl.Text in_txt;
  input String in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      String i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_24;

protected function smf_25
  input Tpl.Text in_txt;
  input Integer in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Integer i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeStr(txt, intString(i_it));
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_25;

protected function fun_26
  input Tpl.Text in_txt;
  input String in_a_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_it)
    local
      Tpl.Text txt;
      String i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeStr(txt, i_it);
      then txt;
  end match;
end fun_26;

protected function lm_27
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = fun_26(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_27(txt, rest);
      then txt;
  end match;
end lm_27;

protected function fun_28
  input Tpl.Text in_txt;
  input String in_a_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_it)
    local
      Tpl.Text txt;
      String i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeStr(txt, i_it);
      then txt;
  end match;
end fun_28;

protected function smf_29
  input Tpl.Text in_txt;
  input String in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      String i_it;

    case ( txt,
           i_it )
      equation
        txt = fun_28(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_29;

protected function fun_30
  input Tpl.Text in_txt;
  input Integer in_a_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_it)
    local
      Tpl.Text txt;
      Integer i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeStr(txt, intString(i_it));
      then txt;
  end match;
end fun_30;

protected function smf_31
  input Tpl.Text in_txt;
  input Integer in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Integer i_it;

    case ( txt,
           i_it )
      equation
        txt = fun_30(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_31;

protected function fun_32
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;
      String i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeStr(txt, i_it);
      then txt;
  end match;
end fun_32;

protected function smf_33
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;
      String str_0;

    case ( txt,
           i_it )
      equation
        str_0 = Tpl.textString(i_it);
        txt = fun_32(txt, str_0);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_33;

protected function fun_34
  input Tpl.Text in_txt;
  input Tpl.StringToken in_a_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_it)
    local
      Tpl.Text txt;
      Tpl.StringToken i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeTok(txt, i_it);
      then txt;
  end match;
end fun_34;

protected function smf_35
  input Tpl.Text in_txt;
  input Tpl.StringToken in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.StringToken i_it;

    case ( txt,
           i_it )
      equation
        txt = fun_34(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_35;

protected function fun_36
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;
      String i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeStr(txt, i_it);
      then txt;
  end match;
end fun_36;

public function test3
  input Tpl.Text txt;
  input list<String> a_items;
  input String a_item;
  input Integer a_ii;

  output Tpl.Text out_txt;
protected
  String str_3;
  Tpl.Text txt_2;
  Tpl.Text txt_1;
  Tpl.Text txt_0;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_9(out_txt, a_items);
  out_txt := smf_10(out_txt, a_item);
  out_txt := smf_11(out_txt, a_ii);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  txt_0 := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  txt_0 := lm_12(txt_0, a_items);
  txt_0 := smf_13(txt_0, a_item);
  txt_0 := smf_14(txt_0, a_ii);
  txt_0 := Tpl.popIter(txt_0);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_15(out_txt, a_items);
  out_txt := smf_16(out_txt, a_item);
  out_txt := smf_17(out_txt, a_ii);
  out_txt := smf_18(out_txt, txt_0);
  out_txt := smf_19(out_txt, Tpl.ST_STRING("blaaa"));
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_20(out_txt, a_items);
  out_txt := smf_21(out_txt, a_item);
  out_txt := smf_22(out_txt, a_ii);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("!!!!!error should be\n"));
  txt_1 := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  txt_1 := lm_23(txt_1, a_items);
  txt_1 := smf_24(txt_1, a_item);
  txt_1 := smf_25(txt_1, a_ii);
  txt_1 := Tpl.popIter(txt_1);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_27(out_txt, a_items);
  out_txt := smf_29(out_txt, a_item);
  out_txt := smf_31(out_txt, a_ii);
  out_txt := smf_33(out_txt, txt_1);
  out_txt := smf_35(out_txt, Tpl.ST_STRING("blaaa"));
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  txt_2 := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("aha"));
  txt_2 := Tpl.writeStr(txt_2, intString(a_ii));
  str_3 := Tpl.textString(txt_2);
  out_txt := fun_36(out_txt, str_3);
end test3;

public function testCond
  input Tpl.Text in_txt;
  input Option<tuple<String, Integer>> in_a_nvOpt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_nvOpt)
    local
      Tpl.Text txt;
      Integer i_value;
      String i_name;

    case ( txt,
           SOME((i_name, i_value)) )
      equation
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeStr(txt, intString(i_value));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("no value"));
      then txt;
  end match;
end testCond;

public function testCond2
  input Tpl.Text in_txt;
  input Option<tuple<String, Integer>> in_a_nvOpt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_nvOpt)
    local
      Tpl.Text txt;
      Integer i_value;
      String i_name;

    case ( txt,
           SOME((i_name, i_value)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SOME("));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_value));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("none"));
      then txt;
  end match;
end testCond2;

public function mapInt
  input Tpl.Text txt;
  input Integer a_it;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("(int:"));
  out_txt := Tpl.writeStr(out_txt, intString(a_it));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(")"));
end mapInt;

public function mapString
  input Tpl.Text txt;
  input String a_it;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("(str:"));
  out_txt := Tpl.writeStr(out_txt, a_it);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(")"));
end mapString;

public function mapIntString
  input Tpl.Text txt;
  input Integer a_intPar;
  input String a_stPar;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("(int:"));
  out_txt := Tpl.writeStr(out_txt, intString(a_intPar));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(",str:"));
  out_txt := Tpl.writeStr(out_txt, a_stPar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(")"));
end mapIntString;

protected function smf_43
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = mapString(txt, Tpl.textString(i_it));
      then txt;
  end match;
end smf_43;

protected function lm_44
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_it;
      Tpl.Text txt_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt_0 = mapInt(Tpl.emptyTxt, i_it);
        txt = smf_43(txt, txt_0);
        txt = Tpl.nextIter(txt);
        txt = lm_44(txt, rest);
      then txt;
  end match;
end lm_44;

public function testMap
  input Tpl.Text txt;
  input list<Integer> a_ints;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_44(out_txt, a_ints);
  out_txt := Tpl.popIter(out_txt);
end testMap;

protected function smf_46
  input Tpl.Text in_txt;
  input Tpl.Text in_it;
  input Integer in_a_int;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it, in_a_int)
    local
      Tpl.Text txt;
      Integer a_int;
      Tpl.Text i_st;

    case ( txt,
           i_st,
           a_int )
      equation
        txt = mapIntString(txt, a_int, Tpl.textString(i_st));
      then txt;
  end match;
end smf_46;

protected function lm_47
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_int;
      Tpl.Text txt_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_int :: rest )
      equation
        txt_0 = mapInt(Tpl.emptyTxt, i_int);
        txt = smf_46(txt, txt_0, i_int);
        txt = Tpl.nextIter(txt);
        txt = lm_47(txt, rest);
      then txt;
  end match;
end lm_47;

public function testMap2
  input Tpl.Text txt;
  input list<Integer> a_ints;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_47(out_txt, a_ints);
  out_txt := Tpl.popIter(out_txt);
end testMap2;

protected function lm_49
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_int;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_int :: rest )
      equation
        txt = mapInt(txt, i_int);
        txt = Tpl.nextIter(txt);
        txt = lm_49(txt, rest);
      then txt;
  end match;
end lm_49;

protected function lm_50
  input Tpl.Text in_txt;
  input list<list<Integer>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<Integer>> rest;
      list<Integer> i_intLst;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_intLst :: rest )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_49(txt, i_intLst);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_50(txt, rest);
      then txt;
  end match;
end lm_50;

public function testMap3
  input Tpl.Text txt;
  input list<list<Integer>> a_lstOfLst;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushBlock(txt, Tpl.BT_ANCHOR(0));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_50(out_txt, a_lstOfLst);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.popBlock(out_txt);
end testMap3;

protected function lm_52
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = mapInt(txt, i_it);
        txt = lm_52(txt, rest);
      then txt;
  end match;
end lm_52;

protected function lm_53
  input Tpl.Text in_txt;
  input list<list<Integer>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<Integer>> rest;
      list<Integer> i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = lm_52(txt, i_it);
        txt = lm_53(txt, rest);
      then txt;
  end match;
end lm_53;

public function testMap4
  input Tpl.Text txt;
  input list<list<Integer>> a_lstOfLst;

  output Tpl.Text out_txt;
algorithm
  out_txt := lm_53(txt, a_lstOfLst);
end testMap4;

protected function lm_55
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_it;
      Tpl.Text txt_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt_0 = mapInt(Tpl.emptyTxt, i_it);
        txt = mapString(txt, Tpl.textString(txt_0));
        txt = Tpl.nextIter(txt);
        txt = lm_55(txt, rest);
      then txt;
  end match;
end lm_55;

public function testMap5
  input Tpl.Text txt;
  input list<Integer> a_ints;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_55(out_txt, a_ints);
  out_txt := Tpl.popIter(out_txt);
end testMap5;

protected function lm_57
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, intString(i_it));
        txt = Tpl.nextIter(txt);
        txt = lm_57(txt, rest);
      then txt;
  end match;
end lm_57;

protected function lm_58
  input Tpl.Text in_txt;
  input list<list<Integer>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<Integer>> rest;
      list<Integer> i_intLst;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_intLst :: rest )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_57(txt, i_intLst);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_58(txt, rest);
      then txt;
  end match;
end lm_58;

public function intMatrix
  input Tpl.Text txt;
  input list<list<Integer>> a_lstOfLst;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("[ "));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_ANCHOR(0));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_58(out_txt, a_lstOfLst);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" ]"));
end intMatrix;

protected function fun_60
  input Tpl.Text in_txt;
  input Tpl.Text in_a_mi;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_mi)
    local
      Tpl.Text txt;
      Tpl.Text i_mi;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* weird I */"));
      then txt;

    case ( txt,
           i_mi )
      equation
        txt = Tpl.writeText(txt, i_mi);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" name;"));
      then txt;
  end match;
end fun_60;

public function ifTest
  input Tpl.Text txt;
  input Integer a_i;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_mi;
algorithm
  l_mi := mapInt(Tpl.emptyTxt, a_i);
  out_txt := fun_60(txt, l_mi);
end ifTest;

protected function smf_62
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_ii;

    case ( txt,
           i_ii )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("some hej"));
        txt = Tpl.writeText(txt, i_ii);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end smf_62;

public function bindTest
  input Tpl.Text txt;

  output Tpl.Text out_txt;
protected
  Tpl.Text txt_0;
algorithm
  txt_0 := ifTest(Tpl.emptyTxt, 1);
  out_txt := smf_62(txt, txt_0);
end bindTest;

public function txtTest
  input Tpl.Text txt;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_txt;
algorithm
  l_txt := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("ahoj"));
  l_txt := Tpl.writeTok(l_txt, Tpl.ST_STRING("hej"));
  out_txt := Tpl.writeText(txt, l_txt);
end txtTest;

public function txtTest2
  input Tpl.Text txt;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_txt;
algorithm
  l_txt := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("ahoj2"));
  l_txt := Tpl.writeTok(l_txt, Tpl.ST_STRING("hej2"));
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("bláá "));
  out_txt := Tpl.writeText(out_txt, l_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("jo"));
end txtTest2;

public function txtTest3
  input Tpl.Text txt;
  input String a_hej;
  input Tpl.Text a_buf;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_buf;
protected
  Tpl.Text l_txt;
algorithm
  l_txt := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("aahoj2"));
  l_txt := Tpl.writeTok(l_txt, Tpl.ST_STRING("ahej2"));
  out_a_buf := Tpl.writeText(a_buf, l_txt);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("abláá "));
  out_txt := Tpl.writeText(out_txt, l_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("ajo"));
end txtTest3;

public function txtTest4
  input Tpl.Text in_txt;
  input String in_a_hej;
  input Tpl.Text in_a_buf;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_buf;
algorithm
  (out_txt, out_a_buf) :=
  match(in_txt, in_a_hej, in_a_buf)
    local
      Tpl.Text txt;
      Tpl.Text a_buf;
      String i_hej;
      Tpl.Text l_txt;

    case ( txt,
           "",
           a_buf )
      then (txt, a_buf);

    case ( txt,
           i_hej,
           a_buf )
      equation
        l_txt = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("ahoj2"));
        l_txt = Tpl.writeStr(l_txt, i_hej);
        a_buf = Tpl.writeText(a_buf, l_txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bláá "));
        txt = Tpl.writeText(txt, l_txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("jo"));
      then (txt, a_buf);
  end match;
end txtTest4;

public function txtTest5
  input Tpl.Text txt;
  input String a_hej;
  input Tpl.Text a_buf;
  input Tpl.Text a_nobuf;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_buf;
  output Tpl.Text out_a_nobuf;
protected
  Tpl.Text l_txt;
algorithm
  l_txt := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("aahoj2"));
  l_txt := Tpl.writeTok(l_txt, Tpl.ST_STRING("ahej2"));
  out_a_buf := Tpl.writeText(a_buf, l_txt);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("abláá "));
  out_txt := Tpl.writeText(out_txt, l_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("ajo"));
  out_a_nobuf := a_nobuf;
end txtTest5;

protected function lm_69
  input Tpl.Text in_txt;
  input list<String> in_items;
  input Tpl.Text in_a_nomut;
  input Tpl.Text in_a_mytxt;
  input Tpl.Text in_a_buf2;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_mytxt;
  output Tpl.Text out_a_buf2;
algorithm
  (out_txt, out_a_mytxt, out_a_buf2) :=
  match(in_txt, in_items, in_a_nomut, in_a_mytxt, in_a_buf2)
    local
      Tpl.Text txt;
      list<String> rest;
      Tpl.Text a_nomut;
      Tpl.Text a_mytxt;
      Tpl.Text a_buf2;
      String i_it;

    case ( txt,
           {},
           _,
           a_mytxt,
           a_buf2 )
      then (txt, a_mytxt, a_buf2);

    case ( txt,
           i_it :: rest,
           a_nomut,
           a_mytxt,
           a_buf2 )
      equation
        a_buf2 = Tpl.writeStr(a_buf2, i_it);
        a_mytxt = Tpl.writeStr(a_mytxt, i_it);
        a_mytxt = Tpl.writeTok(a_mytxt, Tpl.ST_STRING("jo"));
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.writeText(txt, a_nomut);
        txt = Tpl.nextIter(txt);
        (txt, a_mytxt, a_buf2) = lm_69(txt, rest, a_nomut, a_mytxt, a_buf2);
      then (txt, a_mytxt, a_buf2);
  end match;
end lm_69;

protected function smf_70
  input Tpl.Text in_txt;
  input String in_it;
  input Tpl.Text in_a_nomut;
  input Tpl.Text in_a_mytxt;
  input Tpl.Text in_a_buf2;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_mytxt;
  output Tpl.Text out_a_buf2;
algorithm
  (out_txt, out_a_mytxt, out_a_buf2) :=
  match(in_txt, in_it, in_a_nomut, in_a_mytxt, in_a_buf2)
    local
      Tpl.Text txt;
      Tpl.Text a_nomut;
      Tpl.Text a_mytxt;
      Tpl.Text a_buf2;
      String i_it;

    case ( txt,
           i_it,
           a_nomut,
           a_mytxt,
           a_buf2 )
      equation
        a_buf2 = Tpl.writeStr(a_buf2, i_it);
        a_mytxt = Tpl.writeStr(a_mytxt, i_it);
        a_mytxt = Tpl.writeTok(a_mytxt, Tpl.ST_STRING("jo"));
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.writeText(txt, a_nomut);
      then (txt, a_mytxt, a_buf2);
  end match;
end smf_70;

protected function fun_71
  input Tpl.Text in_txt;
  input list<String> in_a_hej;
  input Tpl.Text in_a_mytxt;
  input Tpl.Text in_a_nomut;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_mytxt;
algorithm
  (out_txt, out_a_mytxt) :=
  match(in_txt, in_a_hej, in_a_mytxt, in_a_nomut)
    local
      Tpl.Text txt;
      Tpl.Text a_mytxt;
      Tpl.Text a_nomut;
      String i_h;
      list<String> i_hej;
      Tpl.StringToken ret_2;
      Tpl.StringToken ret_1;
      Tpl.Text l_buf2;

    case ( txt,
           (i_hej as "1" :: _),
           a_mytxt,
           a_nomut )
      equation
        l_buf2 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("hop"));
        ret_1 = Tpl.textStrTok(a_nomut);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(ret_1), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_mytxt, l_buf2) = lm_69(txt, i_hej, a_nomut, a_mytxt, l_buf2);
        txt = Tpl.popIter(txt);
      then (txt, a_mytxt);

    case ( txt,
           i_h :: _,
           a_mytxt,
           a_nomut )
      equation
        l_buf2 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("hop"));
        ret_2 = Tpl.textStrTok(a_nomut);
        (txt, a_mytxt, l_buf2) = smf_70(txt, i_h, a_nomut, a_mytxt, l_buf2);
      then (txt, a_mytxt);

    case ( txt,
           _,
           a_mytxt,
           _ )
      then (txt, a_mytxt);
  end match;
end fun_71;

public function txtTest6
  input Tpl.Text txt;
  input list<String> a_hej;
  input Tpl.Text a_buf;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_buf;
protected
  Tpl.Text l_nomut;
  Tpl.Text l_mytxt;
algorithm
  l_mytxt := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("bolo"));
  l_nomut := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING(","));
  (out_txt, l_mytxt) := fun_71(txt, a_hej, l_mytxt, l_nomut);
  out_a_buf := a_buf;
end txtTest6;

public function contCase
  input Tpl.Text in_txt;
  input String in_a_tst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_tst)
    local
      Tpl.Text txt;

    case ( txt,
           "a" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("hej"));
      then txt;

    case ( txt,
           "b" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("hej"));
      then txt;

    case ( txt,
           "bb" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("hej"));
      then txt;

    case ( txt,
           "c" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("hej"));
      then txt;

    case ( txt,
           "d" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Hej!"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end contCase;

public function contCase2
  input Tpl.Text in_txt;
  input TplAbsyn.PathIdent in_a_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_it)
    local
      Tpl.Text txt;
      TplAbsyn.Ident i_ident;

    case ( txt,
           TplAbsyn.IDENT(ident = i_ident) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("id="));
        txt = Tpl.writeStr(txt, i_ident);
      then txt;

    case ( txt,
           TplAbsyn.PATH_IDENT(ident = i_ident) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("id="));
        txt = Tpl.writeStr(txt, i_ident);
      then txt;

    case ( txt,
           TplAbsyn.IDENT(ident = (i_ident as "ii")) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("id="));
        txt = Tpl.writeStr(txt, i_ident);
      then txt;

    case ( txt,
           TplAbsyn.IDENT(ident = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("hej"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end contCase2;

public function genericTest
  input Tpl.Text txt;
  input list<String> a_lst;

  output Tpl.Text out_txt;
protected
  Integer ret_0;
algorithm
  ret_0 := listLength(a_lst);
  out_txt := Tpl.writeStr(txt, intString(ret_0));
end genericTest;

public function genericTest2
  input Tpl.Text txt;
  input list<Integer> a_lst;

  output Tpl.Text out_txt;
protected
  Integer ret_0;
algorithm
  ret_0 := listLength(a_lst);
  out_txt := Tpl.writeStr(txt, intString(ret_0));
end genericTest2;

public function genericTest3
  input Tpl.Text txt;
  input list<Integer> a_lst;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := listMember(3, a_lst);
  out_txt := Tpl.writeStr(txt, Tpl.booleanString(ret_0));
end genericTest3;

public function genericTest4
  input Tpl.Text txt;
  input list<String> a_lst;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := listMember("ahoj", a_lst);
  out_txt := Tpl.writeStr(txt, Tpl.booleanString(ret_0));
end genericTest4;

public function genericTest5
  input Tpl.Text txt;
  input list<String> a_lst;
  input String a_hoj;

  output Tpl.Text out_txt;
protected
  Boolean ret_1;
  Tpl.Text txt_0;
algorithm
  txt_0 := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("a"));
  txt_0 := Tpl.writeStr(txt_0, a_hoj);
  ret_1 := listMember(Tpl.textString(txt_0), a_lst);
  out_txt := Tpl.writeStr(txt, Tpl.booleanString(ret_1));
end genericTest5;

public function genericTest6
  input Tpl.Text txt;
  input list<String> a_lst;
  input Integer a_idx;

  output Tpl.Text out_txt;
protected
  String ret_0;
algorithm
  ret_0 := listGet(a_lst, a_idx);
  out_txt := Tpl.writeStr(txt, ret_0);
end genericTest6;

public function genericTest7
  input Tpl.Text txt;
  input list<Integer> a_lst;
  input Integer a_idx;

  output Tpl.Text out_txt;
protected
  Integer ret_0;
algorithm
  ret_0 := listGet(a_lst, a_idx);
  out_txt := Tpl.writeStr(txt, intString(ret_0));
end genericTest7;

protected function lm_82
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, intString(i_it));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("th revesed"));
        txt = lm_82(txt, rest);
      then txt;
  end match;
end lm_82;

public function genericTest8
  input Tpl.Text txt;
  input list<Integer> a_lst;

  output Tpl.Text out_txt;
protected
  list<Integer> ret_0;
algorithm
  ret_0 := listReverse(a_lst);
  out_txt := lm_82(txt, ret_0);
end genericTest8;

protected function lm_84
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("hej!"));
        txt = lm_84(txt, rest);
      then txt;
  end match;
end lm_84;

protected function lm_85
  input Tpl.Text in_txt;
  input list<list<String>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<String>> rest;
      list<String> i_it;
      list<String> ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        ret_0 = listReverse(i_it);
        txt = lm_84(txt, ret_0);
        txt = lm_85(txt, rest);
      then txt;
  end match;
end lm_85;

public function genericTest9
  input Tpl.Text txt;
  input list<list<String>> a_lst;

  output Tpl.Text out_txt;
protected
  list<list<String>> ret_0;
algorithm
  ret_0 := listReverse(a_lst);
  out_txt := lm_85(txt, ret_0);
end genericTest9;

public function implementationTempl
  input Tpl.Text txt;
  input String a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeStr(txt, a_str);
end implementationTempl;

public function callImplementationTempl
  input Tpl.Text txt;
  input String a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt := implementationTempl(txt, a_str);
end callImplementationTempl;

protected function fun_89
  input Tpl.Text in_txt;
  input Boolean in_a_cond;
  input TplAbsyn.PathIdent in_a_path;
  input TplAbsyn.Ident in_a_ident;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cond, in_a_path, in_a_ident)
    local
      Tpl.Text txt;
      TplAbsyn.PathIdent a_path;
      TplAbsyn.Ident a_ident;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_path,
           a_ident )
      equation
        txt = Tpl.writeStr(txt, a_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = pathIdent(txt, a_path);
      then txt;
  end match;
end fun_89;

public function pathIdentIf
  input Tpl.Text in_txt;
  input TplAbsyn.PathIdent in_a_pid;
  input Boolean in_a_cond;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_pid, in_a_cond)
    local
      Tpl.Text txt;
      Boolean a_cond;
      TplAbsyn.PathIdent i_path;
      TplAbsyn.Ident i_ident;

    case ( txt,
           TplAbsyn.IDENT(ident = i_ident),
           _ )
      equation
        txt = Tpl.writeStr(txt, i_ident);
      then txt;

    case ( txt,
           TplAbsyn.PATH_IDENT(ident = i_ident, path = i_path),
           a_cond )
      equation
        txt = fun_89(txt, a_cond, i_path, i_ident);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end pathIdentIf;

protected function fun_91
  input Tpl.Text in_txt;
  input Boolean in_a_cond;
  input Integer in_a_strIdx;
  input String in_a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cond, in_a_strIdx, in_a_str)
    local
      Tpl.Text txt;
      Integer a_strIdx;
      String a_str;

    case ( txt,
           false,
           a_strIdx,
           a_str )
      equation
        txt = Tpl.writeStr(txt, a_str);
        txt = Tpl.writeStr(txt, intString(a_strIdx));
      then txt;

    case ( txt,
           _,
           _,
           a_str )
      equation
        txt = Tpl.writeStr(txt, a_str);
      then txt;
  end match;
end fun_91;

protected function lm_92
  input Tpl.Text in_txt;
  input list<String> in_items;
  input Boolean in_a_cond;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_cond)
    local
      Tpl.Text txt;
      list<String> rest;
      Boolean a_cond;
      Integer x_strIdx;
      String i_str;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_str :: rest,
           a_cond )
      equation
        x_strIdx = Tpl.getIteri_i0(txt);
        txt = fun_91(txt, a_cond, x_strIdx, i_str);
        txt = Tpl.nextIter(txt);
        txt = lm_92(txt, rest, a_cond);
      then txt;
  end match;
end lm_92;

public function hasIndexTest
  input Tpl.Text txt;
  input list<String> a_lst;
  input Boolean a_cond;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(10, NONE(), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_92(out_txt, a_lst, a_cond);
  out_txt := Tpl.popIter(out_txt);
end hasIndexTest;

public function lettst
  input Tpl.Text txt;
  input String a_str;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_a_2;
  Tpl.Text l_b_1;
  Tpl.Text l_a_1;
  Tpl.Text l_b;
  Tpl.Text l_a;
algorithm
  l_b := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("ahoj"));
  l_a := Tpl.writeText(Tpl.emptyTxt, l_b);
  l_a := Tpl.writeTok(l_a, Tpl.ST_STRING(" doma"));
  l_a_1 := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("hoj"));
  l_b_1 := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("b inner 3"));
  l_b_1 := Tpl.writeText(l_b_1, l_a_1);
  l_a_2 := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("a inner"));
  l_b := Tpl.writeText(Tpl.emptyTxt, l_a_2);
  l_b := Tpl.writeText(l_b, l_b_1);
  out_txt := Tpl.writeText(txt, l_b);
  out_txt := Tpl.writeText(out_txt, l_a_1);
  out_txt := Tpl.writeText(out_txt, l_a);
end lettst;

end test;