/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook;

import java.io.IOException;
import java.net.URL;
import org.apache.stylebook.BasicContext;
import org.apache.stylebook.BasicParameters;
import org.apache.stylebook.CreationContext;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Engine;
import org.apache.stylebook.LoadingException;
import org.apache.stylebook.NodeListParameters;
import org.apache.stylebook.Project;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Loader {
    private Engine engine = null;

    public Loader(Engine engine) {
        this.engine = engine;
    }

    public Project load(URL uRL, URL uRL2) throws LoadingException {
        try {
            this.engine.log(this, "Parsing Project file");
            Document document = this.engine.getParser().parse(uRL2);
            BasicContext basicContext = new BasicContext(uRL2, "");
            this.engine.debug(this, "Parsing Loader configuration");
            Document document2 = this.engine.getParser().parse(uRL);
            if (!document2.getDocumentElement().getTagName().equals("loader")) {
                throw new LoadingException("Loader config is not <loader>");
            }
            NodeList nodeList = document2.getDocumentElement().getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                if (nodeList.item(n).getNodeType() == 1) {
                    document = this.process(document, (Element)nodeList.item(n), basicContext);
                }
                ++n;
            }
            BasicParameters basicParameters = new BasicParameters();
            basicParameters.setParameter("stylebook.project", uRL2.toExternalForm());
            Project project = new Project(this.engine, document, basicParameters, uRL2);
            return project;
        }
        catch (IOException iOException) {
            this.engine.log(this, "Caught " + iOException.getClass().getName());
            throw new LoadingException(iOException.getMessage());
        }
        catch (CreationException creationException) {
            this.engine.log(this, "Caught " + creationException.getClass().getName());
            throw new LoadingException(creationException.getMessage());
        }
    }

    private Document process(Document document, Element element, CreationContext creationContext) throws IOException, CreationException, LoadingException {
        if (!element.getTagName().equals("processor")) {
            throw new LoadingException("Unknown element <" + element.getTagName() + ">");
        }
        String string = element.getAttribute("name");
        NodeListParameters nodeListParameters = new NodeListParameters(element.getChildNodes());
        document = this.engine.getProcessor(string).process(document, creationContext, nodeListParameters);
        return document;
    }
}

