/*******************************************************************************
 * Copyright (c) 2018, College of William & Mary
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the College of William & Mary nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COLLEGE OF WILLIAM & MARY BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * PRIMME: https://github.com/primme/primme
 * Contact: Andreas Stathopoulos, a n d r e a s _at_ c s . w m . e d u
 *******************************************************************************
 *   NOTE: THIS FILE IS AUTOMATICALLY GENERATED. PLEASE DON'T MODIFY
 ******************************************************************************/


#ifndef cublas_wrapper_H
#define cublas_wrapper_H
#if !defined(CHECK_TEMPLATE) && !defined(toCudaDataType)
#  define toCudaDataType CONCAT(toCudaDataType,SCALAR_SUF)
#endif
void toCudaDataTypecublas_hprimme(primme_op_datatype xt, void *r);
#if !defined(CHECK_TEMPLATE) && !defined(toCublasComputeDataType)
#  define toCublasComputeDataType CONCAT(toCublasComputeDataType,SCALAR_SUF)
#endif
void toCublasComputeDataTypecublas_hprimme(primme_op_datatype xt, void *r);
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_Sprimme)
#  define Num_check_pointer_Sprimme CONCAT(Num_check_pointer_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_Rprimme)
#  define Num_check_pointer_Rprimme CONCAT(Num_check_pointer_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_SHprimme)
#  define Num_check_pointer_SHprimme CONCAT(Num_check_pointer_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_RHprimme)
#  define Num_check_pointer_RHprimme CONCAT(Num_check_pointer_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_SXprimme)
#  define Num_check_pointer_SXprimme CONCAT(Num_check_pointer_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_RXprimme)
#  define Num_check_pointer_RXprimme CONCAT(Num_check_pointer_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_Shprimme)
#  define Num_check_pointer_Shprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_Rhprimme)
#  define Num_check_pointer_Rhprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_Ssprimme)
#  define Num_check_pointer_Ssprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_Rsprimme)
#  define Num_check_pointer_Rsprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_Sdprimme)
#  define Num_check_pointer_Sdprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_Rdprimme)
#  define Num_check_pointer_Rdprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_Sqprimme)
#  define Num_check_pointer_Sqprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_Rqprimme)
#  define Num_check_pointer_Rqprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_SXhprimme)
#  define Num_check_pointer_SXhprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_RXhprimme)
#  define Num_check_pointer_RXhprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_SXsprimme)
#  define Num_check_pointer_SXsprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_RXsprimme)
#  define Num_check_pointer_RXsprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_SXdprimme)
#  define Num_check_pointer_SXdprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_RXdprimme)
#  define Num_check_pointer_RXdprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_SXqprimme)
#  define Num_check_pointer_SXqprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_RXqprimme)
#  define Num_check_pointer_RXqprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_SHhprimme)
#  define Num_check_pointer_SHhprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_RHhprimme)
#  define Num_check_pointer_RHhprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_SHsprimme)
#  define Num_check_pointer_SHsprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_RHsprimme)
#  define Num_check_pointer_RHsprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_SHdprimme)
#  define Num_check_pointer_SHdprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_RHdprimme)
#  define Num_check_pointer_RHdprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_SHqprimme)
#  define Num_check_pointer_SHqprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_check_pointer_RHqprimme)
#  define Num_check_pointer_RHqprimme CONCAT(Num_check_pointer_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_check_pointer_cublas_hprimme(void *x);
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_Sprimme)
#  define Num_malloc_Sprimme CONCAT(Num_malloc_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_Rprimme)
#  define Num_malloc_Rprimme CONCAT(Num_malloc_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_SHprimme)
#  define Num_malloc_SHprimme CONCAT(Num_malloc_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_RHprimme)
#  define Num_malloc_RHprimme CONCAT(Num_malloc_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_SXprimme)
#  define Num_malloc_SXprimme CONCAT(Num_malloc_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_RXprimme)
#  define Num_malloc_RXprimme CONCAT(Num_malloc_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_Shprimme)
#  define Num_malloc_Shprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_Rhprimme)
#  define Num_malloc_Rhprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_Ssprimme)
#  define Num_malloc_Ssprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_Rsprimme)
#  define Num_malloc_Rsprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_Sdprimme)
#  define Num_malloc_Sdprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_Rdprimme)
#  define Num_malloc_Rdprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_Sqprimme)
#  define Num_malloc_Sqprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_Rqprimme)
#  define Num_malloc_Rqprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_SXhprimme)
#  define Num_malloc_SXhprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_RXhprimme)
#  define Num_malloc_RXhprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_SXsprimme)
#  define Num_malloc_SXsprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_RXsprimme)
#  define Num_malloc_RXsprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_SXdprimme)
#  define Num_malloc_SXdprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_RXdprimme)
#  define Num_malloc_RXdprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_SXqprimme)
#  define Num_malloc_SXqprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_RXqprimme)
#  define Num_malloc_RXqprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_SHhprimme)
#  define Num_malloc_SHhprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_RHhprimme)
#  define Num_malloc_RHhprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_SHsprimme)
#  define Num_malloc_SHsprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_RHsprimme)
#  define Num_malloc_RHsprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_SHdprimme)
#  define Num_malloc_SHdprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_RHdprimme)
#  define Num_malloc_RHdprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_SHqprimme)
#  define Num_malloc_SHqprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_malloc_RHqprimme)
#  define Num_malloc_RHqprimme CONCAT(Num_malloc_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_malloc_cublas_hprimme(PRIMME_INT n, dummy_type_cublas_hprimme **x, primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_Sprimme)
#  define Num_free_Sprimme CONCAT(Num_free_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_Rprimme)
#  define Num_free_Rprimme CONCAT(Num_free_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_SHprimme)
#  define Num_free_SHprimme CONCAT(Num_free_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_RHprimme)
#  define Num_free_RHprimme CONCAT(Num_free_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_SXprimme)
#  define Num_free_SXprimme CONCAT(Num_free_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_RXprimme)
#  define Num_free_RXprimme CONCAT(Num_free_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_Shprimme)
#  define Num_free_Shprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_Rhprimme)
#  define Num_free_Rhprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_Ssprimme)
#  define Num_free_Ssprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_Rsprimme)
#  define Num_free_Rsprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_Sdprimme)
#  define Num_free_Sdprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_Rdprimme)
#  define Num_free_Rdprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_Sqprimme)
#  define Num_free_Sqprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_Rqprimme)
#  define Num_free_Rqprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_SXhprimme)
#  define Num_free_SXhprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_RXhprimme)
#  define Num_free_RXhprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_SXsprimme)
#  define Num_free_SXsprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_RXsprimme)
#  define Num_free_RXsprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_SXdprimme)
#  define Num_free_SXdprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_RXdprimme)
#  define Num_free_RXdprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_SXqprimme)
#  define Num_free_SXqprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_RXqprimme)
#  define Num_free_RXqprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_SHhprimme)
#  define Num_free_SHhprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_RHhprimme)
#  define Num_free_RHhprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_SHsprimme)
#  define Num_free_SHsprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_RHsprimme)
#  define Num_free_RHsprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_SHdprimme)
#  define Num_free_SHdprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_RHdprimme)
#  define Num_free_RHdprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_SHqprimme)
#  define Num_free_SHqprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_free_RHqprimme)
#  define Num_free_RHqprimme CONCAT(Num_free_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_free_cublas_hprimme(dummy_type_cublas_hprimme *x, primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_Sprimme)
#  define Num_copy_Tmatrix_Sprimme CONCAT(Num_copy_Tmatrix_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_Rprimme)
#  define Num_copy_Tmatrix_Rprimme CONCAT(Num_copy_Tmatrix_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_SHprimme)
#  define Num_copy_Tmatrix_SHprimme CONCAT(Num_copy_Tmatrix_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_RHprimme)
#  define Num_copy_Tmatrix_RHprimme CONCAT(Num_copy_Tmatrix_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_SXprimme)
#  define Num_copy_Tmatrix_SXprimme CONCAT(Num_copy_Tmatrix_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_RXprimme)
#  define Num_copy_Tmatrix_RXprimme CONCAT(Num_copy_Tmatrix_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_Shprimme)
#  define Num_copy_Tmatrix_Shprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_Rhprimme)
#  define Num_copy_Tmatrix_Rhprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_Ssprimme)
#  define Num_copy_Tmatrix_Ssprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_Rsprimme)
#  define Num_copy_Tmatrix_Rsprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_Sdprimme)
#  define Num_copy_Tmatrix_Sdprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_Rdprimme)
#  define Num_copy_Tmatrix_Rdprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_Sqprimme)
#  define Num_copy_Tmatrix_Sqprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_Rqprimme)
#  define Num_copy_Tmatrix_Rqprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_SXhprimme)
#  define Num_copy_Tmatrix_SXhprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_RXhprimme)
#  define Num_copy_Tmatrix_RXhprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_SXsprimme)
#  define Num_copy_Tmatrix_SXsprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_RXsprimme)
#  define Num_copy_Tmatrix_RXsprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_SXdprimme)
#  define Num_copy_Tmatrix_SXdprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_RXdprimme)
#  define Num_copy_Tmatrix_RXdprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_SXqprimme)
#  define Num_copy_Tmatrix_SXqprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_RXqprimme)
#  define Num_copy_Tmatrix_RXqprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_SHhprimme)
#  define Num_copy_Tmatrix_SHhprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_RHhprimme)
#  define Num_copy_Tmatrix_RHhprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_SHsprimme)
#  define Num_copy_Tmatrix_SHsprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_RHsprimme)
#  define Num_copy_Tmatrix_RHsprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_SHdprimme)
#  define Num_copy_Tmatrix_SHdprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_RHdprimme)
#  define Num_copy_Tmatrix_RHdprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_SHqprimme)
#  define Num_copy_Tmatrix_SHqprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Tmatrix_RHqprimme)
#  define Num_copy_Tmatrix_RHqprimme CONCAT(Num_copy_Tmatrix_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_copy_Tmatrix_cublas_hprimme(void *x, primme_op_datatype xt, PRIMME_INT m,
      PRIMME_INT n, PRIMME_INT ldx, dummy_type_cublas_hprimme *y, PRIMME_INT ldy,
      primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Sprimme)
#  define Num_copy_Sprimme CONCAT(Num_copy_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Rprimme)
#  define Num_copy_Rprimme CONCAT(Num_copy_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_SHprimme)
#  define Num_copy_SHprimme CONCAT(Num_copy_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_RHprimme)
#  define Num_copy_RHprimme CONCAT(Num_copy_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_SXprimme)
#  define Num_copy_SXprimme CONCAT(Num_copy_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_RXprimme)
#  define Num_copy_RXprimme CONCAT(Num_copy_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Shprimme)
#  define Num_copy_Shprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Rhprimme)
#  define Num_copy_Rhprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Ssprimme)
#  define Num_copy_Ssprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Rsprimme)
#  define Num_copy_Rsprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Sdprimme)
#  define Num_copy_Sdprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Rdprimme)
#  define Num_copy_Rdprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Sqprimme)
#  define Num_copy_Sqprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_Rqprimme)
#  define Num_copy_Rqprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_SXhprimme)
#  define Num_copy_SXhprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_RXhprimme)
#  define Num_copy_RXhprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_SXsprimme)
#  define Num_copy_SXsprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_RXsprimme)
#  define Num_copy_RXsprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_SXdprimme)
#  define Num_copy_SXdprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_RXdprimme)
#  define Num_copy_RXdprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_SXqprimme)
#  define Num_copy_SXqprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_RXqprimme)
#  define Num_copy_RXqprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_SHhprimme)
#  define Num_copy_SHhprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_RHhprimme)
#  define Num_copy_RHhprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_SHsprimme)
#  define Num_copy_SHsprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_RHsprimme)
#  define Num_copy_RHsprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_SHdprimme)
#  define Num_copy_SHdprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_RHdprimme)
#  define Num_copy_RHdprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_SHqprimme)
#  define Num_copy_SHqprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_RHqprimme)
#  define Num_copy_RHqprimme CONCAT(Num_copy_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_copy_cublas_hprimme(PRIMME_INT n, dummy_type_cublas_hprimme *x, int incx, dummy_type_cublas_hprimme *y, int incy,
      primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_Sprimme)
#  define Num_set_matrix_Sprimme CONCAT(Num_set_matrix_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_Rprimme)
#  define Num_set_matrix_Rprimme CONCAT(Num_set_matrix_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_SHprimme)
#  define Num_set_matrix_SHprimme CONCAT(Num_set_matrix_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_RHprimme)
#  define Num_set_matrix_RHprimme CONCAT(Num_set_matrix_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_SXprimme)
#  define Num_set_matrix_SXprimme CONCAT(Num_set_matrix_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_RXprimme)
#  define Num_set_matrix_RXprimme CONCAT(Num_set_matrix_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_Shprimme)
#  define Num_set_matrix_Shprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_Rhprimme)
#  define Num_set_matrix_Rhprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_Ssprimme)
#  define Num_set_matrix_Ssprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_Rsprimme)
#  define Num_set_matrix_Rsprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_Sdprimme)
#  define Num_set_matrix_Sdprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_Rdprimme)
#  define Num_set_matrix_Rdprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_Sqprimme)
#  define Num_set_matrix_Sqprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_Rqprimme)
#  define Num_set_matrix_Rqprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_SXhprimme)
#  define Num_set_matrix_SXhprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_RXhprimme)
#  define Num_set_matrix_RXhprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_SXsprimme)
#  define Num_set_matrix_SXsprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_RXsprimme)
#  define Num_set_matrix_RXsprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_SXdprimme)
#  define Num_set_matrix_SXdprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_RXdprimme)
#  define Num_set_matrix_RXdprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_SXqprimme)
#  define Num_set_matrix_SXqprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_RXqprimme)
#  define Num_set_matrix_RXqprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_SHhprimme)
#  define Num_set_matrix_SHhprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_RHhprimme)
#  define Num_set_matrix_RHhprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_SHsprimme)
#  define Num_set_matrix_SHsprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_RHsprimme)
#  define Num_set_matrix_RHsprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_SHdprimme)
#  define Num_set_matrix_SHdprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_RHdprimme)
#  define Num_set_matrix_RHdprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_SHqprimme)
#  define Num_set_matrix_SHqprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_set_matrix_RHqprimme)
#  define Num_set_matrix_RHqprimme CONCAT(Num_set_matrix_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_set_matrix_cublas_hprimme(dummy_type_sprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, dummy_type_cublas_hprimme *y, PRIMME_INT ldy, primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_Sprimme)
#  define Num_get_matrix_Sprimme CONCAT(Num_get_matrix_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_Rprimme)
#  define Num_get_matrix_Rprimme CONCAT(Num_get_matrix_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_SHprimme)
#  define Num_get_matrix_SHprimme CONCAT(Num_get_matrix_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_RHprimme)
#  define Num_get_matrix_RHprimme CONCAT(Num_get_matrix_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_SXprimme)
#  define Num_get_matrix_SXprimme CONCAT(Num_get_matrix_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_RXprimme)
#  define Num_get_matrix_RXprimme CONCAT(Num_get_matrix_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_Shprimme)
#  define Num_get_matrix_Shprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_Rhprimme)
#  define Num_get_matrix_Rhprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_Ssprimme)
#  define Num_get_matrix_Ssprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_Rsprimme)
#  define Num_get_matrix_Rsprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_Sdprimme)
#  define Num_get_matrix_Sdprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_Rdprimme)
#  define Num_get_matrix_Rdprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_Sqprimme)
#  define Num_get_matrix_Sqprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_Rqprimme)
#  define Num_get_matrix_Rqprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_SXhprimme)
#  define Num_get_matrix_SXhprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_RXhprimme)
#  define Num_get_matrix_RXhprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_SXsprimme)
#  define Num_get_matrix_SXsprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_RXsprimme)
#  define Num_get_matrix_RXsprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_SXdprimme)
#  define Num_get_matrix_SXdprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_RXdprimme)
#  define Num_get_matrix_RXdprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_SXqprimme)
#  define Num_get_matrix_SXqprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_RXqprimme)
#  define Num_get_matrix_RXqprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_SHhprimme)
#  define Num_get_matrix_SHhprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_RHhprimme)
#  define Num_get_matrix_RHhprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_SHsprimme)
#  define Num_get_matrix_SHsprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_RHsprimme)
#  define Num_get_matrix_RHsprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_SHdprimme)
#  define Num_get_matrix_SHdprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_RHdprimme)
#  define Num_get_matrix_RHdprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_SHqprimme)
#  define Num_get_matrix_SHqprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_get_matrix_RHqprimme)
#  define Num_get_matrix_RHqprimme CONCAT(Num_get_matrix_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_get_matrix_cublas_hprimme(dummy_type_cublas_hprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, dummy_type_sprimme *y, PRIMME_INT ldy, primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_Sprimme)
#  define Num_gemm_Sprimme CONCAT(Num_gemm_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_Rprimme)
#  define Num_gemm_Rprimme CONCAT(Num_gemm_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_SHprimme)
#  define Num_gemm_SHprimme CONCAT(Num_gemm_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_RHprimme)
#  define Num_gemm_RHprimme CONCAT(Num_gemm_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_SXprimme)
#  define Num_gemm_SXprimme CONCAT(Num_gemm_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_RXprimme)
#  define Num_gemm_RXprimme CONCAT(Num_gemm_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_Shprimme)
#  define Num_gemm_Shprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_Rhprimme)
#  define Num_gemm_Rhprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_Ssprimme)
#  define Num_gemm_Ssprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_Rsprimme)
#  define Num_gemm_Rsprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_Sdprimme)
#  define Num_gemm_Sdprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_Rdprimme)
#  define Num_gemm_Rdprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_Sqprimme)
#  define Num_gemm_Sqprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_Rqprimme)
#  define Num_gemm_Rqprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_SXhprimme)
#  define Num_gemm_SXhprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_RXhprimme)
#  define Num_gemm_RXhprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_SXsprimme)
#  define Num_gemm_SXsprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_RXsprimme)
#  define Num_gemm_RXsprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_SXdprimme)
#  define Num_gemm_SXdprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_RXdprimme)
#  define Num_gemm_RXdprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_SXqprimme)
#  define Num_gemm_SXqprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_RXqprimme)
#  define Num_gemm_RXqprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_SHhprimme)
#  define Num_gemm_SHhprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_RHhprimme)
#  define Num_gemm_RHhprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_SHsprimme)
#  define Num_gemm_SHsprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_RHsprimme)
#  define Num_gemm_RHsprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_SHdprimme)
#  define Num_gemm_SHdprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_RHdprimme)
#  define Num_gemm_RHdprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_SHqprimme)
#  define Num_gemm_SHqprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_RHqprimme)
#  define Num_gemm_RHqprimme CONCAT(Num_gemm_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_gemm_cublas_hprimme(const char *transa, const char *transb, int m, int n,
      int k, dummy_type_sprimme alpha, dummy_type_cublas_hprimme *a, int lda, dummy_type_cublas_hprimme *b, int ldb,
      dummy_type_sprimme beta, dummy_type_cublas_hprimme *c, int ldc, primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_Sprimme)
#  define Num_gemm_dhd_Sprimme CONCAT(Num_gemm_dhd_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_Rprimme)
#  define Num_gemm_dhd_Rprimme CONCAT(Num_gemm_dhd_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_SHprimme)
#  define Num_gemm_dhd_SHprimme CONCAT(Num_gemm_dhd_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_RHprimme)
#  define Num_gemm_dhd_RHprimme CONCAT(Num_gemm_dhd_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_SXprimme)
#  define Num_gemm_dhd_SXprimme CONCAT(Num_gemm_dhd_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_RXprimme)
#  define Num_gemm_dhd_RXprimme CONCAT(Num_gemm_dhd_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_Shprimme)
#  define Num_gemm_dhd_Shprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_Rhprimme)
#  define Num_gemm_dhd_Rhprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_Ssprimme)
#  define Num_gemm_dhd_Ssprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_Rsprimme)
#  define Num_gemm_dhd_Rsprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_Sdprimme)
#  define Num_gemm_dhd_Sdprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_Rdprimme)
#  define Num_gemm_dhd_Rdprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_Sqprimme)
#  define Num_gemm_dhd_Sqprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_Rqprimme)
#  define Num_gemm_dhd_Rqprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_SXhprimme)
#  define Num_gemm_dhd_SXhprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_RXhprimme)
#  define Num_gemm_dhd_RXhprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_SXsprimme)
#  define Num_gemm_dhd_SXsprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_RXsprimme)
#  define Num_gemm_dhd_RXsprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_SXdprimme)
#  define Num_gemm_dhd_SXdprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_RXdprimme)
#  define Num_gemm_dhd_RXdprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_SXqprimme)
#  define Num_gemm_dhd_SXqprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_RXqprimme)
#  define Num_gemm_dhd_RXqprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_SHhprimme)
#  define Num_gemm_dhd_SHhprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_RHhprimme)
#  define Num_gemm_dhd_RHhprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_SHsprimme)
#  define Num_gemm_dhd_SHsprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_RHsprimme)
#  define Num_gemm_dhd_RHsprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_SHdprimme)
#  define Num_gemm_dhd_SHdprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_RHdprimme)
#  define Num_gemm_dhd_RHdprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_SHqprimme)
#  define Num_gemm_dhd_SHqprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_dhd_RHqprimme)
#  define Num_gemm_dhd_RHqprimme CONCAT(Num_gemm_dhd_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_gemm_dhd_cublas_hprimme(const char *transa, const char *transb, int m, int n,
      int k, dummy_type_sprimme alpha, dummy_type_cublas_hprimme *a, int lda, dummy_type_sprimme *b, int ldb,
      dummy_type_sprimme beta, dummy_type_cublas_hprimme *c, int ldc, primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_Sprimme)
#  define Num_gemm_ddh_Sprimme CONCAT(Num_gemm_ddh_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_Rprimme)
#  define Num_gemm_ddh_Rprimme CONCAT(Num_gemm_ddh_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_SHprimme)
#  define Num_gemm_ddh_SHprimme CONCAT(Num_gemm_ddh_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_RHprimme)
#  define Num_gemm_ddh_RHprimme CONCAT(Num_gemm_ddh_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_SXprimme)
#  define Num_gemm_ddh_SXprimme CONCAT(Num_gemm_ddh_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_RXprimme)
#  define Num_gemm_ddh_RXprimme CONCAT(Num_gemm_ddh_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_Shprimme)
#  define Num_gemm_ddh_Shprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_Rhprimme)
#  define Num_gemm_ddh_Rhprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_Ssprimme)
#  define Num_gemm_ddh_Ssprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_Rsprimme)
#  define Num_gemm_ddh_Rsprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_Sdprimme)
#  define Num_gemm_ddh_Sdprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_Rdprimme)
#  define Num_gemm_ddh_Rdprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_Sqprimme)
#  define Num_gemm_ddh_Sqprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_Rqprimme)
#  define Num_gemm_ddh_Rqprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_SXhprimme)
#  define Num_gemm_ddh_SXhprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_RXhprimme)
#  define Num_gemm_ddh_RXhprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_SXsprimme)
#  define Num_gemm_ddh_SXsprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_RXsprimme)
#  define Num_gemm_ddh_RXsprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_SXdprimme)
#  define Num_gemm_ddh_SXdprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_RXdprimme)
#  define Num_gemm_ddh_RXdprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_SXqprimme)
#  define Num_gemm_ddh_SXqprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_RXqprimme)
#  define Num_gemm_ddh_RXqprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_SHhprimme)
#  define Num_gemm_ddh_SHhprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_RHhprimme)
#  define Num_gemm_ddh_RHhprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_SHsprimme)
#  define Num_gemm_ddh_SHsprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_RHsprimme)
#  define Num_gemm_ddh_RHsprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_SHdprimme)
#  define Num_gemm_ddh_SHdprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_RHdprimme)
#  define Num_gemm_ddh_RHdprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_SHqprimme)
#  define Num_gemm_ddh_SHqprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemm_ddh_RHqprimme)
#  define Num_gemm_ddh_RHqprimme CONCAT(Num_gemm_ddh_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_gemm_ddh_cublas_hprimme(const char *transa, const char *transb, int m, int n,
      int k, dummy_type_sprimme alpha, dummy_type_cublas_hprimme *a, int lda, dummy_type_cublas_hprimme *b, int ldb,
      dummy_type_sprimme beta, dummy_type_sprimme *c, int ldc, primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_Sprimme)
#  define Num_gemv_Sprimme CONCAT(Num_gemv_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_Rprimme)
#  define Num_gemv_Rprimme CONCAT(Num_gemv_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_SHprimme)
#  define Num_gemv_SHprimme CONCAT(Num_gemv_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_RHprimme)
#  define Num_gemv_RHprimme CONCAT(Num_gemv_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_SXprimme)
#  define Num_gemv_SXprimme CONCAT(Num_gemv_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_RXprimme)
#  define Num_gemv_RXprimme CONCAT(Num_gemv_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_Shprimme)
#  define Num_gemv_Shprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_Rhprimme)
#  define Num_gemv_Rhprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_Ssprimme)
#  define Num_gemv_Ssprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_Rsprimme)
#  define Num_gemv_Rsprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_Sdprimme)
#  define Num_gemv_Sdprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_Rdprimme)
#  define Num_gemv_Rdprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_Sqprimme)
#  define Num_gemv_Sqprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_Rqprimme)
#  define Num_gemv_Rqprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_SXhprimme)
#  define Num_gemv_SXhprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_RXhprimme)
#  define Num_gemv_RXhprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_SXsprimme)
#  define Num_gemv_SXsprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_RXsprimme)
#  define Num_gemv_RXsprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_SXdprimme)
#  define Num_gemv_SXdprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_RXdprimme)
#  define Num_gemv_RXdprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_SXqprimme)
#  define Num_gemv_SXqprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_RXqprimme)
#  define Num_gemv_RXqprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_SHhprimme)
#  define Num_gemv_SHhprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_RHhprimme)
#  define Num_gemv_RHhprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_SHsprimme)
#  define Num_gemv_SHsprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_RHsprimme)
#  define Num_gemv_RHsprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_SHdprimme)
#  define Num_gemv_SHdprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_RHdprimme)
#  define Num_gemv_RHdprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_SHqprimme)
#  define Num_gemv_SHqprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_RHqprimme)
#  define Num_gemv_RHqprimme CONCAT(Num_gemv_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_gemv_cublas_hprimme(const char *transa, PRIMME_INT m, int n, dummy_type_sprimme alpha,
      dummy_type_cublas_hprimme *a, int lda, dummy_type_cublas_hprimme *x, int incx, dummy_type_sprimme beta, dummy_type_cublas_hprimme *y,
      int incy, primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_Sprimme)
#  define Num_gemv_ddh_Sprimme CONCAT(Num_gemv_ddh_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_Rprimme)
#  define Num_gemv_ddh_Rprimme CONCAT(Num_gemv_ddh_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_SHprimme)
#  define Num_gemv_ddh_SHprimme CONCAT(Num_gemv_ddh_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_RHprimme)
#  define Num_gemv_ddh_RHprimme CONCAT(Num_gemv_ddh_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_SXprimme)
#  define Num_gemv_ddh_SXprimme CONCAT(Num_gemv_ddh_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_RXprimme)
#  define Num_gemv_ddh_RXprimme CONCAT(Num_gemv_ddh_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_Shprimme)
#  define Num_gemv_ddh_Shprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_Rhprimme)
#  define Num_gemv_ddh_Rhprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_Ssprimme)
#  define Num_gemv_ddh_Ssprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_Rsprimme)
#  define Num_gemv_ddh_Rsprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_Sdprimme)
#  define Num_gemv_ddh_Sdprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_Rdprimme)
#  define Num_gemv_ddh_Rdprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_Sqprimme)
#  define Num_gemv_ddh_Sqprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_Rqprimme)
#  define Num_gemv_ddh_Rqprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_SXhprimme)
#  define Num_gemv_ddh_SXhprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_RXhprimme)
#  define Num_gemv_ddh_RXhprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_SXsprimme)
#  define Num_gemv_ddh_SXsprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_RXsprimme)
#  define Num_gemv_ddh_RXsprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_SXdprimme)
#  define Num_gemv_ddh_SXdprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_RXdprimme)
#  define Num_gemv_ddh_RXdprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_SXqprimme)
#  define Num_gemv_ddh_SXqprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_RXqprimme)
#  define Num_gemv_ddh_RXqprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_SHhprimme)
#  define Num_gemv_ddh_SHhprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_RHhprimme)
#  define Num_gemv_ddh_RHhprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_SHsprimme)
#  define Num_gemv_ddh_SHsprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_RHsprimme)
#  define Num_gemv_ddh_RHsprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_SHdprimme)
#  define Num_gemv_ddh_SHdprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_RHdprimme)
#  define Num_gemv_ddh_RHdprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_SHqprimme)
#  define Num_gemv_ddh_SHqprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_ddh_RHqprimme)
#  define Num_gemv_ddh_RHqprimme CONCAT(Num_gemv_ddh_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_gemv_ddh_cublas_hprimme(const char *transa, PRIMME_INT m, int n, dummy_type_sprimme alpha,
      dummy_type_cublas_hprimme *a, int lda, dummy_type_cublas_hprimme *x, int incx, dummy_type_sprimme beta, dummy_type_sprimme *y,
      int incy, primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_Sprimme)
#  define Num_gemv_dhd_Sprimme CONCAT(Num_gemv_dhd_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_Rprimme)
#  define Num_gemv_dhd_Rprimme CONCAT(Num_gemv_dhd_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_SHprimme)
#  define Num_gemv_dhd_SHprimme CONCAT(Num_gemv_dhd_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_RHprimme)
#  define Num_gemv_dhd_RHprimme CONCAT(Num_gemv_dhd_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_SXprimme)
#  define Num_gemv_dhd_SXprimme CONCAT(Num_gemv_dhd_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_RXprimme)
#  define Num_gemv_dhd_RXprimme CONCAT(Num_gemv_dhd_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_Shprimme)
#  define Num_gemv_dhd_Shprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_Rhprimme)
#  define Num_gemv_dhd_Rhprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_Ssprimme)
#  define Num_gemv_dhd_Ssprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_Rsprimme)
#  define Num_gemv_dhd_Rsprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_Sdprimme)
#  define Num_gemv_dhd_Sdprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_Rdprimme)
#  define Num_gemv_dhd_Rdprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_Sqprimme)
#  define Num_gemv_dhd_Sqprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_Rqprimme)
#  define Num_gemv_dhd_Rqprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_SXhprimme)
#  define Num_gemv_dhd_SXhprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_RXhprimme)
#  define Num_gemv_dhd_RXhprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_SXsprimme)
#  define Num_gemv_dhd_SXsprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_RXsprimme)
#  define Num_gemv_dhd_RXsprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_SXdprimme)
#  define Num_gemv_dhd_SXdprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_RXdprimme)
#  define Num_gemv_dhd_RXdprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_SXqprimme)
#  define Num_gemv_dhd_SXqprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_RXqprimme)
#  define Num_gemv_dhd_RXqprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_SHhprimme)
#  define Num_gemv_dhd_SHhprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_RHhprimme)
#  define Num_gemv_dhd_RHhprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_SHsprimme)
#  define Num_gemv_dhd_SHsprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_RHsprimme)
#  define Num_gemv_dhd_RHsprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_SHdprimme)
#  define Num_gemv_dhd_SHdprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_RHdprimme)
#  define Num_gemv_dhd_RHdprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_SHqprimme)
#  define Num_gemv_dhd_SHqprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_gemv_dhd_RHqprimme)
#  define Num_gemv_dhd_RHqprimme CONCAT(Num_gemv_dhd_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_gemv_dhd_cublas_hprimme(const char *transa, PRIMME_INT m, int n, dummy_type_sprimme alpha,
      dummy_type_cublas_hprimme *a, int lda, dummy_type_sprimme *x, int incx, dummy_type_sprimme beta, dummy_type_cublas_hprimme *y,
      int incy, primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_Sprimme)
#  define Num_axpy_Sprimme CONCAT(Num_axpy_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_Rprimme)
#  define Num_axpy_Rprimme CONCAT(Num_axpy_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_SHprimme)
#  define Num_axpy_SHprimme CONCAT(Num_axpy_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_RHprimme)
#  define Num_axpy_RHprimme CONCAT(Num_axpy_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_SXprimme)
#  define Num_axpy_SXprimme CONCAT(Num_axpy_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_RXprimme)
#  define Num_axpy_RXprimme CONCAT(Num_axpy_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_Shprimme)
#  define Num_axpy_Shprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_Rhprimme)
#  define Num_axpy_Rhprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_Ssprimme)
#  define Num_axpy_Ssprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_Rsprimme)
#  define Num_axpy_Rsprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_Sdprimme)
#  define Num_axpy_Sdprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_Rdprimme)
#  define Num_axpy_Rdprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_Sqprimme)
#  define Num_axpy_Sqprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_Rqprimme)
#  define Num_axpy_Rqprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_SXhprimme)
#  define Num_axpy_SXhprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_RXhprimme)
#  define Num_axpy_RXhprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_SXsprimme)
#  define Num_axpy_SXsprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_RXsprimme)
#  define Num_axpy_RXsprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_SXdprimme)
#  define Num_axpy_SXdprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_RXdprimme)
#  define Num_axpy_RXdprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_SXqprimme)
#  define Num_axpy_SXqprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_RXqprimme)
#  define Num_axpy_RXqprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_SHhprimme)
#  define Num_axpy_SHhprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_RHhprimme)
#  define Num_axpy_RHhprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_SHsprimme)
#  define Num_axpy_SHsprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_RHsprimme)
#  define Num_axpy_RHsprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_SHdprimme)
#  define Num_axpy_SHdprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_RHdprimme)
#  define Num_axpy_RHdprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_SHqprimme)
#  define Num_axpy_SHqprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_axpy_RHqprimme)
#  define Num_axpy_RHqprimme CONCAT(Num_axpy_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_axpy_cublas_hprimme(PRIMME_INT n, dummy_type_sprimme alpha, dummy_type_cublas_hprimme *x, int incx,
   dummy_type_cublas_hprimme *y, int incy, primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_Sprimme)
#  define Num_dot_Sprimme CONCAT(Num_dot_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_Rprimme)
#  define Num_dot_Rprimme CONCAT(Num_dot_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_SHprimme)
#  define Num_dot_SHprimme CONCAT(Num_dot_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_RHprimme)
#  define Num_dot_RHprimme CONCAT(Num_dot_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_SXprimme)
#  define Num_dot_SXprimme CONCAT(Num_dot_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_RXprimme)
#  define Num_dot_RXprimme CONCAT(Num_dot_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_Shprimme)
#  define Num_dot_Shprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_Rhprimme)
#  define Num_dot_Rhprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_Ssprimme)
#  define Num_dot_Ssprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_Rsprimme)
#  define Num_dot_Rsprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_Sdprimme)
#  define Num_dot_Sdprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_Rdprimme)
#  define Num_dot_Rdprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_Sqprimme)
#  define Num_dot_Sqprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_Rqprimme)
#  define Num_dot_Rqprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_SXhprimme)
#  define Num_dot_SXhprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_RXhprimme)
#  define Num_dot_RXhprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_SXsprimme)
#  define Num_dot_SXsprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_RXsprimme)
#  define Num_dot_RXsprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_SXdprimme)
#  define Num_dot_SXdprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_RXdprimme)
#  define Num_dot_RXdprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_SXqprimme)
#  define Num_dot_SXqprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_RXqprimme)
#  define Num_dot_RXqprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_SHhprimme)
#  define Num_dot_SHhprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_RHhprimme)
#  define Num_dot_RHhprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_SHsprimme)
#  define Num_dot_SHsprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_RHsprimme)
#  define Num_dot_RHsprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_SHdprimme)
#  define Num_dot_SHdprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_RHdprimme)
#  define Num_dot_RHdprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_SHqprimme)
#  define Num_dot_SHqprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_dot_RHqprimme)
#  define Num_dot_RHqprimme CONCAT(Num_dot_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
dummy_type_sprimme Num_dot_cublas_hprimme(PRIMME_INT n, dummy_type_cublas_hprimme *x, int incx, dummy_type_cublas_hprimme *y, int incy,
      primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_Sprimme)
#  define Num_scal_Sprimme CONCAT(Num_scal_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_Rprimme)
#  define Num_scal_Rprimme CONCAT(Num_scal_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_SHprimme)
#  define Num_scal_SHprimme CONCAT(Num_scal_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_RHprimme)
#  define Num_scal_RHprimme CONCAT(Num_scal_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_SXprimme)
#  define Num_scal_SXprimme CONCAT(Num_scal_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_RXprimme)
#  define Num_scal_RXprimme CONCAT(Num_scal_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_Shprimme)
#  define Num_scal_Shprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_Rhprimme)
#  define Num_scal_Rhprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_Ssprimme)
#  define Num_scal_Ssprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_Rsprimme)
#  define Num_scal_Rsprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_Sdprimme)
#  define Num_scal_Sdprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_Rdprimme)
#  define Num_scal_Rdprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_Sqprimme)
#  define Num_scal_Sqprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_Rqprimme)
#  define Num_scal_Rqprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_SXhprimme)
#  define Num_scal_SXhprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_RXhprimme)
#  define Num_scal_RXhprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_SXsprimme)
#  define Num_scal_SXsprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_RXsprimme)
#  define Num_scal_RXsprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_SXdprimme)
#  define Num_scal_SXdprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_RXdprimme)
#  define Num_scal_RXdprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_SXqprimme)
#  define Num_scal_SXqprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_RXqprimme)
#  define Num_scal_RXqprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_SHhprimme)
#  define Num_scal_SHhprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_RHhprimme)
#  define Num_scal_RHhprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_SHsprimme)
#  define Num_scal_SHsprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_RHsprimme)
#  define Num_scal_RHsprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_SHdprimme)
#  define Num_scal_SHdprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_RHdprimme)
#  define Num_scal_RHdprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_SHqprimme)
#  define Num_scal_SHqprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_scal_RHqprimme)
#  define Num_scal_RHqprimme CONCAT(Num_scal_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_scal_cublas_hprimme(PRIMME_INT n, dummy_type_sprimme alpha, dummy_type_cublas_hprimme *x, int incx,
      primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_Sprimme)
#  define Num_larnv_Sprimme CONCAT(Num_larnv_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_Rprimme)
#  define Num_larnv_Rprimme CONCAT(Num_larnv_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_SHprimme)
#  define Num_larnv_SHprimme CONCAT(Num_larnv_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_RHprimme)
#  define Num_larnv_RHprimme CONCAT(Num_larnv_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_SXprimme)
#  define Num_larnv_SXprimme CONCAT(Num_larnv_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_RXprimme)
#  define Num_larnv_RXprimme CONCAT(Num_larnv_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_Shprimme)
#  define Num_larnv_Shprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_Rhprimme)
#  define Num_larnv_Rhprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_Ssprimme)
#  define Num_larnv_Ssprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_Rsprimme)
#  define Num_larnv_Rsprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_Sdprimme)
#  define Num_larnv_Sdprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_Rdprimme)
#  define Num_larnv_Rdprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_Sqprimme)
#  define Num_larnv_Sqprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_Rqprimme)
#  define Num_larnv_Rqprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_SXhprimme)
#  define Num_larnv_SXhprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_RXhprimme)
#  define Num_larnv_RXhprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_SXsprimme)
#  define Num_larnv_SXsprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_RXsprimme)
#  define Num_larnv_RXsprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_SXdprimme)
#  define Num_larnv_SXdprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_RXdprimme)
#  define Num_larnv_RXdprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_SXqprimme)
#  define Num_larnv_SXqprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_RXqprimme)
#  define Num_larnv_RXqprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_SHhprimme)
#  define Num_larnv_SHhprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_RHhprimme)
#  define Num_larnv_RHhprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_SHsprimme)
#  define Num_larnv_SHsprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_RHsprimme)
#  define Num_larnv_RHsprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_SHdprimme)
#  define Num_larnv_SHdprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_RHdprimme)
#  define Num_larnv_RHdprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_SHqprimme)
#  define Num_larnv_SHqprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_larnv_RHqprimme)
#  define Num_larnv_RHqprimme CONCAT(Num_larnv_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_larnv_cublas_hprimme(int idist, PRIMME_INT *iseed, PRIMME_INT length,
      dummy_type_cublas_hprimme *x, primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_Sprimme)
#  define Num_copy_matrix_Sprimme CONCAT(Num_copy_matrix_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_Rprimme)
#  define Num_copy_matrix_Rprimme CONCAT(Num_copy_matrix_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_SHprimme)
#  define Num_copy_matrix_SHprimme CONCAT(Num_copy_matrix_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_RHprimme)
#  define Num_copy_matrix_RHprimme CONCAT(Num_copy_matrix_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_SXprimme)
#  define Num_copy_matrix_SXprimme CONCAT(Num_copy_matrix_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_RXprimme)
#  define Num_copy_matrix_RXprimme CONCAT(Num_copy_matrix_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_Shprimme)
#  define Num_copy_matrix_Shprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_Rhprimme)
#  define Num_copy_matrix_Rhprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_Ssprimme)
#  define Num_copy_matrix_Ssprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_Rsprimme)
#  define Num_copy_matrix_Rsprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_Sdprimme)
#  define Num_copy_matrix_Sdprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_Rdprimme)
#  define Num_copy_matrix_Rdprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_Sqprimme)
#  define Num_copy_matrix_Sqprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_Rqprimme)
#  define Num_copy_matrix_Rqprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_SXhprimme)
#  define Num_copy_matrix_SXhprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_RXhprimme)
#  define Num_copy_matrix_RXhprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_SXsprimme)
#  define Num_copy_matrix_SXsprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_RXsprimme)
#  define Num_copy_matrix_RXsprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_SXdprimme)
#  define Num_copy_matrix_SXdprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_RXdprimme)
#  define Num_copy_matrix_RXdprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_SXqprimme)
#  define Num_copy_matrix_SXqprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_RXqprimme)
#  define Num_copy_matrix_RXqprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_SHhprimme)
#  define Num_copy_matrix_SHhprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_RHhprimme)
#  define Num_copy_matrix_RHhprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_SHsprimme)
#  define Num_copy_matrix_SHsprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_RHsprimme)
#  define Num_copy_matrix_RHsprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_SHdprimme)
#  define Num_copy_matrix_SHdprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_RHdprimme)
#  define Num_copy_matrix_RHdprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_SHqprimme)
#  define Num_copy_matrix_SHqprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_copy_matrix_RHqprimme)
#  define Num_copy_matrix_RHqprimme CONCAT(Num_copy_matrix_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_copy_matrix_cublas_hprimme(dummy_type_cublas_hprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, dummy_type_cublas_hprimme *y, PRIMME_INT ldy,
      primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_Sprimme)
#  define Num_zero_matrix_Sprimme CONCAT(Num_zero_matrix_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_Rprimme)
#  define Num_zero_matrix_Rprimme CONCAT(Num_zero_matrix_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_SHprimme)
#  define Num_zero_matrix_SHprimme CONCAT(Num_zero_matrix_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_RHprimme)
#  define Num_zero_matrix_RHprimme CONCAT(Num_zero_matrix_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_SXprimme)
#  define Num_zero_matrix_SXprimme CONCAT(Num_zero_matrix_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_RXprimme)
#  define Num_zero_matrix_RXprimme CONCAT(Num_zero_matrix_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_Shprimme)
#  define Num_zero_matrix_Shprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_Rhprimme)
#  define Num_zero_matrix_Rhprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_Ssprimme)
#  define Num_zero_matrix_Ssprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_Rsprimme)
#  define Num_zero_matrix_Rsprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_Sdprimme)
#  define Num_zero_matrix_Sdprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_Rdprimme)
#  define Num_zero_matrix_Rdprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_Sqprimme)
#  define Num_zero_matrix_Sqprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_Rqprimme)
#  define Num_zero_matrix_Rqprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_SXhprimme)
#  define Num_zero_matrix_SXhprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_RXhprimme)
#  define Num_zero_matrix_RXhprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_SXsprimme)
#  define Num_zero_matrix_SXsprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_RXsprimme)
#  define Num_zero_matrix_RXsprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_SXdprimme)
#  define Num_zero_matrix_SXdprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_RXdprimme)
#  define Num_zero_matrix_RXdprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_SXqprimme)
#  define Num_zero_matrix_SXqprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_RXqprimme)
#  define Num_zero_matrix_RXqprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_SHhprimme)
#  define Num_zero_matrix_SHhprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_RHhprimme)
#  define Num_zero_matrix_RHhprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_SHsprimme)
#  define Num_zero_matrix_SHsprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_RHsprimme)
#  define Num_zero_matrix_RHsprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_SHdprimme)
#  define Num_zero_matrix_SHdprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_RHdprimme)
#  define Num_zero_matrix_RHdprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_SHqprimme)
#  define Num_zero_matrix_SHqprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_zero_matrix_RHqprimme)
#  define Num_zero_matrix_RHqprimme CONCAT(Num_zero_matrix_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_zero_matrix_cublas_hprimme(dummy_type_cublas_hprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_Sprimme)
#  define Num_trsm_hd_Sprimme CONCAT(Num_trsm_hd_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_Rprimme)
#  define Num_trsm_hd_Rprimme CONCAT(Num_trsm_hd_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_SHprimme)
#  define Num_trsm_hd_SHprimme CONCAT(Num_trsm_hd_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_RHprimme)
#  define Num_trsm_hd_RHprimme CONCAT(Num_trsm_hd_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_SXprimme)
#  define Num_trsm_hd_SXprimme CONCAT(Num_trsm_hd_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_RXprimme)
#  define Num_trsm_hd_RXprimme CONCAT(Num_trsm_hd_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_Shprimme)
#  define Num_trsm_hd_Shprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_Rhprimme)
#  define Num_trsm_hd_Rhprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_Ssprimme)
#  define Num_trsm_hd_Ssprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_Rsprimme)
#  define Num_trsm_hd_Rsprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_Sdprimme)
#  define Num_trsm_hd_Sdprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_Rdprimme)
#  define Num_trsm_hd_Rdprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_Sqprimme)
#  define Num_trsm_hd_Sqprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_Rqprimme)
#  define Num_trsm_hd_Rqprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_SXhprimme)
#  define Num_trsm_hd_SXhprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_RXhprimme)
#  define Num_trsm_hd_RXhprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_SXsprimme)
#  define Num_trsm_hd_SXsprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_RXsprimme)
#  define Num_trsm_hd_RXsprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_SXdprimme)
#  define Num_trsm_hd_SXdprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_RXdprimme)
#  define Num_trsm_hd_RXdprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_SXqprimme)
#  define Num_trsm_hd_SXqprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_RXqprimme)
#  define Num_trsm_hd_RXqprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_SHhprimme)
#  define Num_trsm_hd_SHhprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_RHhprimme)
#  define Num_trsm_hd_RHhprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_SHsprimme)
#  define Num_trsm_hd_SHsprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_RHsprimme)
#  define Num_trsm_hd_RHsprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_SHdprimme)
#  define Num_trsm_hd_SHdprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_RHdprimme)
#  define Num_trsm_hd_RHdprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_SHqprimme)
#  define Num_trsm_hd_SHqprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_trsm_hd_RHqprimme)
#  define Num_trsm_hd_RHqprimme CONCAT(Num_trsm_hd_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_trsm_hd_cublas_hprimme(const char *side, const char *uplo, const char *transa,
      const char *diag, int m, int n, dummy_type_sprimme alpha, dummy_type_sprimme *a, int lda,
      dummy_type_cublas_hprimme *b, int ldb, primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_Sprimme)
#  define Num_compute_gramm_Sprimme CONCAT(Num_compute_gramm_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_Rprimme)
#  define Num_compute_gramm_Rprimme CONCAT(Num_compute_gramm_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_SHprimme)
#  define Num_compute_gramm_SHprimme CONCAT(Num_compute_gramm_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_RHprimme)
#  define Num_compute_gramm_RHprimme CONCAT(Num_compute_gramm_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_SXprimme)
#  define Num_compute_gramm_SXprimme CONCAT(Num_compute_gramm_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_RXprimme)
#  define Num_compute_gramm_RXprimme CONCAT(Num_compute_gramm_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_Shprimme)
#  define Num_compute_gramm_Shprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_Rhprimme)
#  define Num_compute_gramm_Rhprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_Ssprimme)
#  define Num_compute_gramm_Ssprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_Rsprimme)
#  define Num_compute_gramm_Rsprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_Sdprimme)
#  define Num_compute_gramm_Sdprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_Rdprimme)
#  define Num_compute_gramm_Rdprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_Sqprimme)
#  define Num_compute_gramm_Sqprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_Rqprimme)
#  define Num_compute_gramm_Rqprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_SXhprimme)
#  define Num_compute_gramm_SXhprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_RXhprimme)
#  define Num_compute_gramm_RXhprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_SXsprimme)
#  define Num_compute_gramm_SXsprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_RXsprimme)
#  define Num_compute_gramm_RXsprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_SXdprimme)
#  define Num_compute_gramm_SXdprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_RXdprimme)
#  define Num_compute_gramm_RXdprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_SXqprimme)
#  define Num_compute_gramm_SXqprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_RXqprimme)
#  define Num_compute_gramm_RXqprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_SHhprimme)
#  define Num_compute_gramm_SHhprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_RHhprimme)
#  define Num_compute_gramm_RHhprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_SHsprimme)
#  define Num_compute_gramm_SHsprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_RHsprimme)
#  define Num_compute_gramm_RHsprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_SHdprimme)
#  define Num_compute_gramm_SHdprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_RHdprimme)
#  define Num_compute_gramm_RHdprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_SHqprimme)
#  define Num_compute_gramm_SHqprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_RHqprimme)
#  define Num_compute_gramm_RHqprimme CONCAT(Num_compute_gramm_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_compute_gramm_cublas_hprimme(dummy_type_cublas_hprimme *X, PRIMME_INT m, int n, int ldX,
      dummy_type_cublas_hprimme *Y, PRIMME_INT ldY, dummy_type_sprimme alpha, dummy_type_cublas_hprimme *H, int ldH, int isherm,
      int deep, primme_context ctx);
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_Sprimme)
#  define Num_compute_gramm_ddh_Sprimme CONCAT(Num_compute_gramm_ddh_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_Rprimme)
#  define Num_compute_gramm_ddh_Rprimme CONCAT(Num_compute_gramm_ddh_,REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_SHprimme)
#  define Num_compute_gramm_ddh_SHprimme CONCAT(Num_compute_gramm_ddh_,HOST_SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_RHprimme)
#  define Num_compute_gramm_ddh_RHprimme CONCAT(Num_compute_gramm_ddh_,HOST_REAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_SXprimme)
#  define Num_compute_gramm_ddh_SXprimme CONCAT(Num_compute_gramm_ddh_,XSCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_RXprimme)
#  define Num_compute_gramm_ddh_RXprimme CONCAT(Num_compute_gramm_ddh_,XREAL_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_Shprimme)
#  define Num_compute_gramm_ddh_Shprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_Rhprimme)
#  define Num_compute_gramm_ddh_Rhprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_Ssprimme)
#  define Num_compute_gramm_ddh_Ssprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_Rsprimme)
#  define Num_compute_gramm_ddh_Rsprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_Sdprimme)
#  define Num_compute_gramm_ddh_Sdprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_Rdprimme)
#  define Num_compute_gramm_ddh_Rdprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_Sqprimme)
#  define Num_compute_gramm_ddh_Sqprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_Rqprimme)
#  define Num_compute_gramm_ddh_Rqprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(STEM_C,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_SXhprimme)
#  define Num_compute_gramm_ddh_SXhprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(h,k)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_RXhprimme)
#  define Num_compute_gramm_ddh_RXhprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(,h),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_SXsprimme)
#  define Num_compute_gramm_ddh_SXsprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_RXsprimme)
#  define Num_compute_gramm_ddh_RXsprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_SXdprimme)
#  define Num_compute_gramm_ddh_SXdprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_RXdprimme)
#  define Num_compute_gramm_ddh_RXdprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_SXqprimme)
#  define Num_compute_gramm_ddh_SXqprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_RXqprimme)
#  define Num_compute_gramm_ddh_RXqprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_SHhprimme)
#  define Num_compute_gramm_ddh_SHhprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_RHhprimme)
#  define Num_compute_gramm_ddh_RHhprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_SHsprimme)
#  define Num_compute_gramm_ddh_SHsprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(s,c)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_RHsprimme)
#  define Num_compute_gramm_ddh_RHsprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(,s),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_SHdprimme)
#  define Num_compute_gramm_ddh_SHdprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(d,z)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_RHdprimme)
#  define Num_compute_gramm_ddh_RHdprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(,d),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_SHqprimme)
#  define Num_compute_gramm_ddh_SHqprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(,USE_ARITH(q,w)),primme),))
#endif
#if !defined(CHECK_TEMPLATE) && !defined(Num_compute_gramm_ddh_RHqprimme)
#  define Num_compute_gramm_ddh_RHqprimme CONCAT(Num_compute_gramm_ddh_,CONCAT(CONCAT(CONCAT(,q),primme),))
#endif
int Num_compute_gramm_ddh_cublas_hprimme(dummy_type_cublas_hprimme *X, PRIMME_INT m, int n, int ldX,
      dummy_type_cublas_hprimme *Y, PRIMME_INT ldY, dummy_type_sprimme alpha, dummy_type_sprimme *H, int ldH, int isherm,
      primme_context ctx);
void toCudaDataTypecublas_kprimme(primme_op_datatype xt, void *r);
void toCublasComputeDataTypecublas_kprimme(primme_op_datatype xt, void *r);
int Num_check_pointer_cublas_kprimme(void *x);
int Num_malloc_cublas_kprimme(PRIMME_INT n, dummy_type_cublas_kprimme **x, primme_context ctx);
int Num_free_cublas_kprimme(dummy_type_cublas_kprimme *x, primme_context ctx);
int Num_copy_Tmatrix_cublas_kprimme(void *x, primme_op_datatype xt, PRIMME_INT m,
      PRIMME_INT n, PRIMME_INT ldx, dummy_type_cublas_kprimme *y, PRIMME_INT ldy,
      primme_context ctx);
int Num_copy_cublas_kprimme(PRIMME_INT n, dummy_type_cublas_kprimme *x, int incx, dummy_type_cublas_kprimme *y, int incy,
      primme_context ctx);
int Num_set_matrix_cublas_kprimme(dummy_type_cprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, dummy_type_cublas_kprimme *y, PRIMME_INT ldy, primme_context ctx);
int Num_get_matrix_cublas_kprimme(dummy_type_cublas_kprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, dummy_type_cprimme *y, PRIMME_INT ldy, primme_context ctx);
int Num_gemm_cublas_kprimme(const char *transa, const char *transb, int m, int n,
      int k, dummy_type_cprimme alpha, dummy_type_cublas_kprimme *a, int lda, dummy_type_cublas_kprimme *b, int ldb,
      dummy_type_cprimme beta, dummy_type_cublas_kprimme *c, int ldc, primme_context ctx);
int Num_gemm_dhd_cublas_kprimme(const char *transa, const char *transb, int m, int n,
      int k, dummy_type_cprimme alpha, dummy_type_cublas_kprimme *a, int lda, dummy_type_cprimme *b, int ldb,
      dummy_type_cprimme beta, dummy_type_cublas_kprimme *c, int ldc, primme_context ctx);
int Num_gemm_ddh_cublas_kprimme(const char *transa, const char *transb, int m, int n,
      int k, dummy_type_cprimme alpha, dummy_type_cublas_kprimme *a, int lda, dummy_type_cublas_kprimme *b, int ldb,
      dummy_type_cprimme beta, dummy_type_cprimme *c, int ldc, primme_context ctx);
int Num_gemv_cublas_kprimme(const char *transa, PRIMME_INT m, int n, dummy_type_cprimme alpha,
      dummy_type_cublas_kprimme *a, int lda, dummy_type_cublas_kprimme *x, int incx, dummy_type_cprimme beta, dummy_type_cublas_kprimme *y,
      int incy, primme_context ctx);
int Num_gemv_ddh_cublas_kprimme(const char *transa, PRIMME_INT m, int n, dummy_type_cprimme alpha,
      dummy_type_cublas_kprimme *a, int lda, dummy_type_cublas_kprimme *x, int incx, dummy_type_cprimme beta, dummy_type_cprimme *y,
      int incy, primme_context ctx);
int Num_gemv_dhd_cublas_kprimme(const char *transa, PRIMME_INT m, int n, dummy_type_cprimme alpha,
      dummy_type_cublas_kprimme *a, int lda, dummy_type_cprimme *x, int incx, dummy_type_cprimme beta, dummy_type_cublas_kprimme *y,
      int incy, primme_context ctx);
int Num_axpy_cublas_kprimme(PRIMME_INT n, dummy_type_cprimme alpha, dummy_type_cublas_kprimme *x, int incx,
   dummy_type_cublas_kprimme *y, int incy, primme_context ctx);
dummy_type_cprimme Num_dot_cublas_kprimme(PRIMME_INT n, dummy_type_cublas_kprimme *x, int incx, dummy_type_cublas_kprimme *y, int incy,
      primme_context ctx);
int Num_scal_cublas_kprimme(PRIMME_INT n, dummy_type_cprimme alpha, dummy_type_cublas_kprimme *x, int incx,
      primme_context ctx);
int Num_larnv_cublas_kprimme(int idist, PRIMME_INT *iseed, PRIMME_INT length,
      dummy_type_cublas_kprimme *x, primme_context ctx);
int Num_copy_matrix_cublas_kprimme(dummy_type_cublas_kprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, dummy_type_cublas_kprimme *y, PRIMME_INT ldy,
      primme_context ctx);
int Num_zero_matrix_cublas_kprimme(dummy_type_cublas_kprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, primme_context ctx);
int Num_trsm_hd_cublas_kprimme(const char *side, const char *uplo, const char *transa,
      const char *diag, int m, int n, dummy_type_cprimme alpha, dummy_type_cprimme *a, int lda,
      dummy_type_cublas_kprimme *b, int ldb, primme_context ctx);
int Num_compute_gramm_cublas_kprimme(dummy_type_cublas_kprimme *X, PRIMME_INT m, int n, int ldX,
      dummy_type_cublas_kprimme *Y, PRIMME_INT ldY, dummy_type_cprimme alpha, dummy_type_cublas_kprimme *H, int ldH, int isherm,
      int deep, primme_context ctx);
int Num_compute_gramm_ddh_cublas_kprimme(dummy_type_cublas_kprimme *X, PRIMME_INT m, int n, int ldX,
      dummy_type_cublas_kprimme *Y, PRIMME_INT ldY, dummy_type_cprimme alpha, dummy_type_cprimme *H, int ldH, int isherm,
      primme_context ctx);
void toCudaDataTypecublas_sprimme(primme_op_datatype xt, void *r);
void toCublasComputeDataTypecublas_sprimme(primme_op_datatype xt, void *r);
int Num_check_pointer_cublas_sprimme(void *x);
int Num_malloc_cublas_sprimme(PRIMME_INT n, dummy_type_cublas_sprimme **x, primme_context ctx);
int Num_free_cublas_sprimme(dummy_type_cublas_sprimme *x, primme_context ctx);
int Num_copy_Tmatrix_cublas_sprimme(void *x, primme_op_datatype xt, PRIMME_INT m,
      PRIMME_INT n, PRIMME_INT ldx, dummy_type_cublas_sprimme *y, PRIMME_INT ldy,
      primme_context ctx);
int Num_copy_cublas_sprimme(PRIMME_INT n, dummy_type_cublas_sprimme *x, int incx, dummy_type_cublas_sprimme *y, int incy,
      primme_context ctx);
int Num_set_matrix_cublas_sprimme(dummy_type_sprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, dummy_type_cublas_sprimme *y, PRIMME_INT ldy, primme_context ctx);
int Num_get_matrix_cublas_sprimme(dummy_type_cublas_sprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, dummy_type_sprimme *y, PRIMME_INT ldy, primme_context ctx);
int Num_gemm_cublas_sprimme(const char *transa, const char *transb, int m, int n,
      int k, dummy_type_sprimme alpha, dummy_type_cublas_sprimme *a, int lda, dummy_type_cublas_sprimme *b, int ldb,
      dummy_type_sprimme beta, dummy_type_cublas_sprimme *c, int ldc, primme_context ctx);
int Num_gemm_dhd_cublas_sprimme(const char *transa, const char *transb, int m, int n,
      int k, dummy_type_sprimme alpha, dummy_type_cublas_sprimme *a, int lda, dummy_type_sprimme *b, int ldb,
      dummy_type_sprimme beta, dummy_type_cublas_sprimme *c, int ldc, primme_context ctx);
int Num_gemm_ddh_cublas_sprimme(const char *transa, const char *transb, int m, int n,
      int k, dummy_type_sprimme alpha, dummy_type_cublas_sprimme *a, int lda, dummy_type_cublas_sprimme *b, int ldb,
      dummy_type_sprimme beta, dummy_type_sprimme *c, int ldc, primme_context ctx);
int Num_gemv_cublas_sprimme(const char *transa, PRIMME_INT m, int n, dummy_type_sprimme alpha,
      dummy_type_cublas_sprimme *a, int lda, dummy_type_cublas_sprimme *x, int incx, dummy_type_sprimme beta, dummy_type_cublas_sprimme *y,
      int incy, primme_context ctx);
int Num_gemv_ddh_cublas_sprimme(const char *transa, PRIMME_INT m, int n, dummy_type_sprimme alpha,
      dummy_type_cublas_sprimme *a, int lda, dummy_type_cublas_sprimme *x, int incx, dummy_type_sprimme beta, dummy_type_sprimme *y,
      int incy, primme_context ctx);
int Num_gemv_dhd_cublas_sprimme(const char *transa, PRIMME_INT m, int n, dummy_type_sprimme alpha,
      dummy_type_cublas_sprimme *a, int lda, dummy_type_sprimme *x, int incx, dummy_type_sprimme beta, dummy_type_cublas_sprimme *y,
      int incy, primme_context ctx);
int Num_axpy_cublas_sprimme(PRIMME_INT n, dummy_type_sprimme alpha, dummy_type_cublas_sprimme *x, int incx,
   dummy_type_cublas_sprimme *y, int incy, primme_context ctx);
dummy_type_sprimme Num_dot_cublas_sprimme(PRIMME_INT n, dummy_type_cublas_sprimme *x, int incx, dummy_type_cublas_sprimme *y, int incy,
      primme_context ctx);
int Num_scal_cublas_sprimme(PRIMME_INT n, dummy_type_sprimme alpha, dummy_type_cublas_sprimme *x, int incx,
      primme_context ctx);
int Num_larnv_cublas_sprimme(int idist, PRIMME_INT *iseed, PRIMME_INT length,
      dummy_type_cublas_sprimme *x, primme_context ctx);
int Num_copy_matrix_cublas_sprimme(dummy_type_cublas_sprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, dummy_type_cublas_sprimme *y, PRIMME_INT ldy,
      primme_context ctx);
int Num_zero_matrix_cublas_sprimme(dummy_type_cublas_sprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, primme_context ctx);
int Num_trsm_hd_cublas_sprimme(const char *side, const char *uplo, const char *transa,
      const char *diag, int m, int n, dummy_type_sprimme alpha, dummy_type_sprimme *a, int lda,
      dummy_type_cublas_sprimme *b, int ldb, primme_context ctx);
int Num_compute_gramm_cublas_sprimme(dummy_type_cublas_sprimme *X, PRIMME_INT m, int n, int ldX,
      dummy_type_cublas_sprimme *Y, PRIMME_INT ldY, dummy_type_sprimme alpha, dummy_type_cublas_sprimme *H, int ldH, int isherm,
      int deep, primme_context ctx);
int Num_compute_gramm_ddh_cublas_sprimme(dummy_type_cublas_sprimme *X, PRIMME_INT m, int n, int ldX,
      dummy_type_cublas_sprimme *Y, PRIMME_INT ldY, dummy_type_sprimme alpha, dummy_type_sprimme *H, int ldH, int isherm,
      primme_context ctx);
void toCudaDataTypecublas_cprimme(primme_op_datatype xt, void *r);
void toCublasComputeDataTypecublas_cprimme(primme_op_datatype xt, void *r);
int Num_check_pointer_cublas_cprimme(void *x);
int Num_malloc_cublas_cprimme(PRIMME_INT n, dummy_type_cublas_cprimme **x, primme_context ctx);
int Num_free_cublas_cprimme(dummy_type_cublas_cprimme *x, primme_context ctx);
int Num_copy_Tmatrix_cublas_cprimme(void *x, primme_op_datatype xt, PRIMME_INT m,
      PRIMME_INT n, PRIMME_INT ldx, dummy_type_cublas_cprimme *y, PRIMME_INT ldy,
      primme_context ctx);
int Num_copy_cublas_cprimme(PRIMME_INT n, dummy_type_cublas_cprimme *x, int incx, dummy_type_cublas_cprimme *y, int incy,
      primme_context ctx);
int Num_set_matrix_cublas_cprimme(dummy_type_cprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, dummy_type_cublas_cprimme *y, PRIMME_INT ldy, primme_context ctx);
int Num_get_matrix_cublas_cprimme(dummy_type_cublas_cprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, dummy_type_cprimme *y, PRIMME_INT ldy, primme_context ctx);
int Num_gemm_cublas_cprimme(const char *transa, const char *transb, int m, int n,
      int k, dummy_type_cprimme alpha, dummy_type_cublas_cprimme *a, int lda, dummy_type_cublas_cprimme *b, int ldb,
      dummy_type_cprimme beta, dummy_type_cublas_cprimme *c, int ldc, primme_context ctx);
int Num_gemm_dhd_cublas_cprimme(const char *transa, const char *transb, int m, int n,
      int k, dummy_type_cprimme alpha, dummy_type_cublas_cprimme *a, int lda, dummy_type_cprimme *b, int ldb,
      dummy_type_cprimme beta, dummy_type_cublas_cprimme *c, int ldc, primme_context ctx);
int Num_gemm_ddh_cublas_cprimme(const char *transa, const char *transb, int m, int n,
      int k, dummy_type_cprimme alpha, dummy_type_cublas_cprimme *a, int lda, dummy_type_cublas_cprimme *b, int ldb,
      dummy_type_cprimme beta, dummy_type_cprimme *c, int ldc, primme_context ctx);
int Num_gemv_cublas_cprimme(const char *transa, PRIMME_INT m, int n, dummy_type_cprimme alpha,
      dummy_type_cublas_cprimme *a, int lda, dummy_type_cublas_cprimme *x, int incx, dummy_type_cprimme beta, dummy_type_cublas_cprimme *y,
      int incy, primme_context ctx);
int Num_gemv_ddh_cublas_cprimme(const char *transa, PRIMME_INT m, int n, dummy_type_cprimme alpha,
      dummy_type_cublas_cprimme *a, int lda, dummy_type_cublas_cprimme *x, int incx, dummy_type_cprimme beta, dummy_type_cprimme *y,
      int incy, primme_context ctx);
int Num_gemv_dhd_cublas_cprimme(const char *transa, PRIMME_INT m, int n, dummy_type_cprimme alpha,
      dummy_type_cublas_cprimme *a, int lda, dummy_type_cprimme *x, int incx, dummy_type_cprimme beta, dummy_type_cublas_cprimme *y,
      int incy, primme_context ctx);
int Num_axpy_cublas_cprimme(PRIMME_INT n, dummy_type_cprimme alpha, dummy_type_cublas_cprimme *x, int incx,
   dummy_type_cublas_cprimme *y, int incy, primme_context ctx);
dummy_type_cprimme Num_dot_cublas_cprimme(PRIMME_INT n, dummy_type_cublas_cprimme *x, int incx, dummy_type_cublas_cprimme *y, int incy,
      primme_context ctx);
int Num_scal_cublas_cprimme(PRIMME_INT n, dummy_type_cprimme alpha, dummy_type_cublas_cprimme *x, int incx,
      primme_context ctx);
int Num_larnv_cublas_cprimme(int idist, PRIMME_INT *iseed, PRIMME_INT length,
      dummy_type_cublas_cprimme *x, primme_context ctx);
int Num_copy_matrix_cublas_cprimme(dummy_type_cublas_cprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, dummy_type_cublas_cprimme *y, PRIMME_INT ldy,
      primme_context ctx);
int Num_zero_matrix_cublas_cprimme(dummy_type_cublas_cprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, primme_context ctx);
int Num_trsm_hd_cublas_cprimme(const char *side, const char *uplo, const char *transa,
      const char *diag, int m, int n, dummy_type_cprimme alpha, dummy_type_cprimme *a, int lda,
      dummy_type_cublas_cprimme *b, int ldb, primme_context ctx);
int Num_compute_gramm_cublas_cprimme(dummy_type_cublas_cprimme *X, PRIMME_INT m, int n, int ldX,
      dummy_type_cublas_cprimme *Y, PRIMME_INT ldY, dummy_type_cprimme alpha, dummy_type_cublas_cprimme *H, int ldH, int isherm,
      int deep, primme_context ctx);
int Num_compute_gramm_ddh_cublas_cprimme(dummy_type_cublas_cprimme *X, PRIMME_INT m, int n, int ldX,
      dummy_type_cublas_cprimme *Y, PRIMME_INT ldY, dummy_type_cprimme alpha, dummy_type_cprimme *H, int ldH, int isherm,
      primme_context ctx);
void toCudaDataTypecublas_dprimme(primme_op_datatype xt, void *r);
void toCublasComputeDataTypecublas_dprimme(primme_op_datatype xt, void *r);
int Num_check_pointer_cublas_dprimme(void *x);
int Num_malloc_cublas_dprimme(PRIMME_INT n, dummy_type_cublas_dprimme **x, primme_context ctx);
int Num_free_cublas_dprimme(dummy_type_cublas_dprimme *x, primme_context ctx);
int Num_copy_Tmatrix_cublas_dprimme(void *x, primme_op_datatype xt, PRIMME_INT m,
      PRIMME_INT n, PRIMME_INT ldx, dummy_type_cublas_dprimme *y, PRIMME_INT ldy,
      primme_context ctx);
int Num_copy_cublas_dprimme(PRIMME_INT n, dummy_type_cublas_dprimme *x, int incx, dummy_type_cublas_dprimme *y, int incy,
      primme_context ctx);
int Num_set_matrix_cublas_dprimme(dummy_type_dprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, dummy_type_cublas_dprimme *y, PRIMME_INT ldy, primme_context ctx);
int Num_get_matrix_cublas_dprimme(dummy_type_cublas_dprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, dummy_type_dprimme *y, PRIMME_INT ldy, primme_context ctx);
int Num_gemm_cublas_dprimme(const char *transa, const char *transb, int m, int n,
      int k, dummy_type_dprimme alpha, dummy_type_cublas_dprimme *a, int lda, dummy_type_cublas_dprimme *b, int ldb,
      dummy_type_dprimme beta, dummy_type_cublas_dprimme *c, int ldc, primme_context ctx);
int Num_gemm_dhd_cublas_dprimme(const char *transa, const char *transb, int m, int n,
      int k, dummy_type_dprimme alpha, dummy_type_cublas_dprimme *a, int lda, dummy_type_dprimme *b, int ldb,
      dummy_type_dprimme beta, dummy_type_cublas_dprimme *c, int ldc, primme_context ctx);
int Num_gemm_ddh_cublas_dprimme(const char *transa, const char *transb, int m, int n,
      int k, dummy_type_dprimme alpha, dummy_type_cublas_dprimme *a, int lda, dummy_type_cublas_dprimme *b, int ldb,
      dummy_type_dprimme beta, dummy_type_dprimme *c, int ldc, primme_context ctx);
int Num_gemv_cublas_dprimme(const char *transa, PRIMME_INT m, int n, dummy_type_dprimme alpha,
      dummy_type_cublas_dprimme *a, int lda, dummy_type_cublas_dprimme *x, int incx, dummy_type_dprimme beta, dummy_type_cublas_dprimme *y,
      int incy, primme_context ctx);
int Num_gemv_ddh_cublas_dprimme(const char *transa, PRIMME_INT m, int n, dummy_type_dprimme alpha,
      dummy_type_cublas_dprimme *a, int lda, dummy_type_cublas_dprimme *x, int incx, dummy_type_dprimme beta, dummy_type_dprimme *y,
      int incy, primme_context ctx);
int Num_gemv_dhd_cublas_dprimme(const char *transa, PRIMME_INT m, int n, dummy_type_dprimme alpha,
      dummy_type_cublas_dprimme *a, int lda, dummy_type_dprimme *x, int incx, dummy_type_dprimme beta, dummy_type_cublas_dprimme *y,
      int incy, primme_context ctx);
int Num_axpy_cublas_dprimme(PRIMME_INT n, dummy_type_dprimme alpha, dummy_type_cublas_dprimme *x, int incx,
   dummy_type_cublas_dprimme *y, int incy, primme_context ctx);
dummy_type_dprimme Num_dot_cublas_dprimme(PRIMME_INT n, dummy_type_cublas_dprimme *x, int incx, dummy_type_cublas_dprimme *y, int incy,
      primme_context ctx);
int Num_scal_cublas_dprimme(PRIMME_INT n, dummy_type_dprimme alpha, dummy_type_cublas_dprimme *x, int incx,
      primme_context ctx);
int Num_larnv_cublas_dprimme(int idist, PRIMME_INT *iseed, PRIMME_INT length,
      dummy_type_cublas_dprimme *x, primme_context ctx);
int Num_copy_matrix_cublas_dprimme(dummy_type_cublas_dprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, dummy_type_cublas_dprimme *y, PRIMME_INT ldy,
      primme_context ctx);
int Num_zero_matrix_cublas_dprimme(dummy_type_cublas_dprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, primme_context ctx);
int Num_trsm_hd_cublas_dprimme(const char *side, const char *uplo, const char *transa,
      const char *diag, int m, int n, dummy_type_dprimme alpha, dummy_type_dprimme *a, int lda,
      dummy_type_cublas_dprimme *b, int ldb, primme_context ctx);
int Num_compute_gramm_cublas_dprimme(dummy_type_cublas_dprimme *X, PRIMME_INT m, int n, int ldX,
      dummy_type_cublas_dprimme *Y, PRIMME_INT ldY, dummy_type_dprimme alpha, dummy_type_cublas_dprimme *H, int ldH, int isherm,
      int deep, primme_context ctx);
int Num_compute_gramm_ddh_cublas_dprimme(dummy_type_cublas_dprimme *X, PRIMME_INT m, int n, int ldX,
      dummy_type_cublas_dprimme *Y, PRIMME_INT ldY, dummy_type_dprimme alpha, dummy_type_dprimme *H, int ldH, int isherm,
      primme_context ctx);
void toCudaDataTypecublas_zprimme(primme_op_datatype xt, void *r);
void toCublasComputeDataTypecublas_zprimme(primme_op_datatype xt, void *r);
int Num_check_pointer_cublas_zprimme(void *x);
int Num_malloc_cublas_zprimme(PRIMME_INT n, dummy_type_cublas_zprimme **x, primme_context ctx);
int Num_free_cublas_zprimme(dummy_type_cublas_zprimme *x, primme_context ctx);
int Num_copy_Tmatrix_cublas_zprimme(void *x, primme_op_datatype xt, PRIMME_INT m,
      PRIMME_INT n, PRIMME_INT ldx, dummy_type_cublas_zprimme *y, PRIMME_INT ldy,
      primme_context ctx);
int Num_copy_cublas_zprimme(PRIMME_INT n, dummy_type_cublas_zprimme *x, int incx, dummy_type_cublas_zprimme *y, int incy,
      primme_context ctx);
int Num_set_matrix_cublas_zprimme(dummy_type_zprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, dummy_type_cublas_zprimme *y, PRIMME_INT ldy, primme_context ctx);
int Num_get_matrix_cublas_zprimme(dummy_type_cublas_zprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, dummy_type_zprimme *y, PRIMME_INT ldy, primme_context ctx);
int Num_gemm_cublas_zprimme(const char *transa, const char *transb, int m, int n,
      int k, dummy_type_zprimme alpha, dummy_type_cublas_zprimme *a, int lda, dummy_type_cublas_zprimme *b, int ldb,
      dummy_type_zprimme beta, dummy_type_cublas_zprimme *c, int ldc, primme_context ctx);
int Num_gemm_dhd_cublas_zprimme(const char *transa, const char *transb, int m, int n,
      int k, dummy_type_zprimme alpha, dummy_type_cublas_zprimme *a, int lda, dummy_type_zprimme *b, int ldb,
      dummy_type_zprimme beta, dummy_type_cublas_zprimme *c, int ldc, primme_context ctx);
int Num_gemm_ddh_cublas_zprimme(const char *transa, const char *transb, int m, int n,
      int k, dummy_type_zprimme alpha, dummy_type_cublas_zprimme *a, int lda, dummy_type_cublas_zprimme *b, int ldb,
      dummy_type_zprimme beta, dummy_type_zprimme *c, int ldc, primme_context ctx);
int Num_gemv_cublas_zprimme(const char *transa, PRIMME_INT m, int n, dummy_type_zprimme alpha,
      dummy_type_cublas_zprimme *a, int lda, dummy_type_cublas_zprimme *x, int incx, dummy_type_zprimme beta, dummy_type_cublas_zprimme *y,
      int incy, primme_context ctx);
int Num_gemv_ddh_cublas_zprimme(const char *transa, PRIMME_INT m, int n, dummy_type_zprimme alpha,
      dummy_type_cublas_zprimme *a, int lda, dummy_type_cublas_zprimme *x, int incx, dummy_type_zprimme beta, dummy_type_zprimme *y,
      int incy, primme_context ctx);
int Num_gemv_dhd_cublas_zprimme(const char *transa, PRIMME_INT m, int n, dummy_type_zprimme alpha,
      dummy_type_cublas_zprimme *a, int lda, dummy_type_zprimme *x, int incx, dummy_type_zprimme beta, dummy_type_cublas_zprimme *y,
      int incy, primme_context ctx);
int Num_axpy_cublas_zprimme(PRIMME_INT n, dummy_type_zprimme alpha, dummy_type_cublas_zprimme *x, int incx,
   dummy_type_cublas_zprimme *y, int incy, primme_context ctx);
dummy_type_zprimme Num_dot_cublas_zprimme(PRIMME_INT n, dummy_type_cublas_zprimme *x, int incx, dummy_type_cublas_zprimme *y, int incy,
      primme_context ctx);
int Num_scal_cublas_zprimme(PRIMME_INT n, dummy_type_zprimme alpha, dummy_type_cublas_zprimme *x, int incx,
      primme_context ctx);
int Num_larnv_cublas_zprimme(int idist, PRIMME_INT *iseed, PRIMME_INT length,
      dummy_type_cublas_zprimme *x, primme_context ctx);
int Num_copy_matrix_cublas_zprimme(dummy_type_cublas_zprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, dummy_type_cublas_zprimme *y, PRIMME_INT ldy,
      primme_context ctx);
int Num_zero_matrix_cublas_zprimme(dummy_type_cublas_zprimme *x, PRIMME_INT m, PRIMME_INT n,
      PRIMME_INT ldx, primme_context ctx);
int Num_trsm_hd_cublas_zprimme(const char *side, const char *uplo, const char *transa,
      const char *diag, int m, int n, dummy_type_zprimme alpha, dummy_type_zprimme *a, int lda,
      dummy_type_cublas_zprimme *b, int ldb, primme_context ctx);
int Num_compute_gramm_cublas_zprimme(dummy_type_cublas_zprimme *X, PRIMME_INT m, int n, int ldX,
      dummy_type_cublas_zprimme *Y, PRIMME_INT ldY, dummy_type_zprimme alpha, dummy_type_cublas_zprimme *H, int ldH, int isherm,
      int deep, primme_context ctx);
int Num_compute_gramm_ddh_cublas_zprimme(dummy_type_cublas_zprimme *X, PRIMME_INT m, int n, int ldX,
      dummy_type_cublas_zprimme *Y, PRIMME_INT ldY, dummy_type_zprimme alpha, dummy_type_zprimme *H, int ldH, int isherm,
      primme_context ctx);
#endif
