# Check C++11
IF(NOT(USE_CPP_03))
  IF(MSVC)
    IF(MSVC_VERSION GREATER 1700)
      SET(COMPILER_SUPPORTS_CXX11 True)
    ELSE(MSVC_VERSION GREATER 1700)
      SET(COMPILER_SUPPORTS_CXX11 False)
    ENDIF(MSVC_VERSION GREATER 1700)
  ELSE(MSVC)
    INCLUDE(CheckCXXCompilerFlag)
    IF(APPLE)
      CHECK_CXX_COMPILER_FLAG("-std=c++11 -stdlib=libc++" COMPILER_SUPPORTS_CXX11)
    ELSE(APPLE)
      IF(FMU_TARGET)
        SET(COMPILER_SUPPORTS_CXX11 True)
      ELSE(FMU_TARGET)
        CHECK_CXX_COMPILER_FLAG("-std=c++11" COMPILER_SUPPORTS_CXX11)
      ENDIF(FMU_TARGET)
    ENDIF(APPLE)
    IF(COMPILER_SUPPORTS_CXX11)
      IF(APPLE)
        SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -std=c++11 -stdlib=libc++")
        SET(CMAKE_CXX_FLAGS_${CMAKE_BUILD_TYPE} "${CMAKE_CXX_FLAGS_${CMAKE_BUILD_TYPE}} -std=c++11 -stdlib=libc++")
        SET(CMAKE_EXE_LINKER_FLAGS "-stdlib=libc++")
        SET(CXX11_FLAGS " -std=c++11 -stdlib=libc++") #used for precompiled header
      ELSE(APPLE)
        SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -std=c++11")
        SET(CMAKE_CXX_FLAGS_${CMAKE_BUILD_TYPE} "${CMAKE_CXX_FLAGS_${CMAKE_BUILD_TYPE}} -std=c++11")
        SET(CXX11_FLAGS " -std=c++11") #used for precompiled header
      ENDIF(APPLE)
    ELSE()
      SET(COMPILER_SUPPORTS_CXX11 False)
    ENDIF(COMPILER_SUPPORTS_CXX11)
  ENDIF(MSVC)
ELSE()
  SET(COMPILER_SUPPORTS_CXX11 False)
  IF(APPLE)
    SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -std=c++03 -stdlib=libc++")
    SET(CMAKE_CXX_FLAGS_${CMAKE_BUILD_TYPE} "${CMAKE_CXX_FLAGS_${CMAKE_BUILD_TYPE}} -std=c++03 -stdlib=libc++")
    SET(CMAKE_EXE_LINKER_FLAGS "-stdlib=libc++")
    SET(CXX11_FLAGS " -std=c++03 -stdlib=libc++") #used for precompiled header
  ELSE(APPLE)
    SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -std=c++03")
    SET(CMAKE_CXX_FLAGS_${CMAKE_BUILD_TYPE} "${CMAKE_CXX_FLAGS_${CMAKE_BUILD_TYPE}} -std=c++03")
    SET(CXX11_FLAGS " -std=c++03") #used for precompiled header
  ENDIF(APPLE)
ENDIF(NOT(USE_CPP_03))

IF(COMPILER_SUPPORTS_CXX11)
  MESSAGE(STATUS "C++11 support enabled")
ELSE(COMPILER_SUPPORTS_CXX11)
  MESSAGE(STATUS "C++11 support disabled")
  ADD_DEFINITIONS(-DUSE_CPP_03)
ENDIF(COMPILER_SUPPORTS_CXX11)