/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;
import org.apache.xalan.xpath.FoundIndex;
import org.apache.xalan.xpath.FuncLoader;
import org.apache.xalan.xpath.Function;
import org.apache.xalan.xpath.MutableNodeList;
import org.apache.xalan.xpath.NodeCallback;
import org.apache.xalan.xpath.XBoolean;
import org.apache.xalan.xpath.XBooleanStatic;
import org.apache.xalan.xpath.XLocator;
import org.apache.xalan.xpath.XNodeSet;
import org.apache.xalan.xpath.XNull;
import org.apache.xalan.xpath.XNumber;
import org.apache.xalan.xpath.XObject;
import org.apache.xalan.xpath.XPathException;
import org.apache.xalan.xpath.XPathProcessorImpl;
import org.apache.xalan.xpath.XPathSupport;
import org.apache.xalan.xpath.XRTreeFrag;
import org.apache.xalan.xpath.XString;
import org.apache.xalan.xpath.xml.PrefixResolver;
import org.apache.xalan.xpath.xml.ProblemListener;
import org.apache.xalan.xpath.xml.ProblemListenerDefault;
import org.apache.xalan.xpath.xml.QName;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XPath
implements Serializable {
    static XBoolean m_true = new XBooleanStatic(true);
    static XBoolean m_false = new XBooleanStatic(false);
    String m_currentPattern;
    static final int MAXTOKENQUEUESIZE = 500;
    Object[] m_tokenQueue = new Object[500];
    int m_tokenQueueSize = 0;
    int[] m_opMap = null;
    public static final int MAPINDEX_LENGTH = 1;
    static final boolean m_debug = false;
    private transient ProblemListener m_problemListener = null;
    static final boolean m_trace = false;
    public static final double MATCH_SCORE_NONE = Double.NEGATIVE_INFINITY;
    public static final double MATCH_SCORE_QNAME = 0.0;
    public static final double MATCH_SCORE_NSWILD = -0.25;
    public static final double MATCH_SCORE_NODETEST = -0.5;
    public static final double MATCH_SCORE_OTHER = 0.5;
    public static final int ENDOP = -1;
    public static final int EMPTY = -2;
    public static final int ELEMWILDCARD = -3;
    public static final int OP_XPATH = 1;
    public static final int OP_OR = 2;
    public static final int OP_AND = 3;
    public static final int OP_NOTEQUALS = 4;
    public static final int OP_EQUALS = 5;
    public static final int OP_LTE = 6;
    public static final int OP_LT = 7;
    public static final int OP_GTE = 8;
    public static final int OP_GT = 9;
    public static final int OP_PLUS = 10;
    public static final int OP_MINUS = 11;
    public static final int OP_MULT = 12;
    public static final int OP_DIV = 13;
    public static final int OP_MOD = 14;
    public static final int OP_QUO = 15;
    public static final int OP_NEG = 16;
    public static final int OP_STRING = 17;
    public static final int OP_BOOL = 18;
    public static final int OP_NUMBER = 19;
    public static final int OP_UNION = 20;
    public static final int OP_LITERAL = 21;
    public static final int OP_VARIABLE = 22;
    public static final int OP_GROUP = 23;
    public static final int OP_NUMBERLIT = 24;
    public static final int OP_ARGUMENT = 25;
    public static final int OP_EXTFUNCTION = 26;
    public static final int OP_FUNCTION = 27;
    public static final int OP_LOCATIONPATH = 28;
    public static final int LOCATIONPATHEX_MASK = 65535;
    public static final int LOCATIONPATHEX_ISSIMPLE = 65536;
    public static final int OP_LOCATIONPATH_EX = 65564;
    public static final int OP_PREDICATE = 29;
    public static final int OP_MATCHPATTERN = 30;
    public static final int OP_LOCATIONPATHPATTERN = 31;
    public static final int NODETYPE_COMMENT = 1030;
    public static final int NODETYPE_TEXT = 1031;
    public static final int NODETYPE_PI = 1032;
    public static final int NODETYPE_NODE = 1033;
    public static final int NODENAME = 34;
    public static final int NODETYPE_ROOT = 35;
    public static final int NODETYPE_ANYELEMENT = 36;
    public static final int FROM_ANCESTORS = 37;
    public static final int FROM_ANCESTORS_OR_SELF = 38;
    public static final int FROM_ATTRIBUTES = 39;
    public static final int FROM_CHILDREN = 40;
    public static final int FROM_DESCENDANTS = 41;
    public static final int FROM_DESCENDANTS_OR_SELF = 42;
    public static final int FROM_FOLLOWING = 43;
    public static final int FROM_FOLLOWING_SIBLINGS = 44;
    public static final int FROM_PARENT = 45;
    public static final int FROM_PRECEDING = 46;
    public static final int FROM_PRECEDING_SIBLINGS = 47;
    public static final int FROM_SELF = 48;
    public static final int FROM_NAMESPACE = 49;
    public static final int FROM_ROOT = 55;
    public static final int FUNC_CURRENT = 0;
    public static final int FUNC_LAST = 1;
    public static final int FUNC_POSITION = 2;
    public static final int FUNC_COUNT = 3;
    public static final int FUNC_ID = 4;
    public static final int FUNC_KEY = 5;
    public static final int FUNC_LOCAL_PART = 7;
    public static final int FUNC_NAMESPACE = 8;
    public static final int FUNC_QNAME = 9;
    public static final int FUNC_GENERATE_ID = 10;
    public static final int FUNC_NOT = 11;
    public static final int FUNC_TRUE = 12;
    public static final int FUNC_FALSE = 13;
    public static final int FUNC_BOOLEAN = 14;
    public static final int FUNC_NUMBER = 15;
    public static final int FUNC_FLOOR = 16;
    public static final int FUNC_CEILING = 17;
    public static final int FUNC_ROUND = 18;
    public static final int FUNC_SUM = 19;
    public static final int FUNC_STRING = 20;
    public static final int FUNC_STARTS_WITH = 21;
    public static final int FUNC_CONTAINS = 22;
    public static final int FUNC_SUBSTRING_BEFORE = 23;
    public static final int FUNC_SUBSTRING_AFTER = 24;
    public static final int FUNC_NORMALIZE_SPACE = 25;
    public static final int FUNC_TRANSLATE = 26;
    public static final int FUNC_CONCAT = 27;
    public static final int FUNC_SUBSTRING = 29;
    public static final int FUNC_STRING_LENGTH = 30;
    public static final int FUNC_SYSTEM_PROPERTY = 31;
    public static final int FUNC_LANG = 32;
    public static final int FUNC_EXT_FUNCTION_AVAILABLE = 33;
    public static final int FUNC_EXT_ELEM_AVAILABLE = 34;
    public static final int FUNC_DOCLOCATION = 35;
    public static final int FUNC_UNPARSED_ENTITY_URI = 36;
    private static final int NUM_BUILT_IN_FUNCS = 37;
    private static final int NUM_ALLOWABLE_ADDINS = 30;
    private static Function[] m_functions;
    private static int m_funcNextFreeIndex;
    public static final int MATCH_ATTRIBUTE = 94;
    public static final int MATCH_ANY_ANCESTOR = 95;
    public static final int MATCH_IMMEDIATE_ANCESTOR = 96;
    public static final String PSEUDONAME_ANY = "*";
    public static final String PSEUDONAME_ROOT = "/";
    public static final String PSEUDONAME_TEXT = "#text";
    public static final String PSEUDONAME_COMMENT = "#comment";
    public static final String PSEUDONAME_PI = "#pi";
    public static final String PSEUDONAME_OTHER = "*";
    private static final int NEXT_FREE_ID = 99;

    static {
        m_funcNextFreeIndex = 37;
        m_functions = new Function[67];
        XPath.m_functions[0] = new FuncLoader("FuncCurrent", 0);
        XPath.m_functions[1] = new FuncLoader("FuncLast", 1);
        XPath.m_functions[2] = new FuncLoader("FuncPosition", 2);
        XPath.m_functions[3] = new FuncLoader("FuncCount", 3);
        XPath.m_functions[4] = new FuncLoader("FuncId", 4);
        XPath.m_functions[5] = new FuncLoader("FuncKey", 5);
        XPath.m_functions[7] = new FuncLoader("FuncLocalPart", 7);
        XPath.m_functions[8] = new FuncLoader("FuncNamespace", 8);
        XPath.m_functions[9] = new FuncLoader("FuncQname", 9);
        XPath.m_functions[10] = new FuncLoader("FuncGenerateId", 10);
        XPath.m_functions[11] = new FuncLoader("FuncNot", 11);
        XPath.m_functions[12] = new FuncLoader("FuncTrue", 12);
        XPath.m_functions[13] = new FuncLoader("FuncFalse", 13);
        XPath.m_functions[14] = new FuncLoader("FuncBoolean", 14);
        XPath.m_functions[32] = new FuncLoader("FuncLang", 32);
        XPath.m_functions[15] = new FuncLoader("FuncNumber", 15);
        XPath.m_functions[16] = new FuncLoader("FuncFloor", 16);
        XPath.m_functions[17] = new FuncLoader("FuncCeiling", 17);
        XPath.m_functions[18] = new FuncLoader("FuncRound", 18);
        XPath.m_functions[19] = new FuncLoader("FuncSum", 19);
        XPath.m_functions[20] = new FuncLoader("FuncString", 20);
        XPath.m_functions[21] = new FuncLoader("FuncStartsWith", 21);
        XPath.m_functions[22] = new FuncLoader("FuncContains", 22);
        XPath.m_functions[23] = new FuncLoader("FuncSubstringBefore", 23);
        XPath.m_functions[24] = new FuncLoader("FuncSubstringAfter", 24);
        XPath.m_functions[25] = new FuncLoader("FuncNormalizeSpace", 25);
        XPath.m_functions[26] = new FuncLoader("FuncTranslate", 26);
        XPath.m_functions[27] = new FuncLoader("FuncConcat", 27);
        XPath.m_functions[31] = new FuncLoader("FuncSystemProperty", 31);
        XPath.m_functions[33] = new FuncLoader("FuncExtFunctionAvailable", 33);
        XPath.m_functions[34] = new FuncLoader("FuncExtElementAvailable", 34);
        XPath.m_functions[29] = new FuncLoader("FuncSubstring", 29);
        XPath.m_functions[30] = new FuncLoader("FuncStringLength", 30);
        XPath.m_functions[35] = new FuncLoader("FuncDoclocation", 35);
        XPath.m_functions[36] = new FuncLoader("FuncUnparsedEntityURI", 36);
    }

    public XPath() {
        this.m_problemListener = new ProblemListenerDefault();
    }

    public XPath(ProblemListener problemListener) {
        this.m_problemListener = problemListener;
    }

    protected XBoolean and(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject = this.execute(xPathSupport, node, n);
        if (xObject.bool()) {
            XObject xObject2 = this.execute(xPathSupport, node, n2);
            return xObject2.bool() ? m_true : m_false;
        }
        return m_false;
    }

    protected XObject arg(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        return this.execute(xPathSupport, node, n + 2);
    }

    private void assert(boolean bl, String string) throws SAXException {
        if (!bl) {
            this.error(null, 30, new Object[]{string});
        }
    }

    protected XBoolean bool(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject = this.execute(xPathSupport, node, n + 2);
        return xObject.bool() ? m_true : m_false;
    }

    private XLocator createXLocatorHandler(XPathSupport xPathSupport) {
        return xPathSupport.createXLocatorHandler();
    }

    protected XNumber div(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject = this.execute(xPathSupport, node, n);
        XObject xObject2 = this.execute(xPathSupport, node, n2);
        return new XNumber(xObject.num() / xObject2.num());
    }

    protected XBoolean equals(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject;
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject2 = this.execute(xPathSupport, node, n, null, null, true);
        return xObject2.equals(xObject = this.execute(xPathSupport, node, n2, null, null, true)) ? m_true : m_false;
    }

    void error(int n) throws SAXException {
        this.error(null, n, null);
    }

    void error(int n, Object[] objectArray) throws SAXException {
        this.error(null, n, objectArray);
    }

    void error(Node node, int n) throws SAXException {
        this.error(node, n, null);
    }

    void error(Node node, int n, Object[] objectArray) throws SAXException {
        String string = XSLMessages.createXPATHMessage(n, objectArray);
        String string2 = String.valueOf(this.m_currentPattern != null ? "pattern = '" + this.m_currentPattern + "'\n" : "") + string;
        boolean bl = this.m_problemListener.problem((short)4, (short)2, null, node, string2, null, 0, 0);
        if (bl) {
            throw new XPathException(string2);
        }
    }

    public XObject execute(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        int n2 = this.m_opMap[n];
        switch (n2) {
            case 1: {
                return this.execute(xPathSupport, node, n + 2);
            }
            case 2: {
                return this.or(xPathSupport, node, n);
            }
            case 3: {
                return this.and(xPathSupport, node, n);
            }
            case 4: {
                return this.notequals(xPathSupport, node, n);
            }
            case 5: {
                return this.equals(xPathSupport, node, n);
            }
            case 6: {
                return this.lte(xPathSupport, node, n);
            }
            case 7: {
                return this.lt(xPathSupport, node, n);
            }
            case 8: {
                return this.gte(xPathSupport, node, n);
            }
            case 9: {
                return this.gt(xPathSupport, node, n);
            }
            case 10: {
                return this.plus(xPathSupport, node, n);
            }
            case 11: {
                return this.minus(xPathSupport, node, n);
            }
            case 12: {
                return this.mult(xPathSupport, node, n);
            }
            case 13: {
                return this.div(xPathSupport, node, n);
            }
            case 14: {
                return this.mod(xPathSupport, node, n);
            }
            case 15: {
                return this.quo(xPathSupport, node, n);
            }
            case 16: {
                return this.neg(xPathSupport, node, n);
            }
            case 17: {
                return this.string(xPathSupport, node, n);
            }
            case 18: {
                return this.bool(xPathSupport, node, n);
            }
            case 19: {
                return this.number(xPathSupport, node, n);
            }
            case 20: {
                return this.union(xPathSupport, node, n, null, null);
            }
            case 21: {
                return this.literal(xPathSupport, node, n);
            }
            case 22: {
                return this.variable(xPathSupport, node, n);
            }
            case 23: {
                return this.group(xPathSupport, node, n);
            }
            case 24: {
                return this.numberlit(xPathSupport, node, n);
            }
            case 25: {
                return this.arg(xPathSupport, node, n);
            }
            case 26: {
                return this.executeExtension(xPathSupport, node, n);
            }
            case 27: {
                return this.executeFunction(xPathSupport, node, n);
            }
            case 28: {
                return this.locationPath(xPathSupport, node, n, null, null, false);
            }
            case 29: {
                return null;
            }
            case 30: {
                return this.matchPattern(xPathSupport, node, n + 2);
            }
            case 31: {
                return this.locationPathPattern(xPathSupport, node, n);
            }
        }
        if (n2 == 65564) {
            return this.locationPath(xPathSupport, node, n, null, null, false);
        }
        this.error(node, 24, new Object[]{Integer.toString(this.m_opMap[n])});
        return null;
    }

    public XObject execute(XPathSupport xPathSupport, Node node, int n, NodeCallback nodeCallback, Object object, boolean bl) throws SAXException {
        int n2 = this.m_opMap[n];
        switch (n2) {
            case 1: {
                return this.execute(xPathSupport, node, n + 2, nodeCallback, object, bl);
            }
            case 2: {
                return this.or(xPathSupport, node, n);
            }
            case 3: {
                return this.and(xPathSupport, node, n);
            }
            case 4: {
                return this.notequals(xPathSupport, node, n);
            }
            case 5: {
                return this.equals(xPathSupport, node, n);
            }
            case 6: {
                return this.lte(xPathSupport, node, n);
            }
            case 7: {
                return this.lt(xPathSupport, node, n);
            }
            case 8: {
                return this.gte(xPathSupport, node, n);
            }
            case 9: {
                return this.gt(xPathSupport, node, n);
            }
            case 10: {
                return this.plus(xPathSupport, node, n);
            }
            case 11: {
                return this.minus(xPathSupport, node, n);
            }
            case 12: {
                return this.mult(xPathSupport, node, n);
            }
            case 13: {
                return this.div(xPathSupport, node, n);
            }
            case 14: {
                return this.mod(xPathSupport, node, n);
            }
            case 15: {
                return this.quo(xPathSupport, node, n);
            }
            case 16: {
                return this.neg(xPathSupport, node, n);
            }
            case 17: {
                return this.string(xPathSupport, node, n);
            }
            case 18: {
                return this.bool(xPathSupport, node, n);
            }
            case 19: {
                return this.number(xPathSupport, node, n);
            }
            case 20: {
                return this.union(xPathSupport, node, n, nodeCallback, object);
            }
            case 21: {
                return this.literal(xPathSupport, node, n);
            }
            case 22: {
                return this.variable(xPathSupport, node, n);
            }
            case 23: {
                return this.group(xPathSupport, node, n);
            }
            case 24: {
                return this.numberlit(xPathSupport, node, n);
            }
            case 25: {
                return this.arg(xPathSupport, node, n);
            }
            case 26: {
                return this.executeExtension(xPathSupport, node, n);
            }
            case 27: {
                return this.executeFunction(xPathSupport, node, n);
            }
            case 28: {
                return this.locationPath(xPathSupport, node, n, nodeCallback, object, bl);
            }
            case 29: {
                return null;
            }
            case 30: {
                return this.matchPattern(xPathSupport, node, n + 2);
            }
            case 31: {
                return this.locationPathPattern(xPathSupport, node, n);
            }
        }
        if (n2 == 65564) {
            return this.locationPath(xPathSupport, node, n, nodeCallback, object, bl);
        }
        this.error(node, 24, new Object[]{Integer.toString(this.m_opMap[n])});
        return null;
    }

    public XObject execute(XPathSupport xPathSupport, Node node, PrefixResolver prefixResolver) throws SAXException {
        return this.execute(xPathSupport, node, prefixResolver, null, null, false);
    }

    public XObject execute(XPathSupport xPathSupport, Node node, PrefixResolver prefixResolver, NodeCallback nodeCallback, Object object, boolean bl) throws SAXException {
        XObject xObject;
        PrefixResolver prefixResolver2;
        block3: {
            prefixResolver2 = xPathSupport.getNamespaceContext();
            xPathSupport.setNamespaceContext(prefixResolver);
            xPathSupport.setCurrentNode(node);
            xObject = null;
            try {
                if (object != null) {
                    xPathSupport.pushXPathContext(this, xPathSupport, node, prefixResolver);
                }
                xObject = this.execute(xPathSupport, node, 0, nodeCallback, object, bl);
                if (object == null) break block3;
                xPathSupport.popXPathContext();
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                xPathSupport.setNamespaceContext(prefixResolver2);
                xPathSupport.setCurrentNode(null);
                throw throwable;
            }
        }
        Object var10_9 = null;
        xPathSupport.setNamespaceContext(prefixResolver2);
        xPathSupport.setCurrentNode(null);
        return xObject;
    }

    private XObject executeExtension(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        int n2 = n + this.m_opMap[n + 1] - 1;
        n = XPath.getFirstChildPos(n);
        String string = (String)this.m_tokenQueue[this.m_opMap[n]];
        String string2 = (String)this.m_tokenQueue[this.m_opMap[++n]];
        ++n;
        Vector<XObject> vector = new Vector<XObject>();
        while (n < n2) {
            int n3 = this.getNextOpPos(n);
            vector.addElement(this.execute(xPathSupport, node, n));
            n = n3;
        }
        return this.extfunction(xPathSupport, node, n, string, string2, vector, String.valueOf(String.valueOf(this.m_opMap[n])) + String.valueOf(this.hashCode()));
    }

    XObject executeFunction(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        int n2 = n + this.m_opMap[n + 1] - 1;
        n = XPath.getFirstChildPos(n);
        int n3 = this.m_opMap[n];
        ++n;
        if (n3 != -1) {
            return m_functions[n3].execute(this, xPathSupport, node, n, n3, n2);
        }
        this.warn(7);
        return null;
    }

    protected XObject extfunction(XPathSupport xPathSupport, Node node, int n, String string, String string2, Vector vector, Object object) throws SAXException {
        XObject xObject;
        Object object2 = xPathSupport.extFunction(string, string2, vector, object);
        if (object2 != null) {
            if (object2 instanceof XObject) {
                xObject = (XObject)object2;
            } else if (object2 instanceof XLocator) {
                XLocator xLocator = (XLocator)object2;
                n = this.getNextOpPos(n + 1);
                xObject = xLocator.connectToNodes(this, xPathSupport, node, n, vector);
            } else if (object2 instanceof String) {
                xObject = new XString((String)object2);
            } else if (object2 instanceof Boolean) {
                xObject = (Boolean)object2 != false ? m_true : m_false;
            } else if (object2 instanceof Double) {
                xObject = new XNumber((Double)object2);
            } else if (object2 instanceof DocumentFragment) {
                xObject = new XRTreeFrag((DocumentFragment)object2);
            } else if (object2 instanceof Node) {
                n = this.getNextOpPos(n);
                XNodeSet xNodeSet = null;
                if (n < this.m_opMap[1] && (this.m_opMap[n] & 0xFFFF) == 28) {
                    xNodeSet = this.locationPath(xPathSupport, (Node)object2, n, null, null, false);
                }
                xObject = xNodeSet == null ? new XNodeSet((Node)object2) : xNodeSet;
            } else if (object2 instanceof NodeList) {
                n = this.getNextOpPos(n);
                XNodeSet xNodeSet = null;
                if (n < this.m_opMap[1] && (this.m_opMap[n] & 0xFFFF) == 28) {
                    NodeList nodeList = (NodeList)object2;
                    int n2 = nodeList.getLength();
                    int n3 = 0;
                    while (n3 < n2) {
                        XNodeSet xNodeSet2 = this.locationPath(xPathSupport, nodeList.item(n3), n, null, null, false);
                        if (xNodeSet2 == null) {
                            xNodeSet = xNodeSet2;
                        } else {
                            xNodeSet.mutableNodeset().addNodes(xNodeSet2.nodeset());
                        }
                        ++n3;
                    }
                }
                xObject = xNodeSet == null ? new XNodeSet((NodeList)object2) : xNodeSet;
            } else {
                xObject = new XObject(object2);
            }
        } else {
            xObject = new XNull();
        }
        return xObject;
    }

    public int getArgLengthOfStep(int n) {
        return this.m_opMap[n + 1 + 1] - 3;
    }

    int getCountOfContextNodeList(XPath xPath, XPathSupport xPathSupport, Node node) throws SAXException {
        if (xPathSupport.getThrowFoundIndex()) {
            throw new FoundIndex();
        }
        NodeList nodeList = xPathSupport.getContextNodeList();
        if (nodeList == null) {
            XObject xObject = xPathSupport.reExecuteXPathContext(xPath, xPathSupport, node);
            if (xObject != null && xObject.getType() == 4) {
                nodeList = xObject.nodeset();
            } else {
                if (xPathSupport.getContextNodePosition() > 0) {
                    throw new FoundIndex();
                }
                return 0;
            }
        }
        return nodeList.getLength();
    }

    public static int getFirstChildPos(int n) {
        return n + 2;
    }

    public static int getFirstChildPosOfStep(int n) {
        return n + 3;
    }

    public double getMatchScore(XPathSupport xPathSupport, Node node) throws SAXException {
        double d = Double.NEGATIVE_INFINITY;
        int n = 0;
        if (this.m_opMap[n] == 30) {
            n = XPath.getFirstChildPos(n);
            XLocator xLocator = xPathSupport.getXLocatorFromNode(node);
            if (xLocator == null) {
                xLocator = xPathSupport.createXLocatorHandler();
            }
            while (this.m_opMap[n] == 31) {
                int n2 = this.getNextOpPos(n);
                d = xLocator.locationPathPattern(this, xPathSupport, node, n);
                if (d == Double.NEGATIVE_INFINITY) {
                    n = n2;
                    continue;
                }
                break;
            }
        } else {
            this.error(node, 22);
        }
        return d;
    }

    public int getNextOpPos(int n) {
        return n + this.m_opMap[n + 1];
    }

    public static int getNextOpPos(int[] nArray, int n) {
        return n + nArray[n + 1];
    }

    public int getOp(int n) {
        return this.m_opMap[n];
    }

    public int[] getOpMap() {
        return this.m_opMap;
    }

    public String getPatternString() {
        return this.m_currentPattern;
    }

    int getPositionInContextNodeList(Node node, XPathSupport xPathSupport) {
        if (xPathSupport.getThrowFoundIndex()) {
            throw new FoundIndex();
        }
        int n = xPathSupport.getContextNodePosition();
        if (n >= 0) {
            return n;
        }
        n = -1;
        if (xPathSupport.getContextNodeList() != null) {
            int n2 = xPathSupport.getContextNodeList().getLength();
            int n3 = 0;
            while (n3 < n2) {
                Node node2 = xPathSupport.getContextNodeList().item(n3);
                if (node2 != null && node2.equals(node)) {
                    n = n3 + 1;
                    break;
                }
                ++n3;
            }
        }
        return n;
    }

    public ProblemListener getProblemListener() {
        return this.m_problemListener;
    }

    public Vector getTargetElementStrings() {
        Vector<String> vector = new Vector<String>();
        int n = 2;
        while (this.m_opMap[n] == 31) {
            int n2 = this.getNextOpPos(n);
            n = XPath.getFirstChildPos(n);
            while (this.m_opMap[n] != -1) {
                int n3 = this.getNextOpPos(n);
                int n4 = this.m_opMap[n3];
                if (n4 == 29 || n4 == -1) {
                    int n5 = this.m_opMap[n];
                    n += 3;
                    block0 : switch (n5) {
                        case 27: {
                            vector.addElement("*");
                            break;
                        }
                        case 55: {
                            vector.addElement(PSEUDONAME_ROOT);
                            break;
                        }
                        case 94: 
                        case 95: 
                        case 96: {
                            int n6 = this.m_opMap[n];
                            ++n;
                            switch (n6) {
                                case 1030: {
                                    vector.addElement(PSEUDONAME_COMMENT);
                                    break block0;
                                }
                                case 1031: {
                                    vector.addElement(PSEUDONAME_TEXT);
                                    break block0;
                                }
                                case 1033: {
                                    vector.addElement("*");
                                    break block0;
                                }
                                case 35: {
                                    vector.addElement(PSEUDONAME_ROOT);
                                    break block0;
                                }
                                case 36: {
                                    vector.addElement("*");
                                    break block0;
                                }
                                case 1032: {
                                    vector.addElement("*");
                                    break block0;
                                }
                                case 34: {
                                    int n7 = this.m_opMap[n + 1];
                                    if (n7 >= 0) {
                                        String string = (String)this.m_tokenQueue[n7];
                                        if (string.equals("*")) {
                                            vector.addElement("*");
                                            break block0;
                                        }
                                        vector.addElement(string);
                                        break block0;
                                    }
                                    vector.addElement("*");
                                    break block0;
                                }
                            }
                            vector.addElement("*");
                            break;
                        }
                    }
                }
                n = n3;
            }
            n = n2;
        }
        return vector;
    }

    public Object[] getTokenQueue() {
        return this.m_tokenQueue;
    }

    public int getTokenQueueSize() {
        return this.m_tokenQueueSize;
    }

    protected XObject group(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        return this.execute(xPathSupport, node, n + 2);
    }

    protected XBoolean gt(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject;
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject2 = this.execute(xPathSupport, node, n);
        return xObject2.greaterThan(xObject = this.execute(xPathSupport, node, n2)) ? m_true : m_false;
    }

    protected XBoolean gte(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject;
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject2 = this.execute(xPathSupport, node, n);
        return xObject2.greaterThanOrEqual(xObject = this.execute(xPathSupport, node, n2)) ? m_true : m_false;
    }

    public void installFunction(String string, int n, Function function) {
        XPath.m_functions[n] = function;
    }

    public static int installFunction(String string, Function function) {
        int n;
        Object v = XPathProcessorImpl.m_functions.get(string);
        if (v != null) {
            n = (Integer)v;
        } else {
            n = m_funcNextFreeIndex++;
            XPathProcessorImpl.m_functions.put(string, new Integer(n));
        }
        XPath.m_functions[n] = function;
        return n;
    }

    protected XString literal(XPathSupport xPathSupport, Node node, int n) {
        n = XPath.getFirstChildPos(n);
        return (XString)this.m_tokenQueue[this.m_opMap[n]];
    }

    public XNodeSet locationPath(XPathSupport xPathSupport, Node node, int n, NodeCallback nodeCallback, Object object, boolean bl) throws SAXException {
        XLocator xLocator = xPathSupport.getXLocatorFromNode(node);
        if (xLocator == null) {
            xLocator = xPathSupport.createXLocatorHandler();
        }
        XNodeSet xNodeSet = xLocator.locationPath(this, xPathSupport, node, n, nodeCallback, object, bl);
        return xNodeSet;
    }

    protected XNumber locationPathPattern(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XLocator xLocator = xPathSupport.getXLocatorFromNode(node);
        if (xLocator == null) {
            xLocator = xPathSupport.createXLocatorHandler();
        }
        double d = xLocator.locationPathPattern(this, xPathSupport, node, n);
        return new XNumber(d);
    }

    protected XBoolean lt(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject;
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject2 = this.execute(xPathSupport, node, n);
        return xObject2.lessThan(xObject = this.execute(xPathSupport, node, n2)) ? m_true : m_false;
    }

    protected XBoolean lte(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject;
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject2 = this.execute(xPathSupport, node, n);
        return xObject2.lessThanOrEqual(xObject = this.execute(xPathSupport, node, n2)) ? m_true : m_false;
    }

    protected XObject matchPattern(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject = null;
        while (this.m_opMap[n] == 31) {
            int n2 = this.getNextOpPos(n);
            xObject = this.execute(xPathSupport, node, n);
            if (xObject.num() != Double.NEGATIVE_INFINITY) break;
            n = n2;
        }
        if (xObject == null) {
            xObject = new XNumber(Double.NEGATIVE_INFINITY);
        }
        return xObject;
    }

    protected XNumber minus(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject = this.execute(xPathSupport, node, n);
        XObject xObject2 = this.execute(xPathSupport, node, n2);
        return new XNumber(xObject.num() - xObject2.num());
    }

    protected XNumber mod(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject = this.execute(xPathSupport, node, n);
        XObject xObject2 = this.execute(xPathSupport, node, n2);
        return new XNumber(xObject.num() % xObject2.num());
    }

    protected XNumber mult(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject = this.execute(xPathSupport, node, n);
        XObject xObject2 = this.execute(xPathSupport, node, n2);
        return new XNumber(xObject.num() * xObject2.num());
    }

    protected XNumber neg(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject = this.execute(xPathSupport, node, n + 2);
        return new XNumber(-xObject.num());
    }

    protected XBoolean notequals(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject;
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject2 = this.execute(xPathSupport, node, n);
        return xObject2.notEquals(xObject = this.execute(xPathSupport, node, n2)) ? m_true : m_false;
    }

    protected XNumber number(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject = this.execute(xPathSupport, node, n + 2);
        return new XNumber(xObject.num());
    }

    protected XNumber numberlit(XPathSupport xPathSupport, Node node, int n) {
        n = XPath.getFirstChildPos(n);
        return (XNumber)this.m_tokenQueue[this.m_opMap[n]];
    }

    protected XBoolean or(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject;
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject2 = this.execute(xPathSupport, node, n);
        XBoolean xBoolean = !xObject2.bool() ? (!(xObject = this.execute(xPathSupport, node, n2)).bool() ? new XBoolean(false) : new XBoolean(true)) : new XBoolean(true);
        return xBoolean;
    }

    protected XNumber plus(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject = this.execute(xPathSupport, node, n);
        XObject xObject2 = this.execute(xPathSupport, node, n2);
        return new XNumber(xObject.num() + xObject2.num());
    }

    public XObject predicate(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject = this.execute(xPathSupport, node, n + 2, null, null, true);
        int n2 = xObject.getType();
        if (n2 != 2 && n2 != 1) {
            xObject = xObject.bool() ? m_true : m_false;
        }
        return xObject;
    }

    protected XNumber quo(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        this.warn(5);
        n = XPath.getFirstChildPos(n);
        int n2 = this.getNextOpPos(n);
        XObject xObject = this.execute(xPathSupport, node, n);
        XObject xObject2 = this.execute(xPathSupport, node, n2);
        return new XNumber((int)(xObject.num() / xObject2.num()));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(XSLMessages.createXPATHMessage(68, new Object[]{classNotFoundException.getMessage()}));
        }
    }

    public void setProblemListener(ProblemListener problemListener) {
        this.m_problemListener = problemListener;
    }

    void shrink() {
        int[] nArray = this.m_opMap;
        int n = this.m_opMap[1];
        this.m_opMap = new int[n + 4];
        int n2 = 0;
        while (n2 < n) {
            this.m_opMap[n2] = nArray[n2];
            ++n2;
        }
        this.m_opMap[n2] = 0;
        this.m_opMap[n2 + 1] = 0;
        this.m_opMap[n2 + 2] = 0;
        Object[] objectArray = this.m_tokenQueue;
        n = this.m_tokenQueueSize;
        this.m_tokenQueue = new Object[n + 4];
        n2 = 0;
        while (n2 < n) {
            this.m_tokenQueue[n2] = objectArray[n2];
            ++n2;
        }
        this.m_tokenQueue[n2] = null;
        this.m_tokenQueue[n2 + 1] = null;
        this.m_tokenQueue[n2 + 2] = null;
    }

    protected MutableNodeList step(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        this.warn(node, 6);
        return null;
    }

    protected XString string(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject = this.execute(xPathSupport, node, n + 2);
        return new XString(xObject.str());
    }

    private final void trace(String string) {
        System.out.println(string);
    }

    protected XNodeSet union(XPathSupport xPathSupport, Node node, int n, NodeCallback nodeCallback, Object object) throws SAXException {
        XLocator xLocator = xPathSupport.getXLocatorFromNode(node);
        if (xLocator == null) {
            xLocator = xPathSupport.createXLocatorHandler();
        }
        XNodeSet xNodeSet = xLocator.union(this, xPathSupport, node, n, nodeCallback, object);
        return xNodeSet;
    }

    protected XObject variable(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        XObject xObject;
        n = XPath.getFirstChildPos(n);
        String string = (String)this.m_tokenQueue[this.m_opMap[n]];
        QName qName = new QName(string, xPathSupport.getNamespaceContext());
        try {
            xObject = xPathSupport.getVariable(qName);
        }
        catch (Exception exception) {
            this.error(23, new Object[]{string});
            xObject = null;
        }
        if (xObject == null) {
            this.error(node, 43, new Object[]{string});
        }
        return xObject;
    }

    void warn(int n) throws SAXException {
        this.warn(null, n, null);
    }

    void warn(int n, Object[] objectArray) throws SAXException {
        this.warn(null, n, objectArray);
    }

    void warn(Node node, int n) throws SAXException {
        this.warn(node, n, null);
    }

    void warn(Node node, int n, Object[] objectArray) throws SAXException {
        String string = XSLMessages.createXPATHWarning(n, objectArray);
        boolean bl = this.m_problemListener.problem((short)4, (short)1, null, node, string, null, 0, 0);
        if (bl) {
            throw new XPathException(string);
        }
    }

    protected XObject xpath(XPathSupport xPathSupport, Node node, int n) throws SAXException {
        return this.execute(xPathSupport, node, n + 2);
    }
}

