/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.codegen;

import java.io.IOException;
import org.antlr.Tool;
import org.antlr.codegen.CodeGenerator;
import org.antlr.codegen.Target;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.tool.Grammar;

public class CPPTarget
extends Target {
    public String escapeChar(int c) {
        switch (c) {
            case 10: {
                return "\\n";
            }
            case 9: {
                return "\\t";
            }
            case 13: {
                return "\\r";
            }
            case 92: {
                return "\\\\";
            }
            case 39: {
                return "\\'";
            }
            case 34: {
                return "\\\"";
            }
        }
        if (c < 32 || c > 126) {
            if (c > 255) {
                String s = Integer.toString(c, 16);
                while (s.length() < 4) {
                    s = '0' + s;
                }
                return "\\u" + s;
            }
            return "\\" + Integer.toString(c, 8);
        }
        return String.valueOf((char)c);
    }

    public String escapeString(String s) {
        StringBuffer retval = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            retval.append(this.escapeChar(s.charAt(i)));
        }
        return retval.toString();
    }

    protected void genRecognizerHeaderFile(Tool tool, CodeGenerator generator, Grammar grammar, StringTemplate headerFileST, String extName) throws IOException {
        StringTemplateGroup templates = generator.getTemplates();
        generator.write(headerFileST, grammar.name + extName);
    }

    public String getTargetCharLiteralFromANTLRCharLiteral(CodeGenerator codegen, String literal) {
        int c = Grammar.getCharValueFromGrammarCharLiteral(literal);
        String prefix = "'";
        if (codegen.grammar.getMaxCharValue() > 255) {
            prefix = "L'";
        } else if ((c & 0x80) != 0) {
            return "" + c;
        }
        return prefix + this.escapeChar(c) + "'";
    }

    public String getTargetStringLiteralFromANTLRStringLiteral(CodeGenerator codegen, String literal) {
        StringBuffer buf = Grammar.getUnescapedStringFromGrammarStringLiteral(literal);
        String prefix = "\"";
        if (codegen.grammar.getMaxCharValue() > 255) {
            prefix = "L\"";
        }
        return prefix + this.escapeString(buf.toString()) + "\"";
    }

    public int getMaxCharValue(CodeGenerator codegen) {
        int maxval = 255;
        if (maxval <= 255) {
            return 255;
        }
        return maxval;
    }
}

