/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook.printers;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import org.apache.stylebook.AbstractComponent;
import org.apache.stylebook.CreationContext;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Printer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImagePrinter
extends AbstractComponent
implements Printer {
    int R = 0;
    int G = 1;
    int B = 2;
    int A = 3;

    private boolean placeText(Element element, BufferedImage bufferedImage) throws CreationException {
        int n;
        int n2;
        int n3;
        int n4;
        String string = element.getAttribute("text");
        String string2 = element.getAttribute("font");
        String string3 = element.getAttribute("size");
        String string4 = element.getAttribute("style");
        String string5 = element.getAttribute("color");
        String string6 = element.getAttribute("x");
        String string7 = element.getAttribute("y");
        String string8 = element.getAttribute("halign");
        String string9 = element.getAttribute("valign");
        if (string.length() < 1) {
            return false;
        }
        try {
            n4 = Integer.parseInt(string3);
            n3 = Integer.parseInt(string6);
            n2 = Integer.parseInt(string7);
            n = Integer.parseInt(string5, 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CreationException("Attribute size, x, y or color error");
        }
        int n5 = 0;
        if (string4.equals("bold")) {
            n5 = 1;
        } else if (string4.equals("italic")) {
            n5 = 2;
        } else if (string4.equals("bolditalic")) {
            n5 = 3;
        }
        Font font = new Font(string2, n5, n4);
        FontMetrics fontMetrics = bufferedImage.createGraphics().getFontMetrics(font);
        int n6 = fontMetrics.stringWidth(string) * 2;
        int n7 = fontMetrics.getHeight() * 2;
        BufferedImage bufferedImage2 = new BufferedImage(n6, n7, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setColor(new Color(-16777216, true));
        graphics2D.setFont(font);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawString(string, 5, n7 - n7 / 4);
        int n8 = n6;
        int n9 = n7;
        int n10 = 0;
        int n11 = 0;
        WritableRaster writableRaster = bufferedImage2.getRaster();
        int[] nArray = new int[4];
        int n12 = 0;
        while (n12 < writableRaster.getWidth()) {
            int n13 = 10;
            while (n13 < writableRaster.getHeight()) {
                writableRaster.getPixel(n12, n13, nArray);
                if (nArray[this.A] > 0) {
                    if (n12 < n8) {
                        n8 = n12;
                    }
                    if (n12 > n10) {
                        n10 = n12;
                    }
                    if (n13 < n9) {
                        n9 = n13;
                    }
                    if (n13 > n11) {
                        n11 = n13;
                    }
                }
                ++n13;
            }
            ++n12;
        }
        if (string8.equals("right")) {
            n3 -= n10 - n8 + 1;
        }
        if (string8.equals("center")) {
            n3 -= (n10 - n8 + 1) / 2;
        }
        if (string9.equals("bottom")) {
            n2 -= n11 - n9 + 1;
        }
        if (string9.equals("center")) {
            n2 -= (n11 - n9 + 1) / 2;
        }
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        int n14 = n2;
        int n15 = n9;
        while (n15 <= n11) {
            int n16 = n3;
            if (n14 >= 0) {
                int n17 = n8;
                while (n17 <= n10) {
                    writableRaster.getPixel(n17, n15, nArray);
                    nArray[this.R] = n >> 16 & 0xFF;
                    nArray[this.G] = n >> 8 & 0xFF;
                    nArray[this.B] = n & 0xFF;
                    if (n16 >= 0) {
                        writableRaster2.setPixel(n16, n14, nArray);
                    }
                    if (++n16 >= bufferedImage.getWidth()) break;
                    ++n17;
                }
            }
            if (++n14 >= bufferedImage.getHeight()) break;
            ++n15;
        }
        return true;
    }

    public void print(Document document, CreationContext creationContext, OutputStream outputStream) throws CreationException, IOException {
        Object object;
        int n;
        Object object2;
        Element element = document.getDocumentElement();
        if (!element.getTagName().equals("image")) {
            throw new CreationException("Invalid document supplied", document);
        }
        String string = element.getAttribute("source");
        BufferedImage bufferedImage = null;
        Graphics2D graphics2D = null;
        if (string.length() > 0) {
            object2 = null;
            object2 = string.indexOf(":/") >= 0 ? new ImageIcon(new URL(string).openConnection().getURL()) : new ImageIcon(string);
            if (((ImageIcon)object2).getIconWidth() < 1 | ((ImageIcon)object2).getIconHeight() < 1) {
                throw new CreationException("Cannot load image \"" + string + "\"");
            }
            bufferedImage = new BufferedImage(((ImageIcon)object2).getIconWidth(), ((ImageIcon)object2).getIconHeight(), 1);
            graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(((ImageIcon)object2).getImage(), 0, 0, ((ImageIcon)object2).getImageObserver());
        } else {
            int n2 = 0;
            n = 0;
            try {
                String string2 = element.getAttribute("width");
                object = element.getAttribute("height");
                n2 = Integer.parseInt(string2);
                n = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CreationException("Image witdth or height error");
            }
            if (n2 < 1 | n < 1) {
                throw new CreationException("Image witdth or height unspecified");
            }
            bufferedImage = new BufferedImage(n2, n, 1);
            graphics2D = bufferedImage.createGraphics();
            int n3 = 0;
            try {
                object = element.getAttribute("bgcolor");
                n3 = Integer.parseInt((String)object, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CreationException("Background color error");
            }
            object = new Color(n3);
            graphics2D.setBackground((Color)object);
            graphics2D.clearRect(0, 0, n2, n);
            String string3 = element.getAttribute("background");
            if (string3.length() > 0) {
                ImageIcon imageIcon = new ImageIcon(string3);
                if (imageIcon.getIconWidth() < 1 | imageIcon.getIconHeight() < 1) {
                    throw new CreationException("Cannot load background \"" + string + "\"");
                }
                int n4 = 0;
                int n5 = 0;
                do {
                    graphics2D.drawImage(imageIcon.getImage(), n4, n5, imageIcon.getImageObserver());
                    if ((n4 += imageIcon.getIconWidth()) <= n2) continue;
                    n4 = 0;
                    n5 += imageIcon.getIconHeight();
                } while (n5 <= n);
            }
        }
        object2 = element.getChildNodes();
        n = 0;
        while (n < object2.getLength()) {
            if (object2.item(n).getNodeType() == 1) {
                this.processElement((Element)object2.item(n), bufferedImage);
            }
            ++n;
        }
        JPEGEncodeParam jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
        jPEGEncodeParam.setQuality(1.0f, true);
        object = JPEGCodec.createJPEGEncoder((OutputStream)outputStream, (JPEGEncodeParam)jPEGEncodeParam);
        object.encode(bufferedImage);
        outputStream.flush();
    }

    void processElement(Element element, BufferedImage bufferedImage) throws CreationException {
        int n;
        if (element == null) {
            return;
        }
        int n2 = 0;
        int n3 = 1;
        int n4 = 2;
        int n5 = 3;
        int n6 = bufferedImage.getWidth();
        int n7 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n6, n7, 2);
        int[] nArray = new int[4];
        WritableRaster writableRaster = bufferedImage2.getRaster();
        int n8 = 0;
        while (n8 < writableRaster.getWidth()) {
            n = 10;
            while (n < writableRaster.getHeight()) {
                writableRaster.setPixel(n8, n, nArray);
                ++n;
            }
            ++n8;
        }
        n = 0;
        if (element.getTagName().equals("text")) {
            n = this.placeText(element, bufferedImage2) ? 1 : 0;
        }
        if (n == 0) {
            return;
        }
        WritableRaster writableRaster2 = bufferedImage.getRaster();
        int[] nArray2 = new int[4];
        double d = 0.0;
        double d2 = 1.0;
        int n9 = 0;
        while (n9 < writableRaster2.getWidth()) {
            int n10 = 0;
            while (n10 < writableRaster2.getHeight()) {
                writableRaster2.getPixel(n9, n10, nArray2);
                writableRaster.getPixel(n9, n10, nArray);
                if (nArray[n5] > 0) {
                    d2 = (double)nArray[n5] / 255.0;
                    d = 1.0 - d2;
                    nArray2[n2] = (int)((double)nArray2[n2] * d + (double)nArray[n2] * d2);
                    nArray2[n3] = (int)((double)nArray2[n3] * d + (double)nArray[n3] * d2);
                    nArray2[n4] = (int)((double)nArray2[n4] * d + (double)nArray[n4] * d2);
                }
                writableRaster2.setPixel(n9, n10, nArray2);
                ++n10;
            }
            ++n9;
        }
    }
}

