/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentBuilderImpl
extends DocumentBuilder {
    private boolean namespaces = false;
    private boolean validation = false;
    private DOMParser parser = null;

    private DocumentBuilderImpl() {
    }

    protected DocumentBuilderImpl(boolean bl, boolean bl2) throws ParserConfigurationException {
        this();
        DOMParser dOMParser = new DOMParser();
        try {
            dOMParser.setFeature("http://xml.org/sax/features/namespaces", bl);
        }
        catch (SAXException sAXException) {
            throw new ParserConfigurationException("Cannot set namespace awareness to " + bl);
        }
        try {
            dOMParser.setFeature("http://xml.org/sax/features/validation", bl2);
        }
        catch (SAXException sAXException) {
            throw new ParserConfigurationException("Cannot set validation to " + bl2);
        }
        this.namespaces = bl;
        this.validation = bl2;
        this.parser = dOMParser;
    }

    public boolean isNamespaceAware() {
        return this.namespaces;
    }

    public boolean isValidating() {
        return this.validation;
    }

    public Document newDocument() {
        return new DocumentImpl();
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException, IllegalArgumentException {
        if (inputSource == null) {
            throw new IllegalArgumentException();
        }
        this.parser.parse(inputSource);
        return this.parser.getDocument();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.parser.setEntityResolver(entityResolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.parser.setErrorHandler(errorHandler);
    }
}

