/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stylebook.producers;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.stylebook.AbstractComponent;
import org.apache.stylebook.CreationContext;
import org.apache.stylebook.CreationException;
import org.apache.stylebook.Producer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DirectoryProducer
extends AbstractComponent
implements Producer {
    public Document produce(CreationContext creationContext) throws CreationException, IOException {
        Document document = this.engine.getParser().create();
        Element element = document.createElement("directory");
        URL uRL = creationContext.getSourceURL().openConnection().getURL();
        if (uRL.getProtocol().equals("file")) {
            String string = uRL.getFile();
            File file = new File(string).getCanonicalFile();
            if (!file.isDirectory()) {
                throw new CreationException(String.valueOf(String.valueOf(creationContext.getSourceURL())) + " (" + file + ") is not a Directory");
            }
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                Element element2 = document.createElement("entry");
                String string2 = fileArray[n].getName();
                if (fileArray[n].isDirectory()) {
                    string2 = String.valueOf(fileArray[n].getName()) + "/";
                    element2.setAttribute("directory", "true");
                }
                element2.setAttribute("href", string2);
                element2.appendChild(document.createTextNode(string2));
                element.appendChild(element2);
                ++n;
            }
        } else if (uRL.getProtocol().equals("jar")) {
            Object object;
            URL uRL2;
            int n = uRL.getFile().indexOf(33);
            String string = uRL.getFile();
            String string3 = "";
            if (n > 0) {
                string = uRL.getFile().substring(0, n);
                string3 = uRL.getFile().substring(n + 1);
                if (string3.equals("/")) {
                    string3 = "";
                }
            }
            if (!(uRL2 = new URL(string)).getProtocol().equalsIgnoreCase("file")) {
                throw new CreationException("Cannot open zip files over " + uRL2.getProtocol() + ": protocol");
            }
            string = uRL2.getFile();
            int n2 = 0;
            while (n2 < string.length()) {
                if (string.charAt(n2) != '/') {
                    string = string.substring(n2);
                    break;
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < string3.length()) {
                if (string3.charAt(n3) != '/') {
                    string3 = string3.substring(n3);
                    break;
                }
                ++n3;
            }
            ZipFile zipFile = new ZipFile(string);
            if (string3.length() > 0) {
                object = zipFile.getEntry(string3);
                if (object == null) {
                    throw new CreationException("Cannot find \"" + string3 + "\" in \"" + string + "\"");
                }
                if (!((ZipEntry)object).isDirectory()) {
                    throw new CreationException("Entry \"" + string3 + "\" in \"" + string + "\" is not a Directory");
                }
            }
            object = new ZipFile(string).entries();
            while (object.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)object.nextElement();
                String string4 = zipEntry.getName();
                if (!string4.startsWith(string3) || (string4 = string4.substring(string3.length())).length() == 0 || string4.indexOf(47) != -1 && string4.indexOf(47) != string4.length() - 1) continue;
                Element element3 = document.createElement("entry");
                element3.setAttribute("href", string4);
                if (zipEntry.isDirectory()) {
                    element3.setAttribute("directory", "true");
                }
                element3.appendChild(document.createTextNode(string4));
                element.appendChild(element3);
            }
        }
        document.appendChild(element);
        return document;
    }
}

