#ifndef PackageManagement__H
#define PackageManagement__H
#include "meta/meta_modelica.h"
#include "util/modelica.h"
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#ifdef __cplusplus
extern "C" {
#endif

extern struct record_description ErrorTypes_Message_MESSAGE__desc;

extern struct record_description ErrorTypes_MessageType_SCRIPTING__desc;

extern struct record_description ErrorTypes_MessageType_TRANSLATION__desc;

extern struct record_description ErrorTypes_Severity_ERROR__desc;

extern struct record_description ErrorTypes_Severity_NOTIFICATION__desc;

extern struct record_description ErrorTypes_Severity_WARNING__desc;

extern struct record_description Gettext_TranslatableContent_gettext__desc;

extern struct record_description JSON_FALSE__desc;

extern struct record_description PackageManagement_AvailableLibraries_Tree_EMPTY__desc;

extern struct record_description PackageManagement_AvailableLibraries_Tree_LEAF__desc;

extern struct record_description PackageManagement_AvailableLibraries_Tree_NODE__desc;

extern struct record_description PackageManagement_PackageInstallInfo_PKG__INSTALL__INFO__desc;

extern struct record_description PackageManagement_VersionMap_Tree_EMPTY__desc;

extern struct record_description PackageManagement_VersionMap_Tree_LEAF__desc;

extern struct record_description PackageManagement_VersionMap_Tree_NODE__desc;

extern struct record_description SourceInfo_SOURCEINFO__desc;


#define boxptr_PackageManagement_makeSourceInfo omc_PackageManagement_makeSourceInfo


#define boxptr_PackageManagement_getInstallationCachePath omc_PackageManagement_getInstallationCachePath


#define boxptr_PackageManagement_getInstallationIndexPath omc_PackageManagement_getInstallationIndexPath


DLLDirection
modelica_string omc_PackageManagement_getCachePath(threadData_t *threadData);
#define boxptr_PackageManagement_getCachePath omc_PackageManagement_getCachePath
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_getCachePath,2,0) {(void*) boxptr_PackageManagement_getCachePath,0}};
#define boxvar_PackageManagement_getCachePath MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_getCachePath)


#define boxptr_PackageManagement_getIndexPath omc_PackageManagement_getIndexPath


#define boxptr_PackageManagement_getUserLibraryPath omc_PackageManagement_getUserLibraryPath


#define boxptr_PackageManagement_getMirrors omc_PackageManagement_getMirrors


#define boxptr_PackageManagement_getAllUrls omc_PackageManagement_getAllUrls


#define boxptr_PackageManagement_getShaOrZipfile omc_PackageManagement_getShaOrZipfile


DLLDirection
void omc_PackageManagement_installCachedPackages(threadData_t *threadData);
#define boxptr_PackageManagement_installCachedPackages omc_PackageManagement_installCachedPackages
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_installCachedPackages,2,0) {(void*) boxptr_PackageManagement_installCachedPackages,0}};
#define boxvar_PackageManagement_installCachedPackages MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_installCachedPackages)


DLLDirection
modelica_boolean omc_PackageManagement_installPackage(threadData_t *threadData, modelica_string _pkg, modelica_string _version, modelica_boolean _exactMatch, modelica_boolean _skipDownload);
DLLDirection
modelica_metatype boxptr_PackageManagement_installPackage(threadData_t *threadData, modelica_metatype _pkg, modelica_metatype _version, modelica_metatype _exactMatch, modelica_metatype _skipDownload);
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_installPackage,2,0) {(void*) boxptr_PackageManagement_installPackage,0}};
#define boxvar_PackageManagement_installPackage MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_installPackage)


DLLDirection
modelica_metatype omc_PackageManagement_versionsThatConvertToTheWanted(threadData_t *threadData, modelica_string _id, modelica_string _version, modelica_boolean _printError);
DLLDirection
modelica_metatype boxptr_PackageManagement_versionsThatConvertToTheWanted(threadData_t *threadData, modelica_metatype _id, modelica_metatype _version, modelica_metatype _printError);
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_versionsThatConvertToTheWanted,2,0) {(void*) boxptr_PackageManagement_versionsThatConvertToTheWanted,0}};
#define boxvar_PackageManagement_versionsThatConvertToTheWanted MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_versionsThatConvertToTheWanted)


DLLDirection
modelica_metatype omc_PackageManagement_versionsThatConvertFromTheWanted(threadData_t *threadData, modelica_string _id, modelica_string _version, modelica_boolean _printError);
DLLDirection
modelica_metatype boxptr_PackageManagement_versionsThatConvertFromTheWanted(threadData_t *threadData, modelica_metatype _id, modelica_metatype _version, modelica_metatype _printError);
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_versionsThatConvertFromTheWanted,2,0) {(void*) boxptr_PackageManagement_versionsThatConvertFromTheWanted,0}};
#define boxvar_PackageManagement_versionsThatConvertFromTheWanted MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_versionsThatConvertFromTheWanted)


DLLDirection
modelica_metatype omc_PackageManagement_versionsThatProvideTheWanted(threadData_t *threadData, modelica_string _id, modelica_string _version, modelica_boolean _printError);
DLLDirection
modelica_metatype boxptr_PackageManagement_versionsThatProvideTheWanted(threadData_t *threadData, modelica_metatype _id, modelica_metatype _version, modelica_metatype _printError);
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_versionsThatProvideTheWanted,2,0) {(void*) boxptr_PackageManagement_versionsThatProvideTheWanted,0}};
#define boxvar_PackageManagement_versionsThatProvideTheWanted MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_versionsThatProvideTheWanted)


DLLDirection
modelica_metatype omc_PackageManagement_getAllProvidedVersionsForLibrary(threadData_t *threadData, modelica_string _lib, modelica_boolean _printError);
DLLDirection
modelica_metatype boxptr_PackageManagement_getAllProvidedVersionsForLibrary(threadData_t *threadData, modelica_metatype _lib, modelica_metatype _printError);
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_getAllProvidedVersionsForLibrary,2,0) {(void*) boxptr_PackageManagement_getAllProvidedVersionsForLibrary,0}};
#define boxvar_PackageManagement_getAllProvidedVersionsForLibrary MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_getAllProvidedVersionsForLibrary)


DLLDirection
modelica_metatype omc_PackageManagement_getPackageIndex(threadData_t *threadData, modelica_boolean _printError);
DLLDirection
modelica_metatype boxptr_PackageManagement_getPackageIndex(threadData_t *threadData, modelica_metatype _printError);
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_getPackageIndex,2,0) {(void*) boxptr_PackageManagement_getPackageIndex,0}};
#define boxvar_PackageManagement_getPackageIndex MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_getPackageIndex)


DLLDirection
modelica_boolean omc_PackageManagement_upgradeInstalledPackages(threadData_t *threadData, modelica_boolean _installNewestVersions);
DLLDirection
modelica_metatype boxptr_PackageManagement_upgradeInstalledPackages(threadData_t *threadData, modelica_metatype _installNewestVersions);
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_upgradeInstalledPackages,2,0) {(void*) boxptr_PackageManagement_upgradeInstalledPackages,0}};
#define boxvar_PackageManagement_upgradeInstalledPackages MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_upgradeInstalledPackages)


DLLDirection
modelica_boolean omc_PackageManagement_updateIndex(threadData_t *threadData);
DLLDirection
modelica_metatype boxptr_PackageManagement_updateIndex(threadData_t *threadData);
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_updateIndex,2,0) {(void*) boxptr_PackageManagement_updateIndex,0}};
#define boxvar_PackageManagement_updateIndex MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_updateIndex)


DLLDirection
modelica_boolean omc_PackageManagement_compareVersionsAndSupportLevel(threadData_t *threadData, modelica_metatype _x1, modelica_metatype _x2);
DLLDirection
modelica_metatype boxptr_PackageManagement_compareVersionsAndSupportLevel(threadData_t *threadData, modelica_metatype _x1, modelica_metatype _x2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_compareVersionsAndSupportLevel,2,0) {(void*) boxptr_PackageManagement_compareVersionsAndSupportLevel,0}};
#define boxvar_PackageManagement_compareVersionsAndSupportLevel MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_compareVersionsAndSupportLevel)


DLLDirection
modelica_integer omc_PackageManagement_getSupportLevel(threadData_t *threadData, modelica_metatype _obj);
DLLDirection
modelica_metatype boxptr_PackageManagement_getSupportLevel(threadData_t *threadData, modelica_metatype _obj);
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_getSupportLevel,2,0) {(void*) boxptr_PackageManagement_getSupportLevel,0}};
#define boxvar_PackageManagement_getSupportLevel MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_getSupportLevel)


DLLDirection
modelica_boolean omc_PackageManagement_providesExpectedVersion(threadData_t *threadData, modelica_string _version, modelica_metatype _provides, modelica_metatype _wantedVersion);
DLLDirection
modelica_metatype boxptr_PackageManagement_providesExpectedVersion(threadData_t *threadData, modelica_metatype _version, modelica_metatype _provides, modelica_metatype _wantedVersion);
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_providesExpectedVersion,2,0) {(void*) boxptr_PackageManagement_providesExpectedVersion,0}};
#define boxvar_PackageManagement_providesExpectedVersion MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_providesExpectedVersion)


DLLDirection
modelica_metatype omc_PackageManagement_getLibrarySubdirectories(threadData_t *threadData, modelica_string _inPath);
#define boxptr_PackageManagement_getLibrarySubdirectories omc_PackageManagement_getLibrarySubdirectories
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_getLibrarySubdirectories,2,0) {(void*) boxptr_PackageManagement_getLibrarySubdirectories,0}};
#define boxvar_PackageManagement_getLibrarySubdirectories MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_getLibrarySubdirectories)


DLLDirection
modelica_metatype omc_PackageManagement_getInstalledLibraryVersions(threadData_t *threadData, modelica_string _libraryName);
#define boxptr_PackageManagement_getInstalledLibraryVersions omc_PackageManagement_getInstalledLibraryVersions
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_getInstalledLibraryVersions,2,0) {(void*) boxptr_PackageManagement_getInstalledLibraryVersions,0}};
#define boxvar_PackageManagement_getInstalledLibraryVersions MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_getInstalledLibraryVersions)


DLLDirection
modelica_metatype omc_PackageManagement_getInstalledLibraries(threadData_t *threadData);
#define boxptr_PackageManagement_getInstalledLibraries omc_PackageManagement_getInstalledLibraries
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_getInstalledLibraries,2,0) {(void*) boxptr_PackageManagement_getInstalledLibraries,0}};
#define boxvar_PackageManagement_getInstalledLibraries MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_getInstalledLibraries)


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_add(threadData_t *threadData, modelica_metatype _inTree, modelica_metatype _inKey, modelica_string _inValue, modelica_fnptr _conflictFunc);
#define boxptr_PackageManagement_VersionMap_add omc_PackageManagement_VersionMap_add
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_add,2,0) {(void*) boxptr_PackageManagement_VersionMap_add,0}};
#define boxvar_PackageManagement_VersionMap_add MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_add)


DLLDirection
modelica_string omc_PackageManagement_VersionMap_addConflictDefault(threadData_t *threadData, modelica_string _newValue, modelica_string _oldValue, modelica_metatype _key);
#define boxptr_PackageManagement_VersionMap_addConflictDefault omc_PackageManagement_VersionMap_addConflictDefault
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_addConflictDefault,2,0) {(void*) boxptr_PackageManagement_VersionMap_addConflictDefault,0}};
#define boxvar_PackageManagement_VersionMap_addConflictDefault MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_addConflictDefault)


DLLDirection
modelica_string omc_PackageManagement_VersionMap_addConflictFail(threadData_t *threadData, modelica_string _newValue, modelica_string _oldValue, modelica_metatype _key);
#define boxptr_PackageManagement_VersionMap_addConflictFail omc_PackageManagement_VersionMap_addConflictFail
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_addConflictFail,2,0) {(void*) boxptr_PackageManagement_VersionMap_addConflictFail,0}};
#define boxvar_PackageManagement_VersionMap_addConflictFail MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_addConflictFail)


DLLDirection
modelica_string omc_PackageManagement_VersionMap_addConflictKeep(threadData_t *threadData, modelica_string _newValue, modelica_string _oldValue, modelica_metatype _key);
#define boxptr_PackageManagement_VersionMap_addConflictKeep omc_PackageManagement_VersionMap_addConflictKeep
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_addConflictKeep,2,0) {(void*) boxptr_PackageManagement_VersionMap_addConflictKeep,0}};
#define boxvar_PackageManagement_VersionMap_addConflictKeep MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_addConflictKeep)


DLLDirection
modelica_string omc_PackageManagement_VersionMap_addConflictReplace(threadData_t *threadData, modelica_string _newValue, modelica_string _oldValue, modelica_metatype _key);
#define boxptr_PackageManagement_VersionMap_addConflictReplace omc_PackageManagement_VersionMap_addConflictReplace
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_addConflictReplace,2,0) {(void*) boxptr_PackageManagement_VersionMap_addConflictReplace,0}};
#define boxvar_PackageManagement_VersionMap_addConflictReplace MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_addConflictReplace)


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_addList(threadData_t *threadData, modelica_metatype __omcQ_24in_5Ftree, modelica_metatype _inValues, modelica_fnptr _conflictFunc);
#define boxptr_PackageManagement_VersionMap_addList omc_PackageManagement_VersionMap_addList
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_addList,2,0) {(void*) boxptr_PackageManagement_VersionMap_addList,0}};
#define boxvar_PackageManagement_VersionMap_addList MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_addList)


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_addUpdate(threadData_t *threadData, modelica_metatype __omcQ_24in_5Ftree, modelica_metatype _key, modelica_fnptr _fn);
#define boxptr_PackageManagement_VersionMap_addUpdate omc_PackageManagement_VersionMap_addUpdate
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_addUpdate,2,0) {(void*) boxptr_PackageManagement_VersionMap_addUpdate,0}};
#define boxvar_PackageManagement_VersionMap_addUpdate MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_addUpdate)


#define boxptr_PackageManagement_VersionMap_balance omc_PackageManagement_VersionMap_balance


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_fold(threadData_t *threadData, modelica_metatype _inTree, modelica_fnptr _inFunc, modelica_metatype _inStartValue);
#define boxptr_PackageManagement_VersionMap_fold omc_PackageManagement_VersionMap_fold
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_fold,2,0) {(void*) boxptr_PackageManagement_VersionMap_fold,0}};
#define boxvar_PackageManagement_VersionMap_fold MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_fold)


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_foldCond(threadData_t *threadData, modelica_metatype _tree, modelica_fnptr _foldFunc, modelica_metatype __omcQ_24in_5Fvalue);
#define boxptr_PackageManagement_VersionMap_foldCond omc_PackageManagement_VersionMap_foldCond
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_foldCond,2,0) {(void*) boxptr_PackageManagement_VersionMap_foldCond,0}};
#define boxvar_PackageManagement_VersionMap_foldCond MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_foldCond)


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_fold__2(threadData_t *threadData, modelica_metatype _tree, modelica_fnptr _foldFunc, modelica_metatype __omcQ_24in_5FfoldArg1, modelica_metatype __omcQ_24in_5FfoldArg2, modelica_metatype *out_foldArg2);
#define boxptr_PackageManagement_VersionMap_fold__2 omc_PackageManagement_VersionMap_fold__2
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_fold__2,2,0) {(void*) boxptr_PackageManagement_VersionMap_fold__2,0}};
#define boxvar_PackageManagement_VersionMap_fold__2 MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_fold__2)


DLLDirection
void omc_PackageManagement_VersionMap_forEach(threadData_t *threadData, modelica_metatype _tree, modelica_fnptr _func);
#define boxptr_PackageManagement_VersionMap_forEach omc_PackageManagement_VersionMap_forEach
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_forEach,2,0) {(void*) boxptr_PackageManagement_VersionMap_forEach,0}};
#define boxvar_PackageManagement_VersionMap_forEach MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_forEach)


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_fromList(threadData_t *threadData, modelica_metatype _inValues, modelica_fnptr _conflictFunc);
#define boxptr_PackageManagement_VersionMap_fromList omc_PackageManagement_VersionMap_fromList
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_fromList,2,0) {(void*) boxptr_PackageManagement_VersionMap_fromList,0}};
#define boxvar_PackageManagement_VersionMap_fromList MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_fromList)


DLLDirection
modelica_string omc_PackageManagement_VersionMap_get(threadData_t *threadData, modelica_metatype _tree, modelica_metatype _key);
#define boxptr_PackageManagement_VersionMap_get omc_PackageManagement_VersionMap_get
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_get,2,0) {(void*) boxptr_PackageManagement_VersionMap_get,0}};
#define boxvar_PackageManagement_VersionMap_get MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_get)


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_getOpt(threadData_t *threadData, modelica_metatype _tree, modelica_metatype _key);
#define boxptr_PackageManagement_VersionMap_getOpt omc_PackageManagement_VersionMap_getOpt
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_getOpt,2,0) {(void*) boxptr_PackageManagement_VersionMap_getOpt,0}};
#define boxvar_PackageManagement_VersionMap_getOpt MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_getOpt)


DLLDirection
modelica_boolean omc_PackageManagement_VersionMap_hasKey(threadData_t *threadData, modelica_metatype _inTree, modelica_metatype _inKey);
DLLDirection
modelica_metatype boxptr_PackageManagement_VersionMap_hasKey(threadData_t *threadData, modelica_metatype _inTree, modelica_metatype _inKey);
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_hasKey,2,0) {(void*) boxptr_PackageManagement_VersionMap_hasKey,0}};
#define boxvar_PackageManagement_VersionMap_hasKey MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_hasKey)


DLLDirection
void omc_PackageManagement_VersionMap_intersection(threadData_t *threadData);
#define boxptr_PackageManagement_VersionMap_intersection omc_PackageManagement_VersionMap_intersection
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_intersection,2,0) {(void*) boxptr_PackageManagement_VersionMap_intersection,0}};
#define boxvar_PackageManagement_VersionMap_intersection MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_intersection)


DLLDirection
modelica_boolean omc_PackageManagement_VersionMap_isEmpty(threadData_t *threadData, modelica_metatype _tree);
DLLDirection
modelica_metatype boxptr_PackageManagement_VersionMap_isEmpty(threadData_t *threadData, modelica_metatype _tree);
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_isEmpty,2,0) {(void*) boxptr_PackageManagement_VersionMap_isEmpty,0}};
#define boxvar_PackageManagement_VersionMap_isEmpty MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_isEmpty)


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_join(threadData_t *threadData, modelica_metatype __omcQ_24in_5Ftree, modelica_metatype _treeToJoin, modelica_fnptr _conflictFunc);
#define boxptr_PackageManagement_VersionMap_join omc_PackageManagement_VersionMap_join
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_join,2,0) {(void*) boxptr_PackageManagement_VersionMap_join,0}};
#define boxvar_PackageManagement_VersionMap_join MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_join)


DLLDirection
modelica_integer omc_PackageManagement_VersionMap_keyCompare(threadData_t *threadData, modelica_metatype _inKey1, modelica_metatype _inKey2);
DLLDirection
modelica_metatype boxptr_PackageManagement_VersionMap_keyCompare(threadData_t *threadData, modelica_metatype _inKey1, modelica_metatype _inKey2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_keyCompare,2,0) {(void*) boxptr_PackageManagement_VersionMap_keyCompare,0}};
#define boxvar_PackageManagement_VersionMap_keyCompare MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_keyCompare)


DLLDirection
modelica_string omc_PackageManagement_VersionMap_keyStr(threadData_t *threadData, modelica_metatype _inKey);
#define boxptr_PackageManagement_VersionMap_keyStr omc_PackageManagement_VersionMap_keyStr
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_keyStr,2,0) {(void*) boxptr_PackageManagement_VersionMap_keyStr,0}};
#define boxvar_PackageManagement_VersionMap_keyStr MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_keyStr)


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_listKeys(threadData_t *threadData, modelica_metatype _tree, modelica_metatype __omcQ_24in_5Flst);
#define boxptr_PackageManagement_VersionMap_listKeys omc_PackageManagement_VersionMap_listKeys
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_listKeys,2,0) {(void*) boxptr_PackageManagement_VersionMap_listKeys,0}};
#define boxvar_PackageManagement_VersionMap_listKeys MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_listKeys)


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_listKeysReverse(threadData_t *threadData, modelica_metatype _inTree, modelica_metatype __omcQ_24in_5Flst);
#define boxptr_PackageManagement_VersionMap_listKeysReverse omc_PackageManagement_VersionMap_listKeysReverse
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_listKeysReverse,2,0) {(void*) boxptr_PackageManagement_VersionMap_listKeysReverse,0}};
#define boxvar_PackageManagement_VersionMap_listKeysReverse MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_listKeysReverse)


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_listValues(threadData_t *threadData, modelica_metatype _tree, modelica_metatype __omcQ_24in_5Flst);
#define boxptr_PackageManagement_VersionMap_listValues omc_PackageManagement_VersionMap_listValues
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_listValues,2,0) {(void*) boxptr_PackageManagement_VersionMap_listValues,0}};
#define boxvar_PackageManagement_VersionMap_listValues MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_listValues)


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_map(threadData_t *threadData, modelica_metatype _inTree, modelica_fnptr _inFunc);
#define boxptr_PackageManagement_VersionMap_map omc_PackageManagement_VersionMap_map
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_map,2,0) {(void*) boxptr_PackageManagement_VersionMap_map,0}};
#define boxvar_PackageManagement_VersionMap_map MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_map)


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_mapFold(threadData_t *threadData, modelica_metatype _inTree, modelica_fnptr _inFunc, modelica_metatype _inStartValue, modelica_metatype *out_outResult);
#define boxptr_PackageManagement_VersionMap_mapFold omc_PackageManagement_VersionMap_mapFold
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_mapFold,2,0) {(void*) boxptr_PackageManagement_VersionMap_mapFold,0}};
#define boxvar_PackageManagement_VersionMap_mapFold MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_mapFold)


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_new(threadData_t *threadData);
#define boxptr_PackageManagement_VersionMap_new omc_PackageManagement_VersionMap_new
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_new,2,0) {(void*) boxptr_PackageManagement_VersionMap_new,0}};
#define boxvar_PackageManagement_VersionMap_new MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_new)


DLLDirection
modelica_string omc_PackageManagement_VersionMap_printNodeStr(threadData_t *threadData, modelica_metatype _inNode);
#define boxptr_PackageManagement_VersionMap_printNodeStr omc_PackageManagement_VersionMap_printNodeStr
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_printNodeStr,2,0) {(void*) boxptr_PackageManagement_VersionMap_printNodeStr,0}};
#define boxvar_PackageManagement_VersionMap_printNodeStr MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_printNodeStr)


DLLDirection
modelica_string omc_PackageManagement_VersionMap_printTreeStr(threadData_t *threadData, modelica_metatype _inTree);
#define boxptr_PackageManagement_VersionMap_printTreeStr omc_PackageManagement_VersionMap_printTreeStr
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_printTreeStr,2,0) {(void*) boxptr_PackageManagement_VersionMap_printTreeStr,0}};
#define boxvar_PackageManagement_VersionMap_printTreeStr MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_printTreeStr)


#define boxptr_PackageManagement_VersionMap_rotateLeft omc_PackageManagement_VersionMap_rotateLeft


#define boxptr_PackageManagement_VersionMap_rotateRight omc_PackageManagement_VersionMap_rotateRight


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_setTreeLeftRight(threadData_t *threadData, modelica_metatype _orig, modelica_metatype _left, modelica_metatype _right);
#define boxptr_PackageManagement_VersionMap_setTreeLeftRight omc_PackageManagement_VersionMap_setTreeLeftRight
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_setTreeLeftRight,2,0) {(void*) boxptr_PackageManagement_VersionMap_setTreeLeftRight,0}};
#define boxvar_PackageManagement_VersionMap_setTreeLeftRight MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_setTreeLeftRight)


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_smallestKey(threadData_t *threadData, modelica_metatype _tree);
#define boxptr_PackageManagement_VersionMap_smallestKey omc_PackageManagement_VersionMap_smallestKey
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_smallestKey,2,0) {(void*) boxptr_PackageManagement_VersionMap_smallestKey,0}};
#define boxvar_PackageManagement_VersionMap_smallestKey MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_smallestKey)


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_toList(threadData_t *threadData, modelica_metatype _inTree, modelica_metatype __omcQ_24in_5Flst);
#define boxptr_PackageManagement_VersionMap_toList omc_PackageManagement_VersionMap_toList
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_toList,2,0) {(void*) boxptr_PackageManagement_VersionMap_toList,0}};
#define boxvar_PackageManagement_VersionMap_toList MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_toList)


DLLDirection
modelica_metatype omc_PackageManagement_VersionMap_update(threadData_t *threadData, modelica_metatype _tree, modelica_metatype _key, modelica_string _value);
#define boxptr_PackageManagement_VersionMap_update omc_PackageManagement_VersionMap_update
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_update,2,0) {(void*) boxptr_PackageManagement_VersionMap_update,0}};
#define boxvar_PackageManagement_VersionMap_update MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_update)


DLLDirection
modelica_string omc_PackageManagement_VersionMap_valueStr(threadData_t *threadData, modelica_string _inValue);
#define boxptr_PackageManagement_VersionMap_valueStr omc_PackageManagement_VersionMap_valueStr
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_valueStr,2,0) {(void*) boxptr_PackageManagement_VersionMap_valueStr,0}};
#define boxvar_PackageManagement_VersionMap_valueStr MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_VersionMap_valueStr)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_add(threadData_t *threadData, modelica_metatype _inTree, modelica_string _inKey, modelica_metatype _inValue, modelica_fnptr _conflictFunc);
#define boxptr_PackageManagement_AvailableLibraries_add omc_PackageManagement_AvailableLibraries_add
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_add,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_add,0}};
#define boxvar_PackageManagement_AvailableLibraries_add MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_add)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_addConflictDefault(threadData_t *threadData, modelica_metatype _newValue, modelica_metatype _oldValue, modelica_string _key);
#define boxptr_PackageManagement_AvailableLibraries_addConflictDefault omc_PackageManagement_AvailableLibraries_addConflictDefault
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_addConflictDefault,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_addConflictDefault,0}};
#define boxvar_PackageManagement_AvailableLibraries_addConflictDefault MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_addConflictDefault)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_addConflictFail(threadData_t *threadData, modelica_metatype _newValue, modelica_metatype _oldValue, modelica_string _key);
#define boxptr_PackageManagement_AvailableLibraries_addConflictFail omc_PackageManagement_AvailableLibraries_addConflictFail
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_addConflictFail,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_addConflictFail,0}};
#define boxvar_PackageManagement_AvailableLibraries_addConflictFail MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_addConflictFail)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_addConflictKeep(threadData_t *threadData, modelica_metatype _newValue, modelica_metatype _oldValue, modelica_string _key);
#define boxptr_PackageManagement_AvailableLibraries_addConflictKeep omc_PackageManagement_AvailableLibraries_addConflictKeep
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_addConflictKeep,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_addConflictKeep,0}};
#define boxvar_PackageManagement_AvailableLibraries_addConflictKeep MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_addConflictKeep)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_addConflictReplace(threadData_t *threadData, modelica_metatype _newValue, modelica_metatype _oldValue, modelica_string _key);
#define boxptr_PackageManagement_AvailableLibraries_addConflictReplace omc_PackageManagement_AvailableLibraries_addConflictReplace
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_addConflictReplace,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_addConflictReplace,0}};
#define boxvar_PackageManagement_AvailableLibraries_addConflictReplace MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_addConflictReplace)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_addList(threadData_t *threadData, modelica_metatype __omcQ_24in_5Ftree, modelica_metatype _inValues, modelica_fnptr _conflictFunc);
#define boxptr_PackageManagement_AvailableLibraries_addList omc_PackageManagement_AvailableLibraries_addList
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_addList,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_addList,0}};
#define boxvar_PackageManagement_AvailableLibraries_addList MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_addList)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_addUpdate(threadData_t *threadData, modelica_metatype __omcQ_24in_5Ftree, modelica_string _key, modelica_fnptr _fn);
#define boxptr_PackageManagement_AvailableLibraries_addUpdate omc_PackageManagement_AvailableLibraries_addUpdate
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_addUpdate,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_addUpdate,0}};
#define boxvar_PackageManagement_AvailableLibraries_addUpdate MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_addUpdate)


#define boxptr_PackageManagement_AvailableLibraries_balance omc_PackageManagement_AvailableLibraries_balance


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_fold(threadData_t *threadData, modelica_metatype _inTree, modelica_fnptr _inFunc, modelica_metatype _inStartValue);
#define boxptr_PackageManagement_AvailableLibraries_fold omc_PackageManagement_AvailableLibraries_fold
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_fold,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_fold,0}};
#define boxvar_PackageManagement_AvailableLibraries_fold MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_fold)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_foldCond(threadData_t *threadData, modelica_metatype _tree, modelica_fnptr _foldFunc, modelica_metatype __omcQ_24in_5Fvalue);
#define boxptr_PackageManagement_AvailableLibraries_foldCond omc_PackageManagement_AvailableLibraries_foldCond
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_foldCond,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_foldCond,0}};
#define boxvar_PackageManagement_AvailableLibraries_foldCond MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_foldCond)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_fold__2(threadData_t *threadData, modelica_metatype _tree, modelica_fnptr _foldFunc, modelica_metatype __omcQ_24in_5FfoldArg1, modelica_metatype __omcQ_24in_5FfoldArg2, modelica_metatype *out_foldArg2);
#define boxptr_PackageManagement_AvailableLibraries_fold__2 omc_PackageManagement_AvailableLibraries_fold__2
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_fold__2,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_fold__2,0}};
#define boxvar_PackageManagement_AvailableLibraries_fold__2 MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_fold__2)


DLLDirection
void omc_PackageManagement_AvailableLibraries_forEach(threadData_t *threadData, modelica_metatype _tree, modelica_fnptr _func);
#define boxptr_PackageManagement_AvailableLibraries_forEach omc_PackageManagement_AvailableLibraries_forEach
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_forEach,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_forEach,0}};
#define boxvar_PackageManagement_AvailableLibraries_forEach MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_forEach)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_fromList(threadData_t *threadData, modelica_metatype _inValues, modelica_fnptr _conflictFunc);
#define boxptr_PackageManagement_AvailableLibraries_fromList omc_PackageManagement_AvailableLibraries_fromList
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_fromList,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_fromList,0}};
#define boxvar_PackageManagement_AvailableLibraries_fromList MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_fromList)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_get(threadData_t *threadData, modelica_metatype _tree, modelica_string _key);
#define boxptr_PackageManagement_AvailableLibraries_get omc_PackageManagement_AvailableLibraries_get
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_get,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_get,0}};
#define boxvar_PackageManagement_AvailableLibraries_get MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_get)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_getOpt(threadData_t *threadData, modelica_metatype _tree, modelica_string _key);
#define boxptr_PackageManagement_AvailableLibraries_getOpt omc_PackageManagement_AvailableLibraries_getOpt
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_getOpt,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_getOpt,0}};
#define boxvar_PackageManagement_AvailableLibraries_getOpt MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_getOpt)


DLLDirection
modelica_boolean omc_PackageManagement_AvailableLibraries_hasKey(threadData_t *threadData, modelica_metatype _inTree, modelica_string _inKey);
DLLDirection
modelica_metatype boxptr_PackageManagement_AvailableLibraries_hasKey(threadData_t *threadData, modelica_metatype _inTree, modelica_metatype _inKey);
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_hasKey,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_hasKey,0}};
#define boxvar_PackageManagement_AvailableLibraries_hasKey MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_hasKey)


DLLDirection
void omc_PackageManagement_AvailableLibraries_intersection(threadData_t *threadData);
#define boxptr_PackageManagement_AvailableLibraries_intersection omc_PackageManagement_AvailableLibraries_intersection
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_intersection,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_intersection,0}};
#define boxvar_PackageManagement_AvailableLibraries_intersection MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_intersection)


DLLDirection
modelica_boolean omc_PackageManagement_AvailableLibraries_isEmpty(threadData_t *threadData, modelica_metatype _tree);
DLLDirection
modelica_metatype boxptr_PackageManagement_AvailableLibraries_isEmpty(threadData_t *threadData, modelica_metatype _tree);
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_isEmpty,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_isEmpty,0}};
#define boxvar_PackageManagement_AvailableLibraries_isEmpty MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_isEmpty)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_join(threadData_t *threadData, modelica_metatype __omcQ_24in_5Ftree, modelica_metatype _treeToJoin, modelica_fnptr _conflictFunc);
#define boxptr_PackageManagement_AvailableLibraries_join omc_PackageManagement_AvailableLibraries_join
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_join,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_join,0}};
#define boxvar_PackageManagement_AvailableLibraries_join MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_join)


DLLDirection
modelica_integer omc_PackageManagement_AvailableLibraries_keyCompare(threadData_t *threadData, modelica_string _inKey1, modelica_string _inKey2);
DLLDirection
modelica_metatype boxptr_PackageManagement_AvailableLibraries_keyCompare(threadData_t *threadData, modelica_metatype _inKey1, modelica_metatype _inKey2);
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_keyCompare,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_keyCompare,0}};
#define boxvar_PackageManagement_AvailableLibraries_keyCompare MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_keyCompare)


DLLDirection
modelica_string omc_PackageManagement_AvailableLibraries_keyStr(threadData_t *threadData, modelica_string _inKey);
#define boxptr_PackageManagement_AvailableLibraries_keyStr omc_PackageManagement_AvailableLibraries_keyStr
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_keyStr,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_keyStr,0}};
#define boxvar_PackageManagement_AvailableLibraries_keyStr MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_keyStr)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_listKeys(threadData_t *threadData, modelica_metatype _tree, modelica_metatype __omcQ_24in_5Flst);
#define boxptr_PackageManagement_AvailableLibraries_listKeys omc_PackageManagement_AvailableLibraries_listKeys
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_listKeys,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_listKeys,0}};
#define boxvar_PackageManagement_AvailableLibraries_listKeys MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_listKeys)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_listKeysReverse(threadData_t *threadData, modelica_metatype _inTree, modelica_metatype __omcQ_24in_5Flst);
#define boxptr_PackageManagement_AvailableLibraries_listKeysReverse omc_PackageManagement_AvailableLibraries_listKeysReverse
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_listKeysReverse,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_listKeysReverse,0}};
#define boxvar_PackageManagement_AvailableLibraries_listKeysReverse MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_listKeysReverse)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_listValues(threadData_t *threadData, modelica_metatype _tree, modelica_metatype __omcQ_24in_5Flst);
#define boxptr_PackageManagement_AvailableLibraries_listValues omc_PackageManagement_AvailableLibraries_listValues
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_listValues,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_listValues,0}};
#define boxvar_PackageManagement_AvailableLibraries_listValues MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_listValues)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_map(threadData_t *threadData, modelica_metatype _inTree, modelica_fnptr _inFunc);
#define boxptr_PackageManagement_AvailableLibraries_map omc_PackageManagement_AvailableLibraries_map
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_map,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_map,0}};
#define boxvar_PackageManagement_AvailableLibraries_map MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_map)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_mapFold(threadData_t *threadData, modelica_metatype _inTree, modelica_fnptr _inFunc, modelica_metatype _inStartValue, modelica_metatype *out_outResult);
#define boxptr_PackageManagement_AvailableLibraries_mapFold omc_PackageManagement_AvailableLibraries_mapFold
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_mapFold,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_mapFold,0}};
#define boxvar_PackageManagement_AvailableLibraries_mapFold MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_mapFold)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_new(threadData_t *threadData);
#define boxptr_PackageManagement_AvailableLibraries_new omc_PackageManagement_AvailableLibraries_new
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_new,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_new,0}};
#define boxvar_PackageManagement_AvailableLibraries_new MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_new)


DLLDirection
modelica_string omc_PackageManagement_AvailableLibraries_printNodeStr(threadData_t *threadData, modelica_metatype _inNode);
#define boxptr_PackageManagement_AvailableLibraries_printNodeStr omc_PackageManagement_AvailableLibraries_printNodeStr
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_printNodeStr,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_printNodeStr,0}};
#define boxvar_PackageManagement_AvailableLibraries_printNodeStr MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_printNodeStr)


DLLDirection
modelica_string omc_PackageManagement_AvailableLibraries_printTreeStr(threadData_t *threadData, modelica_metatype _inTree);
#define boxptr_PackageManagement_AvailableLibraries_printTreeStr omc_PackageManagement_AvailableLibraries_printTreeStr
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_printTreeStr,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_printTreeStr,0}};
#define boxvar_PackageManagement_AvailableLibraries_printTreeStr MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_printTreeStr)


#define boxptr_PackageManagement_AvailableLibraries_rotateLeft omc_PackageManagement_AvailableLibraries_rotateLeft


#define boxptr_PackageManagement_AvailableLibraries_rotateRight omc_PackageManagement_AvailableLibraries_rotateRight


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_setTreeLeftRight(threadData_t *threadData, modelica_metatype _orig, modelica_metatype _left, modelica_metatype _right);
#define boxptr_PackageManagement_AvailableLibraries_setTreeLeftRight omc_PackageManagement_AvailableLibraries_setTreeLeftRight
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_setTreeLeftRight,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_setTreeLeftRight,0}};
#define boxvar_PackageManagement_AvailableLibraries_setTreeLeftRight MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_setTreeLeftRight)


DLLDirection
modelica_string omc_PackageManagement_AvailableLibraries_smallestKey(threadData_t *threadData, modelica_metatype _tree);
#define boxptr_PackageManagement_AvailableLibraries_smallestKey omc_PackageManagement_AvailableLibraries_smallestKey
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_smallestKey,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_smallestKey,0}};
#define boxvar_PackageManagement_AvailableLibraries_smallestKey MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_smallestKey)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_toList(threadData_t *threadData, modelica_metatype _inTree, modelica_metatype __omcQ_24in_5Flst);
#define boxptr_PackageManagement_AvailableLibraries_toList omc_PackageManagement_AvailableLibraries_toList
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_toList,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_toList,0}};
#define boxvar_PackageManagement_AvailableLibraries_toList MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_toList)


DLLDirection
modelica_metatype omc_PackageManagement_AvailableLibraries_update(threadData_t *threadData, modelica_metatype _tree, modelica_string _key, modelica_metatype _value);
#define boxptr_PackageManagement_AvailableLibraries_update omc_PackageManagement_AvailableLibraries_update
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_update,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_update,0}};
#define boxvar_PackageManagement_AvailableLibraries_update MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_update)


DLLDirection
modelica_string omc_PackageManagement_AvailableLibraries_valueStr(threadData_t *threadData, modelica_metatype _inValue);
#define boxptr_PackageManagement_AvailableLibraries_valueStr omc_PackageManagement_AvailableLibraries_valueStr
static const MMC_DEFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_valueStr,2,0) {(void*) boxptr_PackageManagement_AvailableLibraries_valueStr,0}};
#define boxvar_PackageManagement_AvailableLibraries_valueStr MMC_REFSTRUCTLIT(boxvar_lit_PackageManagement_AvailableLibraries_valueStr)

#ifdef __cplusplus
}
#endif
#endif
