/*
    Copyright (c) 2007-2017 Contributors as noted in the AUTHORS file

    This file is part of libzmq, the ZeroMQ core engine in C++.

    libzmq is free software; you can redistribute it and/or modify it under
    the terms of the GNU Lesser General Public License (LGPL) as published
    by the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    As a special exception, the Contributors give you permission to link
    this library with independent modules to produce an executable,
    regardless of the license terms of these independent modules, and to
    copy and distribute the resulting executable under terms of your choice,
    provided that you also meet, for each linked independent module, the
    terms and conditions of the license of that module. An independent
    module is a module which is not derived from or based on this library.
    If you modify this library, you must extend this exception to your
    version of the library.

    libzmq is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
    License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "testutil.hpp"

int main (int, char *[])
{
    const char *bind_to = "tcp://127.0.0.1:*";
    size_t len = MAX_SOCKET_STRING;
    char my_endpoint[MAX_SOCKET_STRING];

    int rc;

    void* ctx = zmq_init (1);
    assert (ctx);

    void* s_in = zmq_socket (ctx, ZMQ_PULL);
    assert (s_in);

    int conflate = 1;
    rc = zmq_setsockopt (s_in, ZMQ_CONFLATE, &conflate, sizeof(conflate));
    assert (rc == 0);

    rc = zmq_bind (s_in, bind_to);
    assert (rc == 0);
    rc = zmq_getsockopt (s_in, ZMQ_LAST_ENDPOINT, my_endpoint, &len);
    assert (rc == 0);

    void* s_out = zmq_socket (ctx, ZMQ_PUSH);
    assert (s_out);

    rc = zmq_connect (s_out, my_endpoint);
    assert (rc == 0);

    int message_count = 20;
    for (int j = 0; j < message_count; ++j) {
        rc = zmq_send(s_out, (void*)&j, sizeof(int), 0);
        if (rc < 0) {
            printf ("error in zmq_sendmsg: %s\n", zmq_strerror (errno));
            return -1;
        }
    }
    msleep (SETTLE_TIME);

    int payload_recved = 0;
    rc = zmq_recv (s_in, (void*)&payload_recved, sizeof(int), 0);
    assert (rc > 0);
    assert (payload_recved == message_count - 1);

    rc = zmq_close (s_in);
    assert (rc == 0);

    rc = zmq_close (s_out);
    assert (rc == 0);

    rc = zmq_ctx_term (ctx);
    assert (rc == 0);

    return 0;
}
