/* $ANTLR 2.7.7 (2006-11-01): "flat_modelica_lexer.g" -> "flat_modelica_lexer.cpp"$ */
#include "flat_modelica_lexer.hpp"
#include <antlr/CharBuffer.hpp>
#include <antlr/TokenStreamException.hpp>
#include <antlr/TokenStreamIOException.hpp>
#include <antlr/TokenStreamRecognitionException.hpp>
#include <antlr/CharStreamException.hpp>
#include <antlr/CharStreamIOException.hpp>
#include <antlr/NoViableAltForCharException.hpp>

#line 1 "flat_modelica_lexer.g"
#line 13 "flat_modelica_lexer.cpp"
flat_modelica_lexer::flat_modelica_lexer(ANTLR_USE_NAMESPACE(std)istream& in)
  : ANTLR_USE_NAMESPACE(antlr)CharScanner(new ANTLR_USE_NAMESPACE(antlr)CharBuffer(in),true)
{
  initLiterals();
}

flat_modelica_lexer::flat_modelica_lexer(ANTLR_USE_NAMESPACE(antlr)InputBuffer& ib)
  : ANTLR_USE_NAMESPACE(antlr)CharScanner(ib,true)
{
  initLiterals();
}

flat_modelica_lexer::flat_modelica_lexer(const ANTLR_USE_NAMESPACE(antlr)LexerSharedInputState& state)
  : ANTLR_USE_NAMESPACE(antlr)CharScanner(state,true)
{
  initLiterals();
}

void flat_modelica_lexer::initLiterals()
{
  literals["type"] = 53;
  literals["constant"] = 12;
  literals["relation"] = 67;
  literals["public"] = 46;
  literals["initial"] = 32;
  literals["annotation"] = 6;
  literals["while"] = 56;
  literals["end"] = 18;
  literals["withtype"] = 72;
  literals["equation"] = 20;
  literals["overload"] = 39;
  literals["flow"] = 26;
  literals["then"] = 51;
  literals["unsigned_real"] = 54;
  literals["and"] = 5;
  literals["module"] = 65;
  literals["outer"] = 38;
  literals["not"] = 37;
  literals["package"] = 42;
  literals["external"] = 23;
  literals["replaceable"] = 49;
  literals["protected"] = 45;
  literals["output"] = 41;
  literals["when"] = 55;
  literals["class"] = 9;
  literals["inner"] = 33;
  literals["enumeration"] = 19;
  literals["function"] = 28;
  literals["each"] = 14;
  literals["with"] = 71;
  literals["redeclare"] = 48;
  literals["model"] = 36;
  literals["elseif"] = 16;
  literals["parameter"] = 43;
  literals["input"] = 34;
  literals["interface"] = 64;
  literals["of"] = 66;
  literals["final"] = 25;
  literals["or"] = 40;
  literals["if"] = 29;
  literals["record"] = 47;
  literals["as"] = 59;
  literals["connector"] = 11;
  literals["connect"] = 10;
  literals["results"] = 50;
  literals["for"] = 27;
  literals["extends"] = 22;
  literals["axiom"] = 60;
  literals["loop"] = 35;
  literals["rule"] = 68;
  literals["false"] = 24;
  literals["fail"] = 62;
  literals["datatype"] = 61;
  literals["val"] = 69;
  literals["elsewhen"] = 17;
  literals["Code"] = 8;
  literals["encapsulated"] = 21;
  literals["partial"] = 44;
  literals["abstype"] = 58;
  literals["else"] = 15;
  literals["import"] = 30;
  literals["discrete"] = 13;
  literals["_"] = 70;
  literals["in"] = 31;
  literals["let"] = 63;
  literals["block"] = 7;
  literals["true"] = 52;
  literals["within"] = 57;
  literals["algorithm"] = 4;
}

ANTLR_USE_NAMESPACE(antlr)RefToken flat_modelica_lexer::nextToken()
{
  ANTLR_USE_NAMESPACE(antlr)RefToken theRetToken;
  for (;;) {
    ANTLR_USE_NAMESPACE(antlr)RefToken theRetToken;
    int _ttype = ANTLR_USE_NAMESPACE(antlr)Token::INVALID_TYPE;
    resetText();
    try {   // for lexical and char stream error handling
      switch ( LA(1)) {
      case 0x28 /* '(' */ :
      {
        mLPAR(true);
        theRetToken=_returnToken;
        break;
      }
      case 0x29 /* ')' */ :
      {
        mRPAR(true);
        theRetToken=_returnToken;
        break;
      }
      case 0x5b /* '[' */ :
      {
        mLBRACK(true);
        theRetToken=_returnToken;
        break;
      }
      case 0x5d /* ']' */ :
      {
        mRBRACK(true);
        theRetToken=_returnToken;
        break;
      }
      case 0x7b /* '{' */ :
      {
        mLBRACE(true);
        theRetToken=_returnToken;
        break;
      }
      case 0x7d /* '}' */ :
      {
        mRBRACE(true);
        theRetToken=_returnToken;
        break;
      }
      case 0x2b /* '+' */ :
      {
        mPLUS(true);
        theRetToken=_returnToken;
        break;
      }
      case 0x2a /* '*' */ :
      {
        mSTAR(true);
        theRetToken=_returnToken;
        break;
      }
      case 0x2e /* '.' */ :
      {
        mDOT(true);
        theRetToken=_returnToken;
        break;
      }
      case 0x2c /* ',' */ :
      {
        mCOMMA(true);
        theRetToken=_returnToken;
        break;
      }
      case 0x3b /* ';' */ :
      {
        mSEMICOLON(true);
        theRetToken=_returnToken;
        break;
      }
      case 0x5e /* '^' */ :
      {
        mPOWER(true);
        theRetToken=_returnToken;
        break;
      }
      case 0x26 /* '&' */ :
      {
        mAMPERSAND(true);
        theRetToken=_returnToken;
        break;
      }
      case 0x7c /* '|' */ :
      {
        mPIPEBAR(true);
        theRetToken=_returnToken;
        break;
      }
      case 0x9 /* '\t' */ :
      case 0xa /* '\n' */ :
      case 0xd /* '\r' */ :
      case 0x20 /* ' ' */ :
      {
        mWS(true);
        theRetToken=_returnToken;
        break;
      }
      case 0x41 /* 'A' */ :
      case 0x42 /* 'B' */ :
      case 0x43 /* 'C' */ :
      case 0x44 /* 'D' */ :
      case 0x45 /* 'E' */ :
      case 0x46 /* 'F' */ :
      case 0x47 /* 'G' */ :
      case 0x48 /* 'H' */ :
      case 0x49 /* 'I' */ :
      case 0x4a /* 'J' */ :
      case 0x4b /* 'K' */ :
      case 0x4c /* 'L' */ :
      case 0x4d /* 'M' */ :
      case 0x4e /* 'N' */ :
      case 0x4f /* 'O' */ :
      case 0x50 /* 'P' */ :
      case 0x51 /* 'Q' */ :
      case 0x52 /* 'R' */ :
      case 0x53 /* 'S' */ :
      case 0x54 /* 'T' */ :
      case 0x55 /* 'U' */ :
      case 0x56 /* 'V' */ :
      case 0x57 /* 'W' */ :
      case 0x58 /* 'X' */ :
      case 0x59 /* 'Y' */ :
      case 0x5a /* 'Z' */ :
      case 0x5f /* '_' */ :
      case 0x61 /* 'a' */ :
      case 0x62 /* 'b' */ :
      case 0x63 /* 'c' */ :
      case 0x64 /* 'd' */ :
      case 0x65 /* 'e' */ :
      case 0x66 /* 'f' */ :
      case 0x67 /* 'g' */ :
      case 0x68 /* 'h' */ :
      case 0x69 /* 'i' */ :
      case 0x6a /* 'j' */ :
      case 0x6b /* 'k' */ :
      case 0x6c /* 'l' */ :
      case 0x6d /* 'm' */ :
      case 0x6e /* 'n' */ :
      case 0x6f /* 'o' */ :
      case 0x70 /* 'p' */ :
      case 0x71 /* 'q' */ :
      case 0x72 /* 'r' */ :
      case 0x73 /* 's' */ :
      case 0x74 /* 't' */ :
      case 0x75 /* 'u' */ :
      case 0x76 /* 'v' */ :
      case 0x77 /* 'w' */ :
      case 0x78 /* 'x' */ :
      case 0x79 /* 'y' */ :
      case 0x7a /* 'z' */ :
      {
        mIDENT(true);
        theRetToken=_returnToken;
        break;
      }
      case 0x27 /* '\'' */ :
      {
        mTYVARIDENT(true);
        theRetToken=_returnToken;
        break;
      }
      case 0x30 /* '0' */ :
      case 0x31 /* '1' */ :
      case 0x32 /* '2' */ :
      case 0x33 /* '3' */ :
      case 0x34 /* '4' */ :
      case 0x35 /* '5' */ :
      case 0x36 /* '6' */ :
      case 0x37 /* '7' */ :
      case 0x38 /* '8' */ :
      case 0x39 /* '9' */ :
      {
        mUNSIGNED_INTEGER(true);
        theRetToken=_returnToken;
        break;
      }
      case 0x22 /* '\"' */ :
      {
        mSTRING(true);
        theRetToken=_returnToken;
        break;
      }
      default:
        if ((LA(1) == 0x3a /* ':' */ ) && (LA(2) == 0x3d /* '=' */ )) {
          mASSIGN(true);
          theRetToken=_returnToken;
        }
        else if ((LA(1) == 0x3c /* '<' */ ) && (LA(2) == 0x3d /* '=' */ )) {
          mLESSEQ(true);
          theRetToken=_returnToken;
        }
        else if ((LA(1) == 0x3e /* '>' */ ) && (LA(2) == 0x3d /* '=' */ )) {
          mGREATEREQ(true);
          theRetToken=_returnToken;
        }
        else if ((LA(1) == 0x3d /* '=' */ ) && (LA(2) == 0x3d /* '=' */ )) {
          mEQEQ(true);
          theRetToken=_returnToken;
        }
        else if ((LA(1) == 0x3c /* '<' */ ) && (LA(2) == 0x3e /* '>' */ )) {
          mLESSGT(true);
          theRetToken=_returnToken;
        }
        else if ((LA(1) == 0x3d /* '=' */ ) && (LA(2) == 0x3e /* '>' */ )) {
          mYIELDS(true);
          theRetToken=_returnToken;
        }
        else if ((LA(1) == 0x3a /* ':' */ ) && (LA(2) == 0x3a /* ':' */ )) {
          mCOLONCOLON(true);
          theRetToken=_returnToken;
        }
        else if ((LA(1) == 0x2d /* '-' */ ) && (LA(2) == 0x2d /* '-' */ )) {
          mDASHES(true);
          theRetToken=_returnToken;
        }
        else if ((LA(1) == 0x2f /* '/' */ ) && (LA(2) == 0x2a /* '*' */ )) {
          mML_COMMENT(true);
          theRetToken=_returnToken;
        }
        else if ((LA(1) == 0x2f /* '/' */ ) && (LA(2) == 0x2f /* '/' */ )) {
          mSL_COMMENT(true);
          theRetToken=_returnToken;
        }
        else if ((LA(1) == 0x3d /* '=' */ ) && (true)) {
          mEQUALS(true);
          theRetToken=_returnToken;
        }
        else if ((LA(1) == 0x2d /* '-' */ ) && (true)) {
          mMINUS(true);
          theRetToken=_returnToken;
        }
        else if ((LA(1) == 0x2f /* '/' */ ) && (true)) {
          mSLASH(true);
          theRetToken=_returnToken;
        }
        else if ((LA(1) == 0x3c /* '<' */ ) && (true)) {
          mLESS(true);
          theRetToken=_returnToken;
        }
        else if ((LA(1) == 0x3e /* '>' */ ) && (true)) {
          mGREATER(true);
          theRetToken=_returnToken;
        }
        else if ((LA(1) == 0x3a /* ':' */ ) && (true)) {
          mCOLON(true);
          theRetToken=_returnToken;
        }
      else {
        if (LA(1)==EOF_CHAR)
        {
          uponEOF();
          _returnToken = makeToken(ANTLR_USE_NAMESPACE(antlr)Token::EOF_TYPE);
        }
        else {throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());}
      }
      }
      if ( !_returnToken )
        goto tryAgain; // found SKIP token

      _ttype = _returnToken->getType();
      _returnToken->setType(_ttype);
      return _returnToken;
    }
    catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& e) {
        throw ANTLR_USE_NAMESPACE(antlr)TokenStreamRecognitionException(e);
    }
    catch (ANTLR_USE_NAMESPACE(antlr)CharStreamIOException& csie) {
      throw ANTLR_USE_NAMESPACE(antlr)TokenStreamIOException(csie.io);
    }
    catch (ANTLR_USE_NAMESPACE(antlr)CharStreamException& cse) {
      throw ANTLR_USE_NAMESPACE(antlr)TokenStreamException(cse.getMessage());
    }
tryAgain:;
  }
}

void flat_modelica_lexer::mLPAR(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = LPAR;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match('(' /* charlit */ );
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mRPAR(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = RPAR;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match(')' /* charlit */ );
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mLBRACK(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = LBRACK;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match('[' /* charlit */ );
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mRBRACK(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = RBRACK;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match(']' /* charlit */ );
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mLBRACE(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = LBRACE;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match('{' /* charlit */ );
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mRBRACE(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = RBRACE;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match('}' /* charlit */ );
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mEQUALS(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = EQUALS;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match('=' /* charlit */ );
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mASSIGN(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = ASSIGN;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match(":=");
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mPLUS(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = PLUS;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match('+' /* charlit */ );
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mMINUS(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = MINUS;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match('-' /* charlit */ );
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mSTAR(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = STAR;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match('*' /* charlit */ );
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mSLASH(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = SLASH;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match('/' /* charlit */ );
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mDOT(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = DOT;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match('.' /* charlit */ );
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mCOMMA(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = COMMA;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match(',' /* charlit */ );
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mLESS(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = LESS;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match('<' /* charlit */ );
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mLESSEQ(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = LESSEQ;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match("<=");
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mGREATER(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = GREATER;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match('>' /* charlit */ );
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mGREATEREQ(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = GREATEREQ;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match(">=");
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mEQEQ(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = EQEQ;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match("==");
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mLESSGT(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = LESSGT;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match("<>");
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mCOLON(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = COLON;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match(':' /* charlit */ );
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mSEMICOLON(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = SEMICOLON;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match(';' /* charlit */ );
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mPOWER(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = POWER;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match('^' /* charlit */ );
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mYIELDS(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = YIELDS;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match("=>");
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mAMPERSAND(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = AMPERSAND;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match("&");
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mPIPEBAR(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = PIPEBAR;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match("|");
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mCOLONCOLON(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = COLONCOLON;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match("::");
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mDASHES(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = DASHES;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match('-' /* charlit */ );
  match('-' /* charlit */ );
  match('-' /* charlit */ );
  { // ( ... )*
  for (;;) {
    if ((LA(1) == 0x2d /* '-' */ )) {
      match('-' /* charlit */ );
    }
    else {
      goto _loop30;
    }

  }
  _loop30:;
  } // ( ... )*
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mWS(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = WS;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  {
  switch ( LA(1)) {
  case 0x20 /* ' ' */ :
  {
    match(' ' /* charlit */ );
    break;
  }
  case 0x9 /* '\t' */ :
  {
    match('\t' /* charlit */ );
    break;
  }
  case 0xa /* '\n' */ :
  case 0xd /* '\r' */ :
  {
    {
    if ((LA(1) == 0xd /* '\r' */ ) && (LA(2) == 0xa /* '\n' */ )) {
      match("\r\n");
    }
    else if ((LA(1) == 0xd /* '\r' */ ) && (true)) {
      match('\r' /* charlit */ );
    }
    else if ((LA(1) == 0xa /* '\n' */ )) {
      match('\n' /* charlit */ );
    }
    else {
      throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }

    }
    if ( inputState->guessing==0 ) {
#line 143 "flat_modelica_lexer.g"
      newline();
#line 830 "flat_modelica_lexer.cpp"
    }
    break;
  }
  default:
  {
    throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
  }
  }
  }
  if ( inputState->guessing==0 ) {
#line 145 "flat_modelica_lexer.g"
    _ttype = antlr::Token::SKIP;
#line 843 "flat_modelica_lexer.cpp"
  }
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mML_COMMENT(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = ML_COMMENT;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match("/*");
  { // ( ... )*
  for (;;) {
    if (((LA(1) == 0x2a /* '*' */ ) && ((LA(2) >= 0x3 /* '\3' */  && LA(2) <= 0xff)))&&(LA(2)!='/')) {
      match('*' /* charlit */ );
    }
    else if ((_tokenSet_0.member(LA(1)))) {
      mML_COMMENT_CHAR(false);
    }
    else {
      goto _loop36;
    }

  }
  _loop36:;
  } // ( ... )*
  match("*/");
  if ( inputState->guessing==0 ) {
#line 152 "flat_modelica_lexer.g"
    _ttype = antlr::Token::SKIP;
#line 878 "flat_modelica_lexer.cpp"
  }
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mML_COMMENT_CHAR(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = ML_COMMENT_CHAR;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  if ((LA(1) == 0xa /* '\n' */  || LA(1) == 0xd /* '\r' */ )) {
    {
    switch ( LA(1)) {
    case 0xd /* '\r' */ :
    {
      match("\r\n");
      break;
    }
    case 0xa /* '\n' */ :
    {
      match('\n' /* charlit */ );
      break;
    }
    default:
    {
      throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    }
    }
    if ( inputState->guessing==0 ) {
#line 156 "flat_modelica_lexer.g"
      newline();
#line 915 "flat_modelica_lexer.cpp"
    }
  }
  else if ((_tokenSet_1.member(LA(1)))) {
    {
    match(_tokenSet_1);
    }
  }
  else {
    throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
  }

  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mSL_COMMENT(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = SL_COMMENT;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match("//");
  { // ( ... )*
  for (;;) {
    if ((_tokenSet_2.member(LA(1)))) {
      {
      match(_tokenSet_2);
      }
    }
    else {
      goto _loop43;
    }

  }
  _loop43:;
  } // ( ... )*
  if ( inputState->guessing==0 ) {
#line 162 "flat_modelica_lexer.g"
    _ttype = antlr::Token::SKIP;
#line 958 "flat_modelica_lexer.cpp"
  }
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mIDENT(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = IDENT;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  mNONDIGIT(false);
  { // ( ... )*
  for (;;) {
    switch ( LA(1)) {
    case 0x41 /* 'A' */ :
    case 0x42 /* 'B' */ :
    case 0x43 /* 'C' */ :
    case 0x44 /* 'D' */ :
    case 0x45 /* 'E' */ :
    case 0x46 /* 'F' */ :
    case 0x47 /* 'G' */ :
    case 0x48 /* 'H' */ :
    case 0x49 /* 'I' */ :
    case 0x4a /* 'J' */ :
    case 0x4b /* 'K' */ :
    case 0x4c /* 'L' */ :
    case 0x4d /* 'M' */ :
    case 0x4e /* 'N' */ :
    case 0x4f /* 'O' */ :
    case 0x50 /* 'P' */ :
    case 0x51 /* 'Q' */ :
    case 0x52 /* 'R' */ :
    case 0x53 /* 'S' */ :
    case 0x54 /* 'T' */ :
    case 0x55 /* 'U' */ :
    case 0x56 /* 'V' */ :
    case 0x57 /* 'W' */ :
    case 0x58 /* 'X' */ :
    case 0x59 /* 'Y' */ :
    case 0x5a /* 'Z' */ :
    case 0x5f /* '_' */ :
    case 0x61 /* 'a' */ :
    case 0x62 /* 'b' */ :
    case 0x63 /* 'c' */ :
    case 0x64 /* 'd' */ :
    case 0x65 /* 'e' */ :
    case 0x66 /* 'f' */ :
    case 0x67 /* 'g' */ :
    case 0x68 /* 'h' */ :
    case 0x69 /* 'i' */ :
    case 0x6a /* 'j' */ :
    case 0x6b /* 'k' */ :
    case 0x6c /* 'l' */ :
    case 0x6d /* 'm' */ :
    case 0x6e /* 'n' */ :
    case 0x6f /* 'o' */ :
    case 0x70 /* 'p' */ :
    case 0x71 /* 'q' */ :
    case 0x72 /* 'r' */ :
    case 0x73 /* 's' */ :
    case 0x74 /* 't' */ :
    case 0x75 /* 'u' */ :
    case 0x76 /* 'v' */ :
    case 0x77 /* 'w' */ :
    case 0x78 /* 'x' */ :
    case 0x79 /* 'y' */ :
    case 0x7a /* 'z' */ :
    {
      mNONDIGIT(false);
      break;
    }
    case 0x30 /* '0' */ :
    case 0x31 /* '1' */ :
    case 0x32 /* '2' */ :
    case 0x33 /* '3' */ :
    case 0x34 /* '4' */ :
    case 0x35 /* '5' */ :
    case 0x36 /* '6' */ :
    case 0x37 /* '7' */ :
    case 0x38 /* '8' */ :
    case 0x39 /* '9' */ :
    {
      mDIGIT(false);
      break;
    }
    case 0x2e /* '.' */ :
    {
      mDOT(false);
      break;
    }
    default:
    {
      goto _loop46;
    }
    }
  }
  _loop46:;
  } // ( ... )*
  if ( inputState->guessing==0 ) {
#line 167 "flat_modelica_lexer.g"

    std::string tmp=text.substr(_begin,text.length()-_begin);
    { text.erase(_begin); text += replaceAll(tmp,
    ".",
    "_"); };

#line 1069 "flat_modelica_lexer.cpp"
  }
  _ttype = testLiteralsTable(_ttype);
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mNONDIGIT(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = NONDIGIT;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  {
  switch ( LA(1)) {
  case 0x5f /* '_' */ :
  {
    match('_' /* charlit */ );
    break;
  }
  case 0x61 /* 'a' */ :
  case 0x62 /* 'b' */ :
  case 0x63 /* 'c' */ :
  case 0x64 /* 'd' */ :
  case 0x65 /* 'e' */ :
  case 0x66 /* 'f' */ :
  case 0x67 /* 'g' */ :
  case 0x68 /* 'h' */ :
  case 0x69 /* 'i' */ :
  case 0x6a /* 'j' */ :
  case 0x6b /* 'k' */ :
  case 0x6c /* 'l' */ :
  case 0x6d /* 'm' */ :
  case 0x6e /* 'n' */ :
  case 0x6f /* 'o' */ :
  case 0x70 /* 'p' */ :
  case 0x71 /* 'q' */ :
  case 0x72 /* 'r' */ :
  case 0x73 /* 's' */ :
  case 0x74 /* 't' */ :
  case 0x75 /* 'u' */ :
  case 0x76 /* 'v' */ :
  case 0x77 /* 'w' */ :
  case 0x78 /* 'x' */ :
  case 0x79 /* 'y' */ :
  case 0x7a /* 'z' */ :
  {
    matchRange('a','z');
    break;
  }
  case 0x41 /* 'A' */ :
  case 0x42 /* 'B' */ :
  case 0x43 /* 'C' */ :
  case 0x44 /* 'D' */ :
  case 0x45 /* 'E' */ :
  case 0x46 /* 'F' */ :
  case 0x47 /* 'G' */ :
  case 0x48 /* 'H' */ :
  case 0x49 /* 'I' */ :
  case 0x4a /* 'J' */ :
  case 0x4b /* 'K' */ :
  case 0x4c /* 'L' */ :
  case 0x4d /* 'M' */ :
  case 0x4e /* 'N' */ :
  case 0x4f /* 'O' */ :
  case 0x50 /* 'P' */ :
  case 0x51 /* 'Q' */ :
  case 0x52 /* 'R' */ :
  case 0x53 /* 'S' */ :
  case 0x54 /* 'T' */ :
  case 0x55 /* 'U' */ :
  case 0x56 /* 'V' */ :
  case 0x57 /* 'W' */ :
  case 0x58 /* 'X' */ :
  case 0x59 /* 'Y' */ :
  case 0x5a /* 'Z' */ :
  {
    matchRange('A','Z');
    break;
  }
  default:
  {
    throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
  }
  }
  }
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mDIGIT(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = DIGIT;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  matchRange('0','9');
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mTYVARIDENT(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = TYVARIDENT;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match('\'' /* charlit */ );
  mNONDIGIT(false);
  { // ( ... )*
  for (;;) {
    switch ( LA(1)) {
    case 0x41 /* 'A' */ :
    case 0x42 /* 'B' */ :
    case 0x43 /* 'C' */ :
    case 0x44 /* 'D' */ :
    case 0x45 /* 'E' */ :
    case 0x46 /* 'F' */ :
    case 0x47 /* 'G' */ :
    case 0x48 /* 'H' */ :
    case 0x49 /* 'I' */ :
    case 0x4a /* 'J' */ :
    case 0x4b /* 'K' */ :
    case 0x4c /* 'L' */ :
    case 0x4d /* 'M' */ :
    case 0x4e /* 'N' */ :
    case 0x4f /* 'O' */ :
    case 0x50 /* 'P' */ :
    case 0x51 /* 'Q' */ :
    case 0x52 /* 'R' */ :
    case 0x53 /* 'S' */ :
    case 0x54 /* 'T' */ :
    case 0x55 /* 'U' */ :
    case 0x56 /* 'V' */ :
    case 0x57 /* 'W' */ :
    case 0x58 /* 'X' */ :
    case 0x59 /* 'Y' */ :
    case 0x5a /* 'Z' */ :
    case 0x5f /* '_' */ :
    case 0x61 /* 'a' */ :
    case 0x62 /* 'b' */ :
    case 0x63 /* 'c' */ :
    case 0x64 /* 'd' */ :
    case 0x65 /* 'e' */ :
    case 0x66 /* 'f' */ :
    case 0x67 /* 'g' */ :
    case 0x68 /* 'h' */ :
    case 0x69 /* 'i' */ :
    case 0x6a /* 'j' */ :
    case 0x6b /* 'k' */ :
    case 0x6c /* 'l' */ :
    case 0x6d /* 'm' */ :
    case 0x6e /* 'n' */ :
    case 0x6f /* 'o' */ :
    case 0x70 /* 'p' */ :
    case 0x71 /* 'q' */ :
    case 0x72 /* 'r' */ :
    case 0x73 /* 's' */ :
    case 0x74 /* 't' */ :
    case 0x75 /* 'u' */ :
    case 0x76 /* 'v' */ :
    case 0x77 /* 'w' */ :
    case 0x78 /* 'x' */ :
    case 0x79 /* 'y' */ :
    case 0x7a /* 'z' */ :
    {
      mNONDIGIT(false);
      break;
    }
    case 0x30 /* '0' */ :
    case 0x31 /* '1' */ :
    case 0x32 /* '2' */ :
    case 0x33 /* '3' */ :
    case 0x34 /* '4' */ :
    case 0x35 /* '5' */ :
    case 0x36 /* '6' */ :
    case 0x37 /* '7' */ :
    case 0x38 /* '8' */ :
    case 0x39 /* '9' */ :
    {
      mDIGIT(false);
      break;
    }
    default:
    {
      goto _loop49;
    }
    }
  }
  _loop49:;
  } // ( ... )*
  _ttype = testLiteralsTable(_ttype);
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mEXPONENT(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = EXPONENT;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  {
  switch ( LA(1)) {
  case 0x65 /* 'e' */ :
  {
    match('e' /* charlit */ );
    break;
  }
  case 0x45 /* 'E' */ :
  {
    match('E' /* charlit */ );
    break;
  }
  default:
  {
    throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
  }
  }
  }
  {
  switch ( LA(1)) {
  case 0x2b /* '+' */ :
  {
    match('+' /* charlit */ );
    break;
  }
  case 0x2d /* '-' */ :
  {
    match('-' /* charlit */ );
    break;
  }
  case 0x30 /* '0' */ :
  case 0x31 /* '1' */ :
  case 0x32 /* '2' */ :
  case 0x33 /* '3' */ :
  case 0x34 /* '4' */ :
  case 0x35 /* '5' */ :
  case 0x36 /* '6' */ :
  case 0x37 /* '7' */ :
  case 0x38 /* '8' */ :
  case 0x39 /* '9' */ :
  {
    break;
  }
  default:
  {
    throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
  }
  }
  }
  { // ( ... )+
  int _cnt57=0;
  for (;;) {
    if (((LA(1) >= 0x30 /* '0' */  && LA(1) <= 0x39 /* '9' */ ))) {
      mDIGIT(false);
    }
    else {
      if ( _cnt57>=1 ) { goto _loop57; } else {throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());}
    }

    _cnt57++;
  }
  _loop57:;
  }  // ( ... )+
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mUNSIGNED_INTEGER(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = UNSIGNED_INTEGER;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  {
  bool synPredMatched63 = false;
  if ((((LA(1) >= 0x30 /* '0' */  && LA(1) <= 0x39 /* '9' */ )) && (_tokenSet_3.member(LA(2))))) {
    int _m63 = mark();
    synPredMatched63 = true;
    inputState->guessing++;
    try {
      {
      { // ( ... )+
      int _cnt62=0;
      for (;;) {
        if (((LA(1) >= 0x30 /* '0' */  && LA(1) <= 0x39 /* '9' */ ))) {
          mDIGIT(false);
        }
        else {
          if ( _cnt62>=1 ) { goto _loop62; } else {throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());}
        }

        _cnt62++;
      }
      _loop62:;
      }  // ( ... )+
      match('.' /* charlit */ );
      }
    }
    catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& pe) {
      synPredMatched63 = false;
    }
    rewind(_m63);
    inputState->guessing--;
  }
  if ( synPredMatched63 ) {
    { // ( ... )+
    int _cnt65=0;
    for (;;) {
      if (((LA(1) >= 0x30 /* '0' */  && LA(1) <= 0x39 /* '9' */ ))) {
        mDIGIT(false);
      }
      else {
        if ( _cnt65>=1 ) { goto _loop65; } else {throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());}
      }

      _cnt65++;
    }
    _loop65:;
    }  // ( ... )+
    {
    match('.' /* charlit */ );
    { // ( ... )*
    for (;;) {
      if (((LA(1) >= 0x30 /* '0' */  && LA(1) <= 0x39 /* '9' */ ))) {
        mDIGIT(false);
      }
      else {
        goto _loop68;
      }

    }
    _loop68:;
    } // ( ... )*
    }
    if ( inputState->guessing==0 ) {
#line 196 "flat_modelica_lexer.g"

              _ttype = UNSIGNED_REAL;

#line 1425 "flat_modelica_lexer.cpp"
    }
  }
  else if (((LA(1) >= 0x30 /* '0' */  && LA(1) <= 0x39 /* '9' */ )) && (true)) {
    { // ( ... )+
    int _cnt70=0;
    for (;;) {
      if (((LA(1) >= 0x30 /* '0' */  && LA(1) <= 0x39 /* '9' */ ))) {
        mDIGIT(false);
      }
      else {
        if ( _cnt70>=1 ) { goto _loop70; } else {throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());}
      }

      _cnt70++;
    }
    _loop70:;
    }  // ( ... )+
  }
  else {
    throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
  }

  }
  {
  if ((LA(1) == 0x45 /* 'E' */  || LA(1) == 0x65 /* 'e' */ )) {
    mEXPONENT(false);
    if ( inputState->guessing==0 ) {
#line 201 "flat_modelica_lexer.g"
      _ttype = UNSIGNED_REAL;
#line 1455 "flat_modelica_lexer.cpp"
    }
  }
  else {
  }

  }
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mSTRING(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = STRING;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  _saveIndex = text.length();
  match('\"' /* charlit */ );
  text.erase(_saveIndex);
  { // ( ... )*
  for (;;) {
    if ((_tokenSet_4.member(LA(1)))) {
      mSCHAR(false);
    }
    else if ((LA(1) == 0x5c /* '\\' */ )) {
      mSESCAPE(false);
    }
    else {
      goto _loop74;
    }

  }
  _loop74:;
  } // ( ... )*
  _saveIndex = text.length();
  match('\"' /* charlit */ );
  text.erase(_saveIndex);
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mSCHAR(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = SCHAR;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  switch ( LA(1)) {
  case 0xa /* '\n' */ :
  case 0xd /* '\r' */ :
  {
    {
    {
    switch ( LA(1)) {
    case 0xa /* '\n' */ :
    {
      match('\n' /* charlit */ );
      break;
    }
    case 0xd /* '\r' */ :
    {
      match("\r\n");
      break;
    }
    default:
    {
      throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
    }
    }
    }
    }
    if ( inputState->guessing==0 ) {
#line 208 "flat_modelica_lexer.g"
      newline();
#line 1536 "flat_modelica_lexer.cpp"
    }
    break;
  }
  case 0x9 /* '\t' */ :
  {
    match('\t' /* charlit */ );
    break;
  }
  default:
    if ((_tokenSet_5.member(LA(1)))) {
      {
      match(_tokenSet_5);
      }
    }
  else {
    throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
  }
  }
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mSESCAPE(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = SESCAPE;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match('\\' /* charlit */ );
  {
  switch ( LA(1)) {
  case 0x5c /* '\\' */ :
  {
    match('\\' /* charlit */ );
    break;
  }
  case 0x22 /* '\"' */ :
  {
    match('\"' /* charlit */ );
    break;
  }
  case 0x27 /* '\'' */ :
  {
    match("\'");
    break;
  }
  case 0x3f /* '?' */ :
  {
    match('?' /* charlit */ );
    break;
  }
  case 0x61 /* 'a' */ :
  {
    match('a' /* charlit */ );
    break;
  }
  case 0x62 /* 'b' */ :
  {
    match('b' /* charlit */ );
    break;
  }
  case 0x66 /* 'f' */ :
  {
    match('f' /* charlit */ );
    break;
  }
  case 0x6e /* 'n' */ :
  {
    match('n' /* charlit */ );
    break;
  }
  case 0x72 /* 'r' */ :
  {
    match('r' /* charlit */ );
    break;
  }
  case 0x74 /* 't' */ :
  {
    match('t' /* charlit */ );
    break;
  }
  case 0x76 /* 'v' */ :
  {
    match('v' /* charlit */ );
    break;
  }
  default:
  {
    throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
  }
  }
  }
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}

void flat_modelica_lexer::mESC(bool _createToken) {
  int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; ANTLR_USE_NAMESPACE(std)string::size_type _begin = text.length();
  _ttype = ESC;
  ANTLR_USE_NAMESPACE(std)string::size_type _saveIndex;

  match('\\' /* charlit */ );
  {
  switch ( LA(1)) {
  case 0x22 /* '\"' */ :
  {
    match('\"' /* charlit */ );
    break;
  }
  case 0x5c /* '\\' */ :
  {
    match('\\' /* charlit */ );
    break;
  }
  default:
  {
    throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
  }
  }
  }
  if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
     _token = makeToken(_ttype);
     _token->setText(text.substr(_begin, text.length()-_begin));
  }
  _returnToken = _token;
  _saveIndex=0;
}


const unsigned long flat_modelica_lexer::_tokenSet_0_data_[] = { 4294967288UL, 4294966271UL, 4294967295UL, 4294967295UL, 4294967295UL, 4294967295UL, 4294967295UL, 4294967295UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL };
// 0x3 0x4 0x5 0x6 0x7 0x8 0x9 0xa 0xb 0xc 0xd 0xe 0xf 0x10 0x11 0x12 0x13
// 0x14 0x15 0x16 0x17 0x18 0x19 0x1a 0x1b 0x1c 0x1d 0x1e 0x1f   ! \" #
// $ % & \' ( ) + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? @ A B C D E F
// G H I J K L M N O P Q R S T U V W X Y Z [ 0x5c ] ^ _ ` a b c d e f g
// h i j k l m n o p q r
const ANTLR_USE_NAMESPACE(antlr)BitSet flat_modelica_lexer::_tokenSet_0(_tokenSet_0_data_,16);
const unsigned long flat_modelica_lexer::_tokenSet_1_data_[] = { 4294958072UL, 4294966271UL, 4294967295UL, 4294967295UL, 4294967295UL, 4294967295UL, 4294967295UL, 4294967295UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL };
// 0x3 0x4 0x5 0x6 0x7 0x8 0x9 0xb 0xc 0xe 0xf 0x10 0x11 0x12 0x13 0x14
// 0x15 0x16 0x17 0x18 0x19 0x1a 0x1b 0x1c 0x1d 0x1e 0x1f   ! \" # $ %
// & \' ( ) + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? @ A B C D E F G H
// I J K L M N O P Q R S T U V W X Y Z [ 0x5c ] ^ _ ` a b c d e f g h i
// j k l m n o p q r
const ANTLR_USE_NAMESPACE(antlr)BitSet flat_modelica_lexer::_tokenSet_1(_tokenSet_1_data_,16);
const unsigned long flat_modelica_lexer::_tokenSet_2_data_[] = { 4294958072UL, 4294967295UL, 4294967295UL, 4294967295UL, 4294967295UL, 4294967295UL, 4294967295UL, 4294967295UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL };
// 0x3 0x4 0x5 0x6 0x7 0x8 0x9 0xb 0xc 0xe 0xf 0x10 0x11 0x12 0x13 0x14
// 0x15 0x16 0x17 0x18 0x19 0x1a 0x1b 0x1c 0x1d 0x1e 0x1f   ! \" # $ %
// & \' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? @ A B C D E F G
// H I J K L M N O P Q R S T U V W X Y Z [ 0x5c ] ^ _ ` a b c d e f g h
// i j k l m n o p q r
const ANTLR_USE_NAMESPACE(antlr)BitSet flat_modelica_lexer::_tokenSet_2(_tokenSet_2_data_,16);
const unsigned long flat_modelica_lexer::_tokenSet_3_data_[] = { 0UL, 67059712UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL };
// . 0 1 2 3 4 5 6 7 8 9
const ANTLR_USE_NAMESPACE(antlr)BitSet flat_modelica_lexer::_tokenSet_3(_tokenSet_3_data_,10);
const unsigned long flat_modelica_lexer::_tokenSet_4_data_[] = { 4294967288UL, 4294967291UL, 4026531839UL, 4294967295UL, 4294967295UL, 4294967295UL, 4294967295UL, 4294967295UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL };
// 0x3 0x4 0x5 0x6 0x7 0x8 0x9 0xa 0xb 0xc 0xd 0xe 0xf 0x10 0x11 0x12 0x13
// 0x14 0x15 0x16 0x17 0x18 0x19 0x1a 0x1b 0x1c 0x1d 0x1e 0x1f   ! # $
// % & \' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? @ A B C D E F
// G H I J K L M N O P Q R S T U V W X Y Z [ ] ^ _ ` a b c d e f g h i
// j k l m n o p q r
const ANTLR_USE_NAMESPACE(antlr)BitSet flat_modelica_lexer::_tokenSet_4(_tokenSet_4_data_,16);
const unsigned long flat_modelica_lexer::_tokenSet_5_data_[] = { 4294957560UL, 4294967291UL, 4026531839UL, 4294967295UL, 4294967295UL, 4294967295UL, 4294967295UL, 4294967295UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL };
// 0x3 0x4 0x5 0x6 0x7 0x8 0xb 0xc 0xe 0xf 0x10 0x11 0x12 0x13 0x14 0x15
// 0x16 0x17 0x18 0x19 0x1a 0x1b 0x1c 0x1d 0x1e 0x1f   ! # $ % & \' ( )
// * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? @ A B C D E F G H I J K
// L M N O P Q R S T U V W X Y Z [ ] ^ _ ` a b c d e f g h i j k l m n
// o p q r
const ANTLR_USE_NAMESPACE(antlr)BitSet flat_modelica_lexer::_tokenSet_5(_tokenSet_5_data_,16);

