/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xpath.xml;

import java.io.Serializable;
import java.util.Stack;
import org.apache.xalan.xpath.xml.NameSpace;
import org.apache.xalan.xpath.xml.PrefixResolver;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.w3c.dom.Element;

public class QName
implements Serializable {
    public static final String S_XMLNAMESPACEURI = "http://www.w3.org/XML/1998/namespace";
    public String m_namespace = null;
    public String m_localpart;
    int m_hashCode;

    public QName(String string) {
        this.m_localpart = string;
        this.m_hashCode = this.m_localpart.hashCode();
    }

    public QName(String string, Stack stack) {
        String string2;
        int n = string.indexOf(58);
        if (n > 0) {
            string2 = string.substring(0, n);
            if (string2.equals("xml")) {
                this.m_namespace = S_XMLNAMESPACEURI;
            } else {
                if (string2.equals("xmlns")) {
                    return;
                }
                int n2 = stack.size();
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    NameSpace nameSpace = (NameSpace)stack.elementAt(n3);
                    while (nameSpace != null) {
                        if (nameSpace.m_prefix != null && string2.equals(nameSpace.m_prefix)) {
                            this.m_namespace = nameSpace.m_uri;
                            n3 = -1;
                            break;
                        }
                        nameSpace = nameSpace.m_next;
                    }
                    --n3;
                }
            }
            if (this.m_namespace == null) {
                throw new RuntimeException(XSLMessages.createXPATHMessage(52, new Object[]{string2}));
            }
        }
        String string3 = this.m_localpart = n < 0 ? string : string.substring(n + 1);
        if (this.m_namespace == null) {
            this.m_hashCode = this.m_localpart.hashCode();
        } else {
            string2 = String.valueOf(this.m_namespace) + this.m_localpart;
            this.m_hashCode = string2.hashCode();
        }
    }

    public QName(String string, PrefixResolver prefixResolver) {
        String string2;
        int n = string.indexOf(58);
        if (n > 0) {
            string2 = string.substring(0, n);
            this.m_namespace = string2.equals("xml") ? S_XMLNAMESPACEURI : prefixResolver.getNamespaceForPrefix(string2);
            if (this.m_namespace == null) {
                throw new RuntimeException(XSLMessages.createXPATHMessage(52, new Object[]{string2}));
            }
        }
        String string3 = this.m_localpart = n < 0 ? string : string.substring(n + 1);
        if (this.m_namespace == null) {
            this.m_hashCode = this.m_localpart.hashCode();
        } else {
            string2 = String.valueOf(this.m_namespace) + this.m_localpart;
            this.m_hashCode = string2.hashCode();
        }
    }

    public QName(String string, Element element, PrefixResolver prefixResolver) {
        String string2;
        int n = string.indexOf(58);
        if (n > 0 && element != null) {
            string2 = string.substring(0, n);
            this.m_namespace = string2.equals("xml") ? S_XMLNAMESPACEURI : prefixResolver.getNamespaceForPrefix(string2, element);
            if (this.m_namespace == null) {
                throw new RuntimeException(XSLMessages.createXPATHMessage(52, new Object[]{string2}));
            }
        }
        String string3 = this.m_localpart = n < 0 ? string : string.substring(n + 1);
        if (this.m_namespace == null) {
            this.m_hashCode = this.m_localpart.hashCode();
        } else {
            string2 = String.valueOf(this.m_namespace) + this.m_localpart;
            this.m_hashCode = string2.hashCode();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof QName)) return false;
        QName qName = (QName)object;
        if (!this.m_localpart.equals(qName.m_localpart)) return false;
        if (this.m_namespace == null || qName.m_namespace == null) {
            if (this.m_namespace != null) return false;
            if (qName.m_namespace == null) return true;
            return false;
        }
        boolean bl = this.m_namespace.equals(qName.m_namespace);
        if (bl) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(String string, String string2) {
        if (!this.m_localpart.equals(string2)) return false;
        if (this.m_namespace == null || string == null) {
            if (this.m_namespace != null) return false;
            if (string == null) return true;
            return false;
        }
        boolean bl = this.m_namespace.equals(string);
        if (bl) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(QName qName) {
        if (!this.m_localpart.equals(qName.m_localpart)) return false;
        if (this.m_namespace == null || qName.m_namespace == null) {
            if (this.m_namespace != null) return false;
            if (qName.m_namespace == null) return true;
            return false;
        }
        boolean bl = this.m_namespace.equals(qName.m_namespace);
        if (bl) return true;
        return false;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public String toString() {
        return this.m_namespace != null ? String.valueOf(this.m_namespace) + ":" + this.m_localpart : this.m_localpart;
    }
}

