//
// Copyright (c) 2002--2010
// Toon Knapen, Karl Meerbergen, Kresimir Fresl,
// Thomas Klimpel and Rutger ter Borg
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//
// THIS FILE IS AUTOMATICALLY GENERATED
// PLEASE DO NOT EDIT!
//

#ifndef BOOST_NUMERIC_BINDINGS_LAPACK_COMPUTATIONAL_PTTRF_HPP
#define BOOST_NUMERIC_BINDINGS_LAPACK_COMPUTATIONAL_PTTRF_HPP

#include <boost/assert.hpp>
#include <Core/Utils/numeric/bindings/begin.hpp>
#include <Core/Utils/numeric/bindings/is_complex.hpp>
#include <Core/Utils/numeric/bindings/is_mutable.hpp>
#include <Core/Utils/numeric/bindings/is_real.hpp>
#include <Core/Utils/numeric/bindings/remove_imaginary.hpp>
#include <Core/Utils/numeric/bindings/size.hpp>
#include <Core/Utils/numeric/bindings/stride.hpp>
#include <Core/Utils/numeric/bindings/value_type.hpp>
#include <boost/static_assert.hpp>
#include <boost/type_traits/is_same.hpp>
#include <boost/type_traits/remove_const.hpp>
#include <boost/utility/enable_if.hpp>

//
// The LAPACK-backend for pttrf is the netlib-compatible backend.
//
#include <Core/Utils/numeric/bindings/lapack/detail/lapack.h>
#include <Core/Utils/numeric/bindings/lapack/detail/lapack_option.hpp>

namespace boost
{
    namespace numeric
    {
        namespace bindings
        {
            namespace lapack
            {
                //
                // The detail namespace contains value-type-overloaded functions that
                // dispatch to the appropriate back-end LAPACK-routine.
                //
                namespace detail
                {
                    //
                    // Overloaded function for dispatching to
                    // * netlib-compatible LAPACK backend (the default), and
                    // * float value-type.
                    //
                    inline std::ptrdiff_t pttrf(const fortran_int_t n, float* d, float* e)
                    {
                        fortran_int_t info(0);
                        LAPACK_SPTTRF(&n, d, e, &info);
                        return info;
                    }

                    //
                    // Overloaded function for dispatching to
                    // * netlib-compatible LAPACK backend (the default), and
                    // * double value-type.
                    //
                    inline std::ptrdiff_t pttrf(const fortran_int_t n, double* d, double* e)
                    {
                        fortran_int_t info(0);
                        LAPACK_DPTTRF(&n, d, e, &info);
                        return info;
                    }

                    //
                    // Overloaded function for dispatching to
                    // * netlib-compatible LAPACK backend (the default), and
                    // * complex<float> value-type.
                    //
                    inline std::ptrdiff_t pttrf(const fortran_int_t n, float* d,
                                                std::complex<float>* e)
                    {
                        fortran_int_t info(0);
                        LAPACK_CPTTRF(&n, d, e, &info);
                        return info;
                    }

                    //
                    // Overloaded function for dispatching to
                    // * netlib-compatible LAPACK backend (the default), and
                    // * complex<double> value-type.
                    //
                    inline std::ptrdiff_t pttrf(const fortran_int_t n, double* d,
                                                std::complex<double>* e)
                    {
                        fortran_int_t info(0);
                        LAPACK_ZPTTRF(&n, d, e, &info);
                        return info;
                    }
                } // namespace detail

                //
                // Value-type based template class. Use this class if you need a type
                // for dispatching to pttrf.
                //
                template <typename Value, typename Enable = void>
                struct pttrf_impl
                {
                };

                //
                // This implementation is enabled if Value is a real type.
                //
                template <typename Value>
                struct pttrf_impl<Value, typename boost::enable_if<is_real<Value>>::type>
                {
                    typedef Value value_type;
                    typedef typename remove_imaginary<Value>::type real_type;

                    //
                    // Static member function, that
                    // * Deduces the required arguments for dispatching to LAPACK, and
                    // * Asserts that most arguments make sense.
                    //
                    template <typename VectorD, typename VectorE>
                    static std::ptrdiff_t invoke(VectorD& d, VectorE& e)
                    {
                        namespace bindings = ::boost::numeric::bindings;
                        BOOST_STATIC_ASSERT((boost::is_same<typename remove_const<
                                                                typename bindings::value_type<VectorD>::type>::type,
                                                            typename remove_const<typename bindings::value_type<
                                                                VectorE>::type>::type>::value));
                        BOOST_STATIC_ASSERT((bindings::is_mutable<VectorD>::value));
                        BOOST_STATIC_ASSERT((bindings::is_mutable<VectorE>::value));
                        BOOST_ASSERT(bindings::size(d) >= bindings::size(d));
                        BOOST_ASSERT(bindings::size(d) >= 0);
                        BOOST_ASSERT(bindings::size(e) >= bindings::size(d) - 1);
                        return detail::pttrf(bindings::size(d), bindings::begin_value(d),
                                             bindings::begin_value(e));
                    }
                };

                //
                // This implementation is enabled if Value is a complex type.
                //
                template <typename Value>
                struct pttrf_impl<Value, typename boost::enable_if<is_complex<Value>>::type>
                {
                    typedef Value value_type;
                    typedef typename remove_imaginary<Value>::type real_type;

                    //
                    // Static member function, that
                    // * Deduces the required arguments for dispatching to LAPACK, and
                    // * Asserts that most arguments make sense.
                    //
                    template <typename VectorD, typename VectorE>
                    static std::ptrdiff_t invoke(VectorD& d, VectorE& e)
                    {
                        namespace bindings = ::boost::numeric::bindings;
                        BOOST_STATIC_ASSERT((bindings::is_mutable<VectorD>::value));
                        BOOST_STATIC_ASSERT((bindings::is_mutable<VectorE>::value));
                        BOOST_ASSERT(bindings::size(d) >= bindings::size(d));
                        BOOST_ASSERT(bindings::size(d) >= 0);
                        BOOST_ASSERT(bindings::size(e) >= bindings::size(d) - 1);
                        return detail::pttrf(bindings::size(d), bindings::begin_value(d),
                                             bindings::begin_value(e));
                    }
                };


                //
                // Functions for direct use. These functions are overloaded for temporaries,
                // so that wrapped types can still be passed and used for write-access. In
                // addition, if applicable, they are overloaded for user-defined workspaces.
                // Calls to these functions are passed to the pttrf_impl classes. In the
                // documentation, most overloads are collapsed to avoid a large number of
                // prototypes which are very similar.
                //

                //
                // Overloaded function for pttrf. Its overload differs for
                //
                template <typename VectorD, typename VectorE>
                inline std::ptrdiff_t pttrf(VectorD& d, VectorE& e)
                {
                    return pttrf_impl<typename bindings::value_type<
                        VectorE>::type>::invoke(d, e);
                }
            } // namespace lapack
        } // namespace bindings
    } // namespace numeric
} // namespace boost

#endif
