//
// Copyright (c) 2002--2010
// Toon Knapen, Karl Meerbergen, Kresimir Fresl,
// Thomas Klimpel and Rutger ter Borg
//
// Distributed under the Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)
//
// THIS FILE IS AUTOMATICALLY GENERATED
// PLEASE DO NOT EDIT!
//

#ifndef BOOST_NUMERIC_BINDINGS_LAPACK_AUXILIARY_LARFB_HPP
#define BOOST_NUMERIC_BINDINGS_LAPACK_AUXILIARY_LARFB_HPP

#include <boost/assert.hpp>
#include <Core/Utils/numeric/bindings/begin.hpp>
#include <Core/Utils/numeric/bindings/data_order.hpp>
#include <Core/Utils/numeric/bindings/detail/array.hpp>
#include <Core/Utils/numeric/bindings/detail/if_left.hpp>
#include <Core/Utils/numeric/bindings/is_column_major.hpp>
#include <Core/Utils/numeric/bindings/is_complex.hpp>
#include <Core/Utils/numeric/bindings/is_mutable.hpp>
#include <Core/Utils/numeric/bindings/is_real.hpp>
#include <Core/Utils/numeric/bindings/lapack/workspace.hpp>
#include <Core/Utils/numeric/bindings/remove_imaginary.hpp>
#include <Core/Utils/numeric/bindings/size.hpp>
#include <Core/Utils/numeric/bindings/stride.hpp>
#include <Core/Utils/numeric/bindings/trans_tag.hpp>
#include <Core/Utils/numeric/bindings/value_type.hpp>
#include <boost/static_assert.hpp>
#include <boost/type_traits/is_same.hpp>
#include <boost/type_traits/remove_const.hpp>
#include <boost/utility/enable_if.hpp>

//
// The LAPACK-backend for larfb is the netlib-compatible backend.
//
#include <Core/Utils/numeric/bindings/lapack/detail/lapack.h>
#include <Core/Utils/numeric/bindings/lapack/detail/lapack_option.hpp>

namespace boost
{
    namespace numeric
    {
        namespace bindings
        {
            namespace lapack
            {
                //
                // The detail namespace contains value-type-overloaded functions that
                // dispatch to the appropriate back-end LAPACK-routine.
                //
                namespace detail
                {
                    //
                    // Overloaded function for dispatching to
                    // * netlib-compatible LAPACK backend (the default), and
                    // * float value-type.
                    //
                    template <typename Side, typename Trans>
                    inline std::ptrdiff_t larfb(const Side, const Trans, const char direct,
                                                const char storev, const fortran_int_t m, const fortran_int_t n,
                                                const fortran_int_t k, const float* v, const fortran_int_t ldv,
                                                const float* t, const fortran_int_t ldt, float* c,
                                                const fortran_int_t ldc, float* work, const fortran_int_t ldwork)
                    {
                        fortran_int_t info(0);
                        LAPACK_SLARFB(&lapack_option<Side>::value, &lapack_option<
                                          Trans>::value, &direct, &storev, &m, &n, &k, v, &ldv, t, &ldt, c,
                                      &ldc, work, &ldwork);
                        return info;
                    }

                    //
                    // Overloaded function for dispatching to
                    // * netlib-compatible LAPACK backend (the default), and
                    // * double value-type.
                    //
                    template <typename Side, typename Trans>
                    inline std::ptrdiff_t larfb(const Side, const Trans, const char direct,
                                                const char storev, const fortran_int_t m, const fortran_int_t n,
                                                const fortran_int_t k, const double* v, const fortran_int_t ldv,
                                                const double* t, const fortran_int_t ldt, double* c,
                                                const fortran_int_t ldc, double* work, const fortran_int_t ldwork)
                    {
                        fortran_int_t info(0);
                        LAPACK_DLARFB(&lapack_option<Side>::value, &lapack_option<
                                          Trans>::value, &direct, &storev, &m, &n, &k, v, &ldv, t, &ldt, c,
                                      &ldc, work, &ldwork);
                        return info;
                    }

                    //
                    // Overloaded function for dispatching to
                    // * netlib-compatible LAPACK backend (the default), and
                    // * complex<float> value-type.
                    //
                    template <typename Side, typename Trans>
                    inline std::ptrdiff_t larfb(const Side, const Trans, const char direct,
                                                const char storev, const fortran_int_t m, const fortran_int_t n,
                                                const fortran_int_t k, const std::complex<float>* v,
                                                const fortran_int_t ldv, const std::complex<float>* t,
                                                const fortran_int_t ldt, std::complex<float>* c,
                                                const fortran_int_t ldc, std::complex<float>* work,
                                                const fortran_int_t ldwork)
                    {
                        fortran_int_t info(0);
                        LAPACK_CLARFB(&lapack_option<Side>::value, &lapack_option<
                                          Trans>::value, &direct, &storev, &m, &n, &k, v, &ldv, t, &ldt, c,
                                      &ldc, work, &ldwork);
                        return info;
                    }

                    //
                    // Overloaded function for dispatching to
                    // * netlib-compatible LAPACK backend (the default), and
                    // * complex<double> value-type.
                    //
                    template <typename Side, typename Trans>
                    inline std::ptrdiff_t larfb(const Side, const Trans, const char direct,
                                                const char storev, const fortran_int_t m, const fortran_int_t n,
                                                const fortran_int_t k, const std::complex<double>* v,
                                                const fortran_int_t ldv, const std::complex<double>* t,
                                                const fortran_int_t ldt, std::complex<double>* c,
                                                const fortran_int_t ldc, std::complex<double>* work,
                                                const fortran_int_t ldwork)
                    {
                        fortran_int_t info(0);
                        LAPACK_ZLARFB(&lapack_option<Side>::value, &lapack_option<
                                          Trans>::value, &direct, &storev, &m, &n, &k, v, &ldv, t, &ldt, c,
                                      &ldc, work, &ldwork);
                        return info;
                    }
                } // namespace detail

                //
                // Value-type based template class. Use this class if you need a type
                // for dispatching to larfb.
                //
                template <typename Value, typename Enable = void>
                struct larfb_impl
                {
                };

                //
                // This implementation is enabled if Value is a real type.
                //
                template <typename Value>
                struct larfb_impl<Value, typename boost::enable_if<is_real<Value>>::type>
                {
                    typedef Value value_type;
                    typedef typename remove_imaginary<Value>::type real_type;

                    //
                    // Static member function for user-defined workspaces, that
                    // * Deduces the required arguments for dispatching to LAPACK, and
                    // * Asserts that most arguments make sense.
                    //
                    template <typename Side, typename MatrixV, typename MatrixT,
                              typename MatrixC, typename WORK>
                    static std::ptrdiff_t invoke(const Side side, const char direct,
                                                 const char storev, const MatrixV& v, const MatrixT& t, MatrixC& c,
                                                 const fortran_int_t ldwork, detail::workspace1<WORK> work)
                    {
                        namespace bindings = ::boost::numeric::bindings;
                        typedef typename result_of::data_order<MatrixT>::type order;
                        typedef typename result_of::trans_tag<MatrixV, order>::type trans;
                        BOOST_STATIC_ASSERT((bindings::is_column_major<MatrixC>::value));
                        BOOST_STATIC_ASSERT((boost::is_same<typename remove_const<
                                                                typename bindings::value_type<MatrixV>::type>::type,
                                                            typename remove_const<typename bindings::value_type<
                                                                MatrixT>::type>::type>::value));
                        BOOST_STATIC_ASSERT((boost::is_same<typename remove_const<
                                                                typename bindings::value_type<MatrixV>::type>::type,
                                                            typename remove_const<typename bindings::value_type<
                                                                MatrixC>::type>::type>::value));
                        BOOST_STATIC_ASSERT((bindings::is_mutable<MatrixC>::value));
                        BOOST_ASSERT(bindings::size(work.select(real_type())) >=
                            min_size_work(ldwork, bindings::size_column(t)));
                        BOOST_ASSERT(bindings::size_minor(c) == 1 ||
                            bindings::stride_minor(c) == 1);
                        BOOST_ASSERT(bindings::size_minor(t) == 1 ||
                            bindings::stride_minor(t) == 1);
                        BOOST_ASSERT(bindings::size_minor(v) == 1 ||
                            bindings::stride_minor(v) == 1);
                        BOOST_ASSERT(bindings::stride_major(c) >= std::max<std::ptrdiff_t>(1,
                                                                                           bindings::size_row(c)));
                        BOOST_ASSERT(bindings::stride_major(t) >= bindings::size_column(t));
                        BOOST_ASSERT(direct == 'F' || direct == 'B');
                        BOOST_ASSERT(storev == 'C' || storev == 'R');
                        return detail::larfb(side, trans(), direct, storev,
                                             bindings::size_row(c), bindings::size_column(c),
                                             bindings::size_column(t), bindings::begin_value(v),
                                             bindings::stride_major(v), bindings::begin_value(t),
                                             bindings::stride_major(t), bindings::begin_value(c),
                                             bindings::stride_major(c),
                                             bindings::begin_value(work.select(real_type())), ldwork);
                    }

                    //
                    // Static member function that
                    // * Figures out the minimal workspace requirements, and passes
                    //   the results to the user-defined workspace overload of the
                    //   invoke static member function
                    // * Enables the unblocked algorithm (BLAS level 2)
                    //
                    template <typename Side, typename MatrixV, typename MatrixT,
                              typename MatrixC>
                    static std::ptrdiff_t invoke(const Side side, const char direct,
                                                 const char storev, const MatrixV& v, const MatrixT& t, MatrixC& c,
                                                 const fortran_int_t ldwork, minimal_workspace)
                    {
                        namespace bindings = ::boost::numeric::bindings;
                        typedef typename result_of::data_order<MatrixT>::type order;
                        typedef typename result_of::trans_tag<MatrixV, order>::type trans;
                        bindings::detail::array<real_type> tmp_work(min_size_work(ldwork,
                                                                                  bindings::size_column(t)));
                        return invoke(side, direct, storev, v, t, c, ldwork,
                                      workspace(tmp_work));
                    }

                    //
                    // Static member function that
                    // * Figures out the optimal workspace requirements, and passes
                    //   the results to the user-defined workspace overload of the
                    //   invoke static member
                    // * Enables the blocked algorithm (BLAS level 3)
                    //
                    template <typename Side, typename MatrixV, typename MatrixT,
                              typename MatrixC>
                    static std::ptrdiff_t invoke(const Side side, const char direct,
                                                 const char storev, const MatrixV& v, const MatrixT& t, MatrixC& c,
                                                 const fortran_int_t ldwork, optimal_workspace)
                    {
                        namespace bindings = ::boost::numeric::bindings;
                        typedef typename result_of::data_order<MatrixT>::type order;
                        typedef typename result_of::trans_tag<MatrixV, order>::type trans;
                        return invoke(side, direct, storev, v, t, c, ldwork,
                                      minimal_workspace());
                    }

                    //
                    // Static member function that returns the minimum size of
                    // workspace-array work.
                    //
                    static std::ptrdiff_t min_size_work(const std::ptrdiff_t ldwork,
                                                        const std::ptrdiff_t k)
                    {
                        return ldwork * k;
                    }
                };

                //
                // This implementation is enabled if Value is a complex type.
                //
                template <typename Value>
                struct larfb_impl<Value, typename boost::enable_if<is_complex<Value>>::type>
                {
                    typedef Value value_type;
                    typedef typename remove_imaginary<Value>::type real_type;

                    //
                    // Static member function for user-defined workspaces, that
                    // * Deduces the required arguments for dispatching to LAPACK, and
                    // * Asserts that most arguments make sense.
                    //
                    template <typename Side, typename MatrixV, typename MatrixT,
                              typename MatrixC, typename WORK>
                    static std::ptrdiff_t invoke(const Side side, const char direct,
                                                 const char storev, const MatrixV& v, const MatrixT& t, MatrixC& c,
                                                 const fortran_int_t ldwork, detail::workspace1<WORK> work)
                    {
                        namespace bindings = ::boost::numeric::bindings;
                        typedef typename result_of::data_order<MatrixT>::type order;
                        typedef typename result_of::trans_tag<MatrixV, order>::type trans;
                        BOOST_STATIC_ASSERT((bindings::is_column_major<MatrixC>::value));
                        BOOST_STATIC_ASSERT((boost::is_same<typename remove_const<
                                                                typename bindings::value_type<MatrixV>::type>::type,
                                                            typename remove_const<typename bindings::value_type<
                                                                MatrixT>::type>::type>::value));
                        BOOST_STATIC_ASSERT((boost::is_same<typename remove_const<
                                                                typename bindings::value_type<MatrixV>::type>::type,
                                                            typename remove_const<typename bindings::value_type<
                                                                MatrixC>::type>::type>::value));
                        BOOST_STATIC_ASSERT((bindings::is_mutable<MatrixC>::value));
                        BOOST_ASSERT(bindings::size(work.select(value_type())) >=
                            min_size_work(ldwork, bindings::size_column(t)));
                        BOOST_ASSERT(bindings::size_minor(c) == 1 ||
                            bindings::stride_minor(c) == 1);
                        BOOST_ASSERT(bindings::size_minor(t) == 1 ||
                            bindings::stride_minor(t) == 1);
                        BOOST_ASSERT(bindings::size_minor(v) == 1 ||
                            bindings::stride_minor(v) == 1);
                        BOOST_ASSERT(bindings::stride_major(c) >= std::max<std::ptrdiff_t>(1,
                                                                                           bindings::size_row(c)));
                        BOOST_ASSERT(bindings::stride_major(t) >= bindings::size_column(t));
                        BOOST_ASSERT(direct == 'F' || direct == 'B');
                        BOOST_ASSERT(storev == 'C' || storev == 'R');
                        return detail::larfb(side, trans(), direct, storev,
                                             bindings::size_row(c), bindings::size_column(c),
                                             bindings::size_column(t), bindings::begin_value(v),
                                             bindings::stride_major(v), bindings::begin_value(t),
                                             bindings::stride_major(t), bindings::begin_value(c),
                                             bindings::stride_major(c),
                                             bindings::begin_value(work.select(value_type())), ldwork);
                    }

                    //
                    // Static member function that
                    // * Figures out the minimal workspace requirements, and passes
                    //   the results to the user-defined workspace overload of the
                    //   invoke static member function
                    // * Enables the unblocked algorithm (BLAS level 2)
                    //
                    template <typename Side, typename MatrixV, typename MatrixT,
                              typename MatrixC>
                    static std::ptrdiff_t invoke(const Side side, const char direct,
                                                 const char storev, const MatrixV& v, const MatrixT& t, MatrixC& c,
                                                 const fortran_int_t ldwork, minimal_workspace)
                    {
                        namespace bindings = ::boost::numeric::bindings;
                        typedef typename result_of::data_order<MatrixT>::type order;
                        typedef typename result_of::trans_tag<MatrixV, order>::type trans;
                        bindings::detail::array<value_type> tmp_work(min_size_work(ldwork,
                                                                                   bindings::size_column(t)));
                        return invoke(side, direct, storev, v, t, c, ldwork,
                                      workspace(tmp_work));
                    }

                    //
                    // Static member function that
                    // * Figures out the optimal workspace requirements, and passes
                    //   the results to the user-defined workspace overload of the
                    //   invoke static member
                    // * Enables the blocked algorithm (BLAS level 3)
                    //
                    template <typename Side, typename MatrixV, typename MatrixT,
                              typename MatrixC>
                    static std::ptrdiff_t invoke(const Side side, const char direct,
                                                 const char storev, const MatrixV& v, const MatrixT& t, MatrixC& c,
                                                 const fortran_int_t ldwork, optimal_workspace)
                    {
                        namespace bindings = ::boost::numeric::bindings;
                        typedef typename result_of::data_order<MatrixT>::type order;
                        typedef typename result_of::trans_tag<MatrixV, order>::type trans;
                        return invoke(side, direct, storev, v, t, c, ldwork,
                                      minimal_workspace());
                    }

                    //
                    // Static member function that returns the minimum size of
                    // workspace-array work.
                    //
                    static std::ptrdiff_t min_size_work(const std::ptrdiff_t ldwork,
                                                        const std::ptrdiff_t k)
                    {
                        return ldwork * k;
                    }
                };


                //
                // Functions for direct use. These functions are overloaded for temporaries,
                // so that wrapped types can still be passed and used for write-access. In
                // addition, if applicable, they are overloaded for user-defined workspaces.
                // Calls to these functions are passed to the larfb_impl classes. In the
                // documentation, most overloads are collapsed to avoid a large number of
                // prototypes which are very similar.
                //

                //
                // Overloaded function for larfb. Its overload differs for
                // * User-defined workspace
                //
                template <typename Side, typename MatrixV, typename MatrixT, typename MatrixC,
                          typename Workspace>
                inline typename boost::enable_if<detail::is_workspace<Workspace>,
                                                 std::ptrdiff_t>::type
                larfb(const Side side, const char direct, const char storev,
                      const MatrixV& v, const MatrixT& t, MatrixC& c,
                      const fortran_int_t ldwork, Workspace work)
                {
                    return larfb_impl<typename bindings::value_type<
                        MatrixV>::type>::invoke(side, direct, storev, v, t, c, ldwork,
                                                work);
                }

                //
                // Overloaded function for larfb. Its overload differs for
                // * Default workspace-type (optimal)
                //
                template <typename Side, typename MatrixV, typename MatrixT, typename MatrixC>
                inline typename boost::disable_if<detail::is_workspace<MatrixC>,
                                                  std::ptrdiff_t>::type
                larfb(const Side side, const char direct, const char storev,
                      const MatrixV& v, const MatrixT& t, MatrixC& c,
                      const fortran_int_t ldwork)
                {
                    return larfb_impl<typename bindings::value_type<
                        MatrixV>::type>::invoke(side, direct, storev, v, t, c, ldwork,
                                                optimal_workspace());
                }
            } // namespace lapack
        } // namespace bindings
    } // namespace numeric
} // namespace boost

#endif
