/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.console;

import com.orientechnologies.common.console.OCommandStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ODFACommandStream
implements OCommandStream {
    public static final int BUFFER_SIZE = 1024;
    private final Set<Character> separators = new HashSet<Character>(Arrays.asList(Character.valueOf(';'), Character.valueOf('\n')));
    private Reader reader;
    private Character nextCharacter;
    private State state;

    public ODFACommandStream(String commands) {
        this.reader = new StringReader(commands);
        this.init();
    }

    public ODFACommandStream(File file) throws FileNotFoundException {
        this.reader = new BufferedReader(new FileReader(file), 1024);
        this.init();
    }

    private void init() {
        try {
            int next = this.reader.read();
            this.nextCharacter = next > -1 ? Character.valueOf((char)next) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Character nextCharacter() throws IOException {
        if (this.nextCharacter == null) {
            return null;
        }
        Character result = this.nextCharacter;
        int next = this.reader.read();
        this.nextCharacter = next < 0 ? null : Character.valueOf((char)next);
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.nextCharacter != null;
    }

    @Override
    public String nextCommand() {
        try {
            this.state = State.S;
            StringBuilder result = new StringBuilder();
            StringBuilder stateWord = new StringBuilder();
            while (this.state != State.E) {
                Symbol s2;
                Character c = this.nextCharacter();
                String sch = null;
                if (c == null) {
                    s2 = Symbol.EOF;
                } else if (c.equals(Character.valueOf('\''))) {
                    s2 = Symbol.AP;
                } else if (c.equals(Character.valueOf('\"'))) {
                    s2 = Symbol.QT;
                } else if (this.separators.contains(c)) {
                    s2 = Symbol.SEP;
                } else if (Character.isWhitespace(c.charValue())) {
                    s2 = Symbol.WS;
                } else if (c.charValue() == '\\') {
                    Character nextCharacter = this.nextCharacter();
                    sch = "" + c + nextCharacter;
                    s2 = Symbol.LATTER;
                } else {
                    s2 = Symbol.LATTER;
                }
                State newState = this.transition(this.state, s2);
                if (newState == State.F) {
                    throw new IllegalStateException("Unexpected end of file");
                }
                State oldState = this.state;
                this.state = newState;
                if (this.state != State.E && this.state != State.S) {
                    if (this.state != oldState) {
                        result.append((CharSequence)stateWord);
                        stateWord = new StringBuilder();
                    }
                    if (sch != null) {
                        stateWord.append(sch);
                    } else {
                        stateWord.append(c);
                    }
                }
                if (this.state != State.E || stateWord.length() <= 0 || oldState == State.D) continue;
                result.append((CharSequence)stateWord);
            }
            return result.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Symbol symbol(Character c) {
        if (c.equals(Character.valueOf('\''))) {
            return Symbol.AP;
        }
        if (c.equals(Character.valueOf('\"'))) {
            return Symbol.QT;
        }
        if (this.separators.contains(c)) {
            return Symbol.SEP;
        }
        if (Character.isWhitespace(c.charValue())) {
            return Symbol.WS;
        }
        return Symbol.LATTER;
    }

    private State transition(State s2, Symbol c) {
        switch (s2) {
            case S: {
                switch (c) {
                    case LATTER: {
                        return State.A;
                    }
                    case WS: {
                        return State.S;
                    }
                    case AP: {
                        return State.B;
                    }
                    case QT: {
                        return State.C;
                    }
                    case SEP: {
                        return State.S;
                    }
                    case EOF: {
                        return State.E;
                    }
                }
                break;
            }
            case A: 
            case D: {
                switch (c) {
                    case LATTER: {
                        return State.A;
                    }
                    case WS: {
                        return State.D;
                    }
                    case AP: {
                        return State.B;
                    }
                    case QT: {
                        return State.C;
                    }
                    case SEP: {
                        return State.E;
                    }
                    case EOF: {
                        return State.E;
                    }
                }
                break;
            }
            case B: {
                switch (c) {
                    case LATTER: {
                        return State.B;
                    }
                    case WS: {
                        return State.B;
                    }
                    case AP: {
                        return State.A;
                    }
                    case QT: {
                        return State.B;
                    }
                    case SEP: {
                        return State.B;
                    }
                    case EOF: {
                        return State.F;
                    }
                }
                break;
            }
            case C: {
                switch (c) {
                    case LATTER: {
                        return State.C;
                    }
                    case WS: {
                        return State.C;
                    }
                    case AP: {
                        return State.C;
                    }
                    case QT: {
                        return State.A;
                    }
                    case SEP: {
                        return State.C;
                    }
                    case EOF: {
                        return State.F;
                    }
                }
                break;
            }
            case E: {
                return State.E;
            }
            case F: {
                return State.F;
            }
        }
        throw new IllegalStateException();
    }

    private static enum Symbol {
        LATTER,
        WS,
        QT,
        AP,
        SEP,
        EOF;

    }

    private static enum State {
        S,
        A,
        B,
        C,
        D,
        E,
        F;

    }
}

