/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import java.util.concurrent.Callable;

public class OScenarioThreadLocal
extends ThreadLocal<RunContext> {
    public static volatile OScenarioThreadLocal INSTANCE = new OScenarioThreadLocal();

    public OScenarioThreadLocal() {
        this.setRunMode(RUN_MODE.DEFAULT);
    }

    public static Object executeAsDistributed(Callable<? extends Object> iCallback) {
        RUN_MODE currentDistributedMode = INSTANCE.getRunMode();
        if (currentDistributedMode != RUN_MODE.RUNNING_DISTRIBUTED) {
            INSTANCE.setRunMode(RUN_MODE.RUNNING_DISTRIBUTED);
        }
        try {
            Object object = iCallback.call();
            return object;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (currentDistributedMode != RUN_MODE.RUNNING_DISTRIBUTED) {
                INSTANCE.setRunMode(RUN_MODE.DEFAULT);
            }
        }
    }

    public static <T> Object executeAsDefault(Callable<T> iCallback) {
        RUN_MODE currentDistributedMode = INSTANCE.getRunMode();
        if (currentDistributedMode == RUN_MODE.RUNNING_DISTRIBUTED) {
            INSTANCE.setRunMode(RUN_MODE.DEFAULT);
        }
        try {
            T t2 = iCallback.call();
            return t2;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (currentDistributedMode == RUN_MODE.RUNNING_DISTRIBUTED) {
                INSTANCE.setRunMode(RUN_MODE.RUNNING_DISTRIBUTED);
            }
        }
    }

    public void setRunMode(RUN_MODE value) {
        RunContext context = (RunContext)this.get();
        context.runMode = value;
    }

    public void setInDatabaseLock(boolean value) {
        RunContext context = (RunContext)this.get();
        context.inDatabaseLock = value;
    }

    public RUN_MODE getRunMode() {
        return ((RunContext)this.get()).runMode;
    }

    public boolean isRunModeDistributed() {
        return ((RunContext)this.get()).runMode == RUN_MODE.RUNNING_DISTRIBUTED;
    }

    public boolean isInDatabaseLock() {
        return ((RunContext)this.get()).inDatabaseLock;
    }

    @Override
    protected RunContext initialValue() {
        return new RunContext();
    }

    static {
        Orient.instance().registerListener(new OOrientListenerAbstract(){

            @Override
            public void onStartup() {
                if (INSTANCE == null) {
                    INSTANCE = new OScenarioThreadLocal();
                }
            }

            @Override
            public void onShutdown() {
                INSTANCE = null;
            }
        });
    }

    public static class RunContext {
        public RUN_MODE runMode = RUN_MODE.DEFAULT;
        public boolean inDatabaseLock;
    }

    public static enum RUN_MODE {
        DEFAULT,
        RUNNING_DISTRIBUTED;

    }
}

