/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.Map;

public class OCommandExecutorSQLDropIndex
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_DROP = "DROP";
    public static final String KEYWORD_INDEX = "INDEX";
    private String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLDropIndex parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            this.init((OCommandRequestText)iRequest);
            StringBuilder word = new StringBuilder();
            int oldPos = 0;
            int pos = OCommandExecutorSQLDropIndex.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
            if (pos == -1 || !word.toString().equals(KEYWORD_DROP)) {
                throw new OCommandSQLParsingException("Keyword DROP not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLDropIndex.nextWord(this.parserText, this.parserTextUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_INDEX)) {
                throw new OCommandSQLParsingException("Keyword INDEX not found. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            oldPos = pos;
            if ((pos = OCommandExecutorSQLDropIndex.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, false)) == -1) {
                throw new OCommandSQLParsingException("Expected index name. Use " + this.getSyntax(), this.parserText, oldPos);
            }
            this.name = word.toString();
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.name == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        if (this.name.equals("*")) {
            long totalIndexed = 0L;
            for (OIndex<?> idx : OCommandExecutorSQLDropIndex.getDatabase().getMetadata().getIndexManager().getIndexes()) {
                OCommandExecutorSQLDropIndex.getDatabase().getMetadata().getIndexManager().dropIndex(idx.getName());
                ++totalIndexed;
            }
            return totalIndexed;
        }
        OIndexManagerProxy indexMgr = OCommandExecutorSQLDropIndex.getDatabase().getMetadata().getIndexManager();
        if (indexMgr.existsIndex(this.name)) {
            indexMgr.dropIndex(this.name);
            return 1;
        }
        return 0;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_QUICK_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public String getSyntax() {
        return "DROP INDEX <index-name>|<class>.<property>|*";
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }
}

