/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.method;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLMethodMultiValue;
import com.orientechnologies.orient.core.sql.functions.conversion.OSQLMethodAsDate;
import com.orientechnologies.orient.core.sql.functions.conversion.OSQLMethodAsDateTime;
import com.orientechnologies.orient.core.sql.functions.conversion.OSQLMethodAsDecimal;
import com.orientechnologies.orient.core.sql.functions.conversion.OSQLMethodConvert;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLMethodExclude;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLMethodInclude;
import com.orientechnologies.orient.core.sql.functions.text.OSQLMethodAppend;
import com.orientechnologies.orient.core.sql.functions.text.OSQLMethodFromJSON;
import com.orientechnologies.orient.core.sql.functions.text.OSQLMethodHash;
import com.orientechnologies.orient.core.sql.functions.text.OSQLMethodLength;
import com.orientechnologies.orient.core.sql.functions.text.OSQLMethodReplace;
import com.orientechnologies.orient.core.sql.functions.text.OSQLMethodRight;
import com.orientechnologies.orient.core.sql.functions.text.OSQLMethodSubString;
import com.orientechnologies.orient.core.sql.functions.text.OSQLMethodToJSON;
import com.orientechnologies.orient.core.sql.method.OSQLMethod;
import com.orientechnologies.orient.core.sql.method.OSQLMethodCharAt;
import com.orientechnologies.orient.core.sql.method.OSQLMethodFactory;
import com.orientechnologies.orient.core.sql.method.OSQLMethodLeft;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAsBoolean;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAsFloat;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAsInteger;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAsList;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAsLong;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAsMap;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAsSet;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodAsString;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodField;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodFormat;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodFunctionDelegate;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodIndexOf;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodJavaType;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodKeys;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodLastIndexOf;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodNormalize;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodPrefix;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodRemove;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodRemoveAll;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodSize;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodSplit;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodToLowerCase;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodToUpperCase;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodTrim;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodType;
import com.orientechnologies.orient.core.sql.method.misc.OSQLMethodValues;
import com.orientechnologies.orient.core.sql.method.sequence.OSQLMethodCurrent;
import com.orientechnologies.orient.core.sql.method.sequence.OSQLMethodNext;
import com.orientechnologies.orient.core.sql.method.sequence.OSQLMethodReset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ODefaultSQLMethodFactory
implements OSQLMethodFactory {
    private final Map<String, Object> methods = new HashMap<String, Object>();

    public ODefaultSQLMethodFactory() {
        this.register("append", new OSQLMethodAppend());
        this.register("asboolean", new OSQLMethodAsBoolean());
        this.register("asdate", new OSQLMethodAsDate());
        this.register("asdatetime", new OSQLMethodAsDateTime());
        this.register("asdecimal", new OSQLMethodAsDecimal());
        this.register("asfloat", new OSQLMethodAsFloat());
        this.register("asinteger", new OSQLMethodAsInteger());
        this.register("aslist", new OSQLMethodAsList());
        this.register("aslong", new OSQLMethodAsLong());
        this.register("asmap", new OSQLMethodAsMap());
        this.register("asset", new OSQLMethodAsSet());
        this.register("asstring", new OSQLMethodAsString());
        this.register("charat", new OSQLMethodCharAt());
        this.register("convert", new OSQLMethodConvert());
        this.register("exclude", new OSQLMethodExclude());
        this.register("field", new OSQLMethodField());
        this.register("format", new OSQLMethodFormat());
        this.register("fromjson", new OSQLMethodFromJSON());
        this.register("function", OSQLMethodFunctionDelegate.class);
        this.register("hash", new OSQLMethodHash());
        this.register("include", new OSQLMethodInclude());
        this.register("indexof", new OSQLMethodIndexOf());
        this.register("javatype", new OSQLMethodJavaType());
        this.register("keys", new OSQLMethodKeys());
        this.register("lastindexof", new OSQLMethodLastIndexOf());
        this.register("left", new OSQLMethodLeft());
        this.register("length", new OSQLMethodLength());
        this.register("multivalue", new OSQLMethodMultiValue());
        this.register("normalize", new OSQLMethodNormalize());
        this.register("prefix", new OSQLMethodPrefix());
        this.register("remove", new OSQLMethodRemove());
        this.register("removeall", new OSQLMethodRemoveAll());
        this.register("replace", new OSQLMethodReplace());
        this.register("right", new OSQLMethodRight());
        this.register("size", new OSQLMethodSize());
        this.register("split", new OSQLMethodSplit());
        this.register("tolowercase", new OSQLMethodToLowerCase());
        this.register("touppercase", new OSQLMethodToUpperCase());
        this.register("trim", new OSQLMethodTrim());
        this.register("type", new OSQLMethodType());
        this.register("substring", new OSQLMethodSubString());
        this.register("tojson", new OSQLMethodToJSON());
        this.register("values", new OSQLMethodValues());
        this.register("current", new OSQLMethodCurrent());
        this.register("next", new OSQLMethodNext());
        this.register("reset", new OSQLMethodReset());
    }

    public void register(String iName, Object iImplementation) {
        this.methods.put(iName.toLowerCase(Locale.ENGLISH), iImplementation);
    }

    @Override
    public boolean hasMethod(String iName) {
        return this.methods.containsKey(iName.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public Set<String> getMethodNames() {
        return this.methods.keySet();
    }

    @Override
    public OSQLMethod createMethod(String name) throws OCommandExecutionException {
        OSQLMethod method;
        Object m4 = this.methods.get(name);
        if (m4 instanceof Class) {
            try {
                method = (OSQLMethod)((Class)m4).newInstance();
            }
            catch (Exception e) {
                throw OException.wrapException(new OCommandExecutionException("Cannot create SQL method: " + m4), e);
            }
        } else {
            method = (OSQLMethod)m4;
        }
        if (method == null) {
            throw new OCommandExecutionException("Unknown method name: " + name);
        }
        return method;
    }
}

