/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OStorageOperationResult<RET>
implements Externalizable {
    private RET result;
    private byte[] modifiedRecordContent;
    private boolean isMoved;

    public OStorageOperationResult() {
    }

    public OStorageOperationResult(RET result) {
        this(result, null, false);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public OStorageOperationResult(RET result, boolean moved) {
        this.result = result;
        this.isMoved = moved;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public OStorageOperationResult(RET result, byte[] content, boolean moved) {
        this.result = result;
        this.modifiedRecordContent = content;
        this.isMoved = moved;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getModifiedRecordContent() {
        return this.modifiedRecordContent;
    }

    public boolean isMoved() {
        return this.isMoved;
    }

    public RET getResult() {
        return this.result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.result);
        out.writeBoolean(this.isMoved);
        if (this.modifiedRecordContent != null) {
            out.writeInt(this.modifiedRecordContent.length);
            out.write(this.modifiedRecordContent);
        } else {
            out.writeInt(-1);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.result = in.readObject();
        this.isMoved = in.readBoolean();
        int modifiedRecordContentLength = in.readInt();
        if (modifiedRecordContentLength > -1) {
            int rb;
            this.modifiedRecordContent = new byte[modifiedRecordContentLength];
            for (int bytesRead = 0; bytesRead < modifiedRecordContentLength && (rb = in.read(this.modifiedRecordContent, bytesRead, modifiedRecordContentLength - bytesRead)) >= 0; bytesRead += rb) {
            }
        }
    }
}

