/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OClientConnectionStats;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import java.io.IOException;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class OServerInfo {
    public static String getServerInfo(OServer server) throws IOException {
        StringWriter jsonBuffer = new StringWriter();
        OJSONWriter json = new OJSONWriter(jsonBuffer);
        json.beginObject();
        OServerInfo.getConnections(server, json, null);
        OServerInfo.getDatabases(server, json);
        OServerInfo.getStorages(server, json);
        OServerInfo.getProperties(server, json);
        OServerInfo.getGlobalProperties(server, json);
        json.endObject();
        return jsonBuffer.toString();
    }

    public static void getConnections(OServer server, OJSONWriter json, String databaseName) throws IOException {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        json.beginCollection(1, true, "connections");
        List<OClientConnection> conns = server.getClientConnectionManager().getConnections();
        for (OClientConnection c : conns) {
            String lastUser;
            String lastDatabase;
            ONetworkProtocolData data = c.getData();
            OClientConnectionStats stats = c.getStats();
            if (databaseName != null && !databaseName.equals(stats.lastDatabase)) continue;
            String lastCommandOn = dateTimeFormat.format(new Date(stats.lastCommandReceived));
            String connectedOn = dateTimeFormat.format(new Date(c.getSince()));
            if (stats.lastDatabase != null && stats.lastUser != null) {
                lastDatabase = stats.lastDatabase;
                lastUser = stats.lastUser;
            } else {
                lastDatabase = data.lastDatabase;
                lastUser = data.lastUser;
            }
            json.beginObject(2);
            OServerInfo.writeField(json, 2, "connectionId", c.getId());
            OServerInfo.writeField(json, 2, "remoteAddress", c.getProtocol().getChannel() != null ? c.getProtocol().getChannel().toString() : "Disconnected");
            OServerInfo.writeField(json, 2, "db", lastDatabase != null ? lastDatabase : "-");
            OServerInfo.writeField(json, 2, "user", lastUser != null ? lastUser : "-");
            OServerInfo.writeField(json, 2, "totalRequests", stats.totalRequests);
            OServerInfo.writeField(json, 2, "commandInfo", data.commandInfo);
            OServerInfo.writeField(json, 2, "commandDetail", data.commandDetail);
            OServerInfo.writeField(json, 2, "lastCommandOn", lastCommandOn);
            OServerInfo.writeField(json, 2, "lastCommandInfo", stats.lastCommandInfo);
            OServerInfo.writeField(json, 2, "lastCommandDetail", stats.lastCommandDetail);
            OServerInfo.writeField(json, 2, "lastExecutionTime", stats.lastCommandExecutionTime);
            OServerInfo.writeField(json, 2, "totalWorkingTime", stats.totalCommandExecutionTime);
            OServerInfo.writeField(json, 2, "connectedOn", connectedOn);
            OServerInfo.writeField(json, 2, "protocol", c.getProtocol().getType());
            OServerInfo.writeField(json, 2, "sessionId", data.sessionId);
            OServerInfo.writeField(json, 2, "clientId", data.clientId);
            StringBuilder driver = new StringBuilder(128);
            if (data.driverName != null) {
                driver.append(data.driverName);
                driver.append(" v");
                driver.append(data.driverVersion);
                driver.append(" Protocol v");
                driver.append(data.protocolVersion);
            }
            OServerInfo.writeField(json, 2, "driver", driver.toString());
            json.endObject(2);
        }
        json.endCollection(1, false);
    }

    public static void getGlobalProperties(OServer server, OJSONWriter json) throws IOException {
        json.beginCollection(2, true, "globalProperties");
        for (OGlobalConfiguration c : OGlobalConfiguration.values()) {
            json.beginObject(3, true, null);
            json.writeAttribute(4, false, "key", c.getKey());
            json.writeAttribute(4, false, "description", c.getDescription());
            json.writeAttribute(4, false, "value", c.isHidden() ? "<hidden>" : c.getValue());
            json.writeAttribute(4, false, "defaultValue", c.getDefValue());
            json.writeAttribute(4, false, "canChange", c.isChangeableAtRuntime());
            json.endObject(3, true);
        }
        json.endCollection(2, true);
    }

    public static void getProperties(OServer server, OJSONWriter json) throws IOException {
        json.beginCollection(2, true, "properties");
        OServerEntryConfiguration[] confProperties = server.getConfiguration().properties;
        if (confProperties != null) {
            for (OServerEntryConfiguration entry : confProperties) {
                json.beginObject(3, true, null);
                json.writeAttribute(4, false, "name", entry.name);
                json.writeAttribute(4, false, "value", entry.value);
                json.endObject(3, true);
            }
        }
        json.endCollection(2, true);
    }

    public static void getStorages(OServer server, OJSONWriter json) throws IOException {
        json.beginCollection(1, true, "storages");
        Collection<OStorage> storages = Orient.instance().getStorages();
        for (OStorage s2 : storages) {
            json.beginObject(2);
            OServerInfo.writeField(json, 2, "name", s2.getName());
            OServerInfo.writeField(json, 2, "type", s2.getClass().getSimpleName());
            OServerInfo.writeField(json, 2, "path", s2 instanceof OLocalPaginatedStorage ? ((OLocalPaginatedStorage)s2).getStoragePath().replace('\\', '/') : "");
            OServerInfo.writeField(json, 2, "activeUsers", "n.a.");
            json.endObject(2);
        }
        json.endCollection(1, false);
    }

    public static void getDatabases(OServer server, OJSONWriter json) throws IOException {
        json.beginCollection(1, true, "dbs");
        if (!server.getDatabasePoolFactory().isClosed()) {
            Collection<OPartitionedDatabasePool> dbPools = server.getDatabasePoolFactory().getPools();
            for (OPartitionedDatabasePool pool : dbPools) {
                OServerInfo.writeField(json, 2, "db", pool.getUrl());
                OServerInfo.writeField(json, 2, "user", pool.getUserName());
                json.endObject(2);
            }
        }
        json.endCollection(1, false);
    }

    private static void writeField(OJSONWriter json, int iLevel, String iAttributeName, Object iAttributeValue) throws IOException {
        json.writeAttribute(iLevel, true, iAttributeName, iAttributeValue != null ? iAttributeValue.toString() : "-");
    }
}

