/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.config;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerConfigurationLoaderXml;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OServerConfigurationManager {
    private final OServerConfigurationLoaderXml configurationLoader;
    private OServerConfiguration configuration;
    private Map<String, OServerUserConfiguration> ephemeralUsers = new ConcurrentHashMap<String, OServerUserConfiguration>();

    public OServerConfigurationManager(InputStream iInputStream) throws IOException {
        this.configurationLoader = new OServerConfigurationLoaderXml(OServerConfiguration.class, iInputStream);
        this.configuration = this.configurationLoader.load();
    }

    public OServerConfigurationManager(File iFile) throws IOException {
        this.configurationLoader = new OServerConfigurationLoaderXml(OServerConfiguration.class, iFile);
        this.configuration = this.configurationLoader.load();
    }

    public OServerConfigurationManager(OServerConfiguration iConfiguration) {
        this.configurationLoader = null;
        this.configuration = iConfiguration;
    }

    public OServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public OServerConfigurationManager setUser(String iServerUserName, String iServerUserPasswd, String iPermissions) {
        if (iServerUserName == null || iServerUserName.length() == 0) {
            throw new IllegalArgumentException("User name is null or empty");
        }
        if (iServerUserPasswd == null) {
            throw new IllegalArgumentException("User password is null or empty");
        }
        if (iPermissions == null || iPermissions.length() == 0) {
            throw new IllegalArgumentException("User permissions is null or empty");
        }
        int userPositionInArray = -1;
        if (this.configuration.users == null) {
            this.configuration.users = new OServerUserConfiguration[1];
            userPositionInArray = 0;
        } else {
            for (int i = 0; i < this.configuration.users.length; ++i) {
                OServerUserConfiguration u = this.configuration.users[i];
                if (u == null || !iServerUserName.equalsIgnoreCase(u.name)) continue;
                userPositionInArray = i;
                break;
            }
            if (userPositionInArray == -1) {
                userPositionInArray = this.configuration.users.length;
                this.configuration.users = Arrays.copyOf(this.configuration.users, this.configuration.users.length + 1);
            }
        }
        this.configuration.users[userPositionInArray] = new OServerUserConfiguration(iServerUserName, iServerUserPasswd, iPermissions);
        return this;
    }

    public void saveConfiguration() throws IOException {
        if (this.configurationLoader == null) {
            return;
        }
        this.configurationLoader.save(this.configuration);
    }

    public OServerUserConfiguration setEphemeralUser(String username, String password, String resources) {
        OServerUserConfiguration userCfg = new OServerUserConfiguration(username, password, resources);
        this.ephemeralUsers.put(username, userCfg);
        return userCfg;
    }

    public OServerUserConfiguration getUser(String iServerUserName) {
        if (iServerUserName == null || iServerUserName.length() == 0) {
            throw new IllegalArgumentException("User name is null or empty");
        }
        this.checkForAutoReloading();
        if (this.configuration.users != null) {
            for (OServerUserConfiguration user : this.configuration.users) {
                if (!iServerUserName.equalsIgnoreCase(user.name)) continue;
                return user;
            }
        }
        for (OServerUserConfiguration user : this.ephemeralUsers.values()) {
            if (!iServerUserName.equalsIgnoreCase(user.name)) continue;
            return user;
        }
        return null;
    }

    public boolean existsUser(String iServerUserName) {
        return this.getUser(iServerUserName) != null;
    }

    public void dropUser(String iServerUserName) {
        if (iServerUserName == null || iServerUserName.length() == 0) {
            throw new IllegalArgumentException("User name is null or empty");
        }
        this.checkForAutoReloading();
        for (int i = 0; i < this.configuration.users.length; ++i) {
            int k;
            OServerUserConfiguration u = this.configuration.users[i];
            if (u == null || !iServerUserName.equalsIgnoreCase(u.name)) continue;
            OServerUserConfiguration[] newArray = new OServerUserConfiguration[this.configuration.users.length - 1];
            for (k = 0; k < i; ++k) {
                newArray[k] = this.configuration.users[k];
            }
            for (k = i; k < newArray.length; ++k) {
                newArray[k] = this.configuration.users[k + 1];
            }
            this.configuration.users = newArray;
            break;
        }
    }

    public Set<OServerUserConfiguration> getUsers() {
        this.checkForAutoReloading();
        HashSet<OServerUserConfiguration> result = new HashSet<OServerUserConfiguration>();
        for (int i = 0; i < this.configuration.users.length; ++i) {
            if (this.configuration.users[i] == null) continue;
            result.add(this.configuration.users[i]);
        }
        for (OServerUserConfiguration user : this.ephemeralUsers.values()) {
            result.add(user);
        }
        return result;
    }

    private void checkForAutoReloading() {
        if (this.configurationLoader != null && this.configurationLoader.checkForAutoReloading()) {
            try {
                this.configuration = this.configurationLoader.load();
            }
            catch (IOException e) {
                throw OException.wrapException(new OConfigurationException("Cannot load server configuration"), e);
            }
        }
    }
}

