/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.conflict;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.conflict.OAbstractDistributedConflictResolver;
import com.orientechnologies.orient.server.distributed.conflict.ODistributedConflictResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OVersionDistributedConflictResolver
extends OAbstractDistributedConflictResolver {
    public static final String NAME = "version";

    @Override
    public ODistributedConflictResolver.OConflictResult onConflict(String databaseName, String clusterName, ORecordId rid, ODistributedServerManager dManager, Map<Object, List<String>> candidates) {
        ODistributedConflictResolver.OConflictResult result = new ODistributedConflictResolver.OConflictResult(candidates);
        if (!candidates.isEmpty()) {
            int maxVersion = -1;
            for (Object v : candidates.keySet()) {
                if (!(v instanceof ORawBuffer) || ((ORawBuffer)v).version <= maxVersion) continue;
                maxVersion = ((ORawBuffer)v).version;
            }
            ArrayList<Object> winners = new ArrayList<Object>();
            for (Object v : candidates.keySet()) {
                if (!(v instanceof ORawBuffer) || ((ORawBuffer)v).version != maxVersion) continue;
                winners.add(v);
            }
            if (winners.size() == 1) {
                result.winner = winners.get(0);
                OLogManager.instance().debug((Object)this, "Version Conflict Resolver decided the value '%s' is the winner for record %s, because its version (%d) is the highest. Servers ok=%s", result.winner, rid, maxVersion, candidates.get(result.winner));
            } else {
                OLogManager.instance().debug((Object)this, "Version Conflict Resolver cannot decide the winner for record %s, because %d records have the highest version %d", rid, winners.size(), maxVersion);
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

