/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.config;

import com.sonatype.nexus.db.migrator.utils.CipherHandler;
import org.sonatype.nexus.crypto.CryptoHelper;
import org.sonatype.nexus.crypto.PbeCipherFactory;
import org.sonatype.nexus.crypto.internal.CryptoHelperImpl;
import org.sonatype.nexus.crypto.internal.MavenCipherImpl;
import org.sonatype.nexus.crypto.internal.PbeCipherFactoryImpl;
import org.sonatype.nexus.crypto.maven.MavenCipher;
import org.sonatype.nexus.security.PasswordHelper;
import org.sonatype.nexus.security.PhraseService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CipherConfig {
    public static final String DEFAULT_CIPHER_PASS = "changeme";
    public static final String DEFAULT_CIPHER_SALT = "changeme";
    public static final String DEFAULT_CIPHER_IV = "0123456789ABCDEF";

    @Bean
    public CryptoHelper cryptoHelper() {
        return new CryptoHelperImpl();
    }

    @Bean
    public PbeCipherFactory pbeCipherFactory() {
        return new PbeCipherFactoryImpl(this.cryptoHelper());
    }

    @Bean
    public PbeCipherFactory.PbeCipher pbeCipher() throws Exception {
        return this.pbeCipherFactory().create("changeme", "changeme", DEFAULT_CIPHER_IV);
    }

    @Bean
    public CipherHandler cipherHandler() throws Exception {
        return new CipherHandler(this.pbeCipher());
    }

    @Bean
    public MavenCipher mavenCipher() {
        return new MavenCipherImpl(this.cryptoHelper());
    }

    @Bean
    public PasswordHelper passwordHelper() {
        return new PasswordHelper(this.mavenCipher(), PhraseService.LEGACY_PHRASE_SERVICE);
    }
}

