/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.config;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sonatype.nexus.db.migrator.config.DatabaseName;
import com.sonatype.nexus.db.migrator.item.record.UpgradeModelVersionsRecord;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class Constants {
    public static final char SLASH = '/';
    public static final String INFO_DELIMITER = "------------------------------------------------------------";
    public static final String JOB_PARAMETER_HEALTH_CHECK = "healthcheck";
    public static final String JOB_PARAMETER_MIGRATION_TYPE = "migration_type";
    public static final String JOB_PARAM_POSTGRES_URL = "db_url";
    public static final String SAVE_MIGRATION_FILES = "save_migration_files";
    public static final String MIGRATION_FILES_FOLDER = "migration_folder";
    public static final String JOB_PARAMETER_CONTENT_MIGRATION = "content_migration";
    public static final String JOB_PARAMETER_EXPORT_JSON = "export_json";
    public static final String JOB_PARAMETER_SHUTDOWN_COMPACT = "shutdown_compact";
    public static final String JOB_PARAMETER_FORCE = "force";
    public static final String JOB_PARAMETER_LOG_INTERVAL_TIME = "log_interval_time";
    public static final String CONTEXT_PARAMETER_TEMP_FOLDER_PATH_PROPERTY_NAME = "temp_folder_path";
    public static final String CONTEXT_PARAMETER_CONFIG_FILE_PROPERTY_NAME = "file_export_config";
    public static final String CONTEXT_PARAMETER_SECURITY_FILE_PROPERTY_NAME = "file_export_security";
    public static final String CONTEXT_PARAMETER_COMPONENT_FILE_PROPERTY_NAME = "file_export_component";
    public static final String ORIENT_TO_H2_MIGRATION_TYPE = "h2";
    public static final String ORIENT_TO_POSTGRES_MIGRATION_TYPE = "postgres";
    public static final String H2_TO_POSTGRES_MIGRATION_TYPE = "h2_to_postgres";
    public static final String POSTGRES_TO_H2_MIGRATION = "postgres_to_h2";
    public static final List<String> SUPPORTED_MIGRATION_TYPES = Arrays.asList("h2", "postgres", "h2_to_postgres", "postgres_to_h2");
    public static final String PROPAGATED_RECORDS_PROPERTY_NAME = "records";
    public static final String NUMBER_OF_RECORDS_TO_PROCESS = "records_number_to_process";
    public static final String NUMBER_OF_SKIPPED_RECORDS = "records_number_skipped";
    public static final String NUMBER_OF_MIGRATED_RECORDS = "records_number_migrated";
    public static final String NUMBER_OF_FILTERED_RECORDS = "records_number_filtered";
    public static final String DB_CONFIG_NAME = "config";
    public static final String DB_SECURITY_NAME = "security";
    public static final String DB_COMPONENT_NAME = "component";
    public static final Set<String> ORIENT_DATABASE_NAMES = ImmutableSet.of("config", "security", "component");
    public static final String NUMBER_OF_COMPONENT_DUPLICATES = "number_component_duplicates";
    public static final String NUMBER_OF_ASSETS_DUPLICATES = "number_asset_duplicates";
    public static final String NUMBER_OF_BROWSE_NODES_DUPLICATES = "number_browse_nodes_duplicates";
    public static final String NUMBER_OF_STORAGE_ERRORS = "number_storage_errors";
    public static final String NUMBER_OF_CLUSTER_CONSISTENCY_ERRORS = "number_cluster_consistency_errors";
    public static final String DB_INTEGRITY_IS_HEALTH = "db_integrity_health";
    public static final String EXPORT_JSON_FILES_STEP_NAME = "exportFilesStep";
    public static final String CHECK_MODEL_VERSIONS_STEP_NAME = "checkModelVersionsStep";
    public static final String READ_FILE_STEP_NAME = "readFileStep";
    public static final String PROCESS_CONFIG_STEP_NAME = "processConfigStep";
    public static final String UNZIP_ARCHIVES_STEP_NAME = "unzipArchivesStep";
    public static final String INIT_DATABASE_STEP_NAME = "initDatabaseStep";
    public static final String FINAL_DATABASE_STEP_NAME = "finalDatabaseStep";
    public static final String PROCESS_TAG_STEP_NAME = "processTagStep";
    public static final String PROCESS_COMPONENT_STEP_NAME = "processComponentStep";
    public static final String PROCESS_REPOSITORY_STEP_NAME = "processRepositoryStep";
    public static final String PROCESS_FULL_DATABASE_STEP_NAME = "processFullDatabase";
    public static final String PROCESS_FULL_DATABASE_FLOW_NAME = "processFullDatabaseFlow";
    public static final String MIGRATE_CONFIG_FROM_H2_TO_POSTGRES_STEP_NAME = "migrateConfigFromH2ToPostgresStep";
    public static final String MIGRATE_TAG_FROM_H2_TO_POSTGRES_STEP_NAME = "migrateTagFromH2ToPostgresStep";
    public static final String MIGRATE_COMPONENT_FROM_H2_TO_POSTGRES_STEP_NAME = "migrateComponentFromH2ToPostgresStep";
    public static final String MIGRATE_CONFIG_FROM_POSTGRES_TO_H2_STEP_NAME = "migrateConfigFromPostgresToH2Step";
    public static final String MIGRATE_TAG_FROM_POSTGRES_TO_H2_STEP_NAME = "migrateTagFromPostgresToH2Step";
    public static final String MIGRATE_COMPONENT_FROM_POSTGRES_TO_H2_STEP_NAME = "migrateComponentFromPostgresToH2Step";
    public static final String CREATE_REBUILD_REPOSITORY_TASKS_STEP_NAME = "createRebuildRepositoryTasksStep";
    public static final String START_HEALTH_CHECK_DECIDER_STEP_NAME = "startHealthCheckDeciderStep";
    public static final String MIGRATE_QUARTZ_JOB_DETAILS_STEP_NAME = "migrateQuartzJobDetailsStep";
    public static final String MIGRATE_QUARTZ_JOB_TRIGGERS_STEP_NAME = "migrateQuartzJobTriggersStep";
    public static final String MIGRATE_QUARTZ_JOB_CALENDARS_STEP_NAME = "migrateQuartzJobCalendarsStep";
    public static final String MIGRATE_USERS_STEP_NAME = "migrateUsersStep";
    public static final String MIGRATE_USER_ROLE_MAPPINGS_STEP_NAME = "migrateUserRoleMappingsStep";
    public static final String MIGRATE_ANONYMOUS_CONFIGURATION_STEP_NAME = "migrateAnonymousConfigurationStep";
    public static final String MIGRATE_PRIVILEGES_STEP_NAME = "migratePrivilegesStep";
    public static final String MIGRATE_ROLES_STEP_NAME = "migrateRolesStep";
    public static final String MIGRATE_EMAIL_CONFIGURATION_STEP_NAME = "migrateEmailConfigurationStep";
    public static final String MIGRATE_HTTP_CLIENT_CONFIGURATION_STEP_NAME = "migrateHttpClientConfigurationStep";
    public static final String MIGRATE_REALM_CONFIGURATION_STEP_NAME = "migrateRealmConfigurationStep";
    public static final String MIGRATE_DEPLOYMENT_IDENTIFIER_STEP_NAME = "migrateDeploymentIdentifierStep";
    public static final String MIGRATE_SCRIPTS_STEP_NAME = "migrateScriptsStep";
    public static final String MIGRATE_HEALTH_CHECK_CONFIGURATION_STEP_NAME = "migrateHealthCheckConfigurationStep";
    public static final String MIGRATE_KEY_STORE_STEP_NAME = "migrateKeyStoreStep";
    public static final String MIGRATE_LDAP_CONFIGURATION_STEP_NAME = "migrateLdapConfigurationStep";
    public static final String MIGRATE_SAML_CONFIGURATION_STEP_NAME = "migrateSamlConfigurationStep";
    public static final String MIGRATE_SAML_USERS_STEP_NAME = "migrateSamlUsersStep";
    public static final String MIGRATE_CAPABILITIES_STEP_NAME = "migrateCapabilitiesStep";
    public static final String MIGRATE_CLEANUP_POLICIES_STEP_NAME = "migrateCleanupPoliciesStep";
    public static final String MIGRATE_CONTENT_SELECTORS_STEP_NAME = "migrateContentSelectorsStep";
    public static final String MIGRATE_API_KEYS_STEP_NAME = "migrateApiKeysStep";
    public static final String MIGRATE_REPOSITORIES_STEP_NAME = "migrateRepositoriesStep";
    public static final String MIGRATE_ROUTING_RULES_STEP_NAME = "migrateRoutingRulesStep";
    public static final String MIGRATE_BLOB_STORES_STEP_NAME = "migrateBlobStoresStep";
    public static final String MIGRATE_BUCKETS_STEP_NAME = "migrateBucketsStep";
    public static final String MIGRATE_TAGS_STEP_NAME = "migrateTagsStep";
    public static final String MIGRATE_COMPONENTS_STEP_NAME = "migrateComponentsStep";
    public static final String MIGRATE_ASSETS_STEP_NAME = "migrateAssetsStep";
    public static final String MIGRATE_DOCKER_FOREIGN_LAYERS_STEP_NAME = "migrateDockerForeignLayersStep";
    public static final String MIGRATE_DELETED_BLOB_INDEX_STEP_NAME = "migrateDeletedBlobIndexStep";
    public static final String HEALTH_CHECK_STEP_NAME = "startHealthCheckStep";
    public static final String MIGRATION_FROM_ORIENT_JOB_NAME = "migrationFromOrientJob";
    public static final String MIGRATION_FROM_ORIENT_NO_EXPORT_JSON_JOB_NAME = "migrationFromOrientNoExportJSONJob";
    public static final String MIGRATION_FROM_H2_TO_POSTGRES_JOB_NAME = "migrationFromH2ToPostgresJob";
    public static final String MIGRATION_FROM_POSTGRES_TO_H2_JOB_NAME = "migrationFromPostgresToH2Job";
    public static final String JOB_STATUS_COMPLETED = "COMPLETED";
    public static final String JOB_STATUS_FAILED = "FAILED";
    public static final String DECISION_HEALTH_CHECK_START = "DECISION_HEALTH_CHECK_START";
    public static final String DECISION_HEALTH_CHECK_SKIP = "DECISION_HEALTH_CHECK_SKIP";
    public static final UpgradeModelVersionsRecord SUPPORTED_MODEL_VERSIONS = UpgradeModelVersionsRecord.builder().configVersion("1.10").securityVersion("1.4").componentVersion("1.16").healthCheckVersion("1.1").userTokenVersion("1.5").tagsVersion("1.1").build();
    public static final String SEPARATOR = System.getProperty("file.separator");
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final String TEMP_FOLDER_PREFIX = "export_json-";
    public static final String DEFAULT_USERNAME_PASS = "admin";
    public static final int MIN_AVAILABLE_MEMORY_GB = 10;
    public static final String MISSING_TABLES = "missingTables";
    public static final Set<String> REALMS_TO_SKIP = ImmutableSet.of();
    public static final String ORIENT_COMPONENT_DIRECTORY_NAME = DatabaseName.COMPONENT.toString();
    public static final String ORIENT_CONFIG_DIRECTORY_NAME = DatabaseName.CONFIG.toString();
    public static final String ORIENT_SECURITY_DIRECTORY_NAME = DatabaseName.SECURITY.toString();
    public static final Set<String> ORIENT_REQUIRED_DIRECTORIES = Collections.unmodifiableSet(Sets.newHashSet(ORIENT_COMPONENT_DIRECTORY_NAME, ORIENT_CONFIG_DIRECTORY_NAME, ORIENT_SECURITY_DIRECTORY_NAME));

    public static boolean isPostgresMigration(String migrationType) {
        return ORIENT_TO_POSTGRES_MIGRATION_TYPE.equals(migrationType) || H2_TO_POSTGRES_MIGRATION_TYPE.equals(migrationType) || POSTGRES_TO_H2_MIGRATION.equals(migrationType);
    }

    private Constants() {
    }
}

