/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.config;

import com.sonatype.nexus.db.migrator.condition.H2DestinationCondition;
import com.sonatype.nexus.db.migrator.condition.H2MigrationCondition;
import com.sonatype.nexus.db.migrator.condition.H2SourceCondition;
import com.sonatype.nexus.db.migrator.condition.InvalidMigrationTypeCondition;
import com.sonatype.nexus.db.migrator.condition.PostgresDestinationCondition;
import com.sonatype.nexus.db.migrator.condition.PostgresMigrationCondition;
import com.sonatype.nexus.db.migrator.condition.PostgresSourceCondition;
import com.sonatype.nexus.db.migrator.condition.SQLDestinationCondition;
import com.sonatype.nexus.db.migrator.condition.SQLSourceCondition;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseBuilder;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;

@Configuration
@EnableAutoConfiguration(exclude={DataSourceAutoConfiguration.class})
public class DataSourceConfig {
    @Bean
    @Primary
    @ConfigurationProperties(prefix="h2.datasource")
    public DataSourceProperties h2DataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean(value={"h2DataSource"})
    @Conditional(value={H2MigrationCondition.class})
    public DataSource h2DataSource() {
        return this.h2DataSourceProperties().initializeDataSourceBuilder().username("").password("").build();
    }

    @Bean(value={"postgresDataSource"})
    @Conditional(value={PostgresMigrationCondition.class})
    public DataSource postgresConfigDataSource(@Value(value="${db_url:#{null}}") String url) {
        return this.initPostgresDataSource(url);
    }

    @Bean(value={"sourceDataSource"})
    @Conditional(value={H2SourceCondition.class})
    public DataSource sourceDataSourceForH2(@Qualifier(value="h2DataSource") DataSource h2DataSource) {
        return h2DataSource;
    }

    @Bean(value={"sourceDataSource"})
    @Conditional(value={PostgresSourceCondition.class})
    public DataSource sourceDataSourceForPostgres(@Qualifier(value="postgresDataSource") DataSource postgresDataSource) {
        return postgresDataSource;
    }

    @Bean(value={"destinationDataSource"})
    @Primary
    @Conditional(value={H2DestinationCondition.class})
    public DataSource destinationDataSourceForH2(@Qualifier(value="h2DataSource") DataSource h2DataSource) {
        return h2DataSource;
    }

    @Bean(value={"destinationDataSource"})
    @Primary
    @Conditional(value={PostgresDestinationCondition.class})
    public DataSource destinationDataSourceForPostgres(@Qualifier(value="postgresDataSource") DataSource postgresDataSource) {
        return postgresDataSource;
    }

    @Bean(value={"sourceJdbcTemplate"})
    @Conditional(value={SQLSourceCondition.class})
    public JdbcTemplate sourceJdbcTemplate(@Qualifier(value="sourceDataSource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Bean(value={"destinationJdbcTemplate"})
    @Conditional(value={SQLDestinationCondition.class})
    public JdbcTemplate destinationJdbcTemplate(@Qualifier(value="destinationDataSource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Bean(value={"destinationDataSource"})
    @Primary
    @Conditional(value={InvalidMigrationTypeCondition.class})
    public DataSource defaultDataSource() {
        return new EmbeddedDatabaseBuilder().setType(EmbeddedDatabaseType.H2).build();
    }

    @Bean(value={"destinationJdbcTemplate"})
    @Conditional(value={InvalidMigrationTypeCondition.class})
    public JdbcTemplate invalidJdbcTemplate(@Qualifier(value="destinationDataSource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    private DataSource initPostgresDataSource(String url) {
        if (url == null) {
            return new EmbeddedDatabaseBuilder().setType(EmbeddedDatabaseType.H2).build();
        }
        return DataSourceBuilder.create().url(url).build();
    }
}

