/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.config;

import com.sonatype.nexus.db.migrator.MigratorApplication;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public enum Format {
    RAW(true),
    MAVEN2(true),
    NUGET(true),
    HELM(true),
    DOCKER(true),
    PYPI(true),
    YUM(true),
    NPM(true),
    APT(true),
    CONDA(true),
    CONAN(true),
    R(true),
    GITLFS(true),
    COCOAPODS(true),
    RUBYGEMS(true),
    GO(true),
    P2(true);

    public static final List<String> SUPPORTED_FORMAT_NAMES;
    private final boolean isEarlyAccessFormat;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNotSupportedFormat(String format) {
        if (format == null) return true;
        if (!SUPPORTED_FORMAT_NAMES.stream().noneMatch(format::equalsIgnoreCase)) return false;
        return true;
    }

    @Generated
    public boolean isEarlyAccessFormat() {
        return this.isEarlyAccessFormat;
    }

    @Generated
    private Format(boolean isEarlyAccessFormat) {
        this.isEarlyAccessFormat = isEarlyAccessFormat;
    }

    static {
        SUPPORTED_FORMAT_NAMES = EnumSet.allOf(Format.class).stream().filter(e -> MigratorApplication.isDevMigration() || e.isEarlyAccessFormat()).map(Enum::name).sorted().collect(Collectors.toList());
    }
}

