/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.config;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.sonatype.nexus.db.migrator.config.Constants;
import com.sonatype.nexus.db.migrator.exception.WrongNxrmEditionException;
import com.sonatype.nexus.db.migrator.exception.WrongSchemaVersionException;
import com.sonatype.nexus.db.migrator.item.export.ExportItem;
import com.sonatype.nexus.db.migrator.item.record.UpgradeModelVersionsRecord;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaVersionsValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemaVersionsValidator.class);
    public static final String NO_VERSIONS_ERROR_MESSAGE = "Upgrade model versions are missing! Migration cannot be continued. Please make sure that you're using the latest migrator and Nexus Repository versions and re-run the job.";

    public void checkUpgradeModelVersion(ExportItem configExportItem, String migrationType) throws WrongSchemaVersionException, WrongNxrmEditionException {
        UpgradeModelVersionsRecord upgradeModelVersion = (UpgradeModelVersionsRecord)configExportItem.getRecords().stream().filter(UpgradeModelVersionsRecord.class::isInstance).reduce((first, second) -> second).orElseThrow(() -> new IllegalStateException(NO_VERSIONS_ERROR_MESSAGE));
        this.raiseUnsupportedModelVersion(migrationType, upgradeModelVersion);
    }

    public void checkUpgradeModelVersion(ODatabaseDocument configDatabase, String migrationType, ObjectMapper mapper) throws WrongSchemaVersionException, WrongNxrmEditionException {
        ORecordIteratorClass<ODocument> configModelIter = configDatabase.browseClass("upgrade_model_versions");
        try {
            UpgradeModelVersionsRecord upgradeModelVersion = mapper.readValue(((ODocument)configModelIter.next()).getRecord().toJSON(), UpgradeModelVersionsRecord.class);
            this.raiseUnsupportedModelVersion(migrationType, upgradeModelVersion);
        }
        catch (JacksonException ex) {
            log.warn("Unable to determine current Database Model versions directly. Will check after export");
        }
    }

    private void raiseUnsupportedModelVersion(String migrationType, UpgradeModelVersionsRecord upgradeModelVersion) throws WrongNxrmEditionException, WrongSchemaVersionException {
        if (!upgradeModelVersion.equals(Constants.SUPPORTED_MODEL_VERSIONS)) {
            if (upgradeModelVersion.getUserTokenVersion() == null || upgradeModelVersion.getTagsVersion() == null) {
                log.warn("Missing some schema configurations. Suspecting Nexus Repository Manager to be an OSS instance.");
                if (!"h2".equals(migrationType)) {
                    throw new WrongNxrmEditionException();
                }
            } else {
                throw new WrongSchemaVersionException(upgradeModelVersion);
            }
        }
    }
}

