/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.config;

import com.sonatype.nexus.db.migrator.entity.AnonymousConfigurationEntity;
import com.sonatype.nexus.db.migrator.entity.ApiKeyEntity;
import com.sonatype.nexus.db.migrator.entity.AssetEntity;
import com.sonatype.nexus.db.migrator.entity.AzureDeletedBlobEntity;
import com.sonatype.nexus.db.migrator.entity.BlobStoreEntity;
import com.sonatype.nexus.db.migrator.entity.CapabilityEntity;
import com.sonatype.nexus.db.migrator.entity.ChangeBlobstoreEntity;
import com.sonatype.nexus.db.migrator.entity.CleanupPolicyEntity;
import com.sonatype.nexus.db.migrator.entity.ComponentEntity;
import com.sonatype.nexus.db.migrator.entity.ComponentTagEntity;
import com.sonatype.nexus.db.migrator.entity.ContentRepositoryEntity;
import com.sonatype.nexus.db.migrator.entity.DeploymentIdEntity;
import com.sonatype.nexus.db.migrator.entity.DockerForeignLayerEntity;
import com.sonatype.nexus.db.migrator.entity.EmailEntity;
import com.sonatype.nexus.db.migrator.entity.Entity;
import com.sonatype.nexus.db.migrator.entity.FirewallIgnorePatternEntity;
import com.sonatype.nexus.db.migrator.entity.HealthCheckConfigEntity;
import com.sonatype.nexus.db.migrator.entity.HttpClientEntity;
import com.sonatype.nexus.db.migrator.entity.KeyStoreDataEntity;
import com.sonatype.nexus.db.migrator.entity.LdapConfigurationEntity;
import com.sonatype.nexus.db.migrator.entity.MavenComponentEntity;
import com.sonatype.nexus.db.migrator.entity.PrivilegeEntity;
import com.sonatype.nexus.db.migrator.entity.QuartzCalendarEntity;
import com.sonatype.nexus.db.migrator.entity.QuartzJobDetailEntity;
import com.sonatype.nexus.db.migrator.entity.QuartzTriggerEntity;
import com.sonatype.nexus.db.migrator.entity.RealmEntity;
import com.sonatype.nexus.db.migrator.entity.ReplicationConnectionEntity;
import com.sonatype.nexus.db.migrator.entity.RepositoryEntity;
import com.sonatype.nexus.db.migrator.entity.RoleEntity;
import com.sonatype.nexus.db.migrator.entity.RoutingRuleEntity;
import com.sonatype.nexus.db.migrator.entity.SamlConfigurationEntity;
import com.sonatype.nexus.db.migrator.entity.SamlUserEntity;
import com.sonatype.nexus.db.migrator.entity.ScriptEntity;
import com.sonatype.nexus.db.migrator.entity.SelectorEntity;
import com.sonatype.nexus.db.migrator.entity.TagEntity;
import com.sonatype.nexus.db.migrator.entity.UserEntity;
import com.sonatype.nexus.db.migrator.entity.UserRoleMappingEntity;
import com.sonatype.nexus.db.migrator.entity.UserTokenEntity;
import com.sonatype.nexus.db.migrator.item.record.UpgradeModelVersionsRecord;
import com.sonatype.nexus.db.migrator.property.AbstractInsertScripts;
import com.sonatype.nexus.db.migrator.utils.SqlUtils;
import com.sonatype.nexus.db.migrator.writer.AssetAndAssetBlobWriter;
import com.sonatype.nexus.db.migrator.writer.ComponentTagWriter;
import com.sonatype.nexus.db.migrator.writer.ComponentWriter;
import com.sonatype.nexus.db.migrator.writer.CompositeQuartzTriggerWriter;
import com.sonatype.nexus.db.migrator.writer.ContentRepositoryWriter;
import com.sonatype.nexus.db.migrator.writer.TagWriter;
import com.sonatype.nexus.db.migrator.writer.WriterSkipPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.BeanPropertyItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.JdbcBatchItemWriter;
import org.springframework.batch.item.database.builder.JdbcBatchItemWriterBuilder;
import org.springframework.batch.item.support.builder.ClassifierCompositeItemWriterBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.classify.SubclassClassifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WriterConfig {
    private DataSource dataSource;
    private AbstractInsertScripts insertScriptProperties;

    @Bean
    public ItemWriter<Entity> configWriter() {
        SubclassClassifier<? extends Entity, ItemWriter<? super Entity>> classifier = new SubclassClassifier<Entity, ItemWriter<? super Entity>>();
        classifier.setTypeMap(this.configWriterTypeMap());
        return new ClassifierCompositeItemWriterBuilder<Entity>().classifier(classifier).build();
    }

    @Bean
    public ItemWriter<Entity> tagsWriter() {
        SubclassClassifier<TagEntity, ItemWriter<Entity>> classifier = new SubclassClassifier<TagEntity, ItemWriter<Entity>>();
        classifier.setTypeMap(Collections.singletonMap(TagEntity.class, this.tagWriter()));
        return new ClassifierCompositeItemWriterBuilder<Entity>().classifier(classifier).build();
    }

    @Bean
    public ItemWriter<Entity> componentWriter() {
        SubclassClassifier<? extends Entity, ItemWriter<? super Entity>> classifier = new SubclassClassifier<Entity, ItemWriter<? super Entity>>();
        classifier.setTypeMap(this.componentWriterTypeMap());
        return new ClassifierCompositeItemWriterBuilder<Entity>().classifier(classifier).build();
    }

    @Bean
    public Map<Class<? extends Entity>, ItemWriter<? super Entity>> configWriterTypeMap() {
        HashMap<Class<? extends Entity>, ItemWriter<? super Entity>> typeMap = new HashMap<Class<? extends Entity>, ItemWriter<? super Entity>>();
        typeMap.put(DeploymentIdEntity.class, this.deploymentIdWriter());
        typeMap.put(CapabilityEntity.class, this.capabilityWriter());
        typeMap.put(LdapConfigurationEntity.class, this.ldapConfigurationWriter());
        typeMap.put(SamlConfigurationEntity.class, this.samlConfigurationWriter());
        typeMap.put(SamlUserEntity.class, this.samlUserWriter());
        typeMap.put(UserEntity.class, this.userWriter());
        typeMap.put(RoutingRuleEntity.class, this.routingRuleWriter());
        typeMap.put(RepositoryEntity.class, this.repositoryWriter());
        typeMap.put(BlobStoreEntity.class, this.blobStoreWriter());
        typeMap.put(QuartzJobDetailEntity.class, this.quartzJobDetailWriter());
        typeMap.put(QuartzTriggerEntity.class, this.compositeQuartzTriggerWriter());
        typeMap.put(QuartzCalendarEntity.class, this.quartzCalendarWriter());
        typeMap.put(RealmEntity.class, this.realmWriter());
        typeMap.put(RoleEntity.class, this.roleWriter());
        typeMap.put(UserRoleMappingEntity.class, this.userRoleMappingWriter());
        typeMap.put(EmailEntity.class, this.emailWriter());
        typeMap.put(CleanupPolicyEntity.class, this.cleanupPolicyWriter());
        typeMap.put(FirewallIgnorePatternEntity.class, this.firewallIgnorePatternWriter());
        typeMap.put(PrivilegeEntity.class, this.privilegeWriter());
        typeMap.put(HttpClientEntity.class, this.httpClientWriter());
        typeMap.put(SelectorEntity.class, this.selectorWriter());
        typeMap.put(ScriptEntity.class, this.scriptWriter());
        typeMap.put(AnonymousConfigurationEntity.class, this.anonymousConfigurationWriter());
        typeMap.put(KeyStoreDataEntity.class, this.keyStoreDataWriter());
        typeMap.put(ApiKeyEntity.class, this.apiKeyWriter());
        typeMap.put(UserTokenEntity.class, this.userTokenWriter());
        typeMap.put(HealthCheckConfigEntity.class, this.healthCheckConfigWriter());
        typeMap.put(UpgradeModelVersionsRecord.class, this.noopItemWriter());
        typeMap.put(ReplicationConnectionEntity.class, this.replicationConnectionWriter());
        typeMap.put(ChangeBlobstoreEntity.class, this.changeBlobstoreWriter());
        return typeMap;
    }

    @Bean
    public Map<Class<? extends Entity>, ItemWriter<? super Entity>> componentWriterTypeMap() {
        HashMap<Class<? extends Entity>, ItemWriter<? super Entity>> typeMap = new HashMap<Class<? extends Entity>, ItemWriter<? super Entity>>();
        typeMap.put(ContentRepositoryEntity.class, this.contentRepositoryWriter());
        typeMap.put(ComponentEntity.class, this.componentItemWriter());
        typeMap.put(MavenComponentEntity.class, this.mavenComponentItemWriter());
        typeMap.put(AssetEntity.class, this.assetAndAssetBlobWriter());
        typeMap.put(DockerForeignLayerEntity.class, this.dockerForeignLayerWriter());
        typeMap.put(AzureDeletedBlobEntity.class, this.azureDeletedBlobWriter());
        typeMap.put(ComponentTagEntity.class, this.componentTagWriter());
        return typeMap;
    }

    @Bean
    public ItemWriter<Entity> deploymentIdWriter() {
        return this.buildWriter(this.insertScriptProperties.getDeploymentId());
    }

    @Bean
    public ItemWriter<Entity> capabilityWriter() {
        return this.buildWriter(this.insertScriptProperties.getCapability());
    }

    @Bean
    public ItemWriter<Entity> ldapConfigurationWriter() {
        return this.buildWriter(this.insertScriptProperties.getLdapConfiguration());
    }

    @Bean
    public ItemWriter<Entity> routingRuleWriter() {
        return this.buildWriter(this.insertScriptProperties.getRoutingRule());
    }

    @Bean
    public ItemWriter<Entity> userWriter() {
        return this.buildWriter(this.insertScriptProperties.getUser());
    }

    @Bean
    public ItemWriter<Entity> replicationConnectionWriter() {
        return this.buildWriter(this.insertScriptProperties.getReplicationConnection());
    }

    @Bean
    public ItemWriter<Entity> changeBlobstoreWriter() {
        return this.buildWriter(this.insertScriptProperties.getChangeBlobstore());
    }

    @Bean
    public ItemWriter<Entity> repositoryWriter() {
        return this.buildWriter(this.insertScriptProperties.getRepository());
    }

    @Bean
    public ItemWriter<Entity> blobStoreWriter() {
        return this.buildWriter(this.insertScriptProperties.getBlobStore());
    }

    @Bean
    public ItemWriter<Entity> quartzJobDetailWriter() {
        return this.buildWriter(this.insertScriptProperties.getQuartzJobDetail());
    }

    @Bean
    public ItemWriter<Entity> quartzCalendarWriter() {
        return this.buildWriter(this.insertScriptProperties.getQuartzCalendar());
    }

    @Bean
    public ItemWriter<Entity> compositeQuartzTriggerWriter() {
        return new CompositeQuartzTriggerWriter(this.quartzTriggerWriter(), this.quartzSimpleTriggerWriter(), this.quartzCronTriggerWriter());
    }

    @Bean
    public ItemWriter<Entity> quartzTriggerWriter() {
        return this.buildWriter(this.insertScriptProperties.getQuartzTrigger());
    }

    @Bean
    public ItemWriter<Entity> quartzSimpleTriggerWriter() {
        return this.buildWriter(this.insertScriptProperties.getQuartzSimpleTrigger());
    }

    @Bean
    public ItemWriter<Entity> quartzCronTriggerWriter() {
        return this.buildWriter(this.insertScriptProperties.getQuartzCronTrigger());
    }

    @Bean
    public ItemWriter<Entity> realmWriter() {
        return this.buildWriter(this.insertScriptProperties.getRealm());
    }

    @Bean
    public ItemWriter<Entity> roleWriter() {
        return this.buildWriter(this.insertScriptProperties.getRole());
    }

    @Bean
    public ItemWriter<Entity> userRoleMappingWriter() {
        return this.buildWriter(this.insertScriptProperties.getUserRoleMapping());
    }

    @Bean
    public ItemWriter<Entity> emailWriter() {
        return this.buildWriter(this.insertScriptProperties.getEmail());
    }

    @Bean
    public ItemWriter<Entity> cleanupPolicyWriter() {
        return this.buildWriter(this.insertScriptProperties.getCleanupPolicy());
    }

    @Bean
    public ItemWriter<Entity> firewallIgnorePatternWriter() {
        return this.buildWriter(this.insertScriptProperties.getFirewallIgnorePattern());
    }

    @Bean
    public ItemWriter<Entity> privilegeWriter() {
        return this.buildWriter(this.insertScriptProperties.getPrivilege());
    }

    @Bean
    public ItemWriter<Entity> httpClientWriter() {
        return this.buildWriter(this.insertScriptProperties.getHttpClient());
    }

    @Bean
    public ItemWriter<Entity> selectorWriter() {
        return this.buildWriter(this.insertScriptProperties.getSelector());
    }

    @Bean
    public ItemWriter<Entity> scriptWriter() {
        return this.buildWriter(this.insertScriptProperties.getScript());
    }

    @Bean
    public ItemWriter<Entity> anonymousConfigurationWriter() {
        return this.buildWriter(this.insertScriptProperties.getAnonymousConfiguration());
    }

    @Bean
    public ItemWriter<Entity> keyStoreDataWriter() {
        return this.buildWriter(this.insertScriptProperties.getKeyStoreData());
    }

    @Bean
    public ItemWriter<Entity> apiKeyWriter() {
        return this.buildWriter(this.insertScriptProperties.getApiKey());
    }

    @Bean
    public ItemWriter<Entity> userTokenWriter() {
        return this.buildWriter(this.insertScriptProperties.getUserToken());
    }

    @Bean
    public ItemWriter<Entity> healthCheckConfigWriter() {
        return this.buildWriter(this.insertScriptProperties.getHealthCheckConfig());
    }

    @Bean
    public ItemWriter<Entity> samlConfigurationWriter() {
        return this.buildWriter(this.insertScriptProperties.getSamlConfiguration());
    }

    @Bean
    public ItemWriter<Entity> samlUserWriter() {
        return this.buildWriter(this.insertScriptProperties.getSamlUser());
    }

    @Bean
    public ItemWriter<Entity> contentRepositoryWriter() {
        return new ContentRepositoryWriter(this.contentRepositoryJdbcWriter(), SqlUtils.readSqlFromFile(this.insertScriptProperties.getContentRepository()));
    }

    @Bean
    public ItemWriter<Entity> componentItemWriter() {
        return new ComponentWriter(this.componentJdbcWriter(), SqlUtils.readSqlFromFile(this.insertScriptProperties.getComponent()), this.componentTagJdbcWriter(), SqlUtils.readSqlFromFile(this.insertScriptProperties.getComponentTag()));
    }

    @Bean
    public ItemWriter<Entity> mavenComponentItemWriter() {
        return new ComponentWriter(this.componentJdbcWriter(), SqlUtils.readSqlFromFile(this.insertScriptProperties.getMaven2Component()), this.componentTagJdbcWriter(), SqlUtils.readSqlFromFile(this.insertScriptProperties.getComponentTag()));
    }

    @Bean
    public ItemWriter<Entity> assetAndAssetBlobWriter() {
        return new AssetAndAssetBlobWriter(this.assetWriter(), this.assetBlobWriter(), SqlUtils.readSqlFromFile(this.insertScriptProperties.getAsset()), SqlUtils.readSqlFromFile(this.insertScriptProperties.getAssetBlob()));
    }

    @Bean
    public JdbcBatchItemWriter<Entity> contentRepositoryJdbcWriter() {
        return this.buildWriter(this.insertScriptProperties.getContentRepository());
    }

    @Bean
    public JdbcBatchItemWriter<Entity> componentJdbcWriter() {
        return this.buildWriter(this.insertScriptProperties.getComponent());
    }

    @Bean
    public ItemWriter<Entity> componentTagWriter() {
        return new ComponentTagWriter(this.componentTagJdbcWriter(), SqlUtils.readSqlFromFile(this.insertScriptProperties.getComponentTag()));
    }

    @Bean
    public JdbcBatchItemWriter<Entity> assetWriter() {
        return this.buildWriter(this.insertScriptProperties.getAsset());
    }

    @Bean
    public JdbcBatchItemWriter<Entity> assetBlobWriter() {
        return this.buildWriter(this.insertScriptProperties.getAssetBlob());
    }

    @Bean
    public JdbcBatchItemWriter<Entity> componentTagJdbcWriter() {
        return this.buildWriter(this.insertScriptProperties.getComponentTag());
    }

    @Bean
    public JdbcBatchItemWriter<Entity> dockerForeignLayerWriter() {
        return this.buildWriter(this.insertScriptProperties.getDockerForeignLayers());
    }

    @Bean
    public JdbcBatchItemWriter<Entity> azureDeletedBlobWriter() {
        return this.buildWriter(this.insertScriptProperties.getAzureDeletedBlobs());
    }

    @Bean
    public JdbcBatchItemWriter<Entity> tagJdbcWriter() {
        return this.buildWriter(this.insertScriptProperties.getTag());
    }

    @Bean
    public ItemWriter<Entity> tagWriter() {
        return new TagWriter(this.tagJdbcWriter());
    }

    @Bean
    public BeanPropertyItemSqlParameterSourceProvider<Entity> itemSqlParameterSourceProvider() {
        return new BeanPropertyItemSqlParameterSourceProvider<Entity>();
    }

    @Bean
    public WriterSkipPolicy writerSkipPolicy() {
        return new WriterSkipPolicy();
    }

    @Autowired
    @Qualifier(value="destinationDataSource")
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Autowired
    public void setInsertScriptProperties(AbstractInsertScripts insertScriptProperties) {
        this.insertScriptProperties = insertScriptProperties;
    }

    private JdbcBatchItemWriter<Entity> buildWriter(String insertScript) {
        return new JdbcBatchItemWriterBuilder<Entity>().itemSqlParameterSourceProvider(this.itemSqlParameterSourceProvider()).sql(SqlUtils.readSqlFromFile(insertScript)).dataSource(this.dataSource).build();
    }

    @Bean
    public ItemWriter<Entity> noopItemWriter() {
        return items -> {};
    }
}

