/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.decider;

import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.JobExecutionDecider;

public class HealthCheckJobDecider
implements JobExecutionDecider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthCheckJobDecider.class);

    @Override
    public FlowExecutionStatus decide(JobExecution jobExecution, StepExecution stepExecution) {
        Map<String, JobParameter> jobParameters = ConvertUtils.convertJobParametersToMap(jobExecution.getJobParameters());
        boolean runInHealthCheckMode = jobParameters.containsKey("healthcheck");
        String executionStatus = "DECISION_HEALTH_CHECK_SKIP";
        if (runInHealthCheckMode) {
            executionStatus = "DECISION_HEALTH_CHECK_START";
        }
        return new FlowExecutionStatus(executionStatus);
    }
}

