/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.exception;

import java.io.File;
import org.springframework.batch.core.JobParametersInvalidException;

public class InvalidMigrationFilesException
extends JobParametersInvalidException {
    public static final String ERROR_MESSAGE = "The migration files in %s do not match the expected requirements";

    public InvalidMigrationFilesException(File path, String supplemental) {
        super(InvalidMigrationFilesException.formatMessage(path, supplemental));
    }

    private static String formatMessage(File path, String supplemental) {
        if (supplemental == null) {
            return String.format("The migration files in %s do not match the expected requirements.", path);
        }
        return String.format("The migration files in %s do not match the expected requirements: " + supplemental, path);
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }
}

