/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.export;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.compression.OCompressionFactory;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.tool.ODatabaseExport;
import com.sonatype.nexus.db.migrator.config.Constants;
import com.sonatype.nexus.db.migrator.config.DatabaseName;
import com.sonatype.nexus.db.migrator.config.SchemaVersionsValidator;
import com.sonatype.nexus.db.migrator.exception.NotEnoughDiskSpaceException;
import com.sonatype.nexus.db.migrator.exception.WrongNxrmEditionException;
import com.sonatype.nexus.db.migrator.exception.WrongSchemaVersionException;
import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import com.sonatype.nexus.db.migrator.utils.MigrationFilesPathQualifier;
import com.sonatype.nexus.db.migrator.utils.PathQualifier;
import com.sonatype.nexus.db.migrator.utils.SpaceChecker;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ScheduledFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.crypto.PbeCipherFactory;
import org.sonatype.nexus.orient.entity.ConflictHook;
import org.sonatype.nexus.orient.internal.PbeCompression;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.TaskScheduler;

@StepScope
public class JsonFilesExporter
implements Tasklet,
StepExecutionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonFilesExporter.class);
    private String orientFolderPath;
    private String migrationFilesFolderPath;
    private String tempFolderPath;
    private String configFilePath;
    private String securityFilePath;
    private String componentsFilePath;
    private boolean componentMigration;
    private PbeCipherFactory pbeCipherFactory;
    private PathQualifier pathQualifier;
    private MigrationFilesPathQualifier migrationFilesPathQualifier;
    @Autowired
    private TaskScheduler taskScheduler;
    private ScheduledFuture<?> progressTask;
    private SchemaVersionsValidator versionsValidator;
    private String migrationType;
    private ObjectMapper mapper;

    @Autowired
    public void setPbeCipherFactory(PbeCipherFactory pbeCipherFactory) {
        this.pbeCipherFactory = pbeCipherFactory;
    }

    @Autowired
    public void setPathQualifier(PathQualifier pathQualifier) {
        this.pathQualifier = pathQualifier;
    }

    @Autowired
    public void setMigrationFilesPathQualifier(MigrationFilesPathQualifier migrationFilesPathQualifier) {
        this.migrationFilesPathQualifier = migrationFilesPathQualifier;
    }

    @Autowired
    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Autowired
    public void setVersionsValidator(SchemaVersionsValidator versionsValidator) {
        this.versionsValidator = versionsValidator;
    }

    @Override
    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        if (this.migrationFilesFolderPath != null) {
            this.configFilePath = this.migrationFilesFolderPath + (Object)((Object)DatabaseName.CONFIG);
            log.info("Existing config JSON file path {}", (Object)this.configFilePath);
            this.securityFilePath = this.migrationFilesFolderPath + (Object)((Object)DatabaseName.SECURITY);
            log.info("Existing security JSON file path {}", (Object)this.securityFilePath);
            this.componentsFilePath = this.migrationFilesFolderPath + (Object)((Object)DatabaseName.COMPONENT);
            log.info("Existing component JSON file path {}", (Object)this.componentsFilePath);
            return RepeatStatus.FINISHED;
        }
        this.orientFolderPath = this.pathQualifier.getOrientFolderPath();
        this.tempFolderPath = this.createExportFolder();
        this.checkIfEnoughFreeDiskSpace(this.orientFolderPath);
        this.checkIfEnoughFreeDiskSpace(this.tempFolderPath);
        this.checkModelVersions(DatabaseName.CONFIG.toString());
        contribution.getStepExecution().getJobExecution().getExecutionContext().put("temp_folder_path", this.tempFolderPath);
        this.configFilePath = this.exportDatabaseToJson(DatabaseName.CONFIG.toString());
        log.info("Exported config JSON file path {}", (Object)this.configFilePath);
        this.securityFilePath = this.exportDatabaseToJson(DatabaseName.SECURITY.toString());
        log.info("Exported security JSON file path {}", (Object)this.securityFilePath);
        if (this.componentMigration) {
            this.componentsFilePath = this.exportDatabaseToJson(DatabaseName.COMPONENT.toString());
            log.info("Exported component JSON file path {}", (Object)this.componentsFilePath);
        }
        Orient.instance().shutdown();
        return RepeatStatus.FINISHED;
    }

    void checkModelVersions(String dbName) throws WrongSchemaVersionException, WrongNxrmEditionException {
        String dbLocalConnectionString = "plocal:" + this.orientFolderPath + Constants.SEPARATOR + dbName;
        try (ODatabaseDocumentTx orientDB = new ODatabaseDocumentTx(dbLocalConnectionString);){
            ODatabaseDocument dbConfig = (ODatabaseDocument)orientDB.open("admin", "admin");
            this.versionsValidator.checkUpgradeModelVersion(dbConfig, this.migrationType, this.mapper);
        }
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        String stepLogMsg;
        JobParameter componentMigrationParameter = ConvertUtils.convertJobParametersToMap(stepExecution.getJobParameters()).get("content_migration");
        this.componentMigration = componentMigrationParameter != null && Boolean.parseBoolean(componentMigrationParameter.toString());
        this.migrationFilesFolderPath = this.migrationFilesPathQualifier.getMigrationFolderPath();
        this.migrationType = ConvertUtils.convertJobParametersToMap(stepExecution.getJobParameters()).get("migration_type").toString();
        if (this.migrationFilesFolderPath != null) {
            log.info("Previously exported files will be used");
            stepLogMsg = "Export is not needed";
        } else {
            log.info("Export may take several minutes depending on the amount of data");
            stepLogMsg = "Export in progress";
        }
        this.progressTask = this.taskScheduler.scheduleWithFixedDelay(() -> log.info(stepLogMsg), Instant.now().plusSeconds(5L), Duration.ofMinutes(1L));
    }

    private void checkIfEnoughFreeDiskSpace(String folderPath) throws NotEnoughDiskSpaceException, IOException {
        long usableSpaceInGB = SpaceChecker.getUsableSpaceInGB(folderPath);
        if (usableSpaceInGB < 10L) {
            throw new NotEnoughDiskSpaceException(folderPath);
        }
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        ExecutionContext executionContext = stepExecution.getJobExecution().getExecutionContext();
        executionContext.put("file_export_config", this.configFilePath);
        executionContext.put("file_export_security", this.securityFilePath);
        if (this.componentMigration) {
            executionContext.put("file_export_component", this.componentsFilePath);
        }
        this.progressTask.cancel(true);
        return ExitStatus.COMPLETED;
    }

    private String createExportFolder() {
        try {
            return Files.createTempDirectory("export_json-", new FileAttribute[0]).toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temp folder for exported JSON files");
        }
    }

    private String exportDatabaseToJson(String dbName) throws Exception {
        if (DatabaseName.SECURITY.toString().equals(dbName)) {
            this.performPreExportRoutine();
        }
        String filePath = this.tempFolderPath + Constants.SEPARATOR + dbName;
        String dbLocalConnectionString = "plocal:" + this.orientFolderPath + Constants.SEPARATOR + dbName;
        try (FileOutputStream fileOutputStream = new FileOutputStream(filePath);
             ODatabaseDocumentTx orientDB = new ODatabaseDocumentTx(dbLocalConnectionString);){
            ODatabaseDocument dbConfig = (ODatabaseDocument)orientDB.open("admin", "admin");
            ODatabaseExport exporter = new ODatabaseExport((ODatabaseDocumentInternal)dbConfig, fileOutputStream, text -> log.debug("> {}", (Object)text.trim()));
            exporter.setIncludeSchema(false);
            exporter.setIncludeClusterDefinitions(false);
            exporter.setIncludeManualIndexes(false);
            exporter.setIncludeIndexDefinitions(false);
            exporter.setPreserveRids(false);
            exporter.exportDatabase().close();
        }
        return filePath;
    }

    private void performPreExportRoutine() throws Exception {
        Orient.instance().getRecordConflictStrategy().registerImplementation("ConflictHook", new ConflictHook(false));
        if (!OCompressionFactory.INSTANCE.getCompressions().contains("pbe")) {
            OCompressionFactory.INSTANCE.register(new PbeCompression(this.pbeCipherFactory, "changeme", "changeme", "0123456789ABCDEF"));
        }
    }
}

