/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.listener;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;

@PropertySource(value={"classpath:application.properties"})
public class ProcessChunkListener
implements ChunkListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessChunkListener.class);
    @Value(value="${chunk.size:10}")
    private int chunkSize;
    @Value(value="${log_interval_time:10}")
    private int logIntervalTime;
    private final Stopwatch stopwatch = Stopwatch.createStarted();

    public ProcessChunkListener(int logIntervalTime) {
        this.logIntervalTime = logIntervalTime;
    }

    @Override
    public void beforeChunk(ChunkContext context) {
    }

    @Override
    public void afterChunk(ChunkContext context) {
        int count = context.getStepContext().getStepExecution().getReadCount();
        long elapsedSeconds = this.stopwatch.elapsed(TimeUnit.SECONDS);
        if (elapsedSeconds >= (long)this.logIntervalTime) {
            log.info("Step progress: {} records processed", (Object)count);
            this.stopwatch.reset();
            this.stopwatch.start();
        }
        if (count % this.chunkSize == 0) {
            log.trace("Step progress: {} records processed", (Object)count);
        }
    }

    @Override
    public void afterChunkError(ChunkContext context) {
    }
}

