/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.listener;

import com.sonatype.nexus.db.migrator.config.Format;
import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.util.FileSystemUtils;

public class ProvidingJobInfoListener
implements JobExecutionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProvidingJobInfoListener.class);
    private boolean isInHealthCheck;

    @Override
    public void beforeJob(JobExecution jobExecution) {
        Map<String, JobParameter> jobParameters = ConvertUtils.convertJobParametersToMap(jobExecution.getJobParameters());
        this.isInHealthCheck = jobParameters.containsKey("healthcheck");
        if (this.isInHealthCheck) {
            log.info("Health-Check job started at {}", (Object)jobExecution.getCreateTime());
        } else {
            log.info("Migration job started at {}", (Object)jobExecution.getCreateTime());
        }
    }

    @Override
    public void afterJob(JobExecution jobExecution) {
        if (this.isInHealthCheck) {
            this.healthCheckJobFinished(jobExecution);
        } else {
            this.migrationJobFinished(jobExecution);
        }
    }

    private void healthCheckJobFinished(JobExecution jobExecution) {
        ExecutionContext executionContext = jobExecution.getExecutionContext();
        ExitStatus exitStatus = jobExecution.getExitStatus();
        if (ExitStatus.FAILED.equals(exitStatus)) {
            log.info("Health-Check job finished with errors. Please see health-check logs for more details.");
            return;
        }
        boolean integrityIsHealth = executionContext.getInt("db_integrity_health") == 1;
        log.info("------------------------------------------------------------");
        log.info("Database integrity: {}", (Object)(integrityIsHealth ? "OK" : "BROKEN"));
        log.info("------------------------------------------------------------");
        log.info("Please see health-check logs for more details.");
    }

    private void migrationJobFinished(JobExecution jobExecution) {
        ExecutionContext executionContext = jobExecution.getExecutionContext();
        ExitStatus exitStatus = jobExecution.getExitStatus();
        boolean isJobSuccessful = exitStatus.equals(ExitStatus.COMPLETED);
        int processedRecordsCount = executionContext.get("records_number_to_process") == null ? 0 : executionContext.getInt("records_number_to_process");
        int skippedRecordsCount = executionContext.get("records_number_skipped") == null ? 0 : executionContext.getInt("records_number_skipped");
        int migratedRecordsCount = executionContext.get("records_number_migrated") == null ? 0 : executionContext.getInt("records_number_migrated");
        int filteredRecordsCount = executionContext.get("records_number_filtered") == null ? 0 : executionContext.getInt("records_number_filtered");
        Set missingTables = (Set)executionContext.get("missingTables");
        Map<String, JobParameter> jobParameters = ConvertUtils.convertJobParametersToMap(jobExecution.getJobParameters());
        boolean isContentMigration = jobParameters.containsKey("content_migration") && Boolean.parseBoolean(jobParameters.get("content_migration").toString());
        this.logJobDiffTime(jobExecution);
        log.info("{} records were processed", (Object)processedRecordsCount);
        log.info("{} records were filtered", (Object)filteredRecordsCount);
        log.info("{} records were skipped", (Object)skippedRecordsCount);
        log.info("{} records were migrated", (Object)migratedRecordsCount);
        if (!CollectionUtils.isEmpty(missingTables)) {
            log.info("{} tables are missing from the source database", (Object)missingTables.size());
            log.info("List of missing config tables:{}", (Object)missingTables);
        }
        if (isContentMigration && isJobSuccessful) {
            log.info("Created 'Rebuild repository browse' and 'Rebuild repository search' tasks. They will automatically one-time run after starting your Nexus Repository instance.");
            log.info("Migrated the following formats: {}", (Object)Format.SUPPORTED_FORMAT_NAMES);
        }
        if (!isJobSuccessful) {
            Optional<StepExecution> failedStep = jobExecution.getStepExecutions().stream().filter(stepExecution -> !stepExecution.getExitStatus().equals(ExitStatus.COMPLETED)).findFirst();
            log.info("------------------------------------------------------------");
            log.info("Migration job finished with status FAILED.");
            failedStep.ifPresent(stepExecution -> log.info("Detailed message: {}", (Object)stepExecution.getExitStatus().getExitDescription().trim()));
            log.info("------------------------------------------------------------");
        }
        if (!jobParameters.containsKey("save_migration_files") && !jobParameters.containsKey("migration_folder")) {
            this.cleanup(executionContext);
        }
    }

    private void logJobDiffTime(JobExecution jobExecution) {
        Date start = jobExecution.getCreateTime();
        Date end = jobExecution.getEndTime();
        long diff = end.getTime() - start.getTime();
        TimeUnit logTimeUnit = TimeUnit.MINUTES.convert(diff, TimeUnit.MILLISECONDS) > 0L ? TimeUnit.MINUTES : TimeUnit.SECONDS;
        long unitsOfTime = logTimeUnit.convert(diff, TimeUnit.MILLISECONDS);
        if (this.isInHealthCheck) {
            log.info("Health-Check job finished at {}", (Object)end);
            log.info("Health-Check job took {} {} to execute", (Object)unitsOfTime, (Object)logTimeUnit.toString().toLowerCase());
        } else {
            log.info("Migration job finished at {}", (Object)end);
            log.info("Migration job took {} {} to execute", (Object)unitsOfTime, (Object)logTimeUnit.toString().toLowerCase());
        }
    }

    private void cleanup(ExecutionContext executionContext) {
        if (executionContext.get("temp_folder_path") != null) {
            log.info("Cleaning orient temporary files...");
            try {
                Path exportJsonFolderPath = Paths.get(executionContext.getString("temp_folder_path"), new String[0]);
                FileSystemUtils.deleteRecursively(exportJsonFolderPath);
            }
            catch (Exception e) {
                log.error("Error during orient temporary files cleaning: {}", (Object)e.getMessage());
            }
            log.info("Cleaning finished");
        }
    }
}

