/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.db.migrator.entity.HealthCheckConfigEntity;
import com.sonatype.nexus.db.migrator.item.record.HealthCheckConfigRecord;
import com.sonatype.nexus.db.migrator.processor.AbstractItemProcessor;
import java.util.HashMap;
import java.util.Map;

public class HealthCheckConfigProcessor
extends AbstractItemProcessor<HealthCheckConfigRecord, HealthCheckConfigEntity> {
    private Map<String, Boolean> repositoriesEnabled = new HashMap<String, Boolean>();
    private Boolean useTrustStore;

    public HealthCheckConfigProcessor(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public HealthCheckConfigEntity process(HealthCheckConfigRecord healthCheckConfigRecord) throws Exception {
        if ("useTrustStore".equals(healthCheckConfigRecord.getPropertyName())) {
            this.useTrustStore = healthCheckConfigRecord.getPropertyValue();
        } else {
            this.repositoriesEnabled.put(healthCheckConfigRecord.getPropertyName().replace(".enabled", ""), healthCheckConfigRecord.getPropertyValue());
        }
        return HealthCheckConfigEntity.builder().useTrustStore(this.useTrustStore).repositoryEnabled(this.convertObjectToString(this.repositoriesEnabled)).build();
    }
}

