/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.db.migrator.entity.QuartzJobDetailEntity;
import com.sonatype.nexus.db.migrator.item.record.quartz.job.QuartzJobData;
import com.sonatype.nexus.db.migrator.item.record.quartz.job.QuartzJobDetailRecord;
import com.sonatype.nexus.db.migrator.processor.AbstractItemProcessor;
import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import com.sonatype.nexus.db.migrator.utils.QuartzFilterUtils;
import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class QuartzJobDetailProcessor
extends AbstractItemProcessor<QuartzJobDetailRecord, QuartzJobDetailEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QuartzJobDetailProcessor.class);
    private boolean contentMigration;

    public QuartzJobDetailProcessor(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public QuartzJobDetailEntity process(QuartzJobDetailRecord item) throws IOException {
        boolean shouldBeFiltered;
        QuartzJobData jobData = item.getJobData();
        Map<String, String> jobDataMap = jobData.getJobDataMap();
        boolean bl = shouldBeFiltered = QuartzFilterUtils.containsFilteredRepository(jobDataMap) || QuartzFilterUtils.shouldTaskBeSkipped(jobDataMap, this.contentMigration);
        if (shouldBeFiltered) {
            log.info("Filtered QuartzJobDetail record {}", (Object)jobData.getDescription());
            QuartzFilterUtils.addFilteredJobName(item.getName());
            return null;
        }
        return QuartzJobDetailEntity.builder().jobName(item.getName()).jobGroup(item.getGroup()).description(jobData.getDescription()).jobClassName(jobData.getJobClass()).durable(jobData.isDurability()).requestsRecovery(jobData.isShouldRecover()).jobData(ConvertUtils.convertObjectToBytes(jobDataMap)).build();
    }

    @Value(value="#{jobParameters['-' + T(com.sonatype.nexus.db.migrator.config.Constants).JOB_PARAMETER_CONTENT_MIGRATION]}")
    public void setContentMigration(Boolean contentMigration) {
        this.contentMigration = contentMigration == null ? false : contentMigration;
    }
}

