/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.db.migrator.config.Constants;
import com.sonatype.nexus.db.migrator.entity.RealmEntity;
import com.sonatype.nexus.db.migrator.item.record.RealmRecord;
import com.sonatype.nexus.db.migrator.processor.AbstractItemProcessor;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealmProcessor
extends AbstractItemProcessor<RealmRecord, RealmEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RealmProcessor.class);

    public RealmProcessor(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public RealmEntity process(RealmRecord item) throws IOException {
        List<String> realmNames = item.getRealmNames();
        int originalSize = realmNames.size();
        realmNames.removeAll(Constants.REALMS_TO_SKIP);
        int filteredSize = realmNames.size();
        int skippedRealmsNumber = originalSize - filteredSize;
        if (skippedRealmsNumber > 0) {
            log.info("{} Realm records weren't migrated. {} realms are not supported", (Object)skippedRealmsNumber, (Object)Constants.REALMS_TO_SKIP);
        }
        return RealmEntity.builder().realmNames(this.convertObjectToString(realmNames)).build();
    }
}

