/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.db.migrator.config.Constants;
import com.sonatype.nexus.db.migrator.entity.RealmEntity;
import com.sonatype.nexus.db.migrator.processor.AbstractItemProcessor;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealmSqlProcessor
extends AbstractItemProcessor<RealmEntity, RealmEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RealmSqlProcessor.class);

    public RealmSqlProcessor(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public RealmEntity process(RealmEntity item) throws IOException {
        List remainingRealms;
        String[] initialRealms = item.getRealmNames().split(",");
        int skippedRealms = initialRealms.length - (remainingRealms = Arrays.stream(initialRealms).map(realm -> realm.replaceAll("[\"\\\\\\]\\[\\s+]", "")).filter(realm -> !Constants.REALMS_TO_SKIP.contains(realm)).collect(Collectors.toList())).size();
        if (skippedRealms > 0) {
            log.info("{} Realms weren't migrated. {} realms are not supported", (Object)skippedRealms, (Object)Constants.REALMS_TO_SKIP);
        }
        return RealmEntity.builder().realmNames(this.convertObjectToString(remainingRealms)).build();
    }
}

