/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.db.migrator.config.Format;
import com.sonatype.nexus.db.migrator.entity.RepositoryEntity;
import com.sonatype.nexus.db.migrator.item.record.RepositoryRecord;
import com.sonatype.nexus.db.migrator.processor.AbstractItemProcessor;
import com.sonatype.nexus.db.migrator.utils.RepositoryUtils;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryProcessor
extends AbstractItemProcessor<RepositoryRecord, RepositoryEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RepositoryProcessor.class);
    private static final String STORAGE_KEY = "storage";
    private static final String DATASTORE_NAME = "dataStoreName";
    private static final String NEXUS = "nexus";

    public RepositoryProcessor(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public RepositoryEntity process(RepositoryRecord item) throws IOException {
        log.info("Processing repository: {} {}", (Object)item.getName(), (Object)item.getRecipeName());
        String format = RepositoryUtils.getFormatFromRecipe(item.getRecipeName());
        if (Format.isNotSupportedFormat(format)) {
            log.info("Filtered {} Repository record {}, Reason - Unsupported format", (Object)item.getRecipeName(), (Object)item);
            RepositoryUtils.addFilteredRepositoryName(item.getName());
            return null;
        }
        UUID routingRuleId = item.getRoutingRuleId() == null || item.getRoutingRuleId().isEmpty() ? null : UUID.nameUUIDFromBytes(item.getRoutingRuleId().getBytes());
        RepositoryUtils.addFormatByRepositoryName(item.getName(), format);
        return RepositoryEntity.builder().id(UUID.nameUUIDFromBytes(item.getName().getBytes())).name(item.getName()).recipeName(item.getRecipeName()).online(item.isOnline()).routingRuleId(routingRuleId).attributes(this.convertObjectToString(this.enrichAttributesWithDatastore(item.getAttributes()))).build();
    }

    private Map<String, Map<String, Object>> enrichAttributesWithDatastore(Map<String, Map<String, Object>> attributes) {
        Map<String, Object> storageAttributeMap = attributes.get(STORAGE_KEY);
        storageAttributeMap.put(DATASTORE_NAME, NEXUS);
        TreeMap<String, Object> sortedStorageMap = new TreeMap<String, Object>(storageAttributeMap);
        attributes.put(STORAGE_KEY, sortedStorageMap);
        return attributes;
    }
}

