/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor.content;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.db.migrator.entity.ComponentEntity;
import com.sonatype.nexus.db.migrator.entity.MavenComponentEntity;
import com.sonatype.nexus.db.migrator.item.record.content.ComponentRecord;
import com.sonatype.nexus.db.migrator.processor.content.ComponentProcessor;
import com.sonatype.nexus.db.migrator.utils.ProcessingUtils;
import java.io.IOException;
import java.util.Map;

public class MavenComponentProcessor
extends ComponentProcessor {
    private static final String MAVEN_PACKAGING_ATTRIBUTE = "packaging";
    private static final String MAVEN_2_ATTRIBUTE = "maven2";
    private static final String MAVEN_BASE_VERSION_ATTRIBUTE = "baseVersion";

    public MavenComponentProcessor(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public ComponentEntity process(ComponentRecord item) throws IOException {
        ComponentEntity processedEntity = super.process(item);
        if (processedEntity != null) {
            MavenComponentEntity mavenComponentEntity = (MavenComponentEntity)processedEntity;
            mavenComponentEntity.setKind(ProcessingUtils.getKind(item.getAttributes(), item.getFormat(), MAVEN_PACKAGING_ATTRIBUTE));
            Map attributes = (Map)item.getAttributes().get(MAVEN_2_ATTRIBUTE);
            mavenComponentEntity.setBaseVersion((String)attributes.get(MAVEN_BASE_VERSION_ATTRIBUTE));
            return mavenComponentEntity;
        }
        return null;
    }

    @Override
    protected ComponentEntity.ComponentEntityBuilder<? extends ComponentEntity, ?> entityBuilder() {
        return MavenComponentEntity.builder();
    }
}

