/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.processor.content;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.db.migrator.entity.TagEntity;
import com.sonatype.nexus.db.migrator.item.record.content.TagRecord;
import com.sonatype.nexus.db.migrator.processor.AbstractItemProcessor;
import com.sonatype.nexus.db.migrator.utils.ComponentIdUtils;
import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagProcessor
extends AbstractItemProcessor<TagRecord, TagEntity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TagProcessor.class);

    public TagProcessor(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    public TagEntity process(TagRecord tagRecord) throws Exception {
        Integer tagId = ComponentIdUtils.getTagId(tagRecord.getRid());
        if (tagId == null) {
            tagId = ComponentIdUtils.generateTagId(tagRecord.getRid());
        }
        return TagEntity.builder().id(tagId).name(tagRecord.getName()).attributes(this.convertObjectToString(tagRecord.getAttributes())).firstCreated(ConvertUtils.convertLongToOffsetDateTime(tagRecord.getFirstCreated())).lastUpdated(ConvertUtils.convertLongToOffsetDateTime(tagRecord.getLastUpdated())).build();
    }
}

