/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.reader;

import com.sonatype.nexus.db.migrator.entity.Entity;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.database.JdbcCursorItemReader;

public class CompositeReader<E extends Entity>
implements ItemReader<E>,
StepExecutionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompositeReader.class);
    private Deque<JdbcCursorItemReader<E>> delegates;
    private JdbcCursorItemReader<E> activeDelegate;
    private Set<String> missingTables;
    private String currentStepName;

    public CompositeReader(Deque<JdbcCursorItemReader<E>> delegates) {
        this.delegates = delegates;
    }

    @Override
    public E read() throws Exception {
        Entity currentEntity = null;
        if (this.activeDelegate != null) {
            currentEntity = (Entity)this.activeDelegate.read();
        }
        if (currentEntity != null) {
            return (E)currentEntity;
        }
        if (!this.delegates.isEmpty()) {
            if (this.activeDelegate != null) {
                this.activeDelegate.close();
            }
            this.setDelegate(this.delegates.pop());
            return (E)this.read();
        }
        return null;
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        this.currentStepName = stepExecution.getStepName();
        this.missingTables = (Set)stepExecution.getJobExecution().getExecutionContext().get("missingTables");
        this.missingTables = this.isSqlConfigStep(this.currentStepName) ? new HashSet() : this.missingTables;
        this.setDelegate(this.delegates.pop());
    }

    private boolean isSqlConfigStep(String currentStepName) {
        return "migrateConfigFromH2ToPostgresStep".equals(currentStepName) || "migrateConfigFromPostgresToH2Step".equals(currentStepName);
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        if (this.isSqlConfigStep(this.currentStepName)) {
            stepExecution.getJobExecution().getExecutionContext().put("missingTables", this.missingTables);
        }
        return stepExecution.getExitStatus();
    }

    private void setDelegate(JdbcCursorItemReader<E> delegate) {
        this.activeDelegate = delegate;
        try {
            this.activeDelegate.open(new ExecutionContext());
        }
        catch (ItemStreamException e) {
            String missingTableName = delegate.getSql().substring(delegate.getSql().lastIndexOf(32) + 1).replaceAll("[^_A-Za-z]+", "");
            this.missingTables.add(missingTableName);
            log.warn("The table {} is missing from the source database", (Object)missingTableName);
            if (this.delegates.isEmpty()) {
                this.activeDelegate = null;
            }
            this.setDelegate(this.delegates.pop());
        }
    }

    @Generated
    public CompositeReader() {
    }
}

