/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.reader;

import com.sonatype.nexus.db.migrator.item.record.RecordItem;
import com.sonatype.nexus.db.migrator.item.record.quartz.job.QuartzJobDetailRecord;
import com.sonatype.nexus.db.migrator.item.record.quartz.trigger.QuartzTriggerRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.item.ItemReader;

public class RecordItemReader
implements ItemReader<RecordItem> {
    private List<RecordItem> records = new ArrayList<RecordItem>();
    private List<QuartzJobDetailRecord> quartzJobDetailRecords = new ArrayList<QuartzJobDetailRecord>();
    private List<QuartzTriggerRecord> quartzTriggerRecords = new ArrayList<QuartzTriggerRecord>();

    @Override
    public RecordItem read() {
        if (!this.quartzJobDetailRecords.isEmpty()) {
            return this.quartzJobDetailRecords.remove(0);
        }
        if (!this.quartzTriggerRecords.isEmpty()) {
            return this.quartzTriggerRecords.remove(0);
        }
        if (!this.records.isEmpty()) {
            return this.records.remove(0);
        }
        return null;
    }

    @BeforeStep
    public void initRecords(StepExecution stepExecution) {
        this.records = (List)stepExecution.getJobExecution().getExecutionContext().get("records");
        if (this.records == null) {
            return;
        }
        this.quartzJobDetailRecords = this.records.stream().filter(record -> record instanceof QuartzJobDetailRecord).map(record -> (QuartzJobDetailRecord)record).collect(Collectors.toList());
        List jobDetailNames = this.quartzJobDetailRecords.stream().map(QuartzJobDetailRecord::getName).collect(Collectors.toList());
        List allQuartzTriggerRecords = this.records.stream().filter(record -> record instanceof QuartzTriggerRecord).map(record -> (QuartzTriggerRecord)record).collect(Collectors.toList());
        this.quartzTriggerRecords = allQuartzTriggerRecords.stream().filter(trigger -> jobDetailNames.contains(trigger.getJobName())).collect(Collectors.toList());
        this.records.removeAll(this.quartzJobDetailRecords);
        this.records.removeAll(allQuartzTriggerRecords);
    }

    @Generated
    public RecordItemReader() {
    }
}

