/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.tasklet;

import com.sonatype.nexus.db.migrator.config.Format;
import com.sonatype.nexus.db.migrator.property.SchemaScriptProperties;
import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import com.sonatype.nexus.db.migrator.utils.SqlUtils;
import java.util.EnumSet;
import java.util.Map;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class DatabaseInitializer
implements Tasklet {
    public static final String CANNOT_ESTABLISH_DESTINATION_CONNECTION = "Cannot establish connection to destination database file.";
    static final String TEST_DB_CONNECTION_SQL = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES";
    private JdbcTemplate sourceJdbc;
    private JdbcTemplate destJdbc;
    private SchemaScriptProperties schemaScripts;

    private static void runForAllFormats(JdbcTemplate jdbcTemplate, String script) {
        EnumSet.allOf(Format.class).stream().map(Enum::name).forEach(format -> jdbcTemplate.execute(SqlUtils.readSqlFromFile(script).replace("${format}", (CharSequence)format)));
    }

    private static void initFormatsAndTags(JdbcTemplate jdbcTemplate, String formatDropScript, String formatInit, String tagDropScript, String tagInitScript) {
        DatabaseInitializer.runForAllFormats(jdbcTemplate, formatDropScript);
        jdbcTemplate.execute(SqlUtils.readSqlFromFile(tagDropScript));
        jdbcTemplate.execute(SqlUtils.readSqlFromFile(tagInitScript));
        DatabaseInitializer.runForAllFormats(jdbcTemplate, formatInit);
    }

    @Override
    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) {
        JobParameters jobParameters = chunkContext.getStepContext().getStepExecution().getJobParameters();
        Map<String, JobParameter> jobParameterMap = ConvertUtils.convertJobParametersToMap(jobParameters);
        String migrationType = jobParameterMap.get("migration_type").toString();
        JobParameter componentMigrationParameter = jobParameterMap.getOrDefault("content_migration", new JobParameter("false"));
        boolean shouldMigrateComponents = Boolean.parseBoolean(componentMigrationParameter.toString());
        switch (migrationType) {
            case "h2_to_postgres": {
                if (this.dbIsUnavailable(this.sourceJdbc, chunkContext)) {
                    return RepeatStatus.FINISHED;
                }
                return this.processPostgresDestination(shouldMigrateComponents);
            }
            case "postgres_to_h2": {
                if (this.dbIsUnavailable(this.sourceJdbc, chunkContext)) {
                    return RepeatStatus.FINISHED;
                }
                return this.processH2Destination(shouldMigrateComponents);
            }
            case "h2": {
                return this.processH2Destination(shouldMigrateComponents);
            }
            case "postgres": {
                return this.processPostgresDestination(shouldMigrateComponents);
            }
        }
        throw new IllegalStateException("Unknown migration type:" + migrationType);
    }

    private void processSqlComponentDestination() {
        this.destJdbc.execute(SqlUtils.readSqlFromFile(this.schemaScripts.getDropAzureDeletedBlobScript()));
        this.destJdbc.execute(SqlUtils.readSqlFromFile(this.schemaScripts.getInitAzureDeletedBlobScript()));
        this.destJdbc.execute(SqlUtils.readSqlFromFile(this.schemaScripts.getAlterMaven2Script()));
    }

    private RepeatStatus processH2Destination(boolean shouldMigrateComponents) {
        this.destJdbc.execute(SqlUtils.readSqlFromFile(this.schemaScripts.getDropConfigH2Script()));
        this.destJdbc.execute(SqlUtils.readSqlFromFile(this.schemaScripts.getInitConfigH2Script()));
        if (shouldMigrateComponents) {
            DatabaseInitializer.initFormatsAndTags(this.destJdbc, this.schemaScripts.getDropComponentH2Script(), this.schemaScripts.getInitComponentH2Script(), this.schemaScripts.getDropTagScript(), this.schemaScripts.getInitTagH2Script());
            this.destJdbc.execute(SqlUtils.readSqlFromFile(this.schemaScripts.getDropDockerForeignLayersH2Script()));
            this.destJdbc.execute(SqlUtils.readSqlFromFile(this.schemaScripts.getInitDockerForeignLayersH2Script()));
            this.processSqlComponentDestination();
        }
        return RepeatStatus.FINISHED;
    }

    private RepeatStatus processPostgresDestination(boolean shouldMigrateComponents) {
        this.destJdbc.execute(SqlUtils.readSqlFromFile(this.schemaScripts.getDropConfigPostgresScript()));
        this.destJdbc.execute(SqlUtils.readSqlFromFile(this.schemaScripts.getInitConfigPostgresScript()));
        if (shouldMigrateComponents) {
            DatabaseInitializer.initFormatsAndTags(this.destJdbc, this.schemaScripts.getDropComponentPostgresScript(), this.schemaScripts.getInitComponentPostgresScript(), this.schemaScripts.getDropTagScript(), this.schemaScripts.getInitTagPostgresScript());
            this.destJdbc.execute(SqlUtils.readSqlFromFile(this.schemaScripts.getDropDockerForeignLayersPostgresScript()));
            this.destJdbc.execute(SqlUtils.readSqlFromFile(this.schemaScripts.getInitDockerForeignLayersPostgresScript()));
            this.processSqlComponentDestination();
        }
        return RepeatStatus.FINISHED;
    }

    private boolean dbIsUnavailable(JdbcTemplate jdbcTemplate, ChunkContext chunkContext) {
        try {
            jdbcTemplate.execute(TEST_DB_CONNECTION_SQL);
        }
        catch (DataAccessException exception) {
            chunkContext.getStepContext().getStepExecution().setExitStatus(ExitStatus.FAILED.addExitDescription(CANNOT_ESTABLISH_DESTINATION_CONNECTION));
            return true;
        }
        return false;
    }

    @Autowired(required=false)
    @Qualifier(value="sourceJdbcTemplate")
    public void setSourceJdbc(JdbcTemplate sourceJdbc) {
        this.sourceJdbc = sourceJdbc;
    }

    @Autowired
    @Qualifier(value="destinationJdbcTemplate")
    public void setDestJdbc(JdbcTemplate destJdbc) {
        this.destJdbc = destJdbc;
    }

    @Autowired
    public void setSchemaScripts(SchemaScriptProperties schemaScripts) {
        this.schemaScripts = schemaScripts;
    }
}

