/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.tasklet;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.sonatype.nexus.db.migrator.config.Constants;
import com.sonatype.nexus.db.migrator.config.SchemaVersionsValidator;
import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import com.sonatype.nexus.db.migrator.utils.PathQualifier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;

public class ModelVersionsChecker
implements Tasklet,
StepExecutionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelVersionsChecker.class);
    String migrationType;
    PathQualifier pathQualifier;
    ObjectMapper mapper;
    SchemaVersionsValidator versionsValidator;

    @Override
    public RepeatStatus execute(StepContribution stepContribution, ChunkContext chunkContext) throws Exception {
        String configDbConnString = "plocal:" + this.pathQualifier.getOrientFolderPath() + Constants.SEPARATOR + "config";
        try (ODatabaseDocumentTx orientDB = new ODatabaseDocumentTx(configDbConnString);){
            ODatabaseDocument dbConfig = (ODatabaseDocument)orientDB.open("admin", "admin");
            this.versionsValidator.checkUpgradeModelVersion(dbConfig, this.migrationType, this.mapper);
        }
        return RepeatStatus.FINISHED;
    }

    @Autowired
    public void setPathQualifier(PathQualifier pathQualifier) {
        this.pathQualifier = pathQualifier;
    }

    @Autowired
    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Autowired
    public void setVersionsValidator(SchemaVersionsValidator versionsValidator) {
        this.versionsValidator = versionsValidator;
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        this.migrationType = ConvertUtils.convertJobParametersToMap(stepExecution.getJobParameters()).get("migration_type").toString();
    }

    @Override
    public ExitStatus afterStep(StepExecution stepExecution) {
        return stepExecution.getExitStatus();
    }
}

