/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.db.migrator.tasklet;

import com.sonatype.nexus.db.migrator.entity.Entity;
import com.sonatype.nexus.db.migrator.entity.QuartzJobDetailEntity;
import com.sonatype.nexus.db.migrator.entity.QuartzTriggerEntity;
import com.sonatype.nexus.db.migrator.utils.ConvertUtils;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.RepeatStatus;

public class RebuildRepositoryTaskProducer
implements Tasklet {
    private static final String REBUILD_REPOSITORY_BROWSE_JOB_TYPE = "create.browse.nodes";
    private static final String REBUILD_REPOSITORY_SEARCH_JOB_TYPE = "repository.rebuild-index";
    private static final String REBUILD_REPOSITORY_BROWSE_DESCRIPTION = "Rebuild repository browse";
    private static final String REBUILD_REPOSITORY_SEARCH_DESCRIPTION = "Rebuild repository search";
    private static final String JOB_GROUP = "nexus";
    private static final Long ZERO = 0L;
    private final ItemWriter<Entity> quartzJobDetailWriter;
    private final ItemWriter<Entity> quartzTriggerWriter;

    @Override
    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        String rebuildBrowseJobName = UUID.randomUUID().toString();
        String rebuildSearchJobName = UUID.randomUUID().toString();
        this.quartzJobDetailWriter.write(Collections.singletonList(this.buildJobDetail(rebuildBrowseJobName, REBUILD_REPOSITORY_BROWSE_JOB_TYPE, REBUILD_REPOSITORY_BROWSE_DESCRIPTION)));
        this.quartzTriggerWriter.write(Collections.singletonList(this.buildTrigger(rebuildBrowseJobName, REBUILD_REPOSITORY_BROWSE_DESCRIPTION)));
        this.quartzJobDetailWriter.write(Collections.singletonList(this.buildJobDetail(rebuildSearchJobName, REBUILD_REPOSITORY_SEARCH_JOB_TYPE, REBUILD_REPOSITORY_SEARCH_DESCRIPTION)));
        this.quartzTriggerWriter.write(Collections.singletonList(this.buildTrigger(rebuildSearchJobName, REBUILD_REPOSITORY_SEARCH_DESCRIPTION)));
        return RepeatStatus.FINISHED;
    }

    private QuartzJobDetailEntity buildJobDetail(String jobName, String jobType, String description) throws IOException {
        return QuartzJobDetailEntity.builder().jobName(jobName).jobGroup(JOB_GROUP).description(description).jobClassName("org.sonatype.nexus.quartz.internal.task.QuartzTaskJob").jobData(ConvertUtils.convertObjectToBytes(this.buildJobDataMap(jobType, description))).build();
    }

    private QuartzTriggerEntity buildTrigger(String jobName, String description) throws IOException {
        return QuartzTriggerEntity.builder().triggerName(jobName).triggerGroup(JOB_GROUP).jobName(jobName).jobGroup(JOB_GROUP).description(description).triggerState("WAITING").triggerType("SIMPLE").startTime(Instant.now().toEpochMilli()).jobData(ConvertUtils.convertObjectToBytes(this.buildTriggerJobDataMap())).repeatCount(ZERO).repeatInterval(ZERO).timesTriggered(ZERO).build();
    }

    private Map<String, String> buildTriggerJobDataMap() {
        return Stream.of(new AbstractMap.SimpleEntry<String, String>("schedule.startAt", OffsetDateTime.now().toString()), new AbstractMap.SimpleEntry<String, String>("schedule.type", "once")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, String> buildJobDataMap(String jobType, String jobDescription) {
        return Stream.of(new AbstractMap.SimpleEntry<String, String>(".id", UUID.randomUUID().toString()), new AbstractMap.SimpleEntry<String, String>(".name", jobDescription), new AbstractMap.SimpleEntry<String, String>("repositoryName", "*"), new AbstractMap.SimpleEntry<String, String>(".typeId", jobType)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Generated
    public RebuildRepositoryTaskProducer(ItemWriter<Entity> quartzJobDetailWriter, ItemWriter<Entity> quartzTriggerWriter) {
        this.quartzJobDetailWriter = quartzJobDetailWriter;
        this.quartzTriggerWriter = quartzTriggerWriter;
    }
}

